/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.0
 * november 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "drawingcompo.h"  
static bool draw_mode = false;
/*
signal maps
*/
DEFINE_SIGNAL_MAP(DrawingComponent,VDKBox)
  ON_SIGNAL(clearButton,clicked_signal,Clear)
END_SIGNAL_MAP 

DEFINE_EVENT_LIST(DrawingComponent,VDKBox);
static char buff[128];

/*
 */
DrawingComponent::~DrawingComponent()
{
  for(int t = 0; shape_array[t]; t++)
    delete shape_array[t];
}
 
/*
 */ 
void DrawingComponent::Setup()    
{
  VDKScrolled *scrolled = new VDKScrolled(Owner());
  VDKBox* vbox = new VDKBox(Owner());
  drawing = new VDKDrawingArea(Owner());
  drawing->SetSize(600,600);
  drawing->NormalBackground = clIvory;
  //drawing->Font = new VDKFont(this,"Courier bold 11");
  drawing->Cursor = curCrossHair;  
  EventConnect(drawing,"expose_event",&DrawingComponent::OnExpose);
  EventConnect(drawing,"motion_notify_event",&DrawingComponent::OnMotion);
  EventConnect(drawing,"button_press_event",&DrawingComponent::OnButtonPress);
  EventConnect(drawing,"button_release_event",&DrawingComponent::OnButtonRelease);
  vbox->Add(drawing);
  scrolled->Add(vbox);
  Add(scrolled);
  Add(new VDKSeparator(Owner()),l_justify,false,false);  
  VDKBox* hbox = new VDKBox(Owner(),h_box);  
  label = new VDKLabel(Owner(),"Coords:000,000");
  hbox->Add(label,l_justify,false,false,5);
  clearButton = new VDKCustomButton(Owner(), "_Clear Drawing");
  hbox->Add(clearButton,false,false,5);
  Add(hbox,l_justify,false,false); 
  // makes an array of shapes
  // rectangle not filled, not tiled
  shape_array[0] = new DrawingRectangle(drawing,50,50,100,100,clSiena);
  // rectangle filled and tiled
  shape_array[1] = new DrawingRectangle(drawing,250,50,60,60,VDKRgb("forest green"),true,true);
  // rectangle filled not tiled
  shape_array[2] = new DrawingRectangle(drawing,250,150,70,30, VDKRgb("indian red"),true);
  // a pixmap
  shape_array[3] = new DrawingPixmap(drawing,200,50,"loadfile.xpm");
  // circle not filled, not tiled
  shape_array[4] = new DrawingCircle(drawing,100,200,30,clBlack);
  // circle filled, not tiled
  shape_array[5] = new DrawingCircle(drawing,100,200,29,clWhite,true);
  // arc filled, not tiled
  shape_array[6] = new DrawingArc(drawing,200,200,60,60,0,90,clRed,true);
  // polygon filled, not tiled
  PointArray points(4);
  points[0] = VDKPoint(300,250);
  points[1] = VDKPoint(350,200);
  points[2] = VDKPoint(400,250);
  points[3] = VDKPoint(350,300);
  shape_array[7] = new DrawingPolygon(drawing,points,clAirBlue,true);
  shape_array[8] = NULL;
}   


/*
 */
bool 
DrawingComponent::OnButtonPress(VDKObject*, GdkEvent* ev)
{
  GdkEventButton* event = reinterpret_cast<GdkEventButton*>(ev);
  for(int t = 0; shape_array[t]; t++)
    {
      if(shape_array[t]->bound.Contains(VDKPoint(int(event->x), int(event->y))))
	{
	  shape_array[t]->DrawBound();
	  draw_mode = false;
	  return true;
	}
    }
  drawing->Cursor = curPencil;
  draw_mode = true;
  return true;
}
/*
 */
bool 
DrawingComponent::OnButtonRelease(VDKObject*, GdkEvent* ev)
{
  GdkEventButton* event = reinterpret_cast<GdkEventButton*>(ev);
  if(!draw_mode)
    {
      for(int t = 0; shape_array[t]; t++)
	{
	  if(shape_array[t]->bound.Contains(VDKPoint(int(event->x), int(event->y))))
	    {
	      shape_array[t]->DrawBound();
	      return true;
	    }
	}
    }
  draw_mode = false;
  drawing->Cursor = curCrossHair;  
  return true;
}
/*
 */
bool 
DrawingComponent::OnMotion(VDKObject*, GdkEvent* ev)
{
  GdkEventMotion* event = reinterpret_cast<GdkEventMotion*>(ev);
  if(draw_mode)
    {
      // avoid to overdraw figures
      for(int t = 0; shape_array[t]; t++)
	{
	  if(shape_array[t]->bound.Contains(VDKPoint(int(event->x),
						     int(event->y))))
	    {
	      drawing->Pen->Thickness = 1;
	      return false;
	    }
	}
      drawing->Pen->Thickness = 6;
      drawing->Pen->Color = VDKRgb("gray80");
      GdkRectangle brush;
      brush.x = int(event->x-2);
      brush.y = int(event->y-2);
      brush.width = brush.height = drawing->Pen->Thickness;
      drawing->DrawRect(true,brush.x,brush.y,brush.width,brush.height);
      drawing->Pen->Thickness = 1;
      // add point to list so will be redrown during expose event
      plist.add(VDKPoint(brush.x,brush.y));
    }
  sprintf(buff,"%3d,%3d - %d points stored",int(event->x),int(event->y),plist.size());
  label->Caption = buff;
  return false;
}

 
/*  
 */
bool DrawingComponent::OnExpose(VDKObject*, GdkEvent* )
{ 

  // redraws shapes
  for(int t = 0; shape_array[t]; t++)
    shape_array[t]->Draw();
  drawing->Foreground = clSiena;
  drawing->Font = new VDKFont(this,"helvetica bold 12");
  drawing->DrawString(10,20,"Drag & draw");
  // redraw point list
  PointListIterator li(plist);
  GdkRectangle brush;
  drawing->Pen->Thickness = 6;
  for(;li;li++)
    {
      brush.x = int(li.current().x);
      brush.y = int(li.current().y);
      brush.width = brush.height = drawing->Pen->Thickness;
      drawing->DrawRect(true,brush.x,brush.y,brush.width,brush.height);
    }
  drawing->Pen->Thickness = 1;
  return true;
}
 
bool DrawingComponent::Clear(VDKObject*) 
{
  drawing->Clear();
  // clear point list
  plist.flush();
  // call expose event handler to redraw shapes
  OnExpose(NULL,NULL);
  return true;
}   


DrawingPolygon::DrawingPolygon(VDKDrawingArea *owner,
			     PointArray& array, 
			     VDKRgb color,
			     bool filled):
  DrawingShape(owner,0,0,0,0,color,filled)
{
  int t;
  // compute maxX
  int maxX = array[0].x;
  for(t = 1; t < array.size(); t++)
    maxX = array[t].x > maxX ? array[t].x : maxX;
  // compute maxY
  int maxY = array[0].y;
  for(t = 1; t < array.size(); t++)
    maxY = array[t].y > maxY ? array[t].y : maxY;
  points = new GdkPoint[array.size()];
  for(t = 0; t < array.size(); t++)
    {
      points[t].x = array[t].x;
      points[t].y = array[t].y;
    }
  // compute minX
  int minX = array[0].x;
  for(t = 1; t < array.size(); t++)
    minX = array[t].x < minX ? array[t].x : minX;
  // compute minY
  int minY = array[0].y;
  for(t = 1; t < array.size(); t++)
    minY = array[t].y < minY ? array[t].y : minY;
  points = new GdkPoint[array.size()];
  for(t = 0; t < array.size(); t++)
    {
      points[t].x = array[t].x;
      points[t].y = array[t].y;
    }
  npoints = array.size();
  bound = VDKRect(minX,minY,maxX-minX,maxY-minY);
}

