/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.0
 * november 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "canvascompo.h"  
static bool draw_mode = false;
/*
signal maps
*/
DEFINE_SIGNAL_MAP(CanvasComponent,VDKBox)
  ON_SIGNAL(clearButton,clicked_signal,Clear)
END_SIGNAL_MAP 

DEFINE_EVENT_LIST(CanvasComponent,VDKBox);
static char buff[128];

/*
 */
CanvasComponent::~CanvasComponent()
{
  for(int t = 0; shape_array[t]; t++)
    delete shape_array[t];
}
 
/*
 */ 
void CanvasComponent::Setup()    
{
  VDKScrolled *scrolled = new VDKScrolled(Owner());
  canvas = new VDKCanvas(Owner());
  canvas->SetSize(600,600);
  canvas->NormalBackground = clIvory;
  canvas->Foreground = clSiena;
  canvas->Font = new VDKFont(this,"Courier bold 11");
  canvas->Cursor = curCrossHair;  
  EventConnect(canvas,"expose_event",&CanvasComponent::OnExpose);
  EventConnect(canvas,"motion_notify_event",&CanvasComponent::OnMotion);
  EventConnect(canvas,"button_press_event",&CanvasComponent::OnButtonPress);
  EventConnect(canvas,"button_release_event",&CanvasComponent::OnButtonRelease);
  scrolled->Add(canvas);
  Add(scrolled);

  Add(new VDKSeparator(Owner()),l_justify,false,false);  
  VDKBox* hbox = new VDKBox(Owner(),h_box);  
  label = new VDKLabel(Owner(),"Coords:000,000");
  hbox->Add(label,l_justify,false,false,5);
  clearButton = new VDKCustomButton(Owner(), "_Clear Canvas");
  hbox->Add(clearButton,false,false,5);
  Add(hbox,l_justify,false,false); 
  // makes an array of shapes
  shape_array[0] = new CanvasRectangle(canvas,50,50,100,60,clSiena,false);
  shape_array[1] = new CanvasRectangle(canvas,51,51,99,59,
				       VDKRgb("forest green"),true);
  shape_array[2] = new CanvasRectangle(canvas,80,80,70,30,
				       clYellow,true);
  shape_array[3] = new CanvasPixmap(canvas,200,50,"loadfile.xpm");
  shape_array[4] = new CanvasCircle(canvas,100,200,30,clBlack);
  shape_array[5] = new CanvasCircle(canvas,100,200,29,clWhite,true);
  shape_array[6] = new CanvasArc(canvas,200,200,60,60,0,90,clRed,true);
  PointArray points(4);
  points[0] = VDKPoint(300,250);
  points[1] = VDKPoint(350,200);
  points[2] = VDKPoint(400,250);
  points[3] = VDKPoint(350,300);
  shape_array[7] = new CanvasPolygon(canvas,points,clAirBlue,true);
  shape_array[8] = NULL;
}   


/*
 */
bool 
CanvasComponent::OnButtonPress(VDKObject*, GdkEvent* ev)
{
  canvas->Cursor = curPencil;
  draw_mode = true;
  return true;
}
/*
 */
bool 
CanvasComponent::OnButtonRelease(VDKObject*, GdkEvent* ev)
{
  draw_mode = false;
  canvas->Cursor = curCrossHair;  
  return true;
}
/*
 */
bool 
CanvasComponent::OnMotion(VDKObject*, GdkEvent* ev)
{
  GdkEventMotion* event = reinterpret_cast<GdkEventMotion*>(ev);
  if(draw_mode)
    {
      GdkRectangle brush;
      // avoid to overdraw figures
      for(int t = 0; shape_array[t]; t++)
	{
	  if(shape_array[t]->bound.Contains(VDKPoint(int(event->x),
						     int(event->y))))
	    return false;
	}
      brush.x = int(event->x-2);
      brush.y = int(event->y-2);
      brush.width = brush.height = 4;
      canvas->DrawRect(true,brush.x,brush.y,brush.width,brush.height);
      canvas->Redraw();
      // add point to list so will be redrown during expose event
      plist.add(VDKPoint(brush.x,brush.y));
    }
  sprintf(buff,"%3d,%3d - %d points stored",int(event->x),int(event->y),plist.size());
  label->Caption = buff;
  return false;
}

 
/*  
 */
bool CanvasComponent::OnExpose(VDKObject*, GdkEvent* )
{ 
  canvas->Clear();
  // redraws shapes
  for(int t = 0; shape_array[t]; t++)
    shape_array[t]->Draw();
  canvas->Foreground = clSiena;
  canvas->DrawString(10,20,"Drag & draw");
  // redraw point list
  PointListIterator li(plist);
  GdkRectangle brush;
  for(;li;li++)
    {
      brush.x = int(li.current().x);
      brush.y = int(li.current().y);
      brush.width = brush.height = 4;
      canvas->DrawRect(true,brush.x,brush.y,brush.width,brush.height);
    }
  // shots back buffer onto screen
  canvas->Redraw();
  return true;
}
 
bool CanvasComponent::Clear(VDKObject*) 
{
  // clear point list
  plist.flush();
  // call expose event handler
  OnExpose(NULL,NULL);
  return true;
}   


CanvasPolygon::CanvasPolygon(VDKCanvas *owner,
			     PointArray& array, 
			     VDKRgb color,
			     bool filled):
  CanvasShape(owner,0,0,0,0,color,filled)
{
  int t;
  // compute maxX
  int maxX = array[0].x;
  for(t = 1; t < array.size(); t++)
    maxX = array[t].x > maxX ? array[t].x : maxX;
  // compute maxY
  int maxY = array[0].y;
  for(t = 1; t < array.size(); t++)
    maxY = array[t].y > maxY ? array[t].y : maxY;
  points = new GdkPoint[array.size()];
  for(t = 0; t < array.size(); t++)
    {
      points[t].x = array[t].x;
      points[t].y = array[t].y;
    }
  // compute minX
  int minX = array[0].x;
  for(t = 1; t < array.size(); t++)
    minX = array[t].x < minX ? array[t].x : minX;
  // compute minY
  int minY = array[0].y;
  for(t = 1; t < array.size(); t++)
    minY = array[t].y < minY ? array[t].y : minY;
  points = new GdkPoint[array.size()];
  for(t = 0; t < array.size(); t++)
    {
      points[t].x = array[t].x;
      points[t].y = array[t].y;
    }
  npoints = array.size();
  bound = VDKRect(minX,minY,maxX-minX,maxY-minY);
}

