#include <stdio.h>
#include <vdk/forms.h>
#include "vdkchildtask.h"
#include <ctime>
#define VERBOSE 1
VDKPid::VDKPid (pid_t pid, VDKChildTask *task):
  pid (pid), task (task) 
{
}

/*
*/
DEFINE_SIGNAL_LIST (VDKChildTask, VDKObject);
PIDLIST VDKChildTask::PidList = PIDLIST();
/*
*/
VDKChildTask::VDKChildTask (VDKForm* owner):
  VDKObject (owner)
{
  /*
  even if isn't really a widget we add it to gc and signals
  handling
  */
  owner->Objects().add(this);
  Parent(owner);
  /*
  allocates empty data_buffer
  */
  data_buffer = NULL;
  /*
  */
  struct sigaction sac;
  sigemptyset(&(sac.sa_mask));
  sac.sa_flags=0;
  sac.sa_handler = VDKChildTask::reaper;
  sigaction(SIGCHLD, &sac, NULL);
  for(int i =  0; i < NSIG; i++)
    {
      if(i != SIGQUIT && i != SIGKILL && i != SIGTERM  && i != SIGCHLD &&
	 i != SIGSTOP && i != SIGCONT && i != SIGTSTP)
        {
	  sigemptyset(&(sac.sa_mask));
	  sac.sa_flags=0;
	  sac.sa_handler = VDKChildTask::plumber;
	  sigaction(i, &sac, NULL);  
        }
    }
  Pid (-1);
  Xmit (-1);
}
/*
*/
VDKChildTask::~VDKChildTask ()
{
  if (pid > 0)
  {
    kill (pid, SIGTERM);
    VDKPid* vdkpid = NULL;
    VDKPid _pid(pid);
    if( (vdkpid = VDKChildTask::PidList.find (_pid)) !=  NULL)  
    {
      int ndx = VDKChildTask::PidList.at (*vdkpid);
      if (ndx >=  0)
      {
#if VERBOSE
      printf ("\nchild dies - pid:%d - removed at:%d",
              vdkpid->pid, ndx);
      fflush (stdout);
#endif      
      vdkpid->task->SignalEmit (CHILD_TASK_DIED_SIGNAL);
      vdkpid->task->SignalEmit ("child_task_died");
      vdkpid->task->Pid (-1);
      vdkpid->task->Xmit (-1);
      VDKChildTask::PidList.unlink (ndx);
      } 

    }
  }
  if (data_buffer)
    delete[] data_buffer;
}

/*
*/
void VDKChildTask::plumber(int sig)
{
#if VERBOSE  
    printf ("\nOtherwise unhandled Unix Signal:%d ",sig);
    fflush (stdout);
#endif 
}

void VDKChildTask::reaper(int)
{
    int sts;
    int local_pid;
    VDKPid* vdkpid = NULL;  
    local_pid = waitpid(-1, &sts, WNOHANG);
#if VERBOSE  
    printf ("\nreaper () - pid:%d", local_pid);
    fflush (stdout);
#endif  
    VDKPid _pid(local_pid);
    if( (vdkpid = VDKChildTask::PidList.find (_pid)) !=  NULL)  
    {
      int ndx = VDKChildTask::PidList.at (_pid);
      if (ndx >=  0)
      {
#if VERBOSE
      printf ("\nchild dies - pid:%d - status:%d - removed at:%d",
              vdkpid->pid, sts,  ndx);
      fflush (stdout);
#endif      
      vdkpid->task->SignalEmit (CHILD_TASK_DIED_SIGNAL);
      vdkpid->task->SignalEmit ("child_task_died");
      vdkpid->task->Pid (-1);
      vdkpid->task->Xmit (-1);
      VDKChildTask::PidList.unlink (ndx);
      } 
    }
}

pid_t VDKChildTask::StartChild(char* args[],  bool duplex)
{
  int inpipe[2], outpipe[2];
  if (Pid () >=  0)
  {
#if VERBOSE
    printf ("\nStartChild () aborted child running");
    fflush (stdout);
#endif    
    return -1;
    }
  else
    {
#if VERBOSE
  printf ("\nStartChild ()");
    fflush (stdout);
#endif  
    }
  
  if(access (args[0], X_OK) == 0)
    {
    sigset_t mask,omask;
    // We don't want to get any signals while setting up the task lists
    sigemptyset(&mask);
    sigaddset(&mask,SIGCHLD);
    sigprocmask(SIG_BLOCK,&mask,&omask);
    if (duplex)
       pipe(inpipe);
     pipe(outpipe);
     pid = fork();
     switch(pid)
     {
      // Child
      case 0:
        if (duplex)
          dup2(inpipe[0], 0);
        else
          close (0);
        dup2(outpipe[1], 1);
        dup2(outpipe[1], 2); 
        execvp(args[0], args);
        break;
      case -1:
         break;
      default:
         // Parent 
         close(outpipe[1]);      // Important! Close my end here
         if (duplex)
          {
           close(inpipe[0]);      // Important! Close my end here
           xmit = inpipe[1];
          }
         // Set pipes none blocking, so we can read big buffers
         // in the callback without having to use FIONREAD
         // to make sure the callback doesn't block.
        /*
         int md;
         if((md = fcntl(outpipe[0], F_GETFL)) != -1)
	    fcntl(outpipe[0], F_SETFL, O_NONBLOCK | md );
        */
         VDKInputChannel *inpch = new VDKInputChannel(Owner (),outpipe[0]);
         inpch->Parent (this);
         SignalConnect (inpch, "input_signal", &VDKChildTask::DoIO, false);
#if VERBOSE    
         printf ("\npid =%d", pid);
         fflush (stdout);
#endif  
         VDKPid vdkpid (pid, this);
         if (!VDKChildTask::PidList.find (vdkpid))
	 {
          VDKChildTask::PidList.add (vdkpid);
#if VERBOSE    
	  printf ("\nadded pid =%d", pid);
	  fflush (stdout);
#endif  
	  }
          break;
        }
     sigprocmask(SIG_UNBLOCK ,&mask ,NULL);
    }
    else
    {
    ;
#if VERBOSE    
        char x[256];
        sprintf(x, "Can't execute \"%s\"", 
                (args[0]) ? args[0] : "????");
        puts (x);
        fflush (stdout);
        return -1;
#endif    
    }
#if VERBOSE      
    printf("\nReturning pid %x\n", Pid());
    fflush (stdout);
#endif
    return Pid ();
}
/*
*/

bool VDKChildTask::DoIO (VDKObject *obj)
{
    const int DATA_BUFFER_SIZE = 1024;
    VDKInputChannel *ip = dynamic_cast<VDKInputChannel*>(obj);
    if (!ip)
      return true;
    int res;
    // char * buf = GetData ();
    if (data_buffer)
      delete[] data_buffer;
    data_buffer = new char[DATA_BUFFER_SIZE];
    res = read (ip->getfd(), data_buffer, DATA_BUFFER_SIZE);
    if(res > 0)
    {
      data_buffer[res] = '\0';
      SignalEmit (CHILD_TASK_DATA_SIGNAL);
      SignalEmit ("child_task_data");
     }
    else if(res == 0)
    {
        close(ip->getfd());
        ip->Destroy();
    }
    return true;
}

/*
*/
bool 
VDKChildTask::SendData(char* data)
{
  char *txt;
  char *t;
  bool result = false;
  if(xmit < 0)
    return result;
  else
    {
    txt = new char[strlen (data+1)];
    strcpy(txt,data);
    t = txt+strlen(txt);
    write(xmit, txt, (t - txt));
    result = true;
    }
  delete[] txt;
  return result;
}

