#!gnuplot
set terminal pslatex color auxfile
set output "transmission-1d-fig.tex"

set xtics (0, 0.25, 0.5, 0.75, 1)
set ytics (0, 1, 2, 3)
epsilon = 0.01

a1 = - 0.25*(1.0 + 3.0*epsilon)/(1.0 + epsilon)
b1 = a1
b2 = -b1 - 0.5

u1(x) = -(x*x/2 + a1*x)/epsilon
u2(x) = -(x*x/2 + b1*x + b2)

u(x) = ((x < 0.5) ? u1(x) : u2(x))

plot [0:1][0:3.5]  \
	u(x) title "exact", \
	"transmission-line-6.dat"  title "h=1/6\ " w lp lt 3 pt 3, \
	"transmission-line-10.dat" title "h=1/10"  w lp lt 6 pt 2, \
	"transmission-line-14.dat" title "h=1/14"  w lp lt 2 pt 1

# pause -1 "<return>"

