#include "rheolef.h"
#include "rheolef/uzawa_abtb.h"
using namespace rheolef;
using namespace std;

point g (const point& x) { 
	Float r = sqrt(sqr(x[0])+sqr(x[1]));
	return point(-x[1],x[0])/sqr(r);
}

int main(int argc, char**argv) {
  geo  omega (argv[1]);
  domain boundary = omega.boundary();
  space X1h (omega, "P1", "vector");
  X1h.block(boundary);
  space Bh  (omega, "bubble", "vector");
  space Qh  (omega, "P1");
  space Xh = X1h * Bh;
  field uh (Xh);
  space Wi  (omega, boundary, "P1");
  space Wh = Wi*Wi;
  field uhb = interpolate (Wh,  g);
  uh[0][boundary] = uhb[0];
  uh[1][boundary] = uhb[1];
  field ph (Qh, 0.);

  form a1 (X1h, X1h, "2D_D");
  form ab (Bh,  Bh,  "2D_D");
  form a0 = form_nul (Bh, X1h);
  form_manip a_manip;
  a_manip << size(2,2)
          << a1        << a0
          << trans(a0) << ab;
  form a (Xh, Xh);
  a_manip >> a;

  form b1 = - form(X1h, Qh, "div");
  form bb = - form(Bh,  Qh, "div");
  form_manip b_manip;
  b_manip << size(1,2)
          << b1 << bb;
  form b (Xh, Qh);
  b_manip >> b;

  int   max_iter  = 500;
  Float tol       = 1e-12;
  Float r         = 1e+7;
  form ar = a + r*trans(b)*b;
  ssk<Float> fact = ldlt(ar.uu);
  uzawa_abtb (ar.uu, fact, b.uu, uh.u, ph.u, -(ar.ub*uh.b), -(b.ub*uh.b), r, max_iter, tol);

  cout << catchmark("u")  << uh
       << catchmark("p")  << ph;

  field pi_h_u = interpolate (X1h, g);
  field e0h = pi_h_u[0] - uh[0];
  field e1h = pi_h_u[1] - uh[1];
  Float error_linf = max(e0h.max_abs(), e1h.max_abs());
  cerr << "error_linf = " << error_linf << endl;
  cout << catchmark("ue")  << pi_h_u;
  cout << catchmark("e0")  << e0h;
  cout << catchmark("e1")  << e1h;
  return 0;
}
