#include "rheolef.h"
using namespace std;
using namespace rheolef;
#include "helmholtz_band_assembly.h"
#include "banded_level_set_aux.h"
#include "sphere.h"

Float w (const point& x) { return x[0] + x[1] ; }

field band_solve (const csr<Float>& M, const ssk<Float>& fact_M, field lh) {
    vec<Float> L(M.nrow(), 0.0);
    for (size_t i = 0; i < lh.u.size(); i++) L.at(i) = lh.u.at(i);
    for (size_t i = lh.u.size(); i < L.size(); i++) L.at(i) = 0;
    vec<Float> U (L.size());
    U = fact_M.solve(L);
    field uh (lh.get_space());
    for (size_t i = 0; i < uh.u.size(); i++) uh.u.at(i) = U.at(i);
    return uh;
}
int main (int argc, char**argv) {
    geo Lambda (argv[1]);
    Float tol = (argc > 2) ? atof(argv[2]) : 1e-7;
    space Vh (Lambda, "P1");
    field phi_h_lambda = interpolate(Vh, phi);
    band bh (phi_h_lambda);
    space Bh = bh.get_space();
    space Wh (bh.get_surface_geo(), "P1");
    form m   (Bh, Bh, "mass_s", bh);
    form ext (Wh, Bh, "mass_s", bh);
    field pi_h_w = interpolate(Bh, w);
    field phi_h = bh.get_phi();
    field wh_gamma = zero_level_set(pi_h_w, phi_h);

    csr<Float> M = band_assembly<Float> (m, phi_h);
    field wh_ext2 = band_solve (M, ldlt(M), ext*wh_gamma);
    field e2h = pi_h_w - wh_ext2;
    Float err2_l2   = sqrt(fabs(m(e2h,e2h)));
    cerr << "||e2h||l2(gamma_h)^2 = " << err2_l2   << endl;
    return (err2_l2 < tol) ? 0 : 1;
}
