#include "rheolef.h"
using namespace std;
using namespace rheolef;
#include "neumann-laplace-assembly.h"
#include "torus.h"
int main (int argc, char**argv) {
  geo omega (argv[1]);
  Float tol = (argc > 2) ? atof(argv[2]) : 1e-7;
  size_t d = omega.dimension();
  space Xh (omega, "P1");
  form a (Xh, Xh, "d_ds_d_ds");
  form m (Xh, Xh, "mass");
  field one (Xh,1.0);
  field b = m*one;
  csr<Float> A = neumann_laplace_assembly (a.uu, b.u);
  ssk<Float> fact_A = ldlt(A);
  field fh = interpolate(Xh, f(d));
  field lh = m*fh;
  vec<Float> L(lh.u.size()+1, 0.0);
  for (size_t i = 0; i < L.size()-1; i++) L.at(i) = lh.u.at(i);
  L.at(L.size()-1) = 0;
  vec<Float> U = fact_A.solve(L);
  field uh(Xh);
  for (size_t i = 0; i < U.size()-1; i++) uh.u.at(i) = U.at(i);
  Float lambda = U.at(U.size()-1);
  field pi_h_u = interpolate(Xh, u(d));
  field eh = uh-pi_h_u;
  Float lambda_e = dot(b,eh)/dot(b,one);
  eh = eh - lambda_e*one;
  Float err_l2 = sqrt(m(eh,eh));
  Float err_h1 = sqrt(a(eh,eh));
  cerr << "lambda   = " << lambda   << endl;
  cerr << "lambda_e = " << lambda_e << endl;
  cerr << "err_l2 = " << err_l2 << endl
       << "err_h1 = " << err_h1 << endl;
  cout << setprecision(numeric_limits<Float>::digits10)
       << catchmark("u") << uh
       << catchmark("lambda") << lambda << endl
       << catchmark("ue") << pi_h_u;
  return (err_l2 < tol && err_h1 < tol) ? 0 : 1;
}
