% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_progress.R
\name{with_progress}
\alias{with_progress}
\title{Apply a function with progress bars.}
\usage{
with_progress(fun, total, ...)
}
\arguments{
\item{fun}{The function to be apply}

\item{total}{The total number of elements to be mapped.
If omitted an attempt will be made to infer the
correct number.}

\item{...}{Arguments passed on to \code{progress_bar}
\describe{
  \item{total}{the total number of elements}
  \item{title}{the title of the progress bar}
  \item{type}{the type of progress bar to create as a string, or an
\code{R6ClassGenerator} object for a class that inherits from
the "R6 Progress Base Class".}
}}
}
\description{
Apply a function with progress bars.
}
\examples{

# with purrr functions
long_function <- function(x, how.long=0.05){
    Sys.sleep(how.long)
    x
}
\donttest{
purrr::walk(1:100, with_progress(long_function))
purrr::walk2(1:100, 0.01, with_progress(long_function))
}

# with dplyr::group_map
\donttest{
if(require(dplyr)){
group_function <- function(x, y, how.long=0.05){
    Sys.sleep(how.long)
    x
}
group_map( group_by(mtcars, cyl, gear)
         , with_progress(group_function, type='line')
         , how.long=1/3)
group_walk( group_by_all(mtcars)
          , with_progress(group_function, type='box')
          , how.long=1)
}
}
# with standard apply functions
sapply(1:100, with_progress(long_function, type='txt'), 0.001)


}
