% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs4_endpoints.R
\name{gs4_endpoints}
\alias{gs4_endpoints}
\title{List Sheets endpoints}
\usage{
gs4_endpoints(i = NULL)
}
\arguments{
\item{i}{The name(s) or integer index(ices) of the endpoints to return.
Optional. By default, the entire list is returned.}
}
\value{
A list containing some or all of the subset of the Sheets API v4
endpoints that are used internally by googlesheets4.
}
\description{
Returns a list of selected Sheets API v4 endpoints, as stored inside the
googlesheets4 package. The names of this list (or the \code{id} sub-elements) are
the nicknames that can be used to specify an endpoint in
\code{\link[=request_generate]{request_generate()}}. For each endpoint, we store its nickname or \code{id}, the
associated HTTP \code{method}, the \code{path}, and details about the parameters. This
list is derived programmatically from the Sheets API v4 Discovery
Document (\verb{https://www.googleapis.com/discovery/v1/apis/sheets/v4/rest}).
}
\examples{
str(gs4_endpoints(), max.level = 2)
gs4_endpoints("sheets.spreadsheets.values.get")
gs4_endpoints(4)
}
