% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.lmfm.R
\name{plot.lmfm}
\alias{plot.lmfm}
\title{Comparison Diagnostic Plots for Linear Regression Models}
\usage{
\method{plot}{lmfm}(x, which.plots = c(5, 2, 6, 4), ...)
}
\arguments{
\item{x}{an \code{lmfm} object.}

\item{which.plots}{either \code{"ask"}, \code{"all"}, or a vector of integer
values specifying which plots to draw.  In the latter case, use the plot
numbers given in the description above (or in the "ask" menu).  Any other
values will be silently ignored.}

\item{\dots}{additional parameters are ignored.}
}
\value{
\code{x} is invisibly returned.
}
\description{
Produces a set of comparison diagnostic plots.  The plot options are
\enumerate{
  \item (not used)
  \item Normal QQ Plot of Residuals,
  \item Kernel Density Estimate of Residuals,
  \item Residuals vs. Mahalanobis Distance,
  \item Residuals vs. Fitted Values,
  \item Scale-Location,
  \item Response vs. Fitted Values,
  \item Residuals vs. Index (Time),
  \item Overlaid Normal QQ Plot of Residuals,
  \item Overlaid Kernel Density Estimate of Residuals,
  \item Scatter Plot with Overlaid Fits (for simple linear regression models).
  }
}
\section{Side Effects}{
 The selected plots are drawn on a graphics device.
}

\examples{
data(stackloss)
stack.lm <- lm(stack.loss ~ ., data = stackloss)
stack.clean <- lm(stack.loss ~ ., data = stackloss, subset = 5:20)
fm <- fit.models(stack.clean, stack.lm)
plot(fm)
}
\seealso{
See \code{\link{qqPlot.lmfm}} for 2,
\code{\link{kernDenPlot.lmfm}} for 3, \code{\link{indexPlot.lmfm}} for
8, \code{\link{overlaidQQPlot.lmfm}} for 9,
\code{\link{overlaidKernDenPlot.lmfm}} for 10,
\code{\link{simpleRegPlot.lmfm}} for 11, and
\code{\link{scatterPlot.lmfm}} for the others.
}
\keyword{hplot}
\keyword{methods}
