% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelope.R
\name{envelope}
\alias{envelope}
\title{Create a message.}
\usage{
envelope(
  to = NULL,
  from = NULL,
  cc = NULL,
  bcc = NULL,
  reply = NULL,
  subject = NULL,
  importance = NULL,
  priority = NULL,
  text = NULL,
  html = NULL,
  encrypt = FALSE,
  sign = FALSE,
  public_key = FALSE
)
}
\arguments{
\item{to}{See \code{\link[=to]{to()}}.}

\item{from}{See \code{\link[=from]{from()}}.}

\item{cc}{See \code{\link[=cc]{cc()}}.}

\item{bcc}{See \code{\link[=bcc]{bcc()}}.}

\item{reply}{See \code{\link[=reply]{reply()}}.}

\item{subject}{See \code{\link[=subject]{subject()}}.}

\item{importance}{See \code{\link[=importance]{importance()}}.}

\item{priority}{See \code{\link[=priority]{priority()}}.}

\item{text}{See \code{\link[=text]{text()}}.}

\item{html}{See \code{\link[=html]{html()}}.}

\item{encrypt}{Whether to encrypt the message. If \code{TRUE} then the entire
message will be encrypted using the private key of the sender.}

\item{sign}{Whether to sign the message. If \code{TRUE} then the entire message will be signed using the private key of the sender.}

\item{public_key}{Whether to attach a public key. If \code{TRUE} then the public key of the sender will be attached.}
}
\value{
A message object.
}
\description{
Create a message.
}
\examples{
# Create an (empty) message object.
#
msg <- envelope()

# Create a complete message object, specifying all available fields.
#
envelope(
  to = "bob@gmail.com",
  from = "craig@gmail.com",
  cc = "alex@gmail.com",
  bcc = "shannon@gmail.com",
  reply = "craig@yahoo.com",
  importance = "high",
  priority = "urgent",
  subject = "Hiya!",
  text = "Hi Bob, how are you?"
)
}
\seealso{
\code{\link[=subject]{subject()}}, \code{\link[=from]{from()}}, \code{\link[=to]{to()}}, \code{\link[=cc]{cc()}}, \code{\link[=bcc]{bcc()}}, \code{\link[=reply]{reply()}} and
\code{\link[=encrypt]{encrypt()}}.
}
