% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{package}
\name{checkmate-package}
\alias{checkmate}
\alias{checkmate-package}
\title{checkmate: Fast and Versatile Argument Checks}
\description{
Tests and assertions to perform frequent argument checks. A substantial part of the package was written in C to minimize any worries about execution time overhead.
}
\section{Check scalars}{

\itemize{
  \item{\code{\link{checkFlag}}}
  \item{\code{\link{checkCount}}}
  \item{\code{\link{checkNumber}}}
  \item{\code{\link{checkInt}}}
  \item{\code{\link{checkString}}}
  \item{\code{\link{checkScalar}}}
  \item{\code{\link{checkScalarNA}}}
}
}

\section{Check vectors}{

\itemize{
  \item{\code{\link{checkLogical}}}
  \item{\code{\link{checkNumeric}}}
  \item{\code{\link{checkDouble}}}
  \item{\code{\link{checkInteger}}}
  \item{\code{\link{checkIntegerish}}}
  \item{\code{\link{checkCharacter}}}
  \item{\code{\link{checkComplex}}}
  \item{\code{\link{checkFactor}}}
  \item{\code{\link{checkList}}}
  \item{\code{\link{checkPOSIXct}}}
  \item{\code{\link{checkVector}}}
  \item{\code{\link{checkAtomic}}}
  \item{\code{\link{checkAtomicVector}}}
  \item{\code{\link{checkRaw}}}
}
}

\section{Check attributes}{

\itemize{
  \item{\code{\link{checkClass}}}
  \item{\code{\link{checkMultiClass}}}
  \item{\code{\link{checkNames}}}
  \item{\code{\link{checkNamed}}} (deprecated)
}
}

\section{Check compound types}{

\itemize{
  \item{\code{\link{checkArray}}}
  \item{\code{\link{checkDataFrame}}}
  \item{\code{\link{checkMatrix}}}
}
}

\section{Check other built-in R types}{

\itemize{
  \item{\code{\link{checkDate}}}
  \item{\code{\link{checkEnvironment}}}
  \item{\code{\link{checkFunction}}}
  \item{\code{\link{checkFormula}}}
  \item{\code{\link{checkNull}}}
}
}

\section{Check sets}{

\itemize{
  \item{\code{\link{checkChoice}}}
  \item{\code{\link{checkSubset}}}
  \item{\code{\link{checkSetEqual}}}
  \item{\code{\link{checkDisjunct}}}
  \item{\code{\link{checkPermutation}}}
}
}

\section{File IO}{

\itemize{
  \item{\code{\link{checkFileExists}}}
  \item{\code{\link{checkDirectoryExists}}}
  \item{\code{\link{checkPathForOutput}}}
  \item{\code{\link{checkAccess}}}
}
}

\section{Popular data types of third party packages}{

\itemize{
  \item{\code{\link{checkDataTable}}}
  \item{\code{\link{checkR6}}}
  \item{\code{\link{checkTibble}}}
}
}

\section{Safe coercion to integer}{

\itemize{
  \item{\code{\link{asCount}}}
  \item{\code{\link{asInt}}}
  \item{\code{\link{asInteger}}}
}
}

\section{Quick argument checks using a DSL}{

\itemize{
  \item{\code{\link{qassert}}}
  \item{\code{\link{qassertr}}}
}
}

\section{Misc}{

\itemize{
  \item{\code{\link{checkOS}} (check operating system)}
  \item{\code{\link{assert}} (combine multiple checks into an assertion)}
  \item{\code{\link{anyMissing}}}
  \item{\code{\link{allMissing}}}
  \item{\code{\link{anyNaN}}}
  \item{\code{\link{wf}} (which.first and which.last)}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://mllg.github.io/checkmate/}
  \item \url{https://github.com/mllg/checkmate}
  \item Report bugs at \url{https://github.com/mllg/checkmate/issues}
}

}
\author{
\strong{Maintainer}: Michel Lang \email{michellang@gmail.com} (\href{https://orcid.org/0000-0001-9754-0393}{ORCID})

Other contributors:
\itemize{
  \item Bernd Bischl \email{bernd_bischl@gmx.net} [contributor]
  \item Dénes Tóth \email{toth.denes@kogentum.hu} (\href{https://orcid.org/0000-0003-4262-3217}{ORCID}) [contributor]
}

}
