# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

#### Public Classes

* [`postfix`](#postfix): The top-level class, to install and configure Postfix

#### Private Classes

* `postfix::files`: Manages the Postfix related files
* `postfix::ldap`: Provides the Postfix LDAP support
* `postfix::mailman`: Configure Postfix to work with mailman
* `postfix::mta`: Configures Postfix as minimal MTA
* `postfix::packages`: Install the required packages for postfix
* `postfix::params`: Default parameters
* `postfix::satellite`: Configure Postfix as satellite
* `postfix::service`: Manage service resources for postfix

### Defined types

* [`postfix::canonical`](#postfix--canonical): Manage content of the Postfix canonical map
* [`postfix::conffile`](#postfix--conffile): Manage a Postfix configuration file
* [`postfix::config`](#postfix--config): Set values in Postfix config file
* [`postfix::hash`](#postfix--hash): Creates Postfix hashed "map" files, and builds the corresponding db file
* [`postfix::mailalias`](#postfix--mailalias): Manage the content of the Postfix alias map
* [`postfix::map`](#postfix--map): Create a Postfix map file
* [`postfix::transport`](#postfix--transport): Manage the transport map of postfix
* [`postfix::virtual`](#postfix--virtual): Manages the contents of the virtual map.

## Classes

### <a name="postfix"></a>`postfix`

This class provides a basic setup of Postfix with local and remote
delivery and an SMTP server listening on the loopback interface.

#### Examples

##### Default Postfix with listen address

```puppet
class { 'postfix':
  smtp_listen => '192.168.1.10',
}
```

##### Minimal MTA setup

```puppet
# This class configures a minimal MTA, delivering mail to
# $mydestination. Either a valid relay host or the special
# word 'direct' is required ($relayhost) for outbound email.
#
# transport & virtual maps get configured and can be populated with
# postfix::transport and postfix::virtual
#
class { 'postfix':
  relayhost     => 'mail.example.com',
  smtp_listen   => '0.0.0.0',
  mydestination => '$myorigin, myapp.example.com',
  mta           => true,
}
```

##### Configure Postfix as satellite

```puppet
# This configures all local email (cron, mdadm, etc) to be forwarded
# to $root_mail_recipient, using $relayhost as a relay.
#
# This will call postfix::mta and override its parameters.
# You shouldn't call postfix::mta yourself or use mta=true in the postfix class.
class { 'postfix':
  relayhost           => 'mail.example.com',
  myorigin            => 'toto.example.com',
  root_mail_recipient => 'the.sysadmin@example.com',
  satellite           => true,
}
```

#### Parameters

The following parameters are available in the `postfix` class:

* [`alias_maps`](#-postfix--alias_maps)
* [`amavis_procs`](#-postfix--amavis_procs)
* [`chroot`](#-postfix--chroot)
* [`confdir`](#-postfix--confdir)
* [`conffiles`](#-postfix--conffiles)
* [`configs`](#-postfix--configs)
* [`hashes`](#-postfix--hashes)
* [`inet_interfaces`](#-postfix--inet_interfaces)
* [`inet_protocols`](#-postfix--inet_protocols)
* [`ldap`](#-postfix--ldap)
* [`ldap_base`](#-postfix--ldap_base)
* [`ldap_host`](#-postfix--ldap_host)
* [`ldap_options`](#-postfix--ldap_options)
* [`ldap_packages`](#-postfix--ldap_packages)
* [`lookup_table_type`](#-postfix--lookup_table_type)
* [`mailaliases`](#-postfix--mailaliases)
* [`mail_user`](#-postfix--mail_user)
* [`mailman`](#-postfix--mailman)
* [`mailx_ensure`](#-postfix--mailx_ensure)
* [`maincf_source`](#-postfix--maincf_source)
* [`manage_aliases`](#-postfix--manage_aliases)
* [`manage_conffiles`](#-postfix--manage_conffiles)
* [`manage_mailname`](#-postfix--manage_mailname)
* [`manage_mailx`](#-postfix--manage_mailx)
* [`manage_root_alias`](#-postfix--manage_root_alias)
* [`maps`](#-postfix--maps)
* [`master_bounce_command`](#-postfix--master_bounce_command)
* [`master_defer_command`](#-postfix--master_defer_command)
* [`master_entries`](#-postfix--master_entries)
* [`master_smtp`](#-postfix--master_smtp)
* [`master_smtps`](#-postfix--master_smtps)
* [`master_submission`](#-postfix--master_submission)
* [`mastercf_content`](#-postfix--mastercf_content)
* [`mastercf_source`](#-postfix--mastercf_source)
* [`mastercf_template`](#-postfix--mastercf_template)
* [`masquerade_classes`](#-postfix--masquerade_classes)
* [`masquerade_domains`](#-postfix--masquerade_domains)
* [`masquerade_exceptions`](#-postfix--masquerade_exceptions)
* [`mta`](#-postfix--mta)
* [`mydestination`](#-postfix--mydestination)
* [`mynetworks`](#-postfix--mynetworks)
* [`myorigin`](#-postfix--myorigin)
* [`postfix_ensure`](#-postfix--postfix_ensure)
* [`relayhost`](#-postfix--relayhost)
* [`root_group`](#-postfix--root_group)
* [`root_mail_recipient`](#-postfix--root_mail_recipient)
* [`satellite`](#-postfix--satellite)
* [`service_enabled`](#-postfix--service_enabled)
* [`service_ensure`](#-postfix--service_ensure)
* [`smtp_listen`](#-postfix--smtp_listen)
* [`transports`](#-postfix--transports)
* [`use_amavisd`](#-postfix--use_amavisd)
* [`use_dovecot_lda`](#-postfix--use_dovecot_lda)
* [`use_schleuder`](#-postfix--use_schleuder)
* [`use_sympa`](#-postfix--use_sympa)
* [`virtuals`](#-postfix--virtuals)

##### <a name="-postfix--alias_maps"></a>`alias_maps`

Data type: `String`

A string defining the location of the alias map file.
Example: `hash:/etc/other_aliases`

Default value: `'hash:/etc/aliases'`

##### <a name="-postfix--amavis_procs"></a>`amavis_procs`

Data type: `Integer`

Number of amavis scanner processes to spawn

Default value: `2`

##### <a name="-postfix--chroot"></a>`chroot`

Data type: `Optional[Boolean]`

A boolean to define if Postfix should be run in a chroot jail or not.
If not defined, '-' is used (OS dependant)
Example: `true`

Default value: `undef`

##### <a name="-postfix--confdir"></a>`confdir`

Data type: `Stdlib::Absolutepath`

The base path which should be used as confdir

Default value: `'/etc/postfix'`

##### <a name="-postfix--conffiles"></a>`conffiles`

Data type: `Hash`

A hash of postfix::conffile resources

Default value: `{}`

##### <a name="-postfix--configs"></a>`configs`

Data type: `Hash`

A hash of postfix::config resources. The hash containing optional configuration values for main.cf.
The values are configured using postfix::config.
Example: `{'message_size_limit': {'value': '51200000'}}`

Default value: `{}`

##### <a name="-postfix--hashes"></a>`hashes`

Data type: `Hash`

A hash of postfix::hash resources

Default value: `{}`

##### <a name="-postfix--inet_interfaces"></a>`inet_interfaces`

Data type: `String`

A string defining the network interfaces that Postfix will listen on.
Example: `127.0.0.1, [::1]`

Default value: `'all'`

##### <a name="-postfix--inet_protocols"></a>`inet_protocols`

Data type: `String`

A string defining the internet protocols that Postfix will use.
Example: `ipv4`

Default value: `'all'`

##### <a name="-postfix--ldap"></a>`ldap`

Data type: `Boolean`

A Boolean defining whether to configure Postfix for LDAP use.

Default value: `false`

##### <a name="-postfix--ldap_base"></a>`ldap_base`

Data type: `Optional[String]`

A string defining the LDAP search base to use. This parameter maps to the
search_base parameter (ldap_table(5)).
Example: `cn=Users,dc=example,dc=com`

Default value: `undef`

##### <a name="-postfix--ldap_host"></a>`ldap_host`

Data type: `Optional[String]`

A string defining the LDAP host. This parameter maps to the server_host parameter (ldap_table(5)).
Example: `ldaps://ldap.example.com:636 ldap://ldap2.example.com`.

Default value: `undef`

##### <a name="-postfix--ldap_options"></a>`ldap_options`

Data type: `Optional[String]`

A free form string that can define any LDAP options to be passed through (ldap_table(5)).
Example: `start_tls = yes`.

Default value: `undef`

##### <a name="-postfix--ldap_packages"></a>`ldap_packages`

Data type: `Array[String[1]]`

An array of package names to install for LDAP support if $ldap is true.

Default value: `[]`

##### <a name="-postfix--lookup_table_type"></a>`lookup_table_type`

Data type: `String`

Table format type as described in http://www.postfix.org/DATABASE_README.html#types.
Type has to be supported by system, see "postconf -m" for supported types.

Default value: `'hash'`

##### <a name="-postfix--mailaliases"></a>`mailaliases`

Data type: `Hash`

A hash of postfix::mailalias resources. The hash containing optional configuration values for main.cf.
The values are configured using postfix::mailalias.
Example: `{'nobody': {'ensure': 'present', 'recipient': 'root'}}`

Default value: `{}`

##### <a name="-postfix--mail_user"></a>`mail_user`

Data type: `String`

A string defining the mail user, and optionally group, to execute external commands as.
This parameter maps to the user parameter (pipe(8)).
Example: `vmail:vmail`.

Default value: `'vmail'`

##### <a name="-postfix--mailman"></a>`mailman`

Data type: `Boolean`

A Boolean defining whether to configure a basic smtp server that is able to work for the
mailman mailing list manager.

Default value: `false`

##### <a name="-postfix--mailx_ensure"></a>`mailx_ensure`

Data type: `String`

Installs mailx package

Default value: `'present'`

##### <a name="-postfix--maincf_source"></a>`maincf_source`

Data type: `String`

A string defining the location of a skeleton main.cf file to be used. The default file
supplied is blank. However, if the main.cf file already exists on the system the contents
will **NOT** be replaced by the contents from maincf_source.
Example: `puppet:///modules/some/other/location/main.cf`.

Default value: `"puppet:///modules/${module_name}/main.cf"`

##### <a name="-postfix--manage_aliases"></a>`manage_aliases`

Data type: `Boolean`

Manage /etc/aliases file

Default value: `true`

##### <a name="-postfix--manage_conffiles"></a>`manage_conffiles`

Data type: `Boolean`

A Boolean defining whether the puppet module should replace the configuration files for postfix.
This setting currently effects only the following files:
- /etc/mailname
- /etc/postfix/master.cf

This setting does NOT effect the following files:
- /etc/aliases
- /etc/postfix/main.cf

Default value: `true`

##### <a name="-postfix--manage_mailname"></a>`manage_mailname`

Data type: `Boolean`

A Boolean defining whether the puppet module should manage '/etc/mailname'.
See also $manage_conffiles

Default value: `true`

##### <a name="-postfix--manage_mailx"></a>`manage_mailx`

Data type: `Boolean`

A Boolean defining whether the puppet module should manage the mailx package. See also $mailx_ensure.

Default value: `true`

##### <a name="-postfix--manage_root_alias"></a>`manage_root_alias`

Data type: `Boolean`

Wheter to manage the mailalias for root user

Default value: `true`

##### <a name="-postfix--maps"></a>`maps`

Data type: `Hash`

A hash of postfix::map resources

Default value: `{}`

##### <a name="-postfix--master_bounce_command"></a>`master_bounce_command`

Data type: `String`

The bounce command which should be used in master.cf

Default value: `'bounce'`

##### <a name="-postfix--master_defer_command"></a>`master_defer_command`

Data type: `String`

The defer command which should be used in master.cf

Default value: `'bounce'`

##### <a name="-postfix--master_entries"></a>`master_entries`

Data type: `Array[String]`

Array of strings containing additional entries for the /etc/postfix/master.cf file.
Example: `['submission inet n       -       n       -       -       smtpd']`.

Default value: `[]`

##### <a name="-postfix--master_smtp"></a>`master_smtp`

Data type: `Optional[String]`

A string to define the smtp line in the /etc/postfix/master.cf file.
If this is defined the smtp_listen parameter will be ignored.
Example: `smtp      inet  n       -       n       -       -       smtpd`.

Default value: `undef`

##### <a name="-postfix--master_smtps"></a>`master_smtps`

Data type: `Optional[String]`

A string to define the smtps line in the /etc/postfix/master.cf file.
Example: `smtps     inet  n       -       n       -       -       smtpd`.

Default value: `undef`

##### <a name="-postfix--master_submission"></a>`master_submission`

Data type: `Optional[String]`

A string to define the submission line in the /etc/postfix/master.cf file.
Example: `submission inet n       -       n       -       -       smtpd`.

Default value: `undef`

##### <a name="-postfix--mastercf_content"></a>`mastercf_content`

Data type: `Optional[String]`

Set the content parameter for the master.cf file resource.

Default value: `undef`

##### <a name="-postfix--mastercf_source"></a>`mastercf_source`

Data type: `Optional[String]`

A string defining the location of a skeleton master.cf file to be used.
Example: `puppet:///modules/some/other/location/master.cf`.

Default value: `undef`

##### <a name="-postfix--mastercf_template"></a>`mastercf_template`

Data type: `Optional[String]`

Set the epp template path which will be used for master.cf file resource.

Default value: `undef`

##### <a name="-postfix--masquerade_classes"></a>`masquerade_classes`

Data type: `Optional[Array[String[1]]]`

Postfix config parameter masquerade_classes as an array.
What addresses are subject to address masquerading.
Example: `['envelope_sender', 'envelope_recipient', 'header_sender', 'header_recipient']`

Default value: `undef`

##### <a name="-postfix--masquerade_domains"></a>`masquerade_domains`

Data type: `Optional[Array[String[1]]]`

An array defining the masquerade_domains to use.
The order of elements matters here, so be aware of how you define the elements.
Example: `['foo.example.com', 'example.com']`

Default value: `undef`

##### <a name="-postfix--masquerade_exceptions"></a>`masquerade_exceptions`

Data type: `Optional[Array[String[1]]]`

An array defining the masquerade_exceptions to use. This optional list of user names that are not
subjected to address masquerading, even when their addresses match $masquerade_domains.
Example: `['root']`

Default value: `undef`

##### <a name="-postfix--mta"></a>`mta`

Data type: `Boolean`

A Boolean to define whether to configure Postfix as a mail transfer agent.
This option is mutually exclusive with the satellite Boolean.

Default value: `false`

##### <a name="-postfix--mydestination"></a>`mydestination`

Data type: `String`

A string to define the mydestination parameter in main.cf (postconf(5)).
Example: `example.com, foo.example.com`.

Default value: `'$myhostname, localhost.$mydomain, localhost'`

##### <a name="-postfix--mynetworks"></a>`mynetworks`

Data type: `String`

A string to define the mynetworks parameter that holds trusted remote smtp clients (postconf(5)).
Example: `127.0.0.0/8, [::1]/128`.

Default value: `'127.0.0.0/8 [::ffff:127.0.0.0]/104 [::1]/128'`

##### <a name="-postfix--myorigin"></a>`myorigin`

Data type: `String`

A string to define the myorigin parameter that holds the domain name that mail appears to come from (postconf(5)).
Example: `example.com`

Default value: `$facts['networking']['fqdn']`

##### <a name="-postfix--postfix_ensure"></a>`postfix_ensure`

Data type: `String`

The ensure value of the postfix package

Default value: `'present'`

##### <a name="-postfix--relayhost"></a>`relayhost`

Data type: `Optional[String]`

A string to define the relayhost parameter (postconf(5)).
Example: `smtp.example.com`.

Default value: `undef`

##### <a name="-postfix--root_group"></a>`root_group`

Data type: `String`

The group permission name for the main.cf and master.cf files.

Default value: `'root'`

##### <a name="-postfix--root_mail_recipient"></a>`root_mail_recipient`

Data type: `Variant[Array[String], String]`

A string to define the e-mail address to which all mail directed to root should go (aliases(5)).
Example: `root_catch@example.com`.

Default value: `'nobody'`

##### <a name="-postfix--satellite"></a>`satellite`

Data type: `Boolean`

A Boolean to define whether to configure Postfix as a satellite relay host.
This setting is mutually exclusive with the mta Boolean.

Default value: `false`

##### <a name="-postfix--service_enabled"></a>`service_enabled`

Data type: `Boolean`

Defines if the service 'postfix' is enabled on the system

Default value: `true`

##### <a name="-postfix--service_ensure"></a>`service_ensure`

Data type: `String`

Defines the service state of 'postfix' service

Default value: `'running'`

##### <a name="-postfix--smtp_listen"></a>`smtp_listen`

Data type: `Variant[Array[String[1]], String[1]]`

A string or an array of strings to define the IPs on which to listen in master.cf.
This can also be set to 'all' to listen on all interfaces. If master_smtp is defined
smtp_listen will not be used.
Example: `::1`.

Default value: `'127.0.0.1'`

##### <a name="-postfix--transports"></a>`transports`

Data type: `Hash`

A hash of postfix::transport resources

Default value: `{}`

##### <a name="-postfix--use_amavisd"></a>`use_amavisd`

Data type: `Boolean`

A Boolean to define whether to configure master.cf to allow the use of the amavisd scanner.

Default value: `false`

##### <a name="-postfix--use_dovecot_lda"></a>`use_dovecot_lda`

Data type: `Boolean`

A Boolean to define whether to configure master.cf to use dovecot as the local delivery agent.

Default value: `false`

##### <a name="-postfix--use_schleuder"></a>`use_schleuder`

Data type: `Variant[Integer[2, 3], Boolean]`

A Boolean to define whether to configure master.cf to use the Schleuder GPG-enabled mailing list.
Can be also set to an integer `2` to use Schleuder v2 instead of v3.

Default value: `false`

##### <a name="-postfix--use_sympa"></a>`use_sympa`

Data type: `Boolean`

A Boolean to define whether to configure master.cf to use the Sympa mailing list management software.

Default value: `false`

##### <a name="-postfix--virtuals"></a>`virtuals`

Data type: `Hash`

A hash of postfix::virtual resources

Default value: `{}`

## Defined types

### <a name="postfix--canonical"></a>`postfix::canonical`

This type manages content of the /etc/postfix/canonical map.

* **See also**
  * https://www.postfix.org/canonical.5.html

#### Examples

##### Basic usage and required setup

```puppet
# This defined type requires the following resources:
# - Class["postfix"]
# - Postfix::Hash["/etc/postfix/canonical"]
# - Postfix::Config["canonical_maps"] or Postfix::Config["sender_canonical_maps"] or Postfix::Config["recipient_canonical_maps"]
include postfix
postfix::hash { '/etc/postfix/recipient_canonical':
  ensure => present,
}
postfix::config { 'canonical_alias_maps':
  value => 'hash:/etc/postfix/recipient_canonical',
}
postfix::canonical { 'user@example.com':
  file        => '/etc/postfix/recipient_canonical',
  ensure      => present,
  destination => 'root',
}
```

#### Parameters

The following parameters are available in the `postfix::canonical` defined type:

* [`ensure`](#-postfix--canonical--ensure)
* [`destination`](#-postfix--canonical--destination)
* [`file`](#-postfix--canonical--file)
* [`lookup_table_suffix`](#-postfix--canonical--lookup_table_suffix)

##### <a name="-postfix--canonical--ensure"></a>`ensure`

Data type: `Enum['present','absent']`

Intended state of the resource

Default value: `'present'`

##### <a name="-postfix--canonical--destination"></a>`destination`

Data type: `String`

Where the emails will be delivered to.

##### <a name="-postfix--canonical--file"></a>`file`

Data type: `Stdlib::Absolutepath`

Where to create the file. If not defined "${postfix::confdir}/canonical"
will be used as path.

Default value: `undef`

##### <a name="-postfix--canonical--lookup_table_suffix"></a>`lookup_table_suffix`

Data type: `String[1]`

Depends on the lookup table type, which is used on the postfix::hash and postfix::config resources.
Defaults to 'db', the suffix of the "hash" type.

Default value: `'db'`

### <a name="postfix--conffile"></a>`postfix::conffile`

Manages Postfix configuration files. With it, you could create configuration
files (other than, main.cf, master.cf, etc.) restarting Postfix when necessary.

#### Examples

##### Simple config file with module source

```puppet
postfix::conffile { 'ldapoptions.cf':
  source => 'puppet:///modules/postfix/ldapoptions.cf',
}
```

##### With template options

```puppet
postfix::conffile { 'ldapoptions.cf':
  options            => {
    server_host      => ldap.mydomain.com,
    bind             => 'yes',
    bind_dn          => 'cn=admin,dc=mydomain,dc=com',
    bind_pw          => 'password',
    search_base      => 'dc=example, dc=com',
    query_filter     => 'mail=%s',
    result_attribute => 'uid',
  }
}
```

#### Parameters

The following parameters are available in the `postfix::conffile` defined type:

* [`ensure`](#-postfix--conffile--ensure)
* [`source`](#-postfix--conffile--source)
* [`content`](#-postfix--conffile--content)
* [`path`](#-postfix--conffile--path)
* [`mode`](#-postfix--conffile--mode)
* [`options`](#-postfix--conffile--options)
* [`show_diff`](#-postfix--conffile--show_diff)

##### <a name="-postfix--conffile--ensure"></a>`ensure`

Data type: `Enum['present', 'absent', 'directory']`

A string whose valid values are present, absent or directory.

Default value: `'present'`

##### <a name="-postfix--conffile--source"></a>`source`

Data type: `Variant[Array[String], String, Undef]`

A string with the source of the file. This is the `source` parameter of the underlying file resource.
Example: `puppet:///modules/postfix/configfile.cf`

Default value: `undef`

##### <a name="-postfix--conffile--content"></a>`content`

Data type: `Optional[String]`

The content of the Postfix configuration file. This is an alternative to the `source` parameter.
If you don't provide `source` neither `content` parameters a default template is used and the
content is created with values in the `options` hash.

Default value: `undef`

##### <a name="-postfix--conffile--path"></a>`path`

Data type: `Optional[Stdlib::Absolutepath]`

Where to create the file. If not defined "${postfix::confdir}/${name}" will be used as path.

Default value: `undef`

##### <a name="-postfix--conffile--mode"></a>`mode`

Data type: `Stdlib::Filemode`

Permissions of the configuration file. This option is useful if you want to create the file with
specific permissions (for example, because you have passwords in it).
Example: `0640`

Default value: `'0640'`

##### <a name="-postfix--conffile--options"></a>`options`

Data type: `Hash`

Hash with the options used in the default template that is used when neither `source`
neither `content`parameters are provided.

Default value: `{}`

##### <a name="-postfix--conffile--show_diff"></a>`show_diff`

Data type: `Boolean`

Switch to set file show_diff parameter

Default value: `true`

### <a name="postfix--config"></a>`postfix::config`

Add/alter/remove options in Postfix main configuration file (main.cf).
This uses Augeas to do the editing of the configuration file, as such any
configuration value can be used.

#### Examples

##### Set value for smtp_use_tls

```puppet
postfix::config { 'smtp_use_tls':
  ensure => 'present',
  value  => 'yes',
}
```

##### Set a config parameter with empty value

```puppet
postfix::config { 'relayhost':
  ensure => 'blank',
}
```

##### Configure Postfix to use TLS as a client

```puppet
postfix::config {
  'smtp_tls_mandatory_ciphers':       value   => 'high';
  'smtp_tls_security_level':          value   => 'secure';
  'smtp_tls_CAfile':                  value   => '/etc/pki/tls/certs/ca-bundle.crt';
  'smtp_tls_session_cache_database':  value   => 'btree:${data_directory}/smtp_tls_session_cache';
}
```

##### Configure Postfix to disable the vrfy command

```puppet
postfix::config { 'disable_vrfy_command':
  ensure  => present,
  value   => 'yes',
}
```

#### Parameters

The following parameters are available in the `postfix::config` defined type:

* [`ensure`](#-postfix--config--ensure)
* [`value`](#-postfix--config--value)

##### <a name="-postfix--config--ensure"></a>`ensure`

Data type: `Enum['present', 'absent', 'blank']`

Defines if the config parameter is present, absent or blank.
The special value 'blank', will clear the value for the parameter,
but will not remove it from the config file.
Example: `blank`

Default value: `'present'`

##### <a name="-postfix--config--value"></a>`value`

Data type: `Optional[String]`

A string that can contain any text to be used as the configuration value.
Example: `btree:${data_directory}/smtp_tls_session_cache`.

Default value: `undef`

### <a name="postfix--hash"></a>`postfix::hash`

Creates Postfix hashed "map" files. It will create "${name}", and then build
"${name}.<table type suffix>" using the "postmap" command. The map file can then be referred to
using postfix::config.

#### Examples

##### Creates a virtual hashmap

```puppet
# This example creates a virtual hashmap in the Postfix config dir
# and adds a value into it with the postfix::config type.
postfix::hash { 'virtual':
  ensure => present,
}
postfix::config { 'virtual_alias_maps':
  value => 'hash:/etc/postfix/virtual',
}
```

##### Create a sasl_passwd hash from a source file

```puppet
postfix::hash { '/etc/postfix/sasl_passwd':
  ensure  => 'present',
  source  => 'puppet:///modules/profile/postfix/client/sasl_passwd',
}
```

##### Create a sasl_passwd hash with contents defined in the manifest

```puppet
postfix::hash { '/etc/postfix/sasl_passwd':
  ensure  => 'present',
  content => '#Destination                Credentials\nsmtp.example.com            gssapi:nopassword',
}
```

#### Parameters

The following parameters are available in the `postfix::hash` defined type:

* [`ensure`](#-postfix--hash--ensure)
* [`source`](#-postfix--hash--source)
* [`content`](#-postfix--hash--content)
* [`mode`](#-postfix--hash--mode)

##### <a name="-postfix--hash--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

Defines whether the hash map file is present or not. Value can either be present or absent.
Example: `absent`.

Default value: `'present'`

##### <a name="-postfix--hash--source"></a>`source`

Data type: `Variant[Array[String], String, Undef]`

A string whose value is a location for the source file to be used. This parameter is mutually
exclusive with the content parameter, one or the other must be present, but both cannot be present.
Example: `puppet:///modules/some/location/sasl_passwd`.

Default value: `undef`

##### <a name="-postfix--hash--content"></a>`content`

Data type: `Optional[Variant[Sensitive[String],String]]`

A free form string that defines the contents of the file. This parameter is mutually exclusive
with the source parameter.
Example: `#Destination                Credentials\nsmtp.example.com            gssapi:nopassword`.

Default value: `undef`

##### <a name="-postfix--hash--mode"></a>`mode`

Data type: `Stdlib::Filemode`

the desired file mode

Default value: `'0640'`

### <a name="postfix--mailalias"></a>`postfix::mailalias`

Creates an email alias in the local alias database and updates the binary
version of said database.

* **See also**
  * http://www.postfix.org/aliases.5.html

#### Examples

##### Simple example

```puppet
include postfix
postfix::mailalias { 'postmaster':
  ensure    => present,
  recipient => 'foo',
}
```

#### Parameters

The following parameters are available in the `postfix::mailalias` defined type:

* [`ensure`](#-postfix--mailalias--ensure)
* [`recipient`](#-postfix--mailalias--recipient)

##### <a name="-postfix--mailalias--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

Intended state of the resource

Default value: `'present'`

##### <a name="-postfix--mailalias--recipient"></a>`recipient`

Data type: `Variant[String, Array[String]]`

The recipient address where the mail should be sent to.

### <a name="postfix--map"></a>`postfix::map`

Creates Postfix "map" files. It will create "${name}", and then build
"${name}.db" using the "postmap" command. The map file can then be referred to
using postfix::config.

* **See also**
  * http://www.postfix.org/postmap.1.html

#### Examples

##### Postfix map file and use in config

```puppet
postfix::map { '/etc/postfix/virtual':
  ensure => present,
}
postfix::config { 'virtual_alias_maps':
  value => 'hash:/etc/postfix/virtual',
}
```

#### Parameters

The following parameters are available in the `postfix::map` defined type:

* [`ensure`](#-postfix--map--ensure)
* [`source`](#-postfix--map--source)
* [`content`](#-postfix--map--content)
* [`type`](#-postfix--map--type)
* [`path`](#-postfix--map--path)
* [`mode`](#-postfix--map--mode)

##### <a name="-postfix--map--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

Intended state of the resource

Default value: `'present'`

##### <a name="-postfix--map--source"></a>`source`

Data type: `Optional[Variant[Array[String], String]]`

Sets the value of the source parameter for the file. Can't be used
together with parameter content.

Default value: `undef`

##### <a name="-postfix--map--content"></a>`content`

Data type: `Optional[Variant[Sensitive[String], String]]`

The content of the file. Can't be used together with param source.

Default value: `undef`

##### <a name="-postfix--map--type"></a>`type`

Data type: `String[1]`

Type of the Postfix map (valid values are cidr, pcre, hash...)

Default value: `'hash'`

##### <a name="-postfix--map--path"></a>`path`

Data type: `Optional[Stdlib::Absolutepath]`

Where to create the file. If not defined "${postfix::confdir}/${name}"
will be used as path.

Default value: `undef`

##### <a name="-postfix--map--mode"></a>`mode`

Data type: `Stdlib::Filemode`

File mode of the created file.

Default value: `'0640'`

### <a name="postfix--transport"></a>`postfix::transport`

Manages content of the /etc/postfix/transport map.

* **See also**
  * https://www.postfix.org/transport.5.html

#### Examples

##### Simple transport map config

```puppet
include postfix
postfix::hash { '/etc/postfix/transport':
  ensure => present,
}
postfix::config { 'transport_maps':
  value => 'hash:/etc/postfix/transport, regexp:/etc/postfix/transport_regexp',
}
postfix::transport {
  'mailman.example.com':
     ensure      => present,
     destination => 'mailman';
  'slow_transport':
     ensure      => present,
     nexthop     => '/^user-.*@mydomain\.com/'
     file        => '/etc/postfix/transport_regexp',
     destination => 'slow'
}
```

#### Parameters

The following parameters are available in the `postfix::transport` defined type:

* [`ensure`](#-postfix--transport--ensure)
* [`destination`](#-postfix--transport--destination)
* [`nexthop`](#-postfix--transport--nexthop)
* [`file`](#-postfix--transport--file)

##### <a name="-postfix--transport--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

Defines whether the transport entry is present or not. Value can either be present or absent.

Default value: `'present'`

##### <a name="-postfix--transport--destination"></a>`destination`

Data type: `Optional[String]`

The destination to be delivered to (transport(5)).
Example: `mailman`.

Default value: `undef`

##### <a name="-postfix--transport--nexthop"></a>`nexthop`

Data type: `Optional[String]`

A string to define where and how to deliver the mail (transport(5)).
Example: `[smtp.google.com]:25`.

Default value: `undef`

##### <a name="-postfix--transport--file"></a>`file`

Data type: `Optional[Stdlib::Absolutepath]`

Where to create the file. If not defined "${postfix::confdir}/transport"
will be used as path.

Default value: `undef`

### <a name="postfix--virtual"></a>`postfix::virtual`

Manages content of the /etc/postfix/virtual map.

* **See also**
  * https://www.postfix.org/virtual.8.html

#### Examples

##### Minimum Requirements

```puppet
include postfix
postfix::hash { "/etc/postfix/virtual":
  ensure => present,
}
postfix::config { "virtual_alias_maps":
  value => "hash:/etc/postfix/virtual, regexp:/etc/postfix/virtual_regexp"
}
```

##### Route mail to local users

```puppet
postfix::virtual { "user@example.com":
  ensure      => present,
  destination => ['root', 'postmaster'],
}
```

##### Regex example

```puppet
postfix::virtual { "/.+@.+/"
  ensure      => present,
  file        => '/etc/postfix/virtual_regexp',
  destination => 'root',
}
```

##### Route mail bound for 'user@example.com' to root.

```puppet
postfix::virtual {'user@example.com':
    ensure      => present,
    destination => 'root',
}
```

#### Parameters

The following parameters are available in the `postfix::virtual` defined type:

* [`ensure`](#-postfix--virtual--ensure)
* [`destination`](#-postfix--virtual--destination)
* [`file`](#-postfix--virtual--file)

##### <a name="-postfix--virtual--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

A string whose valid values are present or absent.

Default value: `'present'`

##### <a name="-postfix--virtual--destination"></a>`destination`

Data type: `Variant[String, Array[String]]`

A string defining where the e-mails will be delivered to, (virtual(8)).
Example: `root`

##### <a name="-postfix--virtual--file"></a>`file`

Data type: `Optional[Stdlib::Absolutepath]`

A string defining the location of the virtual map, pre hash.
If not defined "${postfix::confdir}/virtual" will be used as path.
Example: `/etc/postfix/my_virtual_map`.

Default value: `undef`

