import pytest


@pytest.fixture
def molfile():
    return """(R)-SDP
  ChemDraw08122419562D

 43 50  0  0  1  0  0  0  0  0999 V2000
   -0.7846   -1.0799    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -1.4991   -1.4924    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -2.2136   -1.0799    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -2.2136   -0.2549    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -1.4991    0.1576    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -1.7813    0.9328    0.0000 P   0  0  0  0  0  0  0  0  0  0  0  0
   -1.2510    1.5648    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -1.5331    2.3400    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -1.0028    2.9720    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -0.1904    2.8288    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    0.0918    2.0535    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -0.4385    1.4215    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -2.5937    1.0761    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -3.1240    0.4441    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -3.9365    0.5873    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -4.2187    1.3626    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -3.6884    1.9946    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -2.8759    1.8513    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -0.7846   -0.2549    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    0.0000    0.0000    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -0.4849    0.6674    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    0.0000    1.3349    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    0.7846    1.0799    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    0.7846    0.2549    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    1.4991   -0.1576    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    1.7813   -0.9328    0.0000 P   0  0  0  0  0  0  0  0  0  0  0  0
    2.5937   -1.0761    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    2.8759   -1.8513    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    3.6884   -1.9946    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    4.2187   -1.3626    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    3.9365   -0.5873    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    3.1240   -0.4441    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    1.2510   -1.5648    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    0.4385   -1.4215    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -0.0918   -2.0535    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    0.1904   -2.8288    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    1.0028   -2.9720    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    1.5331   -2.3400    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    2.2136    0.2549    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    2.2136    1.0799    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    1.4991    1.4924    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    0.4849   -0.6674    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    0.0000   -1.3349    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
  1  2  2  0        0
  2  3  1  0        0
  3  4  2  0        0
  4  5  1  0        0
  5  6  1  0        0
  6  7  1  0        0
  7  8  2  0        0
  8  9  1  0        0
  9 10  2  0        0
 10 11  1  0        0
 11 12  2  0        0
  7 12  1  0        0
  6 13  1  0        0
 13 14  2  0        0
 14 15  1  0        0
 15 16  2  0        0
 16 17  1  0        0
 17 18  2  0        0
 13 18  1  0        0
  5 19  2  0        0
  1 19  1  0        0
 20 19  1  1        0
 20 21  1  0        0
 21 22  1  0        0
 22 23  1  0        0
 23 24  2  0        0
 20 24  1  0        0
 24 25  1  0        0
 25 26  1  0        0
 26 27  1  0        0
 27 28  2  0        0
 28 29  1  0        0
 29 30  2  0        0
 30 31  1  0        0
 31 32  2  0        0
 27 32  1  0        0
 26 33  1  0        0
 33 34  2  0        0
 34 35  1  0        0
 35 36  2  0        0
 36 37  1  0        0
 37 38  2  0        0
 33 38  1  0        0
 25 39  2  0        0
 39 40  1  0        0
 40 41  2  0        0
 23 41  1  0        0
 20 42  1  6        0
 42 43  1  0        0
  1 43  1  0        0
M  END
"""


@pytest.mark.xfail(strict=True, raises=AssertionError)
def test_spiro_compound_chiral(molfile, run_inchi_exe):
    result = run_inchi_exe(molfile)

    assert "Warning (Not chiral) structure #1." not in result.stderr
