/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id: TransitionDictionary.java 985537 2010-08-14 17:17:00Z jeremias $ */

package org.apache.fop.pdf;

/**
 * Transition Dictionary
 * This class is used to build a transition dictionary to
 * specify the transition between pages.
 */
public class TransitionDictionary extends PDFDictionary {

    /**
     * Create a Transition Dictionary
     */
    public TransitionDictionary() {
        put("Type", new PDFName("Trans"));
    }

}

