/*
 * $XTermId: builtin.c,v 1.9 2025/09/12 20:09:55 tom Exp $
 * This file was generated by ./make-tables
 */
#include <other.h>
#include <sys.h>
#include <luitconv.h>
/* *INDENT-OFF* */
static const BuiltInMapping apl2[] =
{
    /* Character set details are from "APL2 Programming: Language Reference", */
    /* Appendix A "The APL2 Character Set": */
    /* Figure 68 "ASCII Character Set (Workstations)", and */
    /* Figure 71 "ASCII, EBCDIC, Unicode, and Symbol Equivalents" */
    {0x80, 0x00C7},	/* LATIN CAPITAL LETTER C WITH CEDILLA */
    {0x81, 0x00FC},	/* LATIN SMALL LETTER U WITH DIAERESIS */
    {0x82, 0x00E9},	/* LATIN SMALL LETTER E WITH ACUTE */
    {0x83, 0x00E2},	/* LATIN SMALL LETTER A WITH CIRCUMFLEX */
    {0x84, 0x00E4},	/* LATIN SMALL LETTER A WITH DIAERESIS */
    {0x85, 0x00E0},	/* LATIN SMALL LETTER A WITH GRAVE */
    {0x86, 0x00E5},	/* LATIN SMALL LETTER A WITH RING ABOVE */
    {0x87, 0x00E7},	/* LATIN SMALL LETTER C WITH CEDILLA */
    {0x88, 0x00EA},	/* LATIN SMALL LETTER E WITH CIRCUMFLEX */
    {0x89, 0x00EB},	/* LATIN SMALL LETTER E WITH DIAERESIS */
    {0x8A, 0x00E8},	/* LATIN SMALL LETTER E WITH GRAVE */
    {0x8B, 0x00EF},	/* LATIN SMALL LETTER I WITH DIAERESIS */
    {0x8C, 0x00EE},	/* LATIN SMALL LETTER I WITH CIRCUMFLEX */
    {0x8D, 0x00EC},	/* LATIN SMALL LETTER I WITH GRAVE */
    {0x8E, 0x00C4},	/* LATIN CAPITAL LETTER A WITH DIAERESIS */
    {0x8F, 0x00C5},	/* LATIN CAPITAL LETTER A WITH RING ABOVE */
    {0x90, 0x25AF},	/* WHITE VERTICAL RECTANGLE */
    {0x91, 0x235E},	/* APL FUNCTIONAL SYMBOL QUOTE QUAD */
    {0x92, 0x2339},	/* APL FUNCTIONAL SYMBOL QUAD DIVIDE */
    {0x93, 0x00F4},	/* LATIN SMALL LETTER O WITH CIRCUMFLEX */
    {0x94, 0x00F6},	/* LATIN SMALL LETTER O WITH DIAERESIS */
    {0x95, 0x00F2},	/* LATIN SMALL LETTER O WITH GRAVE */
    {0x96, 0x00FB},	/* LATIN SMALL LETTER U WITH CIRCUMFLEX */
    {0x97, 0x00F9},	/* LATIN SMALL LETTER U WITH GRAVE */
    {0x98, 0x22A4},	/* DOWN TACK */
    {0x99, 0x00D6},	/* LATIN CAPITAL LETTER O WITH DIAERESIS */
    {0x9A, 0x00DC},	/* LATIN CAPITAL LETTER U WITH DIAERESIS */
    {0x9B, 0x00F8},	/* LATIN SMALL LETTER O WITH STROKE */
    {0x9C, 0x00A3},	/* POUND SIGN */
    {0x9D, 0x22A5},	/* UP TACK */
    {0x9E, 0x2376},	/* APL FUNCTIONAL SYMBOL ALPHA UNDERBAR */
    {0x9F, 0x2336},	/* APL FUNCTIONAL SYMBOL I-BEAM */
    {0xA0, 0x00E1},	/* LATIN SMALL LETTER A WITH ACUTE */
    {0xA1, 0x00ED},	/* LATIN SMALL LETTER I WITH ACUTE */
    {0xA2, 0x00F3},	/* LATIN SMALL LETTER O WITH ACUTE */
    {0xA3, 0x00FA},	/* LATIN SMALL LETTER U WITH ACUTE */
    {0xA4, 0x00F1},	/* LATIN SMALL LETTER N WITH TILDE */
    {0xA5, 0x00D1},	/* LATIN CAPITAL LETTER N WITH TILDE */
    {0xA6, 0x00AA},	/* FEMININE ORDINAL INDICATOR */
    {0xA7, 0x00BA},	/* MASCULINE ORDINAL INDICATOR */
    {0xA8, 0x00BF},	/* INVERTED QUESTION MARK */
    {0xA9, 0x2308},	/* LEFT CEILING */
    {0xAA, 0x00AC},	/* NOT SIGN */
    {0xAB, 0x00BD},	/* VULGAR FRACTION ONE HALF */
    {0xAC, 0x222A},	/* UNION */
    {0xAD, 0x00A1},	/* INVERTED EXCLAMATION MARK */
    {0xAE, 0x2355},	/* APL FUNCTIONAL SYMBOL UP TACK JOT */
    {0xAF, 0x234E},	/* APL FUNCTIONAL SYMBOL DOWN TACK JOT */
    {0xB0, 0x2591},	/* LIGHT SHADE */
    {0xB1, 0x2592},	/* MEDIUM SHADE */
    {0xB2, 0x2593},	/* DARK SHADE */
    {0xB3, 0x2502},	/* BOX DRAWINGS LIGHT VERTICAL */
    {0xB4, 0x2524},	/* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
    {0xB5, 0x235F},	/* APL FUNCTIONAL SYMBOL CIRCLE STAR */
    {0xB6, 0x2206},	/* INCREMENT */
    {0xB7, 0x2207},	/* NABLA */
    {0xB8, 0x2192},	/* RIGHTWARDS ARROW */
    {0xB9, 0x2563},	/* BOX DRAWINGS DOUBLE VERTICAL AND LEFT */
    {0xBA, 0x2551},	/* BOX DRAWINGS DOUBLE VERTICAL */
    {0xBB, 0x2557},	/* BOX DRAWINGS DOUBLE DOWN AND LEFT */
    {0xBC, 0x255D},	/* BOX DRAWINGS DOUBLE UP AND LEFT */
    {0xBD, 0x2190},	/* LEFTWARDS ARROW */
    {0xBE, 0x230A},	/* LEFT FLOOR */
    {0xBF, 0x2510},	/* BOX DRAWINGS LIGHT DOWN AND LEFT */
    {0xC0, 0x2514},	/* BOX DRAWINGS LIGHT UP AND RIGHT */
    {0xC1, 0x2534},	/* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
    {0xC2, 0x252C},	/* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
    {0xC3, 0x251C},	/* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
    {0xC4, 0x2500},	/* BOX DRAWINGS LIGHT HORIZONTAL */
    {0xC5, 0x253C},	/* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
    {0xC6, 0x2191},	/* UPWARDS ARROW */
    {0xC7, 0x2193},	/* DOWNWARDS ARROW */
    {0xC8, 0x255A},	/* BOX DRAWINGS DOUBLE UP AND RIGHT */
    {0xC9, 0x2554},	/* BOX DRAWINGS DOUBLE DOWN AND RIGHT */
    {0xCA, 0x2569},	/* BOX DRAWINGS DOUBLE UP AND HORIZONTAL */
    {0xCB, 0x2566},	/* BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL */
    {0xCC, 0x2560},	/* BOX DRAWINGS DOUBLE VERTICAL AND RIGHT */
    {0xCD, 0x2550},	/* BOX DRAWINGS DOUBLE HORIZONTAL */
    {0xCE, 0x256C},	/* BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL */
    {0xCF, 0x2261},	/* IDENTICAL TO */
    {0xD0, 0x2378},	/* APL FUNCTIONAL SYMBOL IOTA UNDERBAR */
    {0xD1, 0x2377},	/* APL FUNCTIONAL SYMBOL EPSILON UNDERBAR */
    {0xD2, 0x2235},	/* BECAUSE */
    {0xD3, 0x2337},	/* APL FUNCTIONAL SYMBOL SQUISH QUAD */
    {0xD4, 0x2342},	/* APL FUNCTIONAL SYMBOL QUAD BACKSLASH */
    {0xD5, 0x233B},	/* APL FUNCTIONAL SYMBOL QUAD JOT */
    {0xD6, 0x22A2},	/* RIGHT TACK */
    {0xD7, 0x22A3},	/* LEFT TACK */
    {0xD8, 0x25CA},	/* LOZENGE */
    {0xD9, 0x2518},	/* BOX DRAWINGS LIGHT UP AND LEFT */
    {0xDA, 0x250C},	/* BOX DRAWINGS LIGHT DOWN AND RIGHT */
    {0xDB, 0x2588},	/* FULL BLOCK */
    {0xDC, 0x2584},	/* LOWER HALF BLOCK */
    {0xDD, 0x00A6},	/* BROKEN BAR */
    {0xDE, 0x00CC},	/* LATIN CAPITAL LETTER I WITH GRAVE */
    {0xDF, 0x2580},	/* UPPER HALF BLOCK */
    {0xE0, 0x237A},	/* APL FUNCTIONAL SYMBOL ALPHA */
    {0xE1, 0x2379},	/* APL FUNCTIONAL SYMBOL OMEGA UNDERBAR */
    {0xE2, 0x2282},	/* SUBSET OF */
    {0xE3, 0x2283},	/* SUPERSET OF */
    {0xE4, 0x235D},	/* APL FUNCTIONAL SYMBOL UP SHOE JOT */
    {0xE5, 0x2372},	/* APL FUNCTIONAL SYMBOL UP CARET TILDE */
    {0xE6, 0x2374},	/* APL FUNCTIONAL SYMBOL RHO */
    {0xE7, 0x2371},	/* APL FUNCTIONAL SYMBOL DOWN CARET TILDE */
    {0xE8, 0x233D},	/* APL FUNCTIONAL SYMBOL CIRCLE STILE */
    {0xE9, 0x2296},	/* CIRCLED MINUS */
    {0xEA, 0x25CB},	/* WHITE CIRCLE */
    {0xEB, 0x2228},	/* LOGICAL OR */
    {0xEC, 0x2373},	/* APL FUNCTIONAL SYMBOL IOTA */
    {0xED, 0x2349},	/* APL FUNCTIONAL SYMBOL CIRCLE BACKSLASH */
    {0xEE, 0x220A},	/* SMALL ELEMENT OF */
    {0xEF, 0x2229},	/* INTERSECTION */
    {0xF0, 0x233F},	/* APL FUNCTIONAL SYMBOL SLASH BAR */
    {0xF1, 0x2340},	/* APL FUNCTIONAL SYMBOL BACKSLASH BAR */
    {0xF2, 0x2265},	/* GREATER-THAN OR EQUAL TO */
    {0xF3, 0x2264},	/* LESS-THAN OR EQUAL TO */
    {0xF4, 0x2260},	/* NOT EQUAL TO */
    {0xF5, 0x00D7},	/* MULTIPLICATION SIGN */
    {0xF6, 0x00F7},	/* DIVISION SIGN */
    {0xF7, 0x2359},	/* APL FUNCTIONAL SYMBOL DELTA UNDERBAR */
    {0xF8, 0x2218},	/* RING OPERATOR */
    {0xF9, 0x2375},	/* APL FUNCTIONAL SYMBOL OMEGA */
    {0xFA, 0x236B},	/* APL FUNCTIONAL SYMBOL DEL TILDE */
    {0xFB, 0x234B},	/* APL FUNCTIONAL SYMBOL DELTA STILE */
    {0xFC, 0x2352},	/* APL FUNCTIONAL SYMBOL DEL STILE */
    {0xFD, 0x00AF},	/* MACRON */
    {0xFE, 0x00A8},	/* DIAERESIS */
    {0xFF, 0x00A0},	/* NO-BREAK SPACE */
};

static const BuiltInMapping dec_special[] =
{
    /* This file is derived from the file data.c in the XTerm sources */
    {0x5F, 0x25AE},	/* BLACK VERTICAL RECTANGLE */
    {0x60, 0x25C6},	/* BLACK DIAMOND */
    {0x61, 0x2592},	/* MEDIUM SHADE */
    {0x62, 0x2409},	/* SYMBOL FOR HORIZONTAL TABULATION */
    {0x63, 0x240C},	/* SYMBOL FOR FORM FEED */
    {0x64, 0x240D},	/* SYMBOL FOR CARRIAGE RETURN */
    {0x65, 0x240A},	/* SYMBOL FOR LINE FEED */
    {0x66, 0x00B0},	/* DEGREE SIGN */
    {0x67, 0x00B1},	/* PLUS-MINUS SIGN */
    {0x68, 0x2424},	/* SYMBOL FOR NEWLINE */
    {0x69, 0x240B},	/* SYMBOL FOR VERTICAL TABULATION */
    {0x6A, 0x2518},	/* BOX DRAWINGS LIGHT UP AND LEFT */
    {0x6B, 0x2510},	/* BOX DRAWINGS LIGHT DOWN AND LEFT */
    {0x6C, 0x250C},	/* BOX DRAWINGS LIGHT DOWN AND RIGHT */
    {0x6D, 0x2514},	/* BOX DRAWINGS LIGHT UP AND RIGHT */
    {0x6E, 0x253C},	/* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
    {0x6F, 0x23BA},	/* HORIZONTAL SCAN LINE-1 */
    {0x70, 0x23BB},	/* HORIZONTAL SCAN LINE-3 */
    {0x71, 0x2500},	/* BOX DRAWINGS LIGHT HORIZONTAL */
    {0x72, 0x23BC},	/* HORIZONTAL SCAN LINE-7 */
    {0x73, 0x23BD},	/* HORIZONTAL SCAN LINE-9 */
    {0x74, 0x251C},	/* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
    {0x75, 0x2524},	/* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
    {0x76, 0x2534},	/* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
    {0x77, 0x252C},	/* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
    {0x78, 0x2502},	/* BOX DRAWINGS LIGHT VERTICAL */
    {0x79, 0x2264},	/* LESS-THAN OR EQUAL TO */
    {0x7A, 0x2265},	/* GREATER-THAN OR EQUAL TO */
    {0x7B, 0x03C0},	/* GREEK SMALL LETTER PI */
    {0x7C, 0x2260},	/* NOT EQUAL TO */
    {0x7D, 0x00A3},	/* POUND SIGN */
    {0x7E, 0x00B7},	/* MIDDLE DOT */
};

static const BuiltInMapping dec_technical[] =
{
    /* derived from http://www.vt100.net/charsets/technical.html */
    {0x21, 0x23b7},	/* RADICAL SYMBOL BOTTOM Centred left to right, so that it joins up with 02/02 */
    {0x22, 0x250c},	/* BOX DRAWINGS LIGHT DOWN AND RIGHT */
    {0x23, 0x2500},	/* BOX DRAWINGS LIGHT HORIZONTAL */
    {0x24, 0x2320},	/* TOP HALF INTEGRAL with the proviso that the stem is vertical, to join with 02/06 */
    {0x25, 0x2321},	/* BOTTOM HALF INTEGRAL with the proviso above. */
    {0x26, 0x2502},	/* BOX DRAWINGS LIGHT VERTICAL */
    {0x27, 0x23a1},	/* LEFT SQUARE BRACKET UPPER CORNER Joins vertically to 02/06, 02/08. Doesn't join to its right. */
    {0x28, 0x23a3},	/* LEFT SQUARE BRACKET LOWER CORNER Joins vertically to 02/06, 02/07. Doesn't join to its right. */
    {0x29, 0x23a4},	/* RIGHT SQUARE BRACKET UPPER CORNER Joins vertically to 026, 02a. Doesn't join to its left. */
    {0x2a, 0x23a6},	/* RIGHT SQUARE BRACKET LOWER CORNER Joins vertically to 026, 029. Doesn't join to its left. */
    {0x2b, 0x239b},	/* LEFT PARENTHESIS UPPER HOOK Joins vertically to 026, 02c, 02/15. Doesn't join to its right. */
    {0x2c, 0x239d},	/* LEFT PARENTHESIS LOWER HOOK Joins vertically to 026, 02b, 02/15. Doesn't join to its right. */
    {0x2d, 0x239e},	/* RIGHT PARENTHESIS UPPER HOOK Joins vertically to 026, 02e, 03/00. Doesn't join to its left. */
    {0x2e, 0x23a0},	/* RIGHT PARENTHESIS LOWER HOOK Joins vertically to 026, 02d, 03/00. Doesn't join to its left. */
    {0x2f, 0x23a8},	/* LEFT CURLY BRACKET MIDDLE PIECE Joins vertically to 026, 02b, 02c. */
    {0x30, 0x23ac},	/* RIGHT CURLY BRACKET MIDDLE PIECE Joins vertically to 02/06, 02d, 02e. */
    {0x31, 0x2426},	/* Top Left Sigma. Joins to right with 02/03, 03/05. Joins diagonally below right with 03/03, 03/07. */
    {0x32, 0x2426},	/* Bottom Left Sigma. Joins to right with 02/03, 03/06. Joins diagonally above right with 03/04, 03/07. */
    {0x33, 0x2426},	/* Top Diagonal Sigma. Line for joining 03/01 to 03/04 or 03/07. */
    {0x34, 0x2426},	/* Bottom Diagonal Sigma. Line for joining 03/02 to 03/03 or 03/07. */
    {0x35, 0x2426},	/* Top Right Sigma. Joins to left with 02/03, 03/01. */
    {0x36, 0x2426},	/* Bottom Right Sigma. Joins to left with 02/03, 03/02. */
    {0x37, 0x2426},	/* Middle Sigma. Joins diagonally with 03/01, 03/02, 03/03, 03/04. */
    {0x38, 0x2426},	/* undefined */
    {0x39, 0x2426},	/* undefined */
    {0x3a, 0x2426},	/* undefined */
    {0x3b, 0x2426},	/* undefined */
    {0x3c, 0x2264},	/* LESS-THAN OR EQUAL TO */
    {0x3d, 0x2260},	/* NOT EQUAL TO */
    {0x3e, 0x2265},	/* GREATER-THAN OR EQUAL TO */
    {0x3f, 0x222B},	/* INTEGRAL */
    {0x40, 0x2234},	/* THEREFORE */
    {0x41, 0x221d},	/* PROPORTIONAL TO */
    {0x42, 0x221e},	/* INFINITY */
    {0x43, 0x00f7},	/* DIVISION SIGN */
    {0x44, 0x039a},	/* GREEK CAPITAL DELTA */
    {0x45, 0x2207},	/* NABLA */
    {0x46, 0x03a6},	/* GREEK CAPITAL LETTER PHI */
    {0x47, 0x0393},	/* GREEK CAPITAL LETTER GAMMA */
    {0x48, 0x223c},	/* TILDE OPERATOR */
    {0x49, 0x2243},	/* ASYMPTOTICALLY EQUAL TO */
    {0x4a, 0x0398},	/* GREEK CAPITAL LETTER THETA */
    {0x4b, 0x00d7},	/* MULTIPLICATION SIGN */
    {0x4c, 0x039b},	/* GREEK CAPITAL LETTER LAMDA */
    {0x4d, 0x21d4},	/* LEFT RIGHT DOUBLE ARROW */
    {0x4e, 0x21d2},	/* RIGHTWARDS DOUBLE ARROW */
    {0x4f, 0x2261},	/* IDENTICAL TO */
    {0x50, 0x03a0},	/* GREEK CAPITAL LETTER PI */
    {0x51, 0x03a8},	/* GREEK CAPITAL LETTER PSI */
    {0x52, 0x2426},	/* undefined */
    {0x53, 0x03a3},	/* GREEK CAPITAL LETTER SIGMA */
    {0x54, 0x2426},	/* undefined */
    {0x55, 0x2426},	/* undefined */
    {0x56, 0x221a},	/* SQUARE ROOT */
    {0x57, 0x03a9},	/* GREEK CAPITAL LETTER OMEGA */
    {0x58, 0x039e},	/* GREEK CAPITAL LETTER XI */
    {0x59, 0x03a5},	/* GREEK CAPITAL LETTER UPSILON */
    {0x5a, 0x2282},	/* SUBSET OF */
    {0x5b, 0x2283},	/* SUPERSET OF */
    {0x5c, 0x2229},	/* INTERSECTION */
    {0x5d, 0x222a},	/* UNION */
    {0x5e, 0x2227},	/* LOGICAL AND */
    {0x5f, 0x2228},	/* LOGICAL OR */
    {0x60, 0x00ac},	/* NOT SIGN */
    {0x61, 0x03b1},	/* GREEK SMALL LETTER ALPHA */
    {0x62, 0x03b2},	/* GREEK SMALL LETTER BETA */
    {0x63, 0x03c7},	/* GREEK SMALL LETTER CHI */
    {0x64, 0x03b4},	/* GREEK SMALL LETTER DELTA */
    {0x65, 0x03b5},	/* GREEK SMALL LETTER EPSILON */
    {0x66, 0x03c6},	/* GREEK SMALL LETTER PHI */
    {0x67, 0x03b3},	/* GREEK SMALL LETTER GAMMA */
    {0x68, 0x03b7},	/* GREEK SMALL LETTER ETA */
    {0x69, 0x03b9},	/* GREEK SMALL LETTER IOTA */
    {0x6a, 0x03b8},	/* GREEK SMALL LETTER THETA */
    {0x6b, 0x03ba},	/* GREEK SMALL LETTER KAPPA */
    {0x6c, 0x03bb},	/* GREEK SMALL LETTER LAMDA */
    {0x6d, 0x2426},	/* undefined */
    {0x6e, 0x03bd},	/* GREEK SMALL LETTER NU */
    {0x6f, 0x2202},	/* PARTIAL DIFFERENTIAL */
    {0x70, 0x03c0},	/* GREEK SMALL LETTER PI */
    {0x71, 0x03c8},	/* GREEK SMALL LETTER PSI */
    {0x72, 0x03c1},	/* GREEK SMALL LETTER RHO */
    {0x73, 0x03c3},	/* GREEK SMALL LETTER SIGMA */
    {0x74, 0x03c4},	/* GREEK SMALL LETTER TAU */
    {0x75, 0x2426},	/* undefined */
    {0x76, 0x0192},	/* LATIN SMALL LETTER F WITH HOOK Probably chosen for its meaning of "function" */
    {0x77, 0x03c9},	/* GREEK SMALL LETTER OMEGA */
    {0x78, 0x03bE},	/* GREEK SMALL LETTER XI */
    {0x79, 0x03c5},	/* GREEK SMALL LETTER UPSILON */
    {0x7a, 0x03b6},	/* GREEK SMALL LETTER ZETA */
    {0x7b, 0x2190},	/* LEFTWARDS ARROW */
    {0x7c, 0x2191},	/* UPWARDS ARROW */
    {0x7d, 0x2192},	/* RIGHTWARDS ARROW */
    {0x7e, 0x2193},	/* DOWNWARDS ARROW */
};

static const BuiltInMapping iso8859_1[] =
{
    /* iso8859-1 */
    {0, 0},	/* empty table is illegal syntax */
};

static const BuiltInMapping iso8859_10[] =
{
    /* iso8859-10 */
    {0x00A1, 0x0104},	/* LATIN CAPITAL LETTER A WITH OGONEK */
    {0x00A2, 0x0112},	/* LATIN CAPITAL LETTER E WITH MACRON */
    {0x00A3, 0x0122},	/* LATIN CAPITAL LETTER G WITH CEDILLA */
    {0x00A4, 0x012A},	/* LATIN CAPITAL LETTER I WITH MACRON */
    {0x00A5, 0x0128},	/* LATIN CAPITAL LETTER I WITH TILDE */
    {0x00A6, 0x0136},	/* LATIN CAPITAL LETTER K WITH CEDILLA */
    {0x00A8, 0x013B},	/* LATIN CAPITAL LETTER L WITH CEDILLA */
    {0x00A9, 0x0110},	/* LATIN CAPITAL LETTER D WITH STROKE */
    {0x00AA, 0x0160},	/* LATIN CAPITAL LETTER S WITH CARON */
    {0x00AB, 0x0166},	/* LATIN CAPITAL LETTER T WITH STROKE */
    {0x00AC, 0x017D},	/* LATIN CAPITAL LETTER Z WITH CARON */
    {0x00AE, 0x016A},	/* LATIN CAPITAL LETTER U WITH MACRON */
    {0x00AF, 0x014A},	/* LATIN CAPITAL LETTER ENG */
    {0x00B1, 0x0105},	/* LATIN SMALL LETTER A WITH OGONEK */
    {0x00B2, 0x0113},	/* LATIN SMALL LETTER E WITH MACRON */
    {0x00B3, 0x0123},	/* LATIN SMALL LETTER G WITH CEDILLA */
    {0x00B4, 0x012B},	/* LATIN SMALL LETTER I WITH MACRON */
    {0x00B5, 0x0129},	/* LATIN SMALL LETTER I WITH TILDE */
    {0x00B6, 0x0137},	/* LATIN SMALL LETTER K WITH CEDILLA */
    {0x00B8, 0x013C},	/* LATIN SMALL LETTER L WITH CEDILLA */
    {0x00B9, 0x0111},	/* LATIN SMALL LETTER D WITH STROKE */
    {0x00BA, 0x0161},	/* LATIN SMALL LETTER S WITH CARON */
    {0x00BB, 0x0167},	/* LATIN SMALL LETTER T WITH STROKE */
    {0x00BC, 0x017E},	/* LATIN SMALL LETTER Z WITH CARON */
    {0x00BD, 0x2015},	/* HORIZONTAL BAR */
    {0x00BE, 0x016B},	/* LATIN SMALL LETTER U WITH MACRON */
    {0x00BF, 0x014B},	/* LATIN SMALL LETTER ENG */
    {0x00C0, 0x0100},	/* LATIN CAPITAL LETTER A WITH MACRON */
    {0x00C7, 0x012E},	/* LATIN CAPITAL LETTER I WITH OGONEK */
    {0x00C8, 0x010C},	/* LATIN CAPITAL LETTER C WITH CARON */
    {0x00CA, 0x0118},	/* LATIN CAPITAL LETTER E WITH OGONEK */
    {0x00CC, 0x0116},	/* LATIN CAPITAL LETTER E WITH DOT ABOVE */
    {0x00D1, 0x0145},	/* LATIN CAPITAL LETTER N WITH CEDILLA */
    {0x00D2, 0x014C},	/* LATIN CAPITAL LETTER O WITH MACRON */
    {0x00D7, 0x0168},	/* LATIN CAPITAL LETTER U WITH TILDE */
    {0x00D9, 0x0172},	/* LATIN CAPITAL LETTER U WITH OGONEK */
    {0x00E0, 0x0101},	/* LATIN SMALL LETTER A WITH MACRON */
    {0x00E7, 0x012F},	/* LATIN SMALL LETTER I WITH OGONEK */
    {0x00E8, 0x010D},	/* LATIN SMALL LETTER C WITH CARON */
    {0x00EA, 0x0119},	/* LATIN SMALL LETTER E WITH OGONEK */
    {0x00EC, 0x0117},	/* LATIN SMALL LETTER E WITH DOT ABOVE */
    {0x00F1, 0x0146},	/* LATIN SMALL LETTER N WITH CEDILLA */
    {0x00F2, 0x014D},	/* LATIN SMALL LETTER O WITH MACRON */
    {0x00F7, 0x0169},	/* LATIN SMALL LETTER U WITH TILDE */
    {0x00F9, 0x0173},	/* LATIN SMALL LETTER U WITH OGONEK */
    {0x00FF, 0x0138},	/* LATIN SMALL LETTER KRA */
};

static const BuiltInMapping iso8859_15[] =
{
    /* iso8859-15 */
    {0x00A4, 0x20AC},	/* EURO SIGN */
    {0x00A6, 0x0160},	/* LATIN CAPITAL LETTER S WITH CARON */
    {0x00A8, 0x0161},	/* LATIN SMALL LETTER S WITH CARON */
    {0x00B4, 0x017D},	/* LATIN CAPITAL LETTER Z WITH CARON */
    {0x00B8, 0x017E},	/* LATIN SMALL LETTER Z WITH CARON */
    {0x00BC, 0x0152},	/* LATIN CAPITAL LIGATURE OE */
    {0x00BD, 0x0153},	/* LATIN SMALL LIGATURE OE */
    {0x00BE, 0x0178},	/* LATIN CAPITAL LETTER Y WITH DIAERESIS */
};

static const BuiltInMapping iso8859_2[] =
{
    /* iso8859-2 */
    {0x00A1, 0x0104},	/* LATIN CAPITAL LETTER A WITH OGONEK */
    {0x00A2, 0x02D8},	/* BREVE */
    {0x00A3, 0x0141},	/* LATIN CAPITAL LETTER L WITH STROKE */
    {0x00A5, 0x013D},	/* LATIN CAPITAL LETTER L WITH CARON */
    {0x00A6, 0x015A},	/* LATIN CAPITAL LETTER S WITH ACUTE */
    {0x00A9, 0x0160},	/* LATIN CAPITAL LETTER S WITH CARON */
    {0x00AA, 0x015E},	/* LATIN CAPITAL LETTER S WITH CEDILLA */
    {0x00AB, 0x0164},	/* LATIN CAPITAL LETTER T WITH CARON */
    {0x00AC, 0x0179},	/* LATIN CAPITAL LETTER Z WITH ACUTE */
    {0x00AE, 0x017D},	/* LATIN CAPITAL LETTER Z WITH CARON */
    {0x00AF, 0x017B},	/* LATIN CAPITAL LETTER Z WITH DOT ABOVE */
    {0x00B1, 0x0105},	/* LATIN SMALL LETTER A WITH OGONEK */
    {0x00B2, 0x02DB},	/* OGONEK */
    {0x00B3, 0x0142},	/* LATIN SMALL LETTER L WITH STROKE */
    {0x00B5, 0x013E},	/* LATIN SMALL LETTER L WITH CARON */
    {0x00B6, 0x015B},	/* LATIN SMALL LETTER S WITH ACUTE */
    {0x00B7, 0x02C7},	/* CARON */
    {0x00B9, 0x0161},	/* LATIN SMALL LETTER S WITH CARON */
    {0x00BA, 0x015F},	/* LATIN SMALL LETTER S WITH CEDILLA */
    {0x00BB, 0x0165},	/* LATIN SMALL LETTER T WITH CARON */
    {0x00BC, 0x017A},	/* LATIN SMALL LETTER Z WITH ACUTE */
    {0x00BD, 0x02DD},	/* DOUBLE ACUTE ACCENT */
    {0x00BE, 0x017E},	/* LATIN SMALL LETTER Z WITH CARON */
    {0x00BF, 0x017C},	/* LATIN SMALL LETTER Z WITH DOT ABOVE */
    {0x00C0, 0x0154},	/* LATIN CAPITAL LETTER R WITH ACUTE */
    {0x00C3, 0x0102},	/* LATIN CAPITAL LETTER A WITH BREVE */
    {0x00C5, 0x0139},	/* LATIN CAPITAL LETTER L WITH ACUTE */
    {0x00C6, 0x0106},	/* LATIN CAPITAL LETTER C WITH ACUTE */
    {0x00C8, 0x010C},	/* LATIN CAPITAL LETTER C WITH CARON */
    {0x00CA, 0x0118},	/* LATIN CAPITAL LETTER E WITH OGONEK */
    {0x00CC, 0x011A},	/* LATIN CAPITAL LETTER E WITH CARON */
    {0x00CF, 0x010E},	/* LATIN CAPITAL LETTER D WITH CARON */
    {0x00D0, 0x0110},	/* LATIN CAPITAL LETTER D WITH STROKE */
    {0x00D1, 0x0143},	/* LATIN CAPITAL LETTER N WITH ACUTE */
    {0x00D2, 0x0147},	/* LATIN CAPITAL LETTER N WITH CARON */
    {0x00D5, 0x0150},	/* LATIN CAPITAL LETTER O WITH DOUBLE ACUTE */
    {0x00D8, 0x0158},	/* LATIN CAPITAL LETTER R WITH CARON */
    {0x00D9, 0x016E},	/* LATIN CAPITAL LETTER U WITH RING ABOVE */
    {0x00DB, 0x0170},	/* LATIN CAPITAL LETTER U WITH DOUBLE ACUTE */
    {0x00DE, 0x0162},	/* LATIN CAPITAL LETTER T WITH CEDILLA */
    {0x00E0, 0x0155},	/* LATIN SMALL LETTER R WITH ACUTE */
    {0x00E3, 0x0103},	/* LATIN SMALL LETTER A WITH BREVE */
    {0x00E5, 0x013A},	/* LATIN SMALL LETTER L WITH ACUTE */
    {0x00E6, 0x0107},	/* LATIN SMALL LETTER C WITH ACUTE */
    {0x00E8, 0x010D},	/* LATIN SMALL LETTER C WITH CARON */
    {0x00EA, 0x0119},	/* LATIN SMALL LETTER E WITH OGONEK */
    {0x00EC, 0x011B},	/* LATIN SMALL LETTER E WITH CARON */
    {0x00EF, 0x010F},	/* LATIN SMALL LETTER D WITH CARON */
    {0x00F0, 0x0111},	/* LATIN SMALL LETTER D WITH STROKE */
    {0x00F1, 0x0144},	/* LATIN SMALL LETTER N WITH ACUTE */
    {0x00F2, 0x0148},	/* LATIN SMALL LETTER N WITH CARON */
    {0x00F5, 0x0151},	/* LATIN SMALL LETTER O WITH DOUBLE ACUTE */
    {0x00F8, 0x0159},	/* LATIN SMALL LETTER R WITH CARON */
    {0x00F9, 0x016F},	/* LATIN SMALL LETTER U WITH RING ABOVE */
    {0x00FB, 0x0171},	/* LATIN SMALL LETTER U WITH DOUBLE ACUTE */
    {0x00FE, 0x0163},	/* LATIN SMALL LETTER T WITH CEDILLA */
    {0x00FF, 0x02D9},	/* DOT ABOVE */
};

static const BuiltInMapping iso8859_3[] =
{
    /* iso8859-3 */
    {0x00A1, 0x0126},	/* LATIN CAPITAL LETTER H WITH STROKE */
    {0x00A2, 0x02D8},	/* BREVE */
    {0x00A6, 0x0124},	/* LATIN CAPITAL LETTER H WITH CIRCUMFLEX */
    {0x00A9, 0x0130},	/* LATIN CAPITAL LETTER I WITH DOT ABOVE */
    {0x00AA, 0x015E},	/* LATIN CAPITAL LETTER S WITH CEDILLA */
    {0x00AB, 0x011E},	/* LATIN CAPITAL LETTER G WITH BREVE */
    {0x00AC, 0x0134},	/* LATIN CAPITAL LETTER J WITH CIRCUMFLEX */
    {0x00AF, 0x017B},	/* LATIN CAPITAL LETTER Z WITH DOT ABOVE */
    {0x00B1, 0x0127},	/* LATIN SMALL LETTER H WITH STROKE */
    {0x00B6, 0x0125},	/* LATIN SMALL LETTER H WITH CIRCUMFLEX */
    {0x00B9, 0x0131},	/* LATIN SMALL LETTER DOTLESS I */
    {0x00BA, 0x015F},	/* LATIN SMALL LETTER S WITH CEDILLA */
    {0x00BB, 0x011F},	/* LATIN SMALL LETTER G WITH BREVE */
    {0x00BC, 0x0135},	/* LATIN SMALL LETTER J WITH CIRCUMFLEX */
    {0x00BF, 0x017C},	/* LATIN SMALL LETTER Z WITH DOT ABOVE */
    {0x00C5, 0x010A},	/* LATIN CAPITAL LETTER C WITH DOT ABOVE */
    {0x00C6, 0x0108},	/* LATIN CAPITAL LETTER C WITH CIRCUMFLEX */
    {0x00D5, 0x0120},	/* LATIN CAPITAL LETTER G WITH DOT ABOVE */
    {0x00D8, 0x011C},	/* LATIN CAPITAL LETTER G WITH CIRCUMFLEX */
    {0x00DD, 0x016C},	/* LATIN CAPITAL LETTER U WITH BREVE */
    {0x00DE, 0x015C},	/* LATIN CAPITAL LETTER S WITH CIRCUMFLEX */
    {0x00E5, 0x010B},	/* LATIN SMALL LETTER C WITH DOT ABOVE */
    {0x00E6, 0x0109},	/* LATIN SMALL LETTER C WITH CIRCUMFLEX */
    {0x00F5, 0x0121},	/* LATIN SMALL LETTER G WITH DOT ABOVE */
    {0x00F8, 0x011D},	/* LATIN SMALL LETTER G WITH CIRCUMFLEX */
    {0x00FD, 0x016D},	/* LATIN SMALL LETTER U WITH BREVE */
    {0x00FE, 0x015D},	/* LATIN SMALL LETTER S WITH CIRCUMFLEX */
    {0x00FF, 0x02D9},	/* DOT ABOVE */
};

static const BuiltInMapping iso8859_4[] =
{
    /* iso8859-4 */
    {0x00A1, 0x0104},	/* LATIN CAPITAL LETTER A WITH OGONEK */
    {0x00A2, 0x0138},	/* LATIN SMALL LETTER KRA */
    {0x00A3, 0x0156},	/* LATIN CAPITAL LETTER R WITH CEDILLA */
    {0x00A5, 0x0128},	/* LATIN CAPITAL LETTER I WITH TILDE */
    {0x00A6, 0x013B},	/* LATIN CAPITAL LETTER L WITH CEDILLA */
    {0x00A9, 0x0160},	/* LATIN CAPITAL LETTER S WITH CARON */
    {0x00AA, 0x0112},	/* LATIN CAPITAL LETTER E WITH MACRON */
    {0x00AB, 0x0122},	/* LATIN CAPITAL LETTER G WITH CEDILLA */
    {0x00AC, 0x0166},	/* LATIN CAPITAL LETTER T WITH STROKE */
    {0x00AE, 0x017D},	/* LATIN CAPITAL LETTER Z WITH CARON */
    {0x00B1, 0x0105},	/* LATIN SMALL LETTER A WITH OGONEK */
    {0x00B2, 0x02DB},	/* OGONEK */
    {0x00B3, 0x0157},	/* LATIN SMALL LETTER R WITH CEDILLA */
    {0x00B5, 0x0129},	/* LATIN SMALL LETTER I WITH TILDE */
    {0x00B6, 0x013C},	/* LATIN SMALL LETTER L WITH CEDILLA */
    {0x00B7, 0x02C7},	/* CARON */
    {0x00B9, 0x0161},	/* LATIN SMALL LETTER S WITH CARON */
    {0x00BA, 0x0113},	/* LATIN SMALL LETTER E WITH MACRON */
    {0x00BB, 0x0123},	/* LATIN SMALL LETTER G WITH CEDILLA */
    {0x00BC, 0x0167},	/* LATIN SMALL LETTER T WITH STROKE */
    {0x00BD, 0x014A},	/* LATIN CAPITAL LETTER ENG */
    {0x00BE, 0x017E},	/* LATIN SMALL LETTER Z WITH CARON */
    {0x00BF, 0x014B},	/* LATIN SMALL LETTER ENG */
    {0x00C0, 0x0100},	/* LATIN CAPITAL LETTER A WITH MACRON */
    {0x00C7, 0x012E},	/* LATIN CAPITAL LETTER I WITH OGONEK */
    {0x00C8, 0x010C},	/* LATIN CAPITAL LETTER C WITH CARON */
    {0x00CA, 0x0118},	/* LATIN CAPITAL LETTER E WITH OGONEK */
    {0x00CC, 0x0116},	/* LATIN CAPITAL LETTER E WITH DOT ABOVE */
    {0x00CF, 0x012A},	/* LATIN CAPITAL LETTER I WITH MACRON */
    {0x00D0, 0x0110},	/* LATIN CAPITAL LETTER D WITH STROKE */
    {0x00D1, 0x0145},	/* LATIN CAPITAL LETTER N WITH CEDILLA */
    {0x00D2, 0x014C},	/* LATIN CAPITAL LETTER O WITH MACRON */
    {0x00D3, 0x0136},	/* LATIN CAPITAL LETTER K WITH CEDILLA */
    {0x00D9, 0x0172},	/* LATIN CAPITAL LETTER U WITH OGONEK */
    {0x00DD, 0x0168},	/* LATIN CAPITAL LETTER U WITH TILDE */
    {0x00DE, 0x016A},	/* LATIN CAPITAL LETTER U WITH MACRON */
    {0x00E0, 0x0101},	/* LATIN SMALL LETTER A WITH MACRON */
    {0x00E7, 0x012F},	/* LATIN SMALL LETTER I WITH OGONEK */
    {0x00E8, 0x010D},	/* LATIN SMALL LETTER C WITH CARON */
    {0x00EA, 0x0119},	/* LATIN SMALL LETTER E WITH OGONEK */
    {0x00EC, 0x0117},	/* LATIN SMALL LETTER E WITH DOT ABOVE */
    {0x00EF, 0x012B},	/* LATIN SMALL LETTER I WITH MACRON */
    {0x00F0, 0x0111},	/* LATIN SMALL LETTER D WITH STROKE */
    {0x00F1, 0x0146},	/* LATIN SMALL LETTER N WITH CEDILLA */
    {0x00F2, 0x014D},	/* LATIN SMALL LETTER O WITH MACRON */
    {0x00F3, 0x0137},	/* LATIN SMALL LETTER K WITH CEDILLA */
    {0x00F9, 0x0173},	/* LATIN SMALL LETTER U WITH OGONEK */
    {0x00FD, 0x0169},	/* LATIN SMALL LETTER U WITH TILDE */
    {0x00FE, 0x016B},	/* LATIN SMALL LETTER U WITH MACRON */
    {0x00FF, 0x02D9},	/* DOT ABOVE */
};

static const BuiltInMapping iso8859_5[] =
{
    /* iso8859-5 */
    {0x00A1, 0x0401},	/* CYRILLIC CAPITAL LETTER IO */
    {0x00A2, 0x0402},	/* CYRILLIC CAPITAL LETTER DJE */
    {0x00A3, 0x0403},	/* CYRILLIC CAPITAL LETTER GJE */
    {0x00A4, 0x0404},	/* CYRILLIC CAPITAL LETTER UKRAINIAN IE */
    {0x00A5, 0x0405},	/* CYRILLIC CAPITAL LETTER DZE */
    {0x00A6, 0x0406},	/* CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I */
    {0x00A7, 0x0407},	/* CYRILLIC CAPITAL LETTER YI */
    {0x00A8, 0x0408},	/* CYRILLIC CAPITAL LETTER JE */
    {0x00A9, 0x0409},	/* CYRILLIC CAPITAL LETTER LJE */
    {0x00AA, 0x040A},	/* CYRILLIC CAPITAL LETTER NJE */
    {0x00AB, 0x040B},	/* CYRILLIC CAPITAL LETTER TSHE */
    {0x00AC, 0x040C},	/* CYRILLIC CAPITAL LETTER KJE */
    {0x00AE, 0x040E},	/* CYRILLIC CAPITAL LETTER SHORT U */
    {0x00AF, 0x040F},	/* CYRILLIC CAPITAL LETTER DZHE */
    {0x00B0, 0x0410},	/* CYRILLIC CAPITAL LETTER A */
    {0x00B1, 0x0411},	/* CYRILLIC CAPITAL LETTER BE */
    {0x00B2, 0x0412},	/* CYRILLIC CAPITAL LETTER VE */
    {0x00B3, 0x0413},	/* CYRILLIC CAPITAL LETTER GHE */
    {0x00B4, 0x0414},	/* CYRILLIC CAPITAL LETTER DE */
    {0x00B5, 0x0415},	/* CYRILLIC CAPITAL LETTER IE */
    {0x00B6, 0x0416},	/* CYRILLIC CAPITAL LETTER ZHE */
    {0x00B7, 0x0417},	/* CYRILLIC CAPITAL LETTER ZE */
    {0x00B8, 0x0418},	/* CYRILLIC CAPITAL LETTER I */
    {0x00B9, 0x0419},	/* CYRILLIC CAPITAL LETTER SHORT I */
    {0x00BA, 0x041A},	/* CYRILLIC CAPITAL LETTER KA */
    {0x00BB, 0x041B},	/* CYRILLIC CAPITAL LETTER EL */
    {0x00BC, 0x041C},	/* CYRILLIC CAPITAL LETTER EM */
    {0x00BD, 0x041D},	/* CYRILLIC CAPITAL LETTER EN */
    {0x00BE, 0x041E},	/* CYRILLIC CAPITAL LETTER O */
    {0x00BF, 0x041F},	/* CYRILLIC CAPITAL LETTER PE */
    {0x00C0, 0x0420},	/* CYRILLIC CAPITAL LETTER ER */
    {0x00C1, 0x0421},	/* CYRILLIC CAPITAL LETTER ES */
    {0x00C2, 0x0422},	/* CYRILLIC CAPITAL LETTER TE */
    {0x00C3, 0x0423},	/* CYRILLIC CAPITAL LETTER U */
    {0x00C4, 0x0424},	/* CYRILLIC CAPITAL LETTER EF */
    {0x00C5, 0x0425},	/* CYRILLIC CAPITAL LETTER HA */
    {0x00C6, 0x0426},	/* CYRILLIC CAPITAL LETTER TSE */
    {0x00C7, 0x0427},	/* CYRILLIC CAPITAL LETTER CHE */
    {0x00C8, 0x0428},	/* CYRILLIC CAPITAL LETTER SHA */
    {0x00C9, 0x0429},	/* CYRILLIC CAPITAL LETTER SHCHA */
    {0x00CA, 0x042A},	/* CYRILLIC CAPITAL LETTER HARD SIGN */
    {0x00CB, 0x042B},	/* CYRILLIC CAPITAL LETTER YERU */
    {0x00CC, 0x042C},	/* CYRILLIC CAPITAL LETTER SOFT SIGN */
    {0x00CD, 0x042D},	/* CYRILLIC CAPITAL LETTER E */
    {0x00CE, 0x042E},	/* CYRILLIC CAPITAL LETTER YU */
    {0x00CF, 0x042F},	/* CYRILLIC CAPITAL LETTER YA */
    {0x00D0, 0x0430},	/* CYRILLIC SMALL LETTER A */
    {0x00D1, 0x0431},	/* CYRILLIC SMALL LETTER BE */
    {0x00D2, 0x0432},	/* CYRILLIC SMALL LETTER VE */
    {0x00D3, 0x0433},	/* CYRILLIC SMALL LETTER GHE */
    {0x00D4, 0x0434},	/* CYRILLIC SMALL LETTER DE */
    {0x00D5, 0x0435},	/* CYRILLIC SMALL LETTER IE */
    {0x00D6, 0x0436},	/* CYRILLIC SMALL LETTER ZHE */
    {0x00D7, 0x0437},	/* CYRILLIC SMALL LETTER ZE */
    {0x00D8, 0x0438},	/* CYRILLIC SMALL LETTER I */
    {0x00D9, 0x0439},	/* CYRILLIC SMALL LETTER SHORT I */
    {0x00DA, 0x043A},	/* CYRILLIC SMALL LETTER KA */
    {0x00DB, 0x043B},	/* CYRILLIC SMALL LETTER EL */
    {0x00DC, 0x043C},	/* CYRILLIC SMALL LETTER EM */
    {0x00DD, 0x043D},	/* CYRILLIC SMALL LETTER EN */
    {0x00DE, 0x043E},	/* CYRILLIC SMALL LETTER O */
    {0x00DF, 0x043F},	/* CYRILLIC SMALL LETTER PE */
    {0x00E0, 0x0440},	/* CYRILLIC SMALL LETTER ER */
    {0x00E1, 0x0441},	/* CYRILLIC SMALL LETTER ES */
    {0x00E2, 0x0442},	/* CYRILLIC SMALL LETTER TE */
    {0x00E3, 0x0443},	/* CYRILLIC SMALL LETTER U */
    {0x00E4, 0x0444},	/* CYRILLIC SMALL LETTER EF */
    {0x00E5, 0x0445},	/* CYRILLIC SMALL LETTER HA */
    {0x00E6, 0x0446},	/* CYRILLIC SMALL LETTER TSE */
    {0x00E7, 0x0447},	/* CYRILLIC SMALL LETTER CHE */
    {0x00E8, 0x0448},	/* CYRILLIC SMALL LETTER SHA */
    {0x00E9, 0x0449},	/* CYRILLIC SMALL LETTER SHCHA */
    {0x00EA, 0x044A},	/* CYRILLIC SMALL LETTER HARD SIGN */
    {0x00EB, 0x044B},	/* CYRILLIC SMALL LETTER YERU */
    {0x00EC, 0x044C},	/* CYRILLIC SMALL LETTER SOFT SIGN */
    {0x00ED, 0x044D},	/* CYRILLIC SMALL LETTER E */
    {0x00EE, 0x044E},	/* CYRILLIC SMALL LETTER YU */
    {0x00EF, 0x044F},	/* CYRILLIC SMALL LETTER YA */
    {0x00F0, 0x2116},	/* NUMERO SIGN */
    {0x00F1, 0x0451},	/* CYRILLIC SMALL LETTER IO */
    {0x00F2, 0x0452},	/* CYRILLIC SMALL LETTER DJE */
    {0x00F3, 0x0453},	/* CYRILLIC SMALL LETTER GJE */
    {0x00F4, 0x0454},	/* CYRILLIC SMALL LETTER UKRAINIAN IE */
    {0x00F5, 0x0455},	/* CYRILLIC SMALL LETTER DZE */
    {0x00F6, 0x0456},	/* CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I */
    {0x00F7, 0x0457},	/* CYRILLIC SMALL LETTER YI */
    {0x00F8, 0x0458},	/* CYRILLIC SMALL LETTER JE */
    {0x00F9, 0x0459},	/* CYRILLIC SMALL LETTER LJE */
    {0x00FA, 0x045A},	/* CYRILLIC SMALL LETTER NJE */
    {0x00FB, 0x045B},	/* CYRILLIC SMALL LETTER TSHE */
    {0x00FC, 0x045C},	/* CYRILLIC SMALL LETTER KJE */
    {0x00FD, 0x00A7},	/* SECTION SIGN */
    {0x00FE, 0x045E},	/* CYRILLIC SMALL LETTER SHORT U */
    {0x00FF, 0x045F},	/* CYRILLIC SMALL LETTER DZHE */
};

static const BuiltInMapping iso8859_6[] =
{
    /* iso8859-6 */
    {0x00AC, 0x060C},	/* ARABIC COMMA */
    {0x00BB, 0x061B},	/* ARABIC SEMICOLON */
    {0x00BF, 0x061F},	/* ARABIC QUESTION MARK */
    {0x00C1, 0x0621},	/* ARABIC LETTER HAMZA */
    {0x00C2, 0x0622},	/* ARABIC LETTER ALEF WITH MADDA ABOVE */
    {0x00C3, 0x0623},	/* ARABIC LETTER ALEF WITH HAMZA ABOVE */
    {0x00C4, 0x0624},	/* ARABIC LETTER WAW WITH HAMZA ABOVE */
    {0x00C5, 0x0625},	/* ARABIC LETTER ALEF WITH HAMZA BELOW */
    {0x00C6, 0x0626},	/* ARABIC LETTER YEH WITH HAMZA ABOVE */
    {0x00C7, 0x0627},	/* ARABIC LETTER ALEF */
    {0x00C8, 0x0628},	/* ARABIC LETTER BEH */
    {0x00C9, 0x0629},	/* ARABIC LETTER TEH MARBUTA */
    {0x00CA, 0x062A},	/* ARABIC LETTER TEH */
    {0x00CB, 0x062B},	/* ARABIC LETTER THEH */
    {0x00CC, 0x062C},	/* ARABIC LETTER JEEM */
    {0x00CD, 0x062D},	/* ARABIC LETTER HAH */
    {0x00CE, 0x062E},	/* ARABIC LETTER KHAH */
    {0x00CF, 0x062F},	/* ARABIC LETTER DAL */
    {0x00D0, 0x0630},	/* ARABIC LETTER THAL */
    {0x00D1, 0x0631},	/* ARABIC LETTER REH */
    {0x00D2, 0x0632},	/* ARABIC LETTER ZAIN */
    {0x00D3, 0x0633},	/* ARABIC LETTER SEEN */
    {0x00D4, 0x0634},	/* ARABIC LETTER SHEEN */
    {0x00D5, 0x0635},	/* ARABIC LETTER SAD */
    {0x00D6, 0x0636},	/* ARABIC LETTER DAD */
    {0x00D7, 0x0637},	/* ARABIC LETTER TAH */
    {0x00D8, 0x0638},	/* ARABIC LETTER ZAH */
    {0x00D9, 0x0639},	/* ARABIC LETTER AIN */
    {0x00DA, 0x063A},	/* ARABIC LETTER GHAIN */
    {0x00E0, 0x0640},	/* ARABIC TATWEEL */
    {0x00E1, 0x0641},	/* ARABIC LETTER FEH */
    {0x00E2, 0x0642},	/* ARABIC LETTER QAF */
    {0x00E3, 0x0643},	/* ARABIC LETTER KAF */
    {0x00E4, 0x0644},	/* ARABIC LETTER LAM */
    {0x00E5, 0x0645},	/* ARABIC LETTER MEEM */
    {0x00E6, 0x0646},	/* ARABIC LETTER NOON */
    {0x00E7, 0x0647},	/* ARABIC LETTER HEH */
    {0x00E8, 0x0648},	/* ARABIC LETTER WAW */
    {0x00E9, 0x0649},	/* ARABIC LETTER ALEF MAKSURA */
    {0x00EA, 0x064A},	/* ARABIC LETTER YEH */
    {0x00EB, 0x064B},	/* ARABIC FATHATAN */
    {0x00EC, 0x064C},	/* ARABIC DAMMATAN */
    {0x00ED, 0x064D},	/* ARABIC KASRATAN */
    {0x00EE, 0x064E},	/* ARABIC FATHA */
    {0x00EF, 0x064F},	/* ARABIC DAMMA */
    {0x00F0, 0x0650},	/* ARABIC KASRA */
    {0x00F1, 0x0651},	/* ARABIC SHADDA */
    {0x00F2, 0x0652},	/* ARABIC SUKUN */
};

static const BuiltInMapping iso8859_7[] =
{
    /* iso8859-7 */
    {0x00A1, 0x2018},	/* LEFT SINGLE QUOTATION MARK */
    {0x00A2, 0x2019},	/* RIGHT SINGLE QUOTATION MARK */
    {0x00A4, 0x20AC},	/* EURO SIGN */
    {0x00A5, 0x20AF},	/* DRACHMA SIGN */
    {0x00AA, 0x037A},	/* GREEK YPOGEGRAMMENI */
    {0x00AF, 0x2015},	/* HORIZONTAL BAR */
    {0x00B4, 0x0384},	/* GREEK TONOS */
    {0x00B5, 0x0385},	/* GREEK DIALYTIKA TONOS */
    {0x00B6, 0x0386},	/* GREEK CAPITAL LETTER ALPHA WITH TONOS */
    {0x00B8, 0x0388},	/* GREEK CAPITAL LETTER EPSILON WITH TONOS */
    {0x00B9, 0x0389},	/* GREEK CAPITAL LETTER ETA WITH TONOS */
    {0x00BA, 0x038A},	/* GREEK CAPITAL LETTER IOTA WITH TONOS */
    {0x00BC, 0x038C},	/* GREEK CAPITAL LETTER OMICRON WITH TONOS */
    {0x00BE, 0x038E},	/* GREEK CAPITAL LETTER UPSILON WITH TONOS */
    {0x00BF, 0x038F},	/* GREEK CAPITAL LETTER OMEGA WITH TONOS */
    {0x00C0, 0x0390},	/* GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS */
    {0x00C1, 0x0391},	/* GREEK CAPITAL LETTER ALPHA */
    {0x00C2, 0x0392},	/* GREEK CAPITAL LETTER BETA */
    {0x00C3, 0x0393},	/* GREEK CAPITAL LETTER GAMMA */
    {0x00C4, 0x0394},	/* GREEK CAPITAL LETTER DELTA */
    {0x00C5, 0x0395},	/* GREEK CAPITAL LETTER EPSILON */
    {0x00C6, 0x0396},	/* GREEK CAPITAL LETTER ZETA */
    {0x00C7, 0x0397},	/* GREEK CAPITAL LETTER ETA */
    {0x00C8, 0x0398},	/* GREEK CAPITAL LETTER THETA */
    {0x00C9, 0x0399},	/* GREEK CAPITAL LETTER IOTA */
    {0x00CA, 0x039A},	/* GREEK CAPITAL LETTER KAPPA */
    {0x00CB, 0x039B},	/* GREEK CAPITAL LETTER LAMDA */
    {0x00CC, 0x039C},	/* GREEK CAPITAL LETTER MU */
    {0x00CD, 0x039D},	/* GREEK CAPITAL LETTER NU */
    {0x00CE, 0x039E},	/* GREEK CAPITAL LETTER XI */
    {0x00CF, 0x039F},	/* GREEK CAPITAL LETTER OMICRON */
    {0x00D0, 0x03A0},	/* GREEK CAPITAL LETTER PI */
    {0x00D1, 0x03A1},	/* GREEK CAPITAL LETTER RHO */
    {0x00D3, 0x03A3},	/* GREEK CAPITAL LETTER SIGMA */
    {0x00D4, 0x03A4},	/* GREEK CAPITAL LETTER TAU */
    {0x00D5, 0x03A5},	/* GREEK CAPITAL LETTER UPSILON */
    {0x00D6, 0x03A6},	/* GREEK CAPITAL LETTER PHI */
    {0x00D7, 0x03A7},	/* GREEK CAPITAL LETTER CHI */
    {0x00D8, 0x03A8},	/* GREEK CAPITAL LETTER PSI */
    {0x00D9, 0x03A9},	/* GREEK CAPITAL LETTER OMEGA */
    {0x00DA, 0x03AA},	/* GREEK CAPITAL LETTER IOTA WITH DIALYTIKA */
    {0x00DB, 0x03AB},	/* GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA */
    {0x00DC, 0x03AC},	/* GREEK SMALL LETTER ALPHA WITH TONOS */
    {0x00DD, 0x03AD},	/* GREEK SMALL LETTER EPSILON WITH TONOS */
    {0x00DE, 0x03AE},	/* GREEK SMALL LETTER ETA WITH TONOS */
    {0x00DF, 0x03AF},	/* GREEK SMALL LETTER IOTA WITH TONOS */
    {0x00E0, 0x03B0},	/* GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS */
    {0x00E1, 0x03B1},	/* GREEK SMALL LETTER ALPHA */
    {0x00E2, 0x03B2},	/* GREEK SMALL LETTER BETA */
    {0x00E3, 0x03B3},	/* GREEK SMALL LETTER GAMMA */
    {0x00E4, 0x03B4},	/* GREEK SMALL LETTER DELTA */
    {0x00E5, 0x03B5},	/* GREEK SMALL LETTER EPSILON */
    {0x00E6, 0x03B6},	/* GREEK SMALL LETTER ZETA */
    {0x00E7, 0x03B7},	/* GREEK SMALL LETTER ETA */
    {0x00E8, 0x03B8},	/* GREEK SMALL LETTER THETA */
    {0x00E9, 0x03B9},	/* GREEK SMALL LETTER IOTA */
    {0x00EA, 0x03BA},	/* GREEK SMALL LETTER KAPPA */
    {0x00EB, 0x03BB},	/* GREEK SMALL LETTER LAMDA */
    {0x00EC, 0x03BC},	/* GREEK SMALL LETTER MU */
    {0x00ED, 0x03BD},	/* GREEK SMALL LETTER NU */
    {0x00EE, 0x03BE},	/* GREEK SMALL LETTER XI */
    {0x00EF, 0x03BF},	/* GREEK SMALL LETTER OMICRON */
    {0x00F0, 0x03C0},	/* GREEK SMALL LETTER PI */
    {0x00F1, 0x03C1},	/* GREEK SMALL LETTER RHO */
    {0x00F2, 0x03C2},	/* GREEK SMALL LETTER FINAL SIGMA */
    {0x00F3, 0x03C3},	/* GREEK SMALL LETTER SIGMA */
    {0x00F4, 0x03C4},	/* GREEK SMALL LETTER TAU */
    {0x00F5, 0x03C5},	/* GREEK SMALL LETTER UPSILON */
    {0x00F6, 0x03C6},	/* GREEK SMALL LETTER PHI */
    {0x00F7, 0x03C7},	/* GREEK SMALL LETTER CHI */
    {0x00F8, 0x03C8},	/* GREEK SMALL LETTER PSI */
    {0x00F9, 0x03C9},	/* GREEK SMALL LETTER OMEGA */
    {0x00FA, 0x03CA},	/* GREEK SMALL LETTER IOTA WITH DIALYTIKA */
    {0x00FB, 0x03CB},	/* GREEK SMALL LETTER UPSILON WITH DIALYTIKA */
    {0x00FC, 0x03CC},	/* GREEK SMALL LETTER OMICRON WITH TONOS */
    {0x00FD, 0x03CD},	/* GREEK SMALL LETTER UPSILON WITH TONOS */
    {0x00FE, 0x03CE},	/* GREEK SMALL LETTER OMEGA WITH TONOS */
};

static const BuiltInMapping iso8859_8[] =
{
    /* iso8859-8 */
    {0x00AA, 0x00D7},	/* MULTIPLICATION SIGN */
    {0x00BA, 0x00F7},	/* DIVISION SIGN */
    {0x00DF, 0x2017},	/* DOUBLE LOW LINE */
    {0x00E0, 0x05D0},	/* HEBREW LETTER ALEF */
    {0x00E1, 0x05D1},	/* HEBREW LETTER BET */
    {0x00E2, 0x05D2},	/* HEBREW LETTER GIMEL */
    {0x00E3, 0x05D3},	/* HEBREW LETTER DALET */
    {0x00E4, 0x05D4},	/* HEBREW LETTER HE */
    {0x00E5, 0x05D5},	/* HEBREW LETTER VAV */
    {0x00E6, 0x05D6},	/* HEBREW LETTER ZAYIN */
    {0x00E7, 0x05D7},	/* HEBREW LETTER HET */
    {0x00E8, 0x05D8},	/* HEBREW LETTER TET */
    {0x00E9, 0x05D9},	/* HEBREW LETTER YOD */
    {0x00EA, 0x05DA},	/* HEBREW LETTER FINAL KAF */
    {0x00EB, 0x05DB},	/* HEBREW LETTER KAF */
    {0x00EC, 0x05DC},	/* HEBREW LETTER LAMED */
    {0x00ED, 0x05DD},	/* HEBREW LETTER FINAL MEM */
    {0x00EE, 0x05DE},	/* HEBREW LETTER MEM */
    {0x00EF, 0x05DF},	/* HEBREW LETTER FINAL NUN */
    {0x00F0, 0x05E0},	/* HEBREW LETTER NUN */
    {0x00F1, 0x05E1},	/* HEBREW LETTER SAMEKH */
    {0x00F2, 0x05E2},	/* HEBREW LETTER AYIN */
    {0x00F3, 0x05E3},	/* HEBREW LETTER FINAL PE */
    {0x00F4, 0x05E4},	/* HEBREW LETTER PE */
    {0x00F5, 0x05E5},	/* HEBREW LETTER FINAL TSADI */
    {0x00F6, 0x05E6},	/* HEBREW LETTER TSADI */
    {0x00F7, 0x05E7},	/* HEBREW LETTER QOF */
    {0x00F8, 0x05E8},	/* HEBREW LETTER RESH */
    {0x00F9, 0x05E9},	/* HEBREW LETTER SHIN */
    {0x00FA, 0x05EA},	/* HEBREW LETTER TAV */
    {0x00FD, 0x200E},	/* LEFT-TO-RIGHT MARK */
    {0x00FE, 0x200F},	/* RIGHT-TO-LEFT MARK */
};

static const BuiltInMapping iso8859_9[] =
{
    /* iso8859-9 */
    {0x00D0, 0x011E},	/* LATIN CAPITAL LETTER G WITH BREVE */
    {0x00DD, 0x0130},	/* LATIN CAPITAL LETTER I WITH DOT ABOVE */
    {0x00DE, 0x015E},	/* LATIN CAPITAL LETTER S WITH CEDILLA */
    {0x00F0, 0x011F},	/* LATIN SMALL LETTER G WITH BREVE */
    {0x00FD, 0x0131},	/* LATIN SMALL LETTER DOTLESS I */
    {0x00FE, 0x015F},	/* LATIN SMALL LETTER S WITH CEDILLA */
};

static const BuiltInMapping koi8_e[] =
{
    /* koi8-e */
    {0x00A1, 0x0452},	/* CYRILLIC SMALL LETTER DJE */
    {0x00A2, 0x0453},	/* CYRILLIC SMALL LETTER GJE */
    {0x00A3, 0x0451},	/* CYRILLIC SMALL LETTER IO */
    {0x00A4, 0x0454},	/* CYRILLIC SMALL LETTER UKRAINIAN IE */
    {0x00A5, 0x0455},	/* CYRILLIC SMALL LETTER DZE */
    {0x00A6, 0x0456},	/* CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I */
    {0x00A7, 0x0457},	/* CYRILLIC SMALL LETTER YI */
    {0x00A8, 0x0458},	/* CYRILLIC SMALL LETTER JE */
    {0x00A9, 0x0459},	/* CYRILLIC SMALL LETTER LJE */
    {0x00AA, 0x045A},	/* CYRILLIC SMALL LETTER NJE */
    {0x00AB, 0x045B},	/* CYRILLIC SMALL LETTER TSHE */
    {0x00AC, 0x045C},	/* CYRILLIC SMALL LETTER KJE */
    {0x00AE, 0x045E},	/* CYRILLIC SMALL LETTER SHORT U */
    {0x00AF, 0x045F},	/* CYRILLIC SMALL LETTER DZHE */
    {0x00B0, 0x2116},	/* NUMERO SIGN */
    {0x00B1, 0x0402},	/* CYRILLIC CAPITAL LETTER DJE */
    {0x00B2, 0x0403},	/* CYRILLIC CAPITAL LETTER GJE */
    {0x00B3, 0x0401},	/* CYRILLIC CAPITAL LETTER IO */
    {0x00B4, 0x0404},	/* CYRILLIC CAPITAL LETTER UKRAINIAN IE */
    {0x00B5, 0x0405},	/* CYRILLIC CAPITAL LETTER DZE */
    {0x00B6, 0x0406},	/* CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I */
    {0x00B7, 0x0407},	/* CYRILLIC CAPITAL LETTER YI */
    {0x00B8, 0x0408},	/* CYRILLIC CAPITAL LETTER JE */
    {0x00B9, 0x0409},	/* CYRILLIC CAPITAL LETTER LJE */
    {0x00BA, 0x040A},	/* CYRILLIC CAPITAL LETTER NJE */
    {0x00BB, 0x040B},	/* CYRILLIC CAPITAL LETTER TSHE */
    {0x00BC, 0x040C},	/* CYRILLIC CAPITAL LETTER KJE */
    {0x00BD, 0x00A4},	/* CURRENCY SIGN */
    {0x00BE, 0x040E},	/* CYRILLIC CAPITAL LETTER SHORT U */
    {0x00BF, 0x040F},	/* CYRILLIC CAPITAL LETTER DZHE */
    {0x00C0, 0x044E},	/* CYRILLIC SMALL LETTER YU */
    {0x00C1, 0x0430},	/* CYRILLIC SMALL LETTER A */
    {0x00C2, 0x0431},	/* CYRILLIC SMALL LETTER BE */
    {0x00C3, 0x0446},	/* CYRILLIC SMALL LETTER TSE */
    {0x00C4, 0x0434},	/* CYRILLIC SMALL LETTER DE */
    {0x00C5, 0x0435},	/* CYRILLIC SMALL LETTER IE */
    {0x00C6, 0x0444},	/* CYRILLIC SMALL LETTER EF */
    {0x00C7, 0x0433},	/* CYRILLIC SMALL LETTER GHE */
    {0x00C8, 0x0445},	/* CYRILLIC SMALL LETTER HA */
    {0x00C9, 0x0438},	/* CYRILLIC SMALL LETTER I */
    {0x00CA, 0x0439},	/* CYRILLIC SMALL LETTER SHORT I */
    {0x00CB, 0x043A},	/* CYRILLIC SMALL LETTER KA */
    {0x00CC, 0x043B},	/* CYRILLIC SMALL LETTER EL */
    {0x00CD, 0x043C},	/* CYRILLIC SMALL LETTER EM */
    {0x00CE, 0x043D},	/* CYRILLIC SMALL LETTER EN */
    {0x00CF, 0x043E},	/* CYRILLIC SMALL LETTER O */
    {0x00D0, 0x043F},	/* CYRILLIC SMALL LETTER PE */
    {0x00D1, 0x044F},	/* CYRILLIC SMALL LETTER YA */
    {0x00D2, 0x0440},	/* CYRILLIC SMALL LETTER ER */
    {0x00D3, 0x0441},	/* CYRILLIC SMALL LETTER ES */
    {0x00D4, 0x0442},	/* CYRILLIC SMALL LETTER TE */
    {0x00D5, 0x0443},	/* CYRILLIC SMALL LETTER U */
    {0x00D6, 0x0436},	/* CYRILLIC SMALL LETTER ZHE */
    {0x00D7, 0x0432},	/* CYRILLIC SMALL LETTER VE */
    {0x00D8, 0x044C},	/* CYRILLIC SMALL LETTER SOFT SIGN */
    {0x00D9, 0x044B},	/* CYRILLIC SMALL LETTER YERU */
    {0x00DA, 0x0437},	/* CYRILLIC SMALL LETTER ZE */
    {0x00DB, 0x0448},	/* CYRILLIC SMALL LETTER SHA */
    {0x00DC, 0x044D},	/* CYRILLIC SMALL LETTER E */
    {0x00DD, 0x0449},	/* CYRILLIC SMALL LETTER SHCHA */
    {0x00DE, 0x0447},	/* CYRILLIC SMALL LETTER CHE */
    {0x00DF, 0x044A},	/* CYRILLIC SMALL LETTER HARD SIGN */
    {0x00E0, 0x042E},	/* CYRILLIC CAPITAL LETTER YU */
    {0x00E1, 0x0410},	/* CYRILLIC CAPITAL LETTER A */
    {0x00E2, 0x0411},	/* CYRILLIC CAPITAL LETTER BE */
    {0x00E3, 0x0426},	/* CYRILLIC CAPITAL LETTER TSE */
    {0x00E4, 0x0414},	/* CYRILLIC CAPITAL LETTER DE */
    {0x00E5, 0x0415},	/* CYRILLIC CAPITAL LETTER IE */
    {0x00E6, 0x0424},	/* CYRILLIC CAPITAL LETTER EF */
    {0x00E7, 0x0413},	/* CYRILLIC CAPITAL LETTER GHE */
    {0x00E8, 0x0425},	/* CYRILLIC CAPITAL LETTER HA */
    {0x00E9, 0x0418},	/* CYRILLIC CAPITAL LETTER I */
    {0x00EA, 0x0419},	/* CYRILLIC CAPITAL LETTER SHORT I */
    {0x00EB, 0x041A},	/* CYRILLIC CAPITAL LETTER KA */
    {0x00EC, 0x041B},	/* CYRILLIC CAPITAL LETTER EL */
    {0x00ED, 0x041C},	/* CYRILLIC CAPITAL LETTER EM */
    {0x00EE, 0x041D},	/* CYRILLIC CAPITAL LETTER EN */
    {0x00EF, 0x041E},	/* CYRILLIC CAPITAL LETTER O */
    {0x00F0, 0x041F},	/* CYRILLIC CAPITAL LETTER PE */
    {0x00F1, 0x042F},	/* CYRILLIC CAPITAL LETTER YA */
    {0x00F2, 0x0420},	/* CYRILLIC CAPITAL LETTER ER */
    {0x00F3, 0x0421},	/* CYRILLIC CAPITAL LETTER ES */
    {0x00F4, 0x0422},	/* CYRILLIC CAPITAL LETTER TE */
    {0x00F5, 0x0423},	/* CYRILLIC CAPITAL LETTER U */
    {0x00F6, 0x0416},	/* CYRILLIC CAPITAL LETTER ZHE */
    {0x00F7, 0x0412},	/* CYRILLIC CAPITAL LETTER VE */
    {0x00F8, 0x042C},	/* CYRILLIC CAPITAL LETTER SOFT SIGN */
    {0x00F9, 0x042B},	/* CYRILLIC CAPITAL LETTER YERU */
    {0x00FA, 0x0417},	/* CYRILLIC CAPITAL LETTER ZE */
    {0x00FB, 0x0428},	/* CYRILLIC CAPITAL LETTER SHA */
    {0x00FC, 0x042D},	/* CYRILLIC CAPITAL LETTER E */
    {0x00FD, 0x0429},	/* CYRILLIC CAPITAL LETTER SHCHA */
    {0x00FE, 0x0427},	/* CYRILLIC CAPITAL LETTER CHE */
    {0x00FF, 0x042A},	/* CYRILLIC CAPITAL LETTER HARD SIGN */
};

static const BuiltInMapping koi8_r[] =
{
    /* koi8-r */
    {0x0080, 0x2500},	/* BOX DRAWINGS LIGHT HORIZONTAL */
    {0x0081, 0x2502},	/* BOX DRAWINGS LIGHT VERTICAL */
    {0x0082, 0x250C},	/* BOX DRAWINGS LIGHT DOWN AND RIGHT */
    {0x0083, 0x2510},	/* BOX DRAWINGS LIGHT DOWN AND LEFT */
    {0x0084, 0x2514},	/* BOX DRAWINGS LIGHT UP AND RIGHT */
    {0x0085, 0x2518},	/* BOX DRAWINGS LIGHT UP AND LEFT */
    {0x0086, 0x251C},	/* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
    {0x0087, 0x2524},	/* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
    {0x0088, 0x252C},	/* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
    {0x0089, 0x2534},	/* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
    {0x008A, 0x253C},	/* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
    {0x008B, 0x2580},	/* UPPER HALF BLOCK */
    {0x008C, 0x2584},	/* LOWER HALF BLOCK */
    {0x008D, 0x2588},	/* FULL BLOCK */
    {0x008E, 0x258C},	/* LEFT HALF BLOCK */
    {0x008F, 0x2590},	/* RIGHT HALF BLOCK */
    {0x0090, 0x2591},	/* LIGHT SHADE */
    {0x0091, 0x2592},	/* MEDIUM SHADE */
    {0x0092, 0x2593},	/* DARK SHADE */
    {0x0093, 0x2320},	/* TOP HALF INTEGRAL */
    {0x0094, 0x25A0},	/* BLACK SQUARE */
    {0x0095, 0x2219},	/* BULLET OPERATOR */
    {0x0096, 0x221A},	/* SQUARE ROOT */
    {0x0097, 0x2248},	/* ALMOST EQUAL TO */
    {0x0098, 0x2264},	/* LESS-THAN OR EQUAL TO */
    {0x0099, 0x2265},	/* GREATER-THAN OR EQUAL TO */
    {0x009A, 0x00A0},	/* NO-BREAK SPACE */
    {0x009B, 0x2321},	/* BOTTOM HALF INTEGRAL */
    {0x009C, 0x00B0},	/* DEGREE SIGN */
    {0x009D, 0x00B2},	/* SUPERSCRIPT TWO */
    {0x009E, 0x00B7},	/* MIDDLE DOT */
    {0x009F, 0x00F7},	/* DIVISION SIGN */
    {0x00A0, 0x2550},	/* BOX DRAWINGS DOUBLE HORIZONTAL */
    {0x00A1, 0x2551},	/* BOX DRAWINGS DOUBLE VERTICAL */
    {0x00A2, 0x2552},	/* BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE */
    {0x00A3, 0x0451},	/* CYRILLIC SMALL LETTER IO */
    {0x00A4, 0x2553},	/* BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE */
    {0x00A5, 0x2554},	/* BOX DRAWINGS DOUBLE DOWN AND RIGHT */
    {0x00A6, 0x2555},	/* BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE */
    {0x00A7, 0x2556},	/* BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE */
    {0x00A8, 0x2557},	/* BOX DRAWINGS DOUBLE DOWN AND LEFT */
    {0x00A9, 0x2558},	/* BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE */
    {0x00AA, 0x2559},	/* BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE */
    {0x00AB, 0x255A},	/* BOX DRAWINGS DOUBLE UP AND RIGHT */
    {0x00AC, 0x255B},	/* BOX DRAWINGS UP SINGLE AND LEFT DOUBLE */
    {0x00AD, 0x255C},	/* BOX DRAWINGS UP DOUBLE AND LEFT SINGLE */
    {0x00AE, 0x255D},	/* BOX DRAWINGS DOUBLE UP AND LEFT */
    {0x00AF, 0x255E},	/* BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE */
    {0x00B0, 0x255F},	/* BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE */
    {0x00B1, 0x2560},	/* BOX DRAWINGS DOUBLE VERTICAL AND RIGHT */
    {0x00B2, 0x2561},	/* BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE */
    {0x00B3, 0x0401},	/* CYRILLIC CAPITAL LETTER IO */
    {0x00B4, 0x2562},	/* BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE */
    {0x00B5, 0x2563},	/* BOX DRAWINGS DOUBLE VERTICAL AND LEFT */
    {0x00B6, 0x2564},	/* BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE */
    {0x00B7, 0x2565},	/* BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE */
    {0x00B8, 0x2566},	/* BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL */
    {0x00B9, 0x2567},	/* BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE */
    {0x00BA, 0x2568},	/* BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE */
    {0x00BB, 0x2569},	/* BOX DRAWINGS DOUBLE UP AND HORIZONTAL */
    {0x00BC, 0x256A},	/* BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE */
    {0x00BD, 0x256B},	/* BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE */
    {0x00BE, 0x256C},	/* BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL */
    {0x00BF, 0x00A9},	/* COPYRIGHT SIGN */
    {0x00C0, 0x044E},	/* CYRILLIC SMALL LETTER YU */
    {0x00C1, 0x0430},	/* CYRILLIC SMALL LETTER A */
    {0x00C2, 0x0431},	/* CYRILLIC SMALL LETTER BE */
    {0x00C3, 0x0446},	/* CYRILLIC SMALL LETTER TSE */
    {0x00C4, 0x0434},	/* CYRILLIC SMALL LETTER DE */
    {0x00C5, 0x0435},	/* CYRILLIC SMALL LETTER IE */
    {0x00C6, 0x0444},	/* CYRILLIC SMALL LETTER EF */
    {0x00C7, 0x0433},	/* CYRILLIC SMALL LETTER GHE */
    {0x00C8, 0x0445},	/* CYRILLIC SMALL LETTER HA */
    {0x00C9, 0x0438},	/* CYRILLIC SMALL LETTER I */
    {0x00CA, 0x0439},	/* CYRILLIC SMALL LETTER SHORT I */
    {0x00CB, 0x043A},	/* CYRILLIC SMALL LETTER KA */
    {0x00CC, 0x043B},	/* CYRILLIC SMALL LETTER EL */
    {0x00CD, 0x043C},	/* CYRILLIC SMALL LETTER EM */
    {0x00CE, 0x043D},	/* CYRILLIC SMALL LETTER EN */
    {0x00CF, 0x043E},	/* CYRILLIC SMALL LETTER O */
    {0x00D0, 0x043F},	/* CYRILLIC SMALL LETTER PE */
    {0x00D1, 0x044F},	/* CYRILLIC SMALL LETTER YA */
    {0x00D2, 0x0440},	/* CYRILLIC SMALL LETTER ER */
    {0x00D3, 0x0441},	/* CYRILLIC SMALL LETTER ES */
    {0x00D4, 0x0442},	/* CYRILLIC SMALL LETTER TE */
    {0x00D5, 0x0443},	/* CYRILLIC SMALL LETTER U */
    {0x00D6, 0x0436},	/* CYRILLIC SMALL LETTER ZHE */
    {0x00D7, 0x0432},	/* CYRILLIC SMALL LETTER VE */
    {0x00D8, 0x044C},	/* CYRILLIC SMALL LETTER SOFT SIGN */
    {0x00D9, 0x044B},	/* CYRILLIC SMALL LETTER YERU */
    {0x00DA, 0x0437},	/* CYRILLIC SMALL LETTER ZE */
    {0x00DB, 0x0448},	/* CYRILLIC SMALL LETTER SHA */
    {0x00DC, 0x044D},	/* CYRILLIC SMALL LETTER E */
    {0x00DD, 0x0449},	/* CYRILLIC SMALL LETTER SHCHA */
    {0x00DE, 0x0447},	/* CYRILLIC SMALL LETTER CHE */
    {0x00DF, 0x044A},	/* CYRILLIC SMALL LETTER HARD SIGN */
    {0x00E0, 0x042E},	/* CYRILLIC CAPITAL LETTER YU */
    {0x00E1, 0x0410},	/* CYRILLIC CAPITAL LETTER A */
    {0x00E2, 0x0411},	/* CYRILLIC CAPITAL LETTER BE */
    {0x00E3, 0x0426},	/* CYRILLIC CAPITAL LETTER TSE */
    {0x00E4, 0x0414},	/* CYRILLIC CAPITAL LETTER DE */
    {0x00E5, 0x0415},	/* CYRILLIC CAPITAL LETTER IE */
    {0x00E6, 0x0424},	/* CYRILLIC CAPITAL LETTER EF */
    {0x00E7, 0x0413},	/* CYRILLIC CAPITAL LETTER GHE */
    {0x00E8, 0x0425},	/* CYRILLIC CAPITAL LETTER HA */
    {0x00E9, 0x0418},	/* CYRILLIC CAPITAL LETTER I */
    {0x00EA, 0x0419},	/* CYRILLIC CAPITAL LETTER SHORT I */
    {0x00EB, 0x041A},	/* CYRILLIC CAPITAL LETTER KA */
    {0x00EC, 0x041B},	/* CYRILLIC CAPITAL LETTER EL */
    {0x00ED, 0x041C},	/* CYRILLIC CAPITAL LETTER EM */
    {0x00EE, 0x041D},	/* CYRILLIC CAPITAL LETTER EN */
    {0x00EF, 0x041E},	/* CYRILLIC CAPITAL LETTER O */
    {0x00F0, 0x041F},	/* CYRILLIC CAPITAL LETTER PE */
    {0x00F1, 0x042F},	/* CYRILLIC CAPITAL LETTER YA */
    {0x00F2, 0x0420},	/* CYRILLIC CAPITAL LETTER ER */
    {0x00F3, 0x0421},	/* CYRILLIC CAPITAL LETTER ES */
    {0x00F4, 0x0422},	/* CYRILLIC CAPITAL LETTER TE */
    {0x00F5, 0x0423},	/* CYRILLIC CAPITAL LETTER U */
    {0x00F6, 0x0416},	/* CYRILLIC CAPITAL LETTER ZHE */
    {0x00F7, 0x0412},	/* CYRILLIC CAPITAL LETTER VE */
    {0x00F8, 0x042C},	/* CYRILLIC CAPITAL LETTER SOFT SIGN */
    {0x00F9, 0x042B},	/* CYRILLIC CAPITAL LETTER YERU */
    {0x00FA, 0x0417},	/* CYRILLIC CAPITAL LETTER ZE */
    {0x00FB, 0x0428},	/* CYRILLIC CAPITAL LETTER SHA */
    {0x00FC, 0x042D},	/* CYRILLIC CAPITAL LETTER E */
    {0x00FD, 0x0429},	/* CYRILLIC CAPITAL LETTER SHCHA */
    {0x00FE, 0x0427},	/* CYRILLIC CAPITAL LETTER CHE */
    {0x00FF, 0x042A},	/* CYRILLIC CAPITAL LETTER HARD SIGN */
};

static const BuiltInMapping koi8_ru[] =
{
    /* koi8-ru */
    {0x0080, 0x2500},	/* BOX DRAWINGS LIGHT HORIZONTAL */
    {0x0081, 0x2502},	/* BOX DRAWINGS LIGHT VERTICAL */
    {0x0082, 0x250C},	/* BOX DRAWINGS LIGHT DOWN AND RIGHT */
    {0x0083, 0x2510},	/* BOX DRAWINGS LIGHT DOWN AND LEFT */
    {0x0084, 0x2514},	/* BOX DRAWINGS LIGHT UP AND RIGHT */
    {0x0085, 0x2518},	/* BOX DRAWINGS LIGHT UP AND LEFT */
    {0x0086, 0x251C},	/* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
    {0x0087, 0x2524},	/* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
    {0x0088, 0x252C},	/* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
    {0x0089, 0x2534},	/* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
    {0x008A, 0x253C},	/* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
    {0x008B, 0x2580},	/* UPPER HALF BLOCK */
    {0x008C, 0x2584},	/* LOWER HALF BLOCK */
    {0x008D, 0x2588},	/* FULL BLOCK */
    {0x008E, 0x258C},	/* LEFT HALF BLOCK */
    {0x008F, 0x2590},	/* RIGHT HALF BLOCK */
    {0x0090, 0x2591},	/* LIGHT SHADE */
    {0x0091, 0x2592},	/* MEDIUM SHADE */
    {0x0092, 0x2593},	/* DARK SHADE */
    {0x0093, 0x201C},	/* LEFT DOUBLE QUOTATION MARK */
    {0x0094, 0x25A0},	/* BLACK SQUARE */
    {0x0095, 0x2219},	/* BULLET OPERATOR */
    {0x0096, 0x201D},	/* RIGHT DOUBLE QUOTATION MARK */
    {0x0097, 0x2014},	/* EM DASH */
    {0x0098, 0x2116},	/* NUMERO SIGN */
    {0x0099, 0x2122},	/* TRADE MARK SIGN */
    {0x009A, 0x00A0},	/* NO-BREAK SPACE */
    {0x009B, 0x00BB},	/* RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */
    {0x009C, 0x00AE},	/* REGISTERED SIGN */
    {0x009D, 0x00AB},	/* LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */
    {0x009E, 0x00B7},	/* MIDDLE DOT */
    {0x009F, 0x00A4},	/* CURRENCY SIGN */
    {0x00A0, 0x2550},	/* BOX DRAWINGS DOUBLE HORIZONTAL */
    {0x00A1, 0x2551},	/* BOX DRAWINGS DOUBLE VERTICAL */
    {0x00A2, 0x2552},	/* BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE */
    {0x00A3, 0x0451},	/* CYRILLIC SMALL LETTER IO */
    {0x00A4, 0x0454},	/* CYRILLIC SMALL LETTER UKRAINIAN IE */
    {0x00A5, 0x2554},	/* BOX DRAWINGS DOUBLE DOWN AND RIGHT */
    {0x00A6, 0x0456},	/* CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I */
    {0x00A7, 0x0457},	/* CYRILLIC SMALL LETTER YI */
    {0x00A8, 0x2557},	/* BOX DRAWINGS DOUBLE DOWN AND LEFT */
    {0x00A9, 0x2558},	/* BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE */
    {0x00AA, 0x2559},	/* BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE */
    {0x00AB, 0x255A},	/* BOX DRAWINGS DOUBLE UP AND RIGHT */
    {0x00AC, 0x255B},	/* BOX DRAWINGS UP SINGLE AND LEFT DOUBLE */
    {0x00AD, 0x0491},	/* CYRILLIC SMALL LETTER GHE WITH UPTURN */
    {0x00AE, 0x045E},	/* CYRILLIC SMALL LETTER SHORT U */
    {0x00AF, 0x255E},	/* BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE */
    {0x00B0, 0x255F},	/* BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE */
    {0x00B1, 0x2560},	/* BOX DRAWINGS DOUBLE VERTICAL AND RIGHT */
    {0x00B2, 0x2561},	/* BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE */
    {0x00B3, 0x0401},	/* CYRILLIC CAPITAL LETTER IO */
    {0x00B4, 0x0404},	/* CYRILLIC CAPITAL LETTER UKRAINIAN IE */
    {0x00B5, 0x2563},	/* BOX DRAWINGS DOUBLE VERTICAL AND LEFT */
    {0x00B6, 0x0406},	/* CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I */
    {0x00B7, 0x0407},	/* CYRILLIC CAPITAL LETTER YI */
    {0x00B8, 0x2566},	/* BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL */
    {0x00B9, 0x2567},	/* BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE */
    {0x00BA, 0x2568},	/* BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE */
    {0x00BB, 0x2569},	/* BOX DRAWINGS DOUBLE UP AND HORIZONTAL */
    {0x00BC, 0x256A},	/* BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE */
    {0x00BD, 0x0490},	/* CYRILLIC CAPITAL LETTER GHE WITH UPTURN */
    {0x00BE, 0x040E},	/* CYRILLIC CAPITAL LETTER SHORT U */
    {0x00BF, 0x00A9},	/* COPYRIGHT SIGN */
    {0x00C0, 0x044E},	/* CYRILLIC SMALL LETTER YU */
    {0x00C1, 0x0430},	/* CYRILLIC SMALL LETTER A */
    {0x00C2, 0x0431},	/* CYRILLIC SMALL LETTER BE */
    {0x00C3, 0x0446},	/* CYRILLIC SMALL LETTER TSE */
    {0x00C4, 0x0434},	/* CYRILLIC SMALL LETTER DE */
    {0x00C5, 0x0435},	/* CYRILLIC SMALL LETTER IE */
    {0x00C6, 0x0444},	/* CYRILLIC SMALL LETTER EF */
    {0x00C7, 0x0433},	/* CYRILLIC SMALL LETTER GHE */
    {0x00C8, 0x0445},	/* CYRILLIC SMALL LETTER HA */
    {0x00C9, 0x0438},	/* CYRILLIC SMALL LETTER I */
    {0x00CA, 0x0439},	/* CYRILLIC SMALL LETTER SHORT I */
    {0x00CB, 0x043A},	/* CYRILLIC SMALL LETTER KA */
    {0x00CC, 0x043B},	/* CYRILLIC SMALL LETTER EL */
    {0x00CD, 0x043C},	/* CYRILLIC SMALL LETTER EM */
    {0x00CE, 0x043D},	/* CYRILLIC SMALL LETTER EN */
    {0x00CF, 0x043E},	/* CYRILLIC SMALL LETTER O */
    {0x00D0, 0x043F},	/* CYRILLIC SMALL LETTER PE */
    {0x00D1, 0x044F},	/* CYRILLIC SMALL LETTER YA */
    {0x00D2, 0x0440},	/* CYRILLIC SMALL LETTER ER */
    {0x00D3, 0x0441},	/* CYRILLIC SMALL LETTER ES */
    {0x00D4, 0x0442},	/* CYRILLIC SMALL LETTER TE */
    {0x00D5, 0x0443},	/* CYRILLIC SMALL LETTER U */
    {0x00D6, 0x0436},	/* CYRILLIC SMALL LETTER ZHE */
    {0x00D7, 0x0432},	/* CYRILLIC SMALL LETTER VE */
    {0x00D8, 0x044C},	/* CYRILLIC SMALL LETTER SOFT SIGN */
    {0x00D9, 0x044B},	/* CYRILLIC SMALL LETTER YERU */
    {0x00DA, 0x0437},	/* CYRILLIC SMALL LETTER ZE */
    {0x00DB, 0x0448},	/* CYRILLIC SMALL LETTER SHA */
    {0x00DC, 0x044D},	/* CYRILLIC SMALL LETTER E */
    {0x00DD, 0x0449},	/* CYRILLIC SMALL LETTER SHCHA */
    {0x00DE, 0x0447},	/* CYRILLIC SMALL LETTER CHE */
    {0x00DF, 0x044A},	/* CYRILLIC SMALL LETTER HARD SIGN */
    {0x00E0, 0x042E},	/* CYRILLIC CAPITAL LETTER YU */
    {0x00E1, 0x0410},	/* CYRILLIC CAPITAL LETTER A */
    {0x00E2, 0x0411},	/* CYRILLIC CAPITAL LETTER BE */
    {0x00E3, 0x0426},	/* CYRILLIC CAPITAL LETTER TSE */
    {0x00E4, 0x0414},	/* CYRILLIC CAPITAL LETTER DE */
    {0x00E5, 0x0415},	/* CYRILLIC CAPITAL LETTER IE */
    {0x00E6, 0x0424},	/* CYRILLIC CAPITAL LETTER EF */
    {0x00E7, 0x0413},	/* CYRILLIC CAPITAL LETTER GHE */
    {0x00E8, 0x0425},	/* CYRILLIC CAPITAL LETTER HA */
    {0x00E9, 0x0418},	/* CYRILLIC CAPITAL LETTER I */
    {0x00EA, 0x0419},	/* CYRILLIC CAPITAL LETTER SHORT I */
    {0x00EB, 0x041A},	/* CYRILLIC CAPITAL LETTER KA */
    {0x00EC, 0x041B},	/* CYRILLIC CAPITAL LETTER EL */
    {0x00ED, 0x041C},	/* CYRILLIC CAPITAL LETTER EM */
    {0x00EE, 0x041D},	/* CYRILLIC CAPITAL LETTER EN */
    {0x00EF, 0x041E},	/* CYRILLIC CAPITAL LETTER O */
    {0x00F0, 0x041F},	/* CYRILLIC CAPITAL LETTER PE */
    {0x00F1, 0x042F},	/* CYRILLIC CAPITAL LETTER YA */
    {0x00F2, 0x0420},	/* CYRILLIC CAPITAL LETTER ER */
    {0x00F3, 0x0421},	/* CYRILLIC CAPITAL LETTER ES */
    {0x00F4, 0x0422},	/* CYRILLIC CAPITAL LETTER TE */
    {0x00F5, 0x0423},	/* CYRILLIC CAPITAL LETTER U */
    {0x00F6, 0x0416},	/* CYRILLIC CAPITAL LETTER ZHE */
    {0x00F7, 0x0412},	/* CYRILLIC CAPITAL LETTER VE */
    {0x00F8, 0x042C},	/* CYRILLIC CAPITAL LETTER SOFT SIGN */
    {0x00F9, 0x042B},	/* CYRILLIC CAPITAL LETTER YERU */
    {0x00FA, 0x0417},	/* CYRILLIC CAPITAL LETTER ZE */
    {0x00FB, 0x0428},	/* CYRILLIC CAPITAL LETTER SHA */
    {0x00FC, 0x042D},	/* CYRILLIC CAPITAL LETTER E */
    {0x00FD, 0x0429},	/* CYRILLIC CAPITAL LETTER SHCHA */
    {0x00FE, 0x0427},	/* CYRILLIC CAPITAL LETTER CHE */
    {0x00FF, 0x042A},	/* CYRILLIC CAPITAL LETTER HARD SIGN */
};

static const BuiltInMapping koi8_u[] =
{
    /* koi8-u */
    {0x0080, 0x2500},	/* BOX DRAWINGS LIGHT HORIZONTAL */
    {0x0081, 0x2502},	/* BOX DRAWINGS LIGHT VERTICAL */
    {0x0082, 0x250C},	/* BOX DRAWINGS LIGHT DOWN AND RIGHT */
    {0x0083, 0x2510},	/* BOX DRAWINGS LIGHT DOWN AND LEFT */
    {0x0084, 0x2514},	/* BOX DRAWINGS LIGHT UP AND RIGHT */
    {0x0085, 0x2518},	/* BOX DRAWINGS LIGHT UP AND LEFT */
    {0x0086, 0x251C},	/* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
    {0x0087, 0x2524},	/* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
    {0x0088, 0x252C},	/* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
    {0x0089, 0x2534},	/* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
    {0x008A, 0x253C},	/* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
    {0x008B, 0x2580},	/* UPPER HALF BLOCK */
    {0x008C, 0x2584},	/* LOWER HALF BLOCK */
    {0x008D, 0x2588},	/* FULL BLOCK */
    {0x008E, 0x258C},	/* LEFT HALF BLOCK */
    {0x008F, 0x2590},	/* RIGHT HALF BLOCK */
    {0x0090, 0x2591},	/* LIGHT SHADE */
    {0x0091, 0x2592},	/* MEDIUM SHADE */
    {0x0092, 0x2593},	/* DARK SHADE */
    {0x0093, 0x2320},	/* TOP HALF INTEGRAL */
    {0x0094, 0x25A0},	/* BLACK SQUARE */
    {0x0095, 0x2219},	/* BULLET OPERATOR */
    {0x0096, 0x221A},	/* SQUARE ROOT */
    {0x0097, 0x2248},	/* ALMOST EQUAL TO */
    {0x0098, 0x2264},	/* LESS-THAN OR EQUAL TO */
    {0x0099, 0x2265},	/* GREATER-THAN OR EQUAL TO */
    {0x009A, 0x00A0},	/* NO-BREAK SPACE */
    {0x009B, 0x2321},	/* BOTTOM HALF INTEGRAL */
    {0x009C, 0x00B0},	/* DEGREE SIGN */
    {0x009D, 0x00B2},	/* SUPERSCRIPT TWO */
    {0x009E, 0x00B7},	/* MIDDLE DOT */
    {0x009F, 0x00F7},	/* DIVISION SIGN */
    {0x00A0, 0x2550},	/* BOX DRAWINGS DOUBLE HORIZONTAL */
    {0x00A1, 0x2551},	/* BOX DRAWINGS DOUBLE VERTICAL */
    {0x00A2, 0x2552},	/* BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE */
    {0x00A3, 0x0451},	/* CYRILLIC SMALL LETTER IO */
    {0x00A4, 0x0454},	/* CYRILLIC SMALL LETTER UKRAINIAN IE */
    {0x00A5, 0x2554},	/* BOX DRAWINGS DOUBLE DOWN AND RIGHT */
    {0x00A6, 0x0456},	/* CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I */
    {0x00A7, 0x0457},	/* CYRILLIC SMALL LETTER YI */
    {0x00A8, 0x2557},	/* BOX DRAWINGS DOUBLE DOWN AND LEFT */
    {0x00A9, 0x2558},	/* BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE */
    {0x00AA, 0x2559},	/* BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE */
    {0x00AB, 0x255A},	/* BOX DRAWINGS DOUBLE UP AND RIGHT */
    {0x00AC, 0x255B},	/* BOX DRAWINGS UP SINGLE AND LEFT DOUBLE */
    {0x00AD, 0x0491},	/* CYRILLIC SMALL LETTER GHE WITH UPTURN */
    {0x00AE, 0x255D},	/* BOX DRAWINGS DOUBLE UP AND LEFT */
    {0x00AF, 0x255E},	/* BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE */
    {0x00B0, 0x255F},	/* BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE */
    {0x00B1, 0x2560},	/* BOX DRAWINGS DOUBLE VERTICAL AND RIGHT */
    {0x00B2, 0x2561},	/* BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE */
    {0x00B3, 0x0401},	/* CYRILLIC CAPITAL LETTER IO */
    {0x00B4, 0x0404},	/* CYRILLIC CAPITAL LETTER UKRAINIAN IE */
    {0x00B5, 0x2563},	/* BOX DRAWINGS DOUBLE VERTICAL AND LEFT */
    {0x00B6, 0x0406},	/* CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I */
    {0x00B7, 0x0407},	/* CYRILLIC CAPITAL LETTER YI */
    {0x00B8, 0x2566},	/* BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL */
    {0x00B9, 0x2567},	/* BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE */
    {0x00BA, 0x2568},	/* BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE */
    {0x00BB, 0x2569},	/* BOX DRAWINGS DOUBLE UP AND HORIZONTAL */
    {0x00BC, 0x256A},	/* BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE */
    {0x00BD, 0x0490},	/* CYRILLIC CAPITAL LETTER GHE WITH UPTURN */
    {0x00BE, 0x256C},	/* BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL */
    {0x00BF, 0x00A9},	/* COPYRIGHT SIGN */
    {0x00C0, 0x044E},	/* CYRILLIC SMALL LETTER YU */
    {0x00C1, 0x0430},	/* CYRILLIC SMALL LETTER A */
    {0x00C2, 0x0431},	/* CYRILLIC SMALL LETTER BE */
    {0x00C3, 0x0446},	/* CYRILLIC SMALL LETTER TSE */
    {0x00C4, 0x0434},	/* CYRILLIC SMALL LETTER DE */
    {0x00C5, 0x0435},	/* CYRILLIC SMALL LETTER IE */
    {0x00C6, 0x0444},	/* CYRILLIC SMALL LETTER EF */
    {0x00C7, 0x0433},	/* CYRILLIC SMALL LETTER GHE */
    {0x00C8, 0x0445},	/* CYRILLIC SMALL LETTER HA */
    {0x00C9, 0x0438},	/* CYRILLIC SMALL LETTER I */
    {0x00CA, 0x0439},	/* CYRILLIC SMALL LETTER SHORT I */
    {0x00CB, 0x043A},	/* CYRILLIC SMALL LETTER KA */
    {0x00CC, 0x043B},	/* CYRILLIC SMALL LETTER EL */
    {0x00CD, 0x043C},	/* CYRILLIC SMALL LETTER EM */
    {0x00CE, 0x043D},	/* CYRILLIC SMALL LETTER EN */
    {0x00CF, 0x043E},	/* CYRILLIC SMALL LETTER O */
    {0x00D0, 0x043F},	/* CYRILLIC SMALL LETTER PE */
    {0x00D1, 0x044F},	/* CYRILLIC SMALL LETTER YA */
    {0x00D2, 0x0440},	/* CYRILLIC SMALL LETTER ER */
    {0x00D3, 0x0441},	/* CYRILLIC SMALL LETTER ES */
    {0x00D4, 0x0442},	/* CYRILLIC SMALL LETTER TE */
    {0x00D5, 0x0443},	/* CYRILLIC SMALL LETTER U */
    {0x00D6, 0x0436},	/* CYRILLIC SMALL LETTER ZHE */
    {0x00D7, 0x0432},	/* CYRILLIC SMALL LETTER VE */
    {0x00D8, 0x044C},	/* CYRILLIC SMALL LETTER SOFT SIGN */
    {0x00D9, 0x044B},	/* CYRILLIC SMALL LETTER YERU */
    {0x00DA, 0x0437},	/* CYRILLIC SMALL LETTER ZE */
    {0x00DB, 0x0448},	/* CYRILLIC SMALL LETTER SHA */
    {0x00DC, 0x044D},	/* CYRILLIC SMALL LETTER E */
    {0x00DD, 0x0449},	/* CYRILLIC SMALL LETTER SHCHA */
    {0x00DE, 0x0447},	/* CYRILLIC SMALL LETTER CHE */
    {0x00DF, 0x044A},	/* CYRILLIC SMALL LETTER HARD SIGN */
    {0x00E0, 0x042E},	/* CYRILLIC CAPITAL LETTER YU */
    {0x00E1, 0x0410},	/* CYRILLIC CAPITAL LETTER A */
    {0x00E2, 0x0411},	/* CYRILLIC CAPITAL LETTER BE */
    {0x00E3, 0x0426},	/* CYRILLIC CAPITAL LETTER TSE */
    {0x00E4, 0x0414},	/* CYRILLIC CAPITAL LETTER DE */
    {0x00E5, 0x0415},	/* CYRILLIC CAPITAL LETTER IE */
    {0x00E6, 0x0424},	/* CYRILLIC CAPITAL LETTER EF */
    {0x00E7, 0x0413},	/* CYRILLIC CAPITAL LETTER GHE */
    {0x00E8, 0x0425},	/* CYRILLIC CAPITAL LETTER HA */
    {0x00E9, 0x0418},	/* CYRILLIC CAPITAL LETTER I */
    {0x00EA, 0x0419},	/* CYRILLIC CAPITAL LETTER SHORT I */
    {0x00EB, 0x041A},	/* CYRILLIC CAPITAL LETTER KA */
    {0x00EC, 0x041B},	/* CYRILLIC CAPITAL LETTER EL */
    {0x00ED, 0x041C},	/* CYRILLIC CAPITAL LETTER EM */
    {0x00EE, 0x041D},	/* CYRILLIC CAPITAL LETTER EN */
    {0x00EF, 0x041E},	/* CYRILLIC CAPITAL LETTER O */
    {0x00F0, 0x041F},	/* CYRILLIC CAPITAL LETTER PE */
    {0x00F1, 0x042F},	/* CYRILLIC CAPITAL LETTER YA */
    {0x00F2, 0x0420},	/* CYRILLIC CAPITAL LETTER ER */
    {0x00F3, 0x0421},	/* CYRILLIC CAPITAL LETTER ES */
    {0x00F4, 0x0422},	/* CYRILLIC CAPITAL LETTER TE */
    {0x00F5, 0x0423},	/* CYRILLIC CAPITAL LETTER U */
    {0x00F6, 0x0416},	/* CYRILLIC CAPITAL LETTER ZHE */
    {0x00F7, 0x0412},	/* CYRILLIC CAPITAL LETTER VE */
    {0x00F8, 0x042C},	/* CYRILLIC CAPITAL LETTER SOFT SIGN */
    {0x00F9, 0x042B},	/* CYRILLIC CAPITAL LETTER YERU */
    {0x00FA, 0x0417},	/* CYRILLIC CAPITAL LETTER ZE */
    {0x00FB, 0x0428},	/* CYRILLIC CAPITAL LETTER SHA */
    {0x00FC, 0x042D},	/* CYRILLIC CAPITAL LETTER E */
    {0x00FD, 0x0429},	/* CYRILLIC CAPITAL LETTER SHCHA */
    {0x00FE, 0x0427},	/* CYRILLIC CAPITAL LETTER CHE */
    {0x00FF, 0x042A},	/* CYRILLIC CAPITAL LETTER HARD SIGN */
};

#define DATA(name) name, SizeOf(name)
const BuiltInCharsetRec builtin_encodings[] =
{
    { "apl2",           DATA(apl2) },
    { "dec-special",    DATA(dec_special) },
    { "dec-technical",  DATA(dec_technical) },
    { "iso8859-1",      DATA(iso8859_1) },
    { "iso8859-10",     DATA(iso8859_10) },
    { "iso8859-15",     DATA(iso8859_15) },
    { "iso8859-2",      DATA(iso8859_2) },
    { "iso8859-3",      DATA(iso8859_3) },
    { "iso8859-4",      DATA(iso8859_4) },
    { "iso8859-5",      DATA(iso8859_5) },
    { "iso8859-6",      DATA(iso8859_6) },
    { "iso8859-7",      DATA(iso8859_7) },
    { "iso8859-8",      DATA(iso8859_8) },
    { "iso8859-9",      DATA(iso8859_9) },
    { "koi8-e",         DATA(koi8_e) },
    { "koi8-r",         DATA(koi8_r) },
    { "koi8-ru",        DATA(koi8_ru) },
    { "koi8-u",         DATA(koi8_u) },
    { NULL, NULL, 0 }
};
/* *INDENT-ON* */
