/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Polymer;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.Logger;
import org.jmol.util.Measure;

public class AminoPolymer
extends AlphaPolymer {
    private boolean hasOAtoms;
    private static final float maxHbondAlphaDistance = 9.0f;
    private static final float maxHbondAlphaDistance2 = 81.0f;
    private static final float minimumHbondDistance2 = 0.5f;
    private static final double QConst = -27888.0;

    AminoPolymer(Monomer[] monomerArray) {
        super(monomerArray);
        this.type = 1;
    }

    boolean hasWingPoints() {
        return this.hasOAtoms;
    }

    public void calcHydrogenBonds(Polymer polymer, BitSet bitSet, BitSet bitSet2) {
        this.calcProteinMainchainHydrogenBonds((AminoPolymer)polymer, bitSet, bitSet2);
    }

    private void calcProteinMainchainHydrogenBonds(AminoPolymer aminoPolymer, BitSet bitSet, BitSet bitSet2) {
        boolean bl;
        Point3f point3f = new Point3f();
        Vector3f vector3f = new Vector3f();
        boolean bl2 = bl = aminoPolymer == null;
        if (bl) {
            aminoPolymer = this;
        }
        for (int i = 1; i < aminoPolymer.monomerCount; ++i) {
            AminoMonomer aminoMonomer = (AminoMonomer)aminoPolymer.monomers[i];
            if (!aminoMonomer.getNHPoint(point3f, vector3f)) continue;
            this.bondAminoHydrogen(aminoMonomer, bl ? i : -100, point3f, bitSet, bitSet2);
        }
    }

    private void bondAminoHydrogen(AminoMonomer aminoMonomer, int n, Point3f point3f, BitSet bitSet, BitSet bitSet2) {
        Point3f point3f2 = aminoMonomer.getLeadAtomPoint();
        Point3f point3f3 = aminoMonomer.getNitrogenAtomPoint();
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        int n6 = this.monomerCount;
        while (--n6 >= 0) {
            AminoMonomer aminoMonomer2;
            Point3f point3f4;
            float f;
            if (n6 == n || n6 + 1 == n || n6 - 1 == n || (f = point3f2.distanceSquared(point3f4 = (aminoMonomer2 = (AminoMonomer)this.monomers[n6]).getLeadAtomPoint())) > 81.0f) continue;
            int n7 = this.calcHbondEnergy(aminoMonomer.getNitrogenAtom(), point3f3, point3f, aminoMonomer2);
            if (n7 < n2) {
                n3 = n2;
                n5 = n4;
                n2 = n7;
                n4 = n6;
                continue;
            }
            if (n7 >= n3) continue;
            n3 = n7;
            n5 = n6;
        }
        if (n4 >= 0) {
            this.createResidueHydrogenBond(aminoMonomer, n, n4, bitSet, bitSet2, (float)(-n2) / 1000.0f);
            if (n5 >= 0) {
                this.createResidueHydrogenBond(aminoMonomer, n, n5, bitSet, bitSet2, (float)(-n3) / 1000.0f);
            }
        }
    }

    private int calcHbondEnergy(Atom atom, Point3f point3f, Point3f point3f2, AminoMonomer aminoMonomer) {
        boolean bl;
        Point3f point3f3 = aminoMonomer.getCarbonylOxygenAtomPoint();
        if (point3f3 == null) {
            return 0;
        }
        float f = point3f3.distanceSquared(point3f);
        if (f < 0.5f) {
            return 0;
        }
        float f2 = point3f3.distanceSquared(point3f2);
        if (f2 < 0.5f) {
            return 0;
        }
        Point3f point3f4 = aminoMonomer.getCarbonylCarbonAtomPoint();
        float f3 = point3f4.distanceSquared(point3f2);
        if (f3 < 0.5f) {
            return 0;
        }
        float f4 = point3f4.distanceSquared(point3f);
        if (f4 < 0.5f) {
            return 0;
        }
        double d = Math.sqrt(f2);
        double d2 = Math.sqrt(f3);
        double d3 = Math.sqrt(f4);
        double d4 = Math.sqrt(f);
        int n = (int)(-27888.0 / d - -27888.0 / d2 + -27888.0 / d3 - -27888.0 / d4);
        boolean bl2 = bl = f4 > f3 && d <= 3.0 && n <= -500;
        return !bl ? 0 : (n < -9900 ? -9900 : n);
    }

    private void createResidueHydrogenBond(AminoMonomer aminoMonomer, int n, int n2, BitSet bitSet, BitSet bitSet2, float f) {
        short s;
        int n3 = n - n2;
        switch (n3) {
            case 2: {
                s = 6144;
                break;
            }
            case 3: {
                s = 8192;
                break;
            }
            case 4: {
                s = 10240;
                break;
            }
            case 5: {
                s = 12288;
                break;
            }
            case -3: {
                s = 14336;
                break;
            }
            case -4: {
                s = 16384;
                break;
            }
            default: {
                s = 4096;
            }
        }
        Atom atom = aminoMonomer.getNitrogenAtom();
        AminoMonomer aminoMonomer2 = (AminoMonomer)this.monomers[n2];
        Atom atom2 = aminoMonomer2.getCarbonylOxygenAtom();
        this.model.addHydrogenBond(atom, atom2, s, bitSet, bitSet2, f);
    }

    public void calculateStructures() {
        int n;
        char[] cArray = new char[this.monomerCount];
        for (n = 0; n < this.monomerCount - 1; ++n) {
            AminoMonomer aminoMonomer = (AminoMonomer)this.monomers[n];
            AminoMonomer aminoMonomer2 = (AminoMonomer)this.monomers[n + 1];
            float f = aminoMonomer2.getPhi();
            float f2 = aminoMonomer.getPsi();
            cArray[n] = AminoPolymer.isHelix(f2, f) ? (f < 0.0f && f2 < 25.0f ? 52 : 51) : (AminoPolymer.isSheet(f2, f) ? 115 : (AminoPolymer.isTurn(f2, f) ? 116 : 110));
            if (!Logger.debugging) continue;
            Logger.debug('\u0000' + this.monomers[0].getChainID() + " aminopolymer:" + n + " " + aminoMonomer2.getPhi() + "," + aminoMonomer.getPsi() + " " + cArray[n]);
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n2;
            if (cArray[n] != '4') continue;
            for (n2 = n + 1; n2 < this.monomerCount && cArray[n2] == '4'; ++n2) {
            }
            if (--n2 >= n + 3) {
                this.addSecondaryStructure((byte)3, null, 0, 0, n, n2);
            }
            n = n2;
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n3;
            if (cArray[n] != '3') continue;
            for (n3 = n + 1; n3 < this.monomerCount && cArray[n3] == '3'; ++n3) {
            }
            if (--n3 >= n + 3) {
                this.addSecondaryStructure((byte)3, null, 0, 0, n, n3);
            }
            n = n3;
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n4;
            if (cArray[n] != 's') continue;
            for (n4 = n + 1; n4 < this.monomerCount && cArray[n4] == 's'; ++n4) {
            }
            if (--n4 >= n + 2) {
                this.addSecondaryStructure((byte)2, null, 0, 0, n, n4);
            }
            n = n4;
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n5;
            if (cArray[n] != 't') continue;
            for (n5 = n + 1; n5 < this.monomerCount && cArray[n5] == 't'; ++n5) {
            }
            if (--n5 >= n + 2) {
                this.addSecondaryStructure((byte)1, null, 0, 0, n, n5);
            }
            n = n5;
        }
    }

    protected void resetHydrogenPoints() {
        ProteinStructure proteinStructure = null;
        for (int i = 0; i < this.monomerCount; ++i) {
            ProteinStructure proteinStructure2 = this.getProteinStructure(i);
            if (proteinStructure2 != null && proteinStructure2 != proteinStructure) {
                proteinStructure = proteinStructure2;
                proteinStructure.resetAxes();
            }
            ((AminoMonomer)this.monomers[i]).resetHydrogenPoint();
        }
    }

    private boolean checkWingAtoms() {
        for (int i = 0; i < this.monomerCount; ++i) {
            if (((AminoMonomer)this.monomers[i]).hasOAtom()) continue;
            return false;
        }
        return true;
    }

    public void freeze() {
        this.hasOAtoms = this.checkWingAtoms();
        this.calcPhiPsiAngles();
    }

    protected boolean calcPhiPsiAngles() {
        for (int i = 0; i < this.monomerCount - 1; ++i) {
            this.calcPhiPsiAngles((AminoMonomer)this.monomers[i], (AminoMonomer)this.monomers[i + 1]);
        }
        return true;
    }

    private void calcPhiPsiAngles(AminoMonomer aminoMonomer, AminoMonomer aminoMonomer2) {
        Point3f point3f = aminoMonomer.getNitrogenAtomPoint();
        Point3f point3f2 = aminoMonomer.getLeadAtomPoint();
        Point3f point3f3 = aminoMonomer.getCarbonylCarbonAtomPoint();
        Point3f point3f4 = aminoMonomer2.getNitrogenAtomPoint();
        Point3f point3f5 = aminoMonomer2.getLeadAtomPoint();
        Point3f point3f6 = aminoMonomer2.getCarbonylCarbonAtomPoint();
        aminoMonomer2.setPhi(Measure.computeTorsion(point3f3, point3f4, point3f5, point3f6, true));
        aminoMonomer.setPsi(Measure.computeTorsion(point3f, point3f2, point3f3, point3f4, true));
        aminoMonomer.setOmega(Measure.computeTorsion(point3f2, point3f3, point3f4, point3f5, true));
    }

    protected float calculateRamachandranHelixAngle(int n, char c) {
        float f = n == 0 ? Float.NaN : this.monomers[n - 1].getPsi();
        float f2 = this.monomers[n].getPsi();
        float f3 = this.monomers[n].getPhi();
        float f4 = n == this.monomerCount - 1 ? Float.NaN : this.monomers[n + 1].getPhi();
        float f5 = n == this.monomerCount - 1 ? Float.NaN : this.monomers[n + 1].getPsi();
        switch (c) {
            default: {
                float f6 = (float)((double)((f4 - f3) / 2.0f) * Math.PI / 180.0);
                float f7 = (float)((double)((f5 - f2) / 2.0f) * Math.PI / 180.0);
                return (float)(114.59155902616465 * Math.acos(Math.cos(f7) * Math.cos(f6) - Math.cos(1.2217304763960306) * Math.sin(f7) * Math.sin(f6)));
            }
            case 'C': 
            case 'c': 
        }
        return f2 - f + f4 - f3;
    }

    private static boolean isHelix(float f, float f2) {
        return f2 >= -160.0f && f2 <= 0.0f && f >= -100.0f && f <= 45.0f;
    }

    private static boolean isSheet(float f, float f2) {
        return f2 >= -180.0f && f2 <= -10.0f && f >= 70.0f && f <= 180.0f || f2 >= -180.0f && f2 <= -45.0f && f >= -180.0f && f <= -130.0f || f2 >= 140.0f && f2 <= 180.0f && f >= 90.0f && f <= 180.0f;
    }

    private static boolean isTurn(float f, float f2) {
        return f2 >= 30.0f && f2 <= 90.0f && f >= -15.0f && f <= 95.0f;
    }
}

