/*
 * SelectionCommand.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "SelectionCommand.h"
#include "Scene.h"
#include "Path.h"

SelectionCommand::SelectionCommand(Scene *scene, Path *newPath)
{
    _oldPath = _scene->getSelection();
    _newPath = newPath;
}

SelectionCommand::~SelectionCommand()
{
    delete _oldPath;
    delete _newPath;
}

void
SelectionCommand::execute()
{
    _scene->setSelection(_newPath);
    _scene->UpdateViews(NULL, UPDATE_SELECTION);
}

void
SelectionCommand::undo()
{
    _scene->setSelection(_oldPath);
    _scene->UpdateViews(NULL, UPDATE_SELECTION);
}
