# Changelog

## [5.8.0](https://github.com/htacg/tidy-html5/tree/5.8.0) (2021-07-10)

[Full Changelog](https://github.com/htacg/tidy-html5/compare/5.6.0...5.8.0)

**Fixed bugs:**

- Details open, Value added to Attribute [\#925](https://github.com/htacg/tidy-html5/issues/925)
- Fix handling of percent symbols in CheckLength validation routine [\#910](https://github.com/htacg/tidy-html5/issues/910)
- What is the true purpose and use case of the --bare option? [\#896](https://github.com/htacg/tidy-html5/issues/896)
- Warning about missing \</summary\> [\#895](https://github.com/htacg/tidy-html5/issues/895)
- DecodeMacRoman\(\) is missing an upper bounds check before indexing into Mac2Unicode array [\#891](https://github.com/htacg/tidy-html5/issues/891)
- Can't disable wrap [\#858](https://github.com/htacg/tidy-html5/issues/858)
- Recursion limit exceeded [\#850](https://github.com/htacg/tidy-html5/issues/850)
- template tag should be allowed in head [\#836](https://github.com/htacg/tidy-html5/issues/836)
- tag\_defs + AdjustTags\(\) and ResetTags\(\) during parsing is not thread-safe \(tags.c\) [\#816](https://github.com/htacg/tidy-html5/issues/816)
- Unexpected parsing with uppercase DOCTYPE [\#815](https://github.com/htacg/tidy-html5/issues/815)
- bugfix for messageobj.c for windows vc++ [\#800](https://github.com/htacg/tidy-html5/issues/800)
- Tidy 5.7.20 GetSurrogatePair can use uninitialised value processing malformed entity refs [\#798](https://github.com/htacg/tidy-html5/issues/798)
- regression tests fail if /etc/tidy.conf or ~/.tidyrc exists [\#778](https://github.com/htacg/tidy-html5/issues/778)
- AddByte allocAmt overflows for large input files [\#761](https://github.com/htacg/tidy-html5/issues/761)
- --strict-tags-attributes no doesn't ignore \<td align\> [\#729](https://github.com/htacg/tidy-html5/issues/729)
- "Too many title elements in \<title\>" should say "Too many title elements in \<head\>" [\#692](https://github.com/htacg/tidy-html5/issues/692)
- Tidy 5.6.0 on Mac says Not a file when file is not writeable [\#681](https://github.com/htacg/tidy-html5/issues/681)
- Tidy fails if html contains a section \<!\[endif\]—\> [\#487](https://github.com/htacg/tidy-html5/issues/487)
- "Malformed" Word 2000 sequence may cause Tidy to skip document content [\#462](https://github.com/htacg/tidy-html5/issues/462)
- Change open tag to Boolean [\#932](https://github.com/htacg/tidy-html5/pull/932) (@arrmo)
- Is \#729 - Show 'warnings' in all td cases [\#928](https://github.com/htacg/tidy-html5/pull/928) (@geoffmcl)
- Issue \#692 - too many titles [\#927](https://github.com/htacg/tidy-html5/pull/927) (@geoffmcl)
- Is. \#681 - read-only files, and dirs [\#926](https://github.com/htacg/tidy-html5/pull/926) (@geoffmcl)
- Free attributes before return NULL [\#899](https://github.com/htacg/tidy-html5/pull/899) (@ltx2018)
- Is. \#896 - make 'bear' docs match code [\#898](https://github.com/htacg/tidy-html5/pull/898) (@geoffmcl)
- Correction for issue-895 [\#897](https://github.com/htacg/tidy-html5/pull/897) (@arrmo)
- fix memleak in GetTokenFromStream [\#884](https://github.com/htacg/tidy-html5/pull/884) (@ltx2018)
- Protect against NULL in PruneSection. [\#853](https://github.com/htacg/tidy-html5/pull/853) (@esclim)
- Is \#815 - Use case-insensitive test 'html' [\#832](https://github.com/htacg/tidy-html5/pull/832) (@geoffmcl)
- Is. \#761 - just deal with the 'uint' wrap [\#830](https://github.com/htacg/tidy-html5/pull/830) (@geoffmcl)
- Tidy 5.7.20 crashes if allocator replaced [\#797](https://github.com/htacg/tidy-html5/issues/797)
- --mute should suppress non-zero exit code [\#794](https://github.com/htacg/tidy-html5/issues/794)
- Seems tidy.c has sprung a leak [\#791](https://github.com/htacg/tidy-html5/issues/791)
- Cannot handle read-only html files \(possibly regression?\) [\#789](https://github.com/htacg/tidy-html5/issues/789)
- setlocale\( LC\_ALL, ""\) changes the locale for the entire application [\#770](https://github.com/htacg/tidy-html5/issues/770)
- mute in ~/.tidyrc runs fine but triggers exit\(1\) [\#752](https://github.com/htacg/tidy-html5/issues/752)
- Duplicate IDs are not detected if the ID has an uppercase letter [\#726](https://github.com/htacg/tidy-html5/issues/726)
- Tidy gets confused with a \<span\> around a block element [\#709](https://github.com/htacg/tidy-html5/issues/709)
- Tidy seems to get confused by HTML strings in JavaScript blocks. [\#700](https://github.com/htacg/tidy-html5/issues/700)
- tidy indent+wrap breaks \<pre\> formatting [\#697](https://github.com/htacg/tidy-html5/issues/697)
- -export-config creates invalid configuration file [\#679](https://github.com/htacg/tidy-html5/issues/679)
- Segmentation Fault [\#656](https://github.com/htacg/tidy-html5/issues/656)
- Maybe a problem with some vsnprintf implementations? [\#655](https://github.com/htacg/tidy-html5/issues/655)
- Why is libtidy complaining \<data\> isn’t approved by W3C? [\#649](https://github.com/htacg/tidy-html5/issues/649)
- Is. \#791 - free some allocations [\#809](https://github.com/htacg/tidy-html5/pull/809) (@geoffmcl)
- Issue 726 upper case anchors [\#731](https://github.com/htacg/tidy-html5/pull/731) (@geoffmcl)
- Is \#673 - Revert 350f7b4 and 86e62db AdjustConfig logic [\#705](https://github.com/htacg/tidy-html5/pull/705) (@geoffmcl)
- Issue \#655 - Fix unsafe use of output buffer as input param [\#662](https://github.com/htacg/tidy-html5/pull/662) (@geoffmcl)
- Issue \#656 - protect against NULL node set in loop [\#661](https://github.com/htacg/tidy-html5/pull/661) (@geoffmcl)

**Closed issues:**

- No NPM? [\#960](https://github.com/htacg/tidy-html5/issues/960)
- Where can I find the list of known tags? [\#958](https://github.com/htacg/tidy-html5/issues/958)
- fix non-standard static library name [\#952](https://github.com/htacg/tidy-html5/issues/952)
- Lot of config options; but where are the defaults specified [\#948](https://github.com/htacg/tidy-html5/issues/948)
- Any Windows Binaries for 5.7.28, just like 5.6? [\#947](https://github.com/htacg/tidy-html5/issues/947)
- Setup continuous integration and testing [\#944](https://github.com/htacg/tidy-html5/issues/944)
- Linux binaries for latest releases [\#939](https://github.com/htacg/tidy-html5/issues/939)
- Outdated warnings [\#938](https://github.com/htacg/tidy-html5/issues/938)
- Umlauts/special characters not converted to correct html entities [\#936](https://github.com/htacg/tidy-html5/issues/936)
- tidy hanging [\#935](https://github.com/htacg/tidy-html5/issues/935)
- Tidy catches repeated attributes, but misses identical ids [\#924](https://github.com/htacg/tidy-html5/issues/924)
- drop-empty-elements is not removing empty Table elements [\#923](https://github.com/htacg/tidy-html5/issues/923)
- Tag "main" is shown as error [\#922](https://github.com/htacg/tidy-html5/issues/922)
- Unexpected parsing a tag in table [\#919](https://github.com/htacg/tidy-html5/issues/919)
- beginner on windows -- tidy reports: document: "a0.htm" is not a file! -- But it is [\#918](https://github.com/htacg/tidy-html5/issues/918)
- tidy says this misplaced \</dl\> is OK [\#917](https://github.com/htacg/tidy-html5/issues/917)
- Tidy can't deal with \<中文\> XML tags [\#913](https://github.com/htacg/tidy-html5/issues/913)
- Support extended color names in HTML 5 [\#908](https://github.com/htacg/tidy-html5/issues/908)
- Unknown type uint trying to use the shared lib. [\#906](https://github.com/htacg/tidy-html5/issues/906)
- \</select\> ending tag missing [\#904](https://github.com/htacg/tidy-html5/issues/904)
- SVG attributes flagged as proprietary [\#903](https://github.com/htacg/tidy-html5/issues/903)
- tidy-mark option is not working [\#901](https://github.com/htacg/tidy-html5/issues/901)
- Need help controlling output [\#894](https://github.com/htacg/tidy-html5/issues/894)
- Say how to deal with XHTML input [\#893](https://github.com/htacg/tidy-html5/issues/893)
- Help output refers to a non-existent -options option [\#892](https://github.com/htacg/tidy-html5/issues/892)
- Tidy gets confused with u tags and underline styles [\#890](https://github.com/htacg/tidy-html5/issues/890)
- how to forbid auto insert tag? [\#889](https://github.com/htacg/tidy-html5/issues/889)
- Incorrectly changing — to - \(emdash \[alt 0151\]\) to hypens. [\#885](https://github.com/htacg/tidy-html5/issues/885)
- html-tidy site does not work with https [\#883](https://github.com/htacg/tidy-html5/issues/883)
- Use with TextPad 8 [\#882](https://github.com/htacg/tidy-html5/issues/882)
- Translation: TidyKeepTabs [\#880](https://github.com/htacg/tidy-html5/issues/880)
- \<img\> proprietary attribute "loading" [\#879](https://github.com/htacg/tidy-html5/issues/879)
- Versioning seems a bit off [\#877](https://github.com/htacg/tidy-html5/issues/877)
- --quote-ampersand yes doesn't work [\#876](https://github.com/htacg/tidy-html5/issues/876)
- Convert spaces to non-breaking space [\#875](https://github.com/htacg/tidy-html5/issues/875)
- Tidy 5.6.0 mangled html / php code. [\#872](https://github.com/htacg/tidy-html5/issues/872)
- Even with -utf8 tidy replaces UTF8 code U+00A0 into numeric entity &\#160; [\#871](https://github.com/htacg/tidy-html5/issues/871)
- http-equiv metas should trigger helpful upgrade messages [\#868](https://github.com/htacg/tidy-html5/issues/868)
- HTML Tidy website does not render propertly when using HTTPS [\#867](https://github.com/htacg/tidy-html5/issues/867)
- \[-Wignored-qualifiers\] warning in tidy [\#866](https://github.com/htacg/tidy-html5/issues/866)
- Wrong character encoding [\#863](https://github.com/htacg/tidy-html5/issues/863)
- Missing semicolon after html entity sometimes returns generic 'unknown entity' warning instead of specific 'missing semicolon' [\#862](https://github.com/htacg/tidy-html5/issues/862)
- Warning: unescaped & or unknown entity "&P" when encoding as utf-8 [\#861](https://github.com/htacg/tidy-html5/issues/861)
- Tidy output clutter [\#857](https://github.com/htacg/tidy-html5/issues/857)
- Trailing backspace removed [\#856](https://github.com/htacg/tidy-html5/issues/856)
- Only wrap at tags [\#854](https://github.com/htacg/tidy-html5/issues/854)
- ENABLE\_DEBUG\_LOG is ignored on Windows [\#852](https://github.com/htacg/tidy-html5/issues/852)
- Kill off alphabetical ordering clause for publicly-exposed enum defs [\#851](https://github.com/htacg/tidy-html5/issues/851)
- For Sublime Text 3 [\#849](https://github.com/htacg/tidy-html5/issues/849)
- \<li\> tags skipped in tidy result shown on screen [\#847](https://github.com/htacg/tidy-html5/issues/847)
- man page missing header causing appending to XML discussion [\#846](https://github.com/htacg/tidy-html5/issues/846)
- \<input type="file"\> needs name= [\#845](https://github.com/htacg/tidy-html5/issues/845)
- Expose node-\>last in the public API [\#844](https://github.com/htacg/tidy-html5/issues/844)
- Support EJS? [\#842](https://github.com/htacg/tidy-html5/issues/842)
- Tidy 5.2 cleaned up curly quotes but 5.6 doesn't [\#841](https://github.com/htacg/tidy-html5/issues/841)
- Jekyll headings removed [\#840](https://github.com/htacg/tidy-html5/issues/840)
- Should tidy allow an empty title element? [\#839](https://github.com/htacg/tidy-html5/issues/839)
- Missing tags for 5.7.\* [\#834](https://github.com/htacg/tidy-html5/issues/834)
- Python binding? [\#826](https://github.com/htacg/tidy-html5/issues/826)
- Self-closing tags are not correctly recognized [\#813](https://github.com/htacg/tidy-html5/issues/813)
- Different output when parsing HTML [\#790](https://github.com/htacg/tidy-html5/issues/790)
- Continuously fuzzing tidy-html5 with OSS-Fuzz [\#788](https://github.com/htacg/tidy-html5/issues/788)
- I18N isn't working \(mostly\) via changing the environment variables [\#783](https://github.com/htacg/tidy-html5/issues/783)
- 5.6.0 and breakage with php-tidy [\#780](https://github.com/htacg/tidy-html5/issues/780)
- Tidy needs a changelog [\#776](https://github.com/htacg/tidy-html5/issues/776)
- TidyNodeGetText returns text with a new line appended [\#775](https://github.com/htacg/tidy-html5/issues/775)
- Breaks microseconds after call tidy\_repair\_string [\#771](https://github.com/htacg/tidy-html5/issues/771)
- Typos in language\_en.h, etc [\#765](https://github.com/htacg/tidy-html5/issues/765)
- Document accessibility priority numbers better [\#756](https://github.com/htacg/tidy-html5/issues/756)
- Xcode not working with tidylib [\#751](https://github.com/htacg/tidy-html5/issues/751)
- Intent-To-Package: Snaps are Universal Linux Packages [\#748](https://github.com/htacg/tidy-html5/issues/748)
- Can't parse UTF16 html string [\#744](https://github.com/htacg/tidy-html5/issues/744)
- libtidy.so.5 has removed symbols between 5.2.0 and 5.6.0, but kept SONAME [\#743](https://github.com/htacg/tidy-html5/issues/743)
- Tidy 5.7.16 -\> empty result [\#740](https://github.com/htacg/tidy-html5/issues/740)
- Crash with malformed \<meta\> tag [\#739](https://github.com/htacg/tidy-html5/issues/739)
- bug\(encoding\): non-ASCII characters in configuration file [\#737](https://github.com/htacg/tidy-html5/issues/737)
- Improve documentation re: wrap-script-literals [\#736](https://github.com/htacg/tidy-html5/issues/736)
- feature\_request\(validation\): “preserve-entities yes” by default [\#732](https://github.com/htacg/tidy-html5/issues/732)
- Tidy emits warnings that aren't in order [\#696](https://github.com/htacg/tidy-html5/issues/696)
- Option to disable tidy code fixing option [\#693](https://github.com/htacg/tidy-html5/issues/693)
- tidy change html view when deal with white-space:pre tag [\#685](https://github.com/htacg/tidy-html5/issues/685)
- CLI option to stop insertion/deletion of tags [\#682](https://github.com/htacg/tidy-html5/issues/682)
- Tidy does not strip leading and trailing spaces in HTML href [\#678](https://github.com/htacg/tidy-html5/issues/678)
- Use tidy with json  custom attributes on  custom components [\#677](https://github.com/htacg/tidy-html5/issues/677)
- \[Question\] How to use tidy for multiple files? [\#668](https://github.com/htacg/tidy-html5/issues/668)
- How to run a test-kit from terminal? [\#667](https://github.com/htacg/tidy-html5/issues/667)
- Dependency on DLLs not Documented [\#666](https://github.com/htacg/tidy-html5/issues/666)
- tidylib.c fails to compile on Visual Studio 2010 [\#665](https://github.com/htacg/tidy-html5/issues/665)
- Minify HTML [\#628](https://github.com/htacg/tidy-html5/issues/628)
- Do not insert newlines into TEXT when wrapping! [\#625](https://github.com/htacg/tidy-html5/issues/625)
- Configuration Options "cleanup" [\#609](https://github.com/htacg/tidy-html5/issues/609)
- Next Release 5.6.0 [\#600](https://github.com/htacg/tidy-html5/issues/600)
- anchor-as-name: false replaces name attribute of a form tag with id attribute [\#571](https://github.com/htacg/tidy-html5/issues/571)
- Why does tidy format the '\<' and '\>' numeric operator? [\#485](https://github.com/htacg/tidy-html5/issues/485)
- span with display: inline-block is treated as inline [\#448](https://github.com/htacg/tidy-html5/issues/448)
- wrap-php multiple lines [\#437](https://github.com/htacg/tidy-html5/issues/437)
- Option to always encode double ampersands [\#827](https://github.com/htacg/tidy-html5/issues/827)
- \[ENH\] Add meta options to disable/enable cleanup and repair option [\#819](https://github.com/htacg/tidy-html5/issues/819)
- --vertical-space yes adds too much after comment [\#811](https://github.com/htacg/tidy-html5/issues/811)
- Line breaking on "|"  [\#810](https://github.com/htacg/tidy-html5/issues/810)
- Installs library in /usr/local/lib/lib instead of /usr/local/lib [\#807](https://github.com/htacg/tidy-html5/issues/807)
- Publishing in VS2015 - System.DllNotFoundException [\#804](https://github.com/htacg/tidy-html5/issues/804)
- can not fix script async Attr to async="async" [\#799](https://github.com/htacg/tidy-html5/issues/799)
- Feature Request: Omit boilerplate [\#795](https://github.com/htacg/tidy-html5/issues/795)
- html conversion to xml leaves many tags unclosed [\#792](https://github.com/htacg/tidy-html5/issues/792)
- NppTidy 5.6.0 quickref.html link broken - please fix [\#787](https://github.com/htacg/tidy-html5/issues/787)
- Redundant blank lines when printing -help [\#781](https://github.com/htacg/tidy-html5/issues/781)
- --css-prefix option no longer adds a hyphen to its built classes [\#777](https://github.com/htacg/tidy-html5/issues/777)
- Build error on Android \(Termux\): unknown type name 'ulong' [\#773](https://github.com/htacg/tidy-html5/issues/773)
- alter default config file processing [\#772](https://github.com/htacg/tidy-html5/issues/772)
- Tidy output going to stderr [\#763](https://github.com/htacg/tidy-html5/issues/763)
- --tidy-mark no inserts blank line [\#760](https://github.com/htacg/tidy-html5/issues/760)
- tidy -access: \<doctype\> NOT missing [\#758](https://github.com/htacg/tidy-html5/issues/758)
- type qualifiers ignored on function return type \[-Werror=ignored-qualifiers\] [\#746](https://github.com/htacg/tidy-html5/issues/746)
- tidy dies on unexpected character [\#745](https://github.com/htacg/tidy-html5/issues/745)
- tidy 5.6.0 warning `inserting missing 'title' element` appears in php-only files [\#728](https://github.com/htacg/tidy-html5/issues/728)
- bug\(build\): tidyBufAppend\(&buf1, d-\>def, strlen\(d-\>def\)\); [\#721](https://github.com/htacg/tidy-html5/issues/721)
- Allow specify ranges of code that do not get checked [\#720](https://github.com/htacg/tidy-html5/issues/720)
- README/CONTRIBUTING.md [\#718](https://github.com/htacg/tidy-html5/issues/718)
- tidy's error messages should include filename somewhere [\#713](https://github.com/htacg/tidy-html5/issues/713)
- Tidy does not complain about valign in \<tr\>, \<th\> or \<td\> [\#711](https://github.com/htacg/tidy-html5/issues/711)
- tidy converts '&' in query parameters \(&aen=true =\> &amp;aen=true\) in relative paths [\#710](https://github.com/htacg/tidy-html5/issues/710)
- TidyHtml not working properly in C++ [\#707](https://github.com/htacg/tidy-html5/issues/707)
- Unescaped `&` emitted despite using \*\*output-xhtml\*\* key bindings in 5.6.0 in PHP bindings [\#704](https://github.com/htacg/tidy-html5/issues/704)
- How to ignore specific warnings [\#699](https://github.com/htacg/tidy-html5/issues/699)
- Mention the need for a `:` before options' value in the configuration file [\#698](https://github.com/htacg/tidy-html5/issues/698)
- Tidy 5.6.0 -\> bug with pre tag [\#690](https://github.com/htacg/tidy-html5/issues/690)
- Is there any way to remove inline styles? [\#689](https://github.com/htacg/tidy-html5/issues/689)
- feature request\(safari\): Pinned Tab Icons support [\#686](https://github.com/htacg/tidy-html5/issues/686)
- Adopt Cygwin tidy package [\#680](https://github.com/htacg/tidy-html5/issues/680)
- Clarification on releases / release tarballs missing [\#676](https://github.com/htacg/tidy-html5/issues/676)
- --fix-uri no does not turn off check [\#675](https://github.com/htacg/tidy-html5/issues/675)
- Unexpected behavior of 'add-xml-space' setting when used with 'wrap' =\> 0 and saveBuffer is called twice in tidy-html5 5.6.0 [\#673](https://github.com/htacg/tidy-html5/issues/673)
- show-body-only [\#672](https://github.com/htacg/tidy-html5/issues/672)
- Tidy deletes empty tags [\#669](https://github.com/htacg/tidy-html5/issues/669)
- unbalanced \#endif's [\#663](https://github.com/htacg/tidy-html5/issues/663)
- Feature request: option to replace inline styles with classes + `<style>` tag styles [\#638](https://github.com/htacg/tidy-html5/issues/638)
- Windows 32-bit XP Release [\#568](https://github.com/htacg/tidy-html5/issues/568)
- Release an updated HTML::Tidy perl library [\#562](https://github.com/htacg/tidy-html5/issues/562)
- \<Script\> tag gets removed [\#528](https://github.com/htacg/tidy-html5/issues/528)
- Word filtered html doesn't convert accents to utf8 [\#512](https://github.com/htacg/tidy-html5/issues/512)
- option to ignore attribute-errors if attribute contains pseudo-elements [\#505](https://github.com/htacg/tidy-html5/issues/505)
- Allow \<div\> inside \<pre\> [\#479](https://github.com/htacg/tidy-html5/issues/479)

**Merged pull requests:**

- Fixes \#743. [\#966](https://github.com/htacg/tidy-html5/pull/966) (@balthisar)
- Fixed merge conflict; fixed non-build issue on macOS. RC for testing. [\#965](https://github.com/htacg/tidy-html5/pull/965) (@balthisar)
- README.md: add Wikidata link [\#961](https://github.com/htacg/tidy-html5/pull/961) (@vitaly-zdanevich)
- Fix issues with user-specified settings changing [\#959](https://github.com/htacg/tidy-html5/pull/959) (@balthisar)
- Automated Testing [\#957](https://github.com/htacg/tidy-html5/pull/957) (@balthisar)
- simple fix for the range of the condition. [\#953](https://github.com/htacg/tidy-html5/pull/953) (@ihsinme)
- Add muted and playsinline video attributes for HTML5. [\#949](https://github.com/htacg/tidy-html5/pull/949) (@drichardson)
- Add German Language [\#943](https://github.com/htacg/tidy-html5/pull/943) (@balthisar)
- Link macOS console application with required plist [\#942](https://github.com/htacg/tidy-html5/pull/942) (@balthisar)
- Is. \#839 -  new message for 'blank' title [\#930](https://github.com/htacg/tidy-html5/pull/930) (@geoffmcl)
- Support extended color names in HTML 5 validation [\#914](https://github.com/htacg/tidy-html5/pull/914) (@cqcallaw)
- Fix percentage validation in CheckLength [\#912](https://github.com/htacg/tidy-html5/pull/912) (@cqcallaw)
- Add SVG paint attributes [\#907](https://github.com/htacg/tidy-html5/pull/907) (@cqcallaw)
- Is. \#879: add loading attribute for img, iframe [\#902](https://github.com/htacg/tidy-html5/pull/902) (@sidvishnoi)
- COMPILE\_FLAGS property only once per target, avoid overwriting. [\#886](https://github.com/htacg/tidy-html5/pull/886) (@SvenPStarFinanz)
- Complete pt\_br translation [\#881](https://github.com/htacg/tidy-html5/pull/881) (@hugotiburtino)
- Support the \<slot\> tag [\#848](https://github.com/htacg/tidy-html5/pull/848) (@lhchavez)
- Issue \#437 - re-use of 'wrap-php' option [\#645](https://github.com/htacg/tidy-html5/pull/645) (@geoffmcl)
- Change "tidyLocalMapItem" to "tidyLocaleMapItem" [\#829](https://github.com/htacg/tidy-html5/pull/829) (@MrSorcus)
- added OS \_\_ANDROID\_\_ in tidyplatform.h [\#823](https://github.com/htacg/tidy-html5/pull/823) (@naveedpash)
- Update BRANCHES.md [\#793](https://github.com/htacg/tidy-html5/pull/793) (@SConaway)
- Is. \#783 - Fix language detection [\#785](https://github.com/htacg/tidy-html5/pull/785) (@Lin-Buo-Ren)
- Is. \#781 - Drop redundant blank lines in -help [\#782](https://github.com/htacg/tidy-html5/pull/782) (@Lin-Buo-Ren)
- Issue 649 adding tag \<data\> [\#769](https://github.com/htacg/tidy-html5/pull/769) (@AntoniosHadji)
- Issue 752 [\#764](https://github.com/htacg/tidy-html5/pull/764) (@geoffmcl)
- PHP ≥ 7.1.0 recognizes tidy-html5 [\#762](https://github.com/htacg/tidy-html5/pull/762) (@cmb69)
- Fix typo [\#753](https://github.com/htacg/tidy-html5/pull/753) (@Lin-Buo-Ren)
- Fix extra const modifier [\#747](https://github.com/htacg/tidy-html5/pull/747) (@drizt)
- Is \#721 - cast away some gcc warnings [\#722](https://github.com/htacg/tidy-html5/pull/722) (@geoffmcl)
- Doc nits [\#717](https://github.com/htacg/tidy-html5/pull/717) (@ler762)
- Is \#709 - Improve message if 'implict' [\#714](https://github.com/htacg/tidy-html5/pull/714) (@geoffmcl)
- Make global attribute `dir` accept auto as well. [\#712](https://github.com/htacg/tidy-html5/pull/712) (@doronbehar)
- Is \#697 - Add NOWRAP to print of pre tag [\#708](https://github.com/htacg/tidy-html5/pull/708) (@geoffmcl)
- Is \#700 - change script parsing if in html5 mode [\#703](https://github.com/htacg/tidy-html5/pull/703) (@geoffmcl)
- Issue 698 - docs update [\#702](https://github.com/htacg/tidy-html5/pull/702) (@geoffmcl)
- Is \#686 - Add attr COLOR to W3CAttrsFor\_LINK [\#701](https://github.com/htacg/tidy-html5/pull/701) (@geoffmcl)
- Issue 679 [\#695](https://github.com/htacg/tidy-html5/pull/695) (@geoffmcl)
- Issue 663 - fixes for Haiku port [\#664](https://github.com/htacg/tidy-html5/pull/664) (@geoffmcl)

\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
