## TFSA-2022-042: Abort caused by allocating a vector that is too large

### CVE Number
CVE-2022-23580

### Impact
During shape inference, TensorFlow can [allocate a large vector](https://github.com/tensorflow/tensorflow/blob/a1320ec1eac186da1d03f033109191f715b2b130/tensorflow/core/framework/shape_inference.cc#L788-L790) based on a value from a tensor controlled by the user:

```cc
  const auto num_dims = Value(shape_dim);
  std::vector<DimensionHandle> dims;
  dims.reserve(num_dims);
```

### Patches
We have patched the issue in GitHub commit [1361fb7e29449629e1df94d44e0427ebec8c83c7](https://github.com/tensorflow/tensorflow/commit/1361fb7e29449629e1df94d44e0427ebec8c83c7).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
