# StringTemplate 4 Documentation

Please check [Frequently asked questions (FAQ)](faq/index.md) before asking questions on stackoverflow or StringTemplate-discussion list.

Notes: To add to or improve this documentation, <a href=https://help.github.com/articles/fork-a-repo>fork</a> the <a href=https://github.com/antlr/stringtemplate4>antlr/stringtemplate4 repo</a> then update this `doc/index.md` or file(s) in that directory.  Submit a <a href=https://help.github.com/articles/creating-a-pull-request>pull request</a> to get your changes incorporated into the main repository. Do not mix code and documentation updates in the same pull request. <b>You must sign the contributors.txt certificate of origin with your pull request if you've not done so before.</b></li>

## Installation

* [Java](java.md)
* [C#](https://github.com/antlr/antlrcs)
* [JavaScript--not stable](https://github.com/jsnyders/StringTemplate-js)
* Python
* [Objective-C](https://github.com/muggins/ST4-ObjC2.0-Runtime)

## Introductory material

* [Introduction](introduction.md)
* [StringTemplate cheat sheet](cheatsheet.md)
* [Motivation and philosophy](motivation.md)

## Groups

* [Group file syntax](groups.md)
* [Group inheritance](inheritance.md)
* [Template regions](regions.md)

## Templates

* [Literals](templates.md#literals)
* [Expressions](templates.md#expressions)
* [Template includes](templates.md#includes)
* [Expression options](expr-options.md)
* [Conditionals](templates.md#conditionals)
* [Anonymous templates](templates.md#subtemplates)
* [Map operations](templates.md#map)
* [Functions](templates.md#functions)
* [Lazy evaluation](templates.md#lazy)
* [Missing and null attribute evaluation](null-vs-empty.md)

## Whitespace and formatting

* [Auto-indentation](indent.md)
* [Automatic line wrapping](wrapping.md)

## Customizing StringTemplate behavior

* [Error listeners](listeners.md)
* [Renderers](renderers.md)
* [Model adaptors](adaptors.md)

## Debugging

* [StringTemplate Inspector GUI](inspector.md)

## Misc

* [Template to Bytecode mapping](bytecode.md)
* [Differences between v3 and v4](3to4.md)
* [Releasing ST4](releasing-st4.md)

## Release Notes

For just 4.0.0 - 4.0.7. Now look at [github for release notes](https://github.com/antlr/stringtemplate4/releases).

* [4.0 Release Notes](release-notes/4.0.md)
* [4.0.1 Release Notes](release-notes/4.0.1.md)
* [4.0.2 Release Notes](release-notes/4.0.2.md)
* [4.0.3 Release Notes](release-notes/4.0.3.md)
* [4.0.4 Release Notes](release-notes/4.0.4.md)
* [4.0.5 Release Notes](release-notes/4.0.5.md)
* [4.0.6 Release Notes](release-notes/4.0.6.md)
* [4.0.7 Release Notes](release-notes/4.0.7.md)
