// -----------------------------------------------------------------------------------------------------
// Copyright (c) 2006-2022, Knut Reinert & Freie Universität Berlin
// Copyright (c) 2016-2022, Knut Reinert & MPI für molekulare Genetik
// This file may be used, modified and/or redistributed under the terms of the 3-clause BSD-License
// shipped with this file and also available at: https://github.com/seqan/seqan3/blob/master/LICENSE.md
// -----------------------------------------------------------------------------------------------------

/*!\file
 * \brief Meta-header for the \link utility_container Utility / Container submodule \endlink.
 * \author Marcel Ehrhardt <marcel.ehrhardt AT fu-berlin.de>
 */

/*!\defgroup utility_container Container
 * \brief Provides various general purpose container and concepts.
 * \ingroup utility
 * \see utility
 */

#pragma once

#include <seqan3/utility/container/aligned_allocator.hpp>
#include <seqan3/utility/container/concept.hpp>
#include <seqan3/utility/container/dynamic_bitset.hpp>
#include <seqan3/utility/container/small_string.hpp>
#include <seqan3/utility/container/small_vector.hpp>
