/* The following code was generated by JFlex 1.7.0 */

package org.jruby.lexer;

import org.jruby.parser.JavaSignatureParser;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.7.0
 * from the specification file <tt>core/src/main/java/org/jruby/lexer/JavaSignatureLexer.flex</tt>
 */
public class JavaSignatureLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int CHARACTER = 2;
  public static final int STRING = 4;
  public static final int NUMBER = 6;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3, 3
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\5\1\3\1\2\1\0\1\3\1\1\16\5\4\0\1\3\1\0"+
    "\1\60\1\0\1\4\1\0\1\42\1\61\1\50\1\51\2\0\1\43"+
    "\1\14\1\15\1\0\1\11\11\6\2\0\1\55\1\45\1\56\1\54"+
    "\1\41\6\10\24\4\1\52\1\62\1\53\1\0\1\13\1\0\1\22"+
    "\1\16\1\33\1\7\1\21\1\34\1\32\1\27\1\31\2\4\1\20"+
    "\1\4\1\23\1\17\1\37\1\4\1\30\1\26\1\25\1\35\1\36"+
    "\1\57\1\12\1\24\1\40\1\46\1\0\1\47\1\0\41\5\2\0"+
    "\4\4\4\0\1\4\2\0\1\5\7\0\1\4\4\0\1\4\5\0"+
    "\27\4\1\0\37\4\1\0\u01ca\4\4\0\14\4\16\0\5\4\7\0"+
    "\1\4\1\0\1\4\21\0\160\5\5\4\1\0\2\4\2\0\4\4"+
    "\10\0\1\4\1\0\3\4\1\0\1\4\1\0\24\4\1\0\123\4"+
    "\1\0\213\4\1\0\5\5\2\0\236\4\11\0\46\4\2\0\1\4"+
    "\7\0\47\4\7\0\1\4\1\0\55\5\1\0\1\5\1\0\2\5"+
    "\1\0\2\5\1\0\1\5\10\0\33\4\5\0\3\4\15\0\5\5"+
    "\6\0\1\4\4\0\13\5\5\0\53\4\37\5\4\0\2\4\1\5"+
    "\143\4\1\0\1\4\10\5\1\0\6\5\2\4\2\5\1\0\4\5"+
    "\2\4\12\5\3\4\2\0\1\4\17\0\1\5\1\4\1\5\36\4"+
    "\33\5\2\0\131\4\13\5\1\4\16\0\12\5\41\4\11\5\2\4"+
    "\4\0\1\4\5\0\26\4\4\5\1\4\11\5\1\4\3\5\1\4"+
    "\5\5\22\0\31\4\3\5\104\0\1\4\1\0\13\4\67\0\33\5"+
    "\1\0\4\5\66\4\3\5\1\4\22\5\1\4\7\5\12\4\2\5"+
    "\2\0\12\5\1\0\7\4\1\0\7\4\1\0\3\5\1\0\10\4"+
    "\2\0\2\4\2\0\26\4\1\0\7\4\1\0\1\4\3\0\4\4"+
    "\2\0\1\5\1\4\7\5\2\0\2\5\2\0\3\5\1\4\10\0"+
    "\1\5\4\0\2\4\1\0\3\4\2\5\2\0\12\5\4\4\7\0"+
    "\1\4\5\0\3\5\1\0\6\4\4\0\2\4\2\0\26\4\1\0"+
    "\7\4\1\0\2\4\1\0\2\4\1\0\2\4\2\0\1\5\1\0"+
    "\5\5\4\0\2\5\2\0\3\5\3\0\1\5\7\0\4\4\1\0"+
    "\1\4\7\0\14\5\3\4\1\5\13\0\3\5\1\0\11\4\1\0"+
    "\3\4\1\0\26\4\1\0\7\4\1\0\2\4\1\0\5\4\2\0"+
    "\1\5\1\4\10\5\1\0\3\5\1\0\3\5\2\0\1\4\17\0"+
    "\2\4\2\5\2\0\12\5\1\0\1\4\17\0\3\5\1\0\10\4"+
    "\2\0\2\4\2\0\26\4\1\0\7\4\1\0\2\4\1\0\5\4"+
    "\2\0\1\5\1\4\7\5\2\0\2\5\2\0\3\5\10\0\2\5"+
    "\4\0\2\4\1\0\3\4\2\5\2\0\12\5\1\0\1\4\20\0"+
    "\1\5\1\4\1\0\6\4\3\0\3\4\1\0\4\4\3\0\2\4"+
    "\1\0\1\4\1\0\2\4\3\0\2\4\3\0\3\4\3\0\14\4"+
    "\4\0\5\5\3\0\3\5\1\0\4\5\2\0\1\4\6\0\1\5"+
    "\16\0\12\5\11\0\1\4\7\0\3\5\1\0\10\4\1\0\3\4"+
    "\1\0\27\4\1\0\12\4\1\0\5\4\3\0\1\4\7\5\1\0"+
    "\3\5\1\0\4\5\7\0\2\5\1\0\2\4\6\0\2\4\2\5"+
    "\2\0\12\5\22\0\2\5\1\0\10\4\1\0\3\4\1\0\27\4"+
    "\1\0\12\4\1\0\5\4\2\0\1\5\1\4\7\5\1\0\3\5"+
    "\1\0\4\5\7\0\2\5\7\0\1\4\1\0\2\4\2\5\2\0"+
    "\12\5\1\0\2\4\17\0\2\5\1\0\10\4\1\0\3\4\1\0"+
    "\51\4\2\0\1\4\7\5\1\0\3\5\1\0\4\5\1\4\10\0"+
    "\1\5\10\0\2\4\2\5\2\0\12\5\12\0\6\4\2\0\2\5"+
    "\1\0\22\4\3\0\30\4\1\0\11\4\1\0\1\4\2\0\7\4"+
    "\3\0\1\5\4\0\6\5\1\0\1\5\1\0\10\5\22\0\2\5"+
    "\15\0\60\4\1\5\2\4\7\5\4\0\10\4\10\5\1\0\12\5"+
    "\47\0\2\4\1\0\1\4\2\0\2\4\1\0\1\4\2\0\1\4"+
    "\6\0\4\4\1\0\7\4\1\0\3\4\1\0\1\4\1\0\1\4"+
    "\2\0\2\4\1\0\4\4\1\5\2\4\6\5\1\0\2\5\1\4"+
    "\2\0\5\4\1\0\1\4\1\0\6\5\2\0\12\5\2\0\4\4"+
    "\40\0\1\4\27\0\2\5\6\0\12\5\13\0\1\5\1\0\1\5"+
    "\1\0\1\5\4\0\2\5\10\4\1\0\44\4\4\0\24\5\1\0"+
    "\2\5\5\4\13\5\1\0\44\5\11\0\1\5\71\0\53\4\24\5"+
    "\1\4\12\5\6\0\6\4\4\5\4\4\3\5\1\4\3\5\2\4"+
    "\7\5\3\4\4\5\15\4\14\5\1\4\17\5\2\0\46\4\1\0"+
    "\1\4\5\0\1\4\2\0\53\4\1\0\u014d\4\1\0\4\4\2\0"+
    "\7\4\1\0\1\4\1\0\4\4\2\0\51\4\1\0\4\4\2\0"+
    "\41\4\1\0\4\4\2\0\7\4\1\0\1\4\1\0\4\4\2\0"+
    "\17\4\1\0\71\4\1\0\4\4\2\0\103\4\2\0\3\5\40\0"+
    "\20\4\20\0\125\4\14\0\u026c\4\2\0\21\4\1\0\32\4\5\0"+
    "\113\4\3\0\3\4\17\0\15\4\1\0\4\4\3\5\13\0\22\4"+
    "\3\5\13\0\22\4\2\5\14\0\15\4\1\0\3\4\1\0\2\5"+
    "\14\0\64\4\40\5\3\0\1\4\3\0\2\4\1\5\2\0\12\5"+
    "\41\0\3\5\2\0\12\5\6\0\130\4\10\0\51\4\1\5\1\4"+
    "\5\0\106\4\12\0\35\4\3\0\14\5\4\0\14\5\12\0\12\5"+
    "\36\4\2\0\5\4\13\0\54\4\4\0\21\5\7\4\2\5\6\0"+
    "\12\5\46\0\27\4\5\5\4\0\65\4\12\5\1\0\35\5\2\0"+
    "\13\5\6\0\12\5\15\0\1\4\130\0\5\5\57\4\21\5\7\4"+
    "\4\0\12\5\21\0\11\5\14\0\3\5\36\4\15\5\2\4\12\5"+
    "\54\4\16\5\14\0\44\4\24\5\10\0\12\5\3\0\3\4\12\5"+
    "\44\4\122\0\3\5\1\0\25\5\4\4\1\5\4\4\3\5\2\4"+
    "\11\0\300\4\47\5\25\0\4\5\u0116\4\2\0\6\4\2\0\46\4"+
    "\2\0\6\4\2\0\10\4\1\0\1\4\1\0\1\4\1\0\1\4"+
    "\1\0\37\4\2\0\65\4\1\0\7\4\1\0\1\4\3\0\3\4"+
    "\1\0\7\4\3\0\4\4\2\0\6\4\4\0\15\4\5\0\3\4"+
    "\1\0\7\4\16\0\5\5\26\0\1\44\3\0\5\5\20\0\2\4"+
    "\23\0\1\4\13\0\5\5\5\0\6\5\1\0\1\4\15\0\1\4"+
    "\20\0\15\4\3\0\33\4\25\0\15\5\4\0\1\5\3\0\14\5"+
    "\21\0\1\4\4\0\1\4\2\0\12\4\1\0\1\4\3\0\5\4"+
    "\6\0\1\4\1\0\1\4\1\0\1\4\1\0\4\4\1\0\13\4"+
    "\2\0\4\4\5\0\5\4\4\0\1\4\21\0\51\4\u0a77\0\57\4"+
    "\1\0\57\4\1\0\205\4\6\0\4\4\3\5\2\4\14\0\46\4"+
    "\1\0\1\4\5\0\1\4\2\0\70\4\7\0\1\4\17\0\1\5"+
    "\27\4\11\0\7\4\1\0\7\4\1\0\7\4\1\0\7\4\1\0"+
    "\7\4\1\0\7\4\1\0\7\4\1\0\7\4\1\0\40\5\57\0"+
    "\1\4\u01d5\0\3\4\31\0\11\4\6\5\1\0\5\4\2\0\5\4"+
    "\4\0\126\4\2\0\2\5\2\0\3\4\1\0\132\4\1\0\4\4"+
    "\5\0\51\4\3\0\136\4\21\0\33\4\65\0\20\4\u0200\0\u19b6\4"+
    "\112\0\u51cd\4\63\0\u048d\4\103\0\56\4\2\0\u010d\4\3\0\20\4"+
    "\12\5\2\4\24\0\57\4\1\5\4\0\12\5\1\0\31\4\7\0"+
    "\1\5\120\4\2\5\45\0\11\4\2\0\147\4\2\0\4\4\1\0"+
    "\4\4\14\0\13\4\115\0\12\4\1\5\3\4\1\5\4\4\1\5"+
    "\27\4\5\5\20\0\1\4\7\0\64\4\14\0\2\5\62\4\21\5"+
    "\13\0\12\5\6\0\22\5\6\4\3\0\1\4\4\0\12\5\34\4"+
    "\10\5\2\0\27\4\15\5\14\0\35\4\3\0\4\5\57\4\16\5"+
    "\16\0\1\4\12\5\46\0\51\4\16\5\11\0\3\4\1\5\10\4"+
    "\2\5\2\0\12\5\6\0\27\4\3\0\1\4\1\5\4\0\60\4"+
    "\1\5\1\4\3\5\2\4\2\5\5\4\2\5\1\4\1\5\1\4"+
    "\30\0\3\4\2\0\13\4\5\5\2\0\3\4\2\5\12\0\6\4"+
    "\2\0\6\4\2\0\6\4\11\0\7\4\1\0\7\4\221\0\43\4"+
    "\10\5\1\0\2\5\2\0\12\5\6\0\u2ba4\4\14\0\27\4\4\0"+
    "\61\4\u2104\0\u016e\4\2\0\152\4\46\0\7\4\14\0\5\4\5\0"+
    "\1\4\1\5\12\4\1\0\15\4\1\0\5\4\1\0\1\4\1\0"+
    "\2\4\1\0\2\4\1\0\154\4\41\0\u016b\4\22\0\100\4\2\0"+
    "\66\4\50\0\15\4\3\0\20\5\20\0\7\5\14\0\2\4\30\0"+
    "\3\4\31\0\1\4\6\0\5\4\1\0\207\4\2\0\1\5\4\0"+
    "\1\4\13\0\12\5\7\0\32\4\4\0\1\4\1\0\32\4\13\0"+
    "\131\4\3\0\6\4\2\0\6\4\2\0\6\4\2\0\3\4\3\0"+
    "\2\4\3\0\2\4\22\0\3\5\4\0\14\4\1\0\32\4\1\0"+
    "\23\4\1\0\2\4\1\0\17\4\2\0\16\4\42\0\173\4\105\0"+
    "\65\4\210\0\1\5\202\0\35\4\3\0\61\4\57\0\37\4\21\0"+
    "\33\4\65\0\36\4\2\0\44\4\4\0\10\4\1\0\5\4\52\0"+
    "\236\4\2\0\12\5\u0356\0\6\4\2\0\1\4\1\0\54\4\1\0"+
    "\2\4\3\0\1\4\2\0\27\4\252\0\26\4\12\0\32\4\106\0"+
    "\70\4\6\0\2\4\100\0\1\4\3\5\1\0\2\5\5\0\4\5"+
    "\4\4\1\0\3\4\1\0\33\4\4\0\3\5\4\0\1\5\40\0"+
    "\35\4\203\0\66\4\12\0\26\4\12\0\23\4\215\0\111\4\u03b7\0"+
    "\3\5\65\4\17\5\37\0\12\5\20\0\3\5\55\4\13\5\2\0"+
    "\1\5\22\0\31\4\7\0\12\5\6\0\3\5\44\4\16\5\1\0"+
    "\12\5\100\0\3\5\60\4\16\5\4\4\13\0\12\5\u04a6\0\53\4"+
    "\15\5\10\0\12\5\u0936\0\u036f\4\221\0\143\4\u0b9d\0\u042f\4\u33d1\0"+
    "\u0239\4\u04c7\0\105\4\13\0\1\4\56\5\20\0\4\5\15\4\u4060\0"+
    "\2\4\u2163\0\5\5\3\0\26\5\2\0\7\5\36\0\4\5\224\0"+
    "\3\5\u01bb\0\125\4\1\0\107\4\1\0\2\4\2\0\1\4\2\0"+
    "\2\4\2\0\4\4\1\0\14\4\1\0\1\4\1\0\7\4\1\0"+
    "\101\4\1\0\4\4\2\0\10\4\1\0\7\4\1\0\34\4\1\0"+
    "\4\4\1\0\5\4\1\0\1\4\3\0\7\4\1\0\u0154\4\2\0"+
    "\31\4\1\0\31\4\1\0\37\4\1\0\31\4\1\0\37\4\1\0"+
    "\31\4\1\0\37\4\1\0\31\4\1\0\37\4\1\0\31\4\1\0"+
    "\10\4\2\0\62\5\u1600\0\4\4\1\0\33\4\1\0\2\4\1\0"+
    "\1\4\2\0\1\4\1\0\12\4\1\0\4\4\1\0\1\4\1\0"+
    "\1\4\6\0\1\4\4\0\1\4\1\0\1\4\1\0\1\4\1\0"+
    "\3\4\1\0\2\4\1\0\1\4\2\0\1\4\1\0\1\4\1\0"+
    "\1\4\1\0\1\4\1\0\1\4\1\0\2\4\1\0\1\4\2\0"+
    "\4\4\1\0\7\4\1\0\4\4\1\0\4\4\1\0\1\4\1\0"+
    "\12\4\1\0\21\4\5\0\3\4\1\0\5\4\1\0\21\4\u1144\0"+
    "\ua6d7\4\51\0\u1035\4\13\0\336\4\u3fe2\0\u021e\4\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\u05ee\0"+
    "\1\5\36\0\140\5\200\0\360\5\uffff\0\uffff\0\ufe12\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\4\0\1\1\2\2\1\3\1\4\1\3\1\4\1\1"+
    "\1\5\14\3\1\6\1\7\1\10\1\11\1\12\1\13"+
    "\1\14\1\15\1\16\1\17\1\20\1\21\1\22\1\23"+
    "\1\24\1\25\1\26\1\27\1\30\1\26\1\31\2\0"+
    "\1\3\2\0\24\3\1\32\1\33\1\34\1\35\1\36"+
    "\1\37\1\40\1\41\1\4\1\3\1\42\16\3\1\43"+
    "\11\3\1\44\2\3\1\45\1\46\5\3\1\47\5\3"+
    "\1\50\4\3\1\51\15\3\1\52\1\53\1\54\1\55"+
    "\1\56\4\3\1\57\3\3\1\60\1\61\2\3\1\62"+
    "\4\3\1\63\1\64\1\65\6\3\1\66\1\67\2\3"+
    "\1\70\1\71\1\3\1\72\1\3\1\73\2\3\1\74";

  private static int [] zzUnpackAction() {
    int [] result = new int[185];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\63\0\146\0\231\0\314\0\377\0\314\0\u0132"+
    "\0\u0165\0\u0198\0\u01cb\0\u01fe\0\u0231\0\u0264\0\u0297\0\u02ca"+
    "\0\u02fd\0\u0330\0\u0363\0\u0396\0\u03c9\0\u03fc\0\u042f\0\u0462"+
    "\0\u0495\0\314\0\314\0\314\0\314\0\314\0\314\0\314"+
    "\0\314\0\314\0\314\0\314\0\314\0\314\0\u04c8\0\314"+
    "\0\314\0\u04fb\0\314\0\u052e\0\u0561\0\314\0\u01fe\0\u0594"+
    "\0\u05c7\0\u05fa\0\u062d\0\u0660\0\u0693\0\u06c6\0\u06f9\0\u072c"+
    "\0\u075f\0\u0792\0\u07c5\0\u07f8\0\u082b\0\u085e\0\u0891\0\u08c4"+
    "\0\u08f7\0\u092a\0\u095d\0\u0990\0\u09c3\0\u09f6\0\u0a29\0\u0a5c"+
    "\0\314\0\314\0\314\0\314\0\314\0\314\0\314\0\u0a8f"+
    "\0\u0ac2\0\u0af5\0\u0b28\0\u0b5b\0\u0b8e\0\u0bc1\0\u0bf4\0\u0c27"+
    "\0\u0c5a\0\u0c8d\0\u0cc0\0\u0cf3\0\u0d26\0\u0d59\0\u0d8c\0\u0dbf"+
    "\0\u0132\0\u0df2\0\u0e25\0\u0e58\0\u0e8b\0\u0ebe\0\u0ef1\0\u0f24"+
    "\0\u0f57\0\u0f8a\0\314\0\u0fbd\0\u0ff0\0\u0132\0\u0132\0\u1023"+
    "\0\u1056\0\u1089\0\u10bc\0\u10ef\0\u0132\0\u1122\0\u1155\0\u1188"+
    "\0\u11bb\0\u11ee\0\u0132\0\u1221\0\u1254\0\u1287\0\u12ba\0\u0132"+
    "\0\u12ed\0\u1320\0\u1353\0\u1386\0\u13b9\0\u13ec\0\u141f\0\u1452"+
    "\0\u1485\0\u14b8\0\u14eb\0\u151e\0\u1551\0\u0132\0\u0132\0\u0132"+
    "\0\u0132\0\u0132\0\u1584\0\u15b7\0\u15ea\0\u161d\0\u0132\0\u1650"+
    "\0\u1683\0\u16b6\0\u0132\0\u0132\0\u16e9\0\u171c\0\u0132\0\u174f"+
    "\0\u1782\0\u17b5\0\u17e8\0\u0132\0\u0132\0\u0132\0\u181b\0\u184e"+
    "\0\u1881\0\u18b4\0\u18e7\0\u191a\0\u0132\0\u0132\0\u194d\0\u1980"+
    "\0\u0132\0\u0132\0\u19b3\0\u0132\0\u19e6\0\u0132\0\u1a19\0\u1a4c"+
    "\0\u0132";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[185];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\5\1\6\2\7\1\10\1\5\1\11\1\12\1\10"+
    "\1\13\2\10\1\14\1\15\1\16\1\10\1\17\1\20"+
    "\1\21\1\22\1\10\1\23\1\24\2\10\1\25\1\10"+
    "\1\26\1\27\1\10\1\30\1\31\1\10\1\32\1\33"+
    "\1\34\1\35\1\36\1\37\1\40\1\41\1\42\1\43"+
    "\1\44\1\45\1\46\1\47\1\10\1\50\1\51\1\5"+
    "\1\52\2\5\56\52\1\53\1\54\1\55\2\5\55\55"+
    "\1\56\1\55\1\54\63\5\65\0\1\7\64\0\10\10"+
    "\2\0\23\10\16\0\1\10\11\0\1\11\2\0\1\11"+
    "\1\0\1\57\1\0\1\60\51\0\10\10\2\0\1\10"+
    "\1\61\21\10\16\0\1\10\11\0\1\11\2\0\1\11"+
    "\1\62\1\57\1\0\1\60\53\0\1\11\2\0\1\11"+
    "\66\0\1\63\51\0\10\10\2\0\1\10\1\64\4\10"+
    "\1\65\14\10\16\0\1\10\7\0\10\10\2\0\1\10"+
    "\1\66\21\10\16\0\1\10\7\0\6\10\1\67\1\10"+
    "\2\0\23\10\16\0\1\10\7\0\10\10\2\0\1\70"+
    "\22\10\16\0\1\10\7\0\10\10\2\0\4\10\1\71"+
    "\16\10\16\0\1\10\7\0\10\10\2\0\11\10\1\72"+
    "\1\73\10\10\16\0\1\10\7\0\10\10\2\0\6\10"+
    "\1\74\1\75\1\10\1\76\5\10\1\77\3\10\16\0"+
    "\1\10\7\0\10\10\2\0\5\10\1\100\15\10\16\0"+
    "\1\10\7\0\10\10\2\0\11\10\1\101\11\10\16\0"+
    "\1\10\7\0\10\10\2\0\2\10\1\102\1\10\1\103"+
    "\6\10\1\104\7\10\16\0\1\10\7\0\10\10\2\0"+
    "\1\10\1\105\21\10\16\0\1\10\7\0\10\10\2\0"+
    "\12\10\1\106\4\10\1\107\3\10\16\0\1\10\61\0"+
    "\1\110\4\0\1\52\2\0\56\52\20\0\1\111\4\0"+
    "\1\112\1\0\1\113\2\0\1\114\3\0\1\115\23\0"+
    "\1\116\1\117\1\0\1\55\2\0\55\55\1\0\1\55"+
    "\7\0\1\120\2\0\1\120\55\0\10\10\2\0\17\10"+
    "\1\121\3\10\16\0\1\10\11\0\4\122\4\0\1\122"+
    "\2\0\2\122\10\0\2\122\43\0\1\35\51\0\10\10"+
    "\2\0\1\10\1\123\21\10\16\0\1\10\7\0\10\10"+
    "\2\0\7\10\1\124\13\10\16\0\1\10\7\0\10\10"+
    "\2\0\5\10\1\125\15\10\16\0\1\10\7\0\10\10"+
    "\2\0\7\10\1\126\13\10\16\0\1\10\7\0\10\10"+
    "\2\0\10\10\1\127\12\10\16\0\1\10\7\0\10\10"+
    "\2\0\7\10\1\130\13\10\16\0\1\10\7\0\10\10"+
    "\2\0\12\10\1\131\10\10\16\0\1\10\7\0\10\10"+
    "\2\0\4\10\1\132\12\10\1\133\3\10\16\0\1\10"+
    "\7\0\10\10\2\0\5\10\1\134\15\10\16\0\1\10"+
    "\7\0\10\10\2\0\4\10\1\135\5\10\1\136\10\10"+
    "\16\0\1\10\7\0\10\10\2\0\1\10\1\137\21\10"+
    "\16\0\1\10\7\0\10\10\2\0\21\10\1\140\1\10"+
    "\16\0\1\10\7\0\10\10\2\0\7\10\1\141\13\10"+
    "\16\0\1\10\7\0\10\10\2\0\4\10\1\142\16\10"+
    "\16\0\1\10\7\0\10\10\2\0\1\10\1\143\21\10"+
    "\16\0\1\10\7\0\10\10\2\0\2\10\1\144\20\10"+
    "\16\0\1\10\7\0\10\10\2\0\5\10\1\145\15\10"+
    "\16\0\1\10\7\0\10\10\2\0\2\10\1\146\10\10"+
    "\1\147\7\10\16\0\1\10\7\0\10\10\2\0\1\10"+
    "\1\150\11\10\1\151\7\10\16\0\1\10\7\0\10\10"+
    "\2\0\1\152\22\10\16\0\1\10\61\0\1\153\12\0"+
    "\1\120\2\0\1\120\1\0\1\60\53\0\10\10\2\0"+
    "\1\154\22\10\16\0\1\10\11\0\4\122\1\0\1\62"+
    "\2\0\1\122\2\0\2\122\10\0\2\122\32\0\10\10"+
    "\2\0\2\10\1\155\20\10\16\0\1\10\7\0\10\10"+
    "\2\0\3\10\1\156\17\10\16\0\1\10\7\0\10\10"+
    "\2\0\14\10\1\157\6\10\16\0\1\10\7\0\10\10"+
    "\2\0\3\10\1\160\17\10\16\0\1\10\7\0\10\10"+
    "\2\0\7\10\1\161\13\10\16\0\1\10\7\0\10\10"+
    "\2\0\13\10\1\162\7\10\16\0\1\10\7\0\10\10"+
    "\2\0\1\10\1\163\21\10\16\0\1\10\7\0\10\10"+
    "\2\0\5\10\1\164\15\10\16\0\1\10\7\0\10\10"+
    "\2\0\3\10\1\165\17\10\16\0\1\10\7\0\10\10"+
    "\2\0\15\10\1\166\5\10\16\0\1\10\7\0\10\10"+
    "\2\0\7\10\1\167\13\10\16\0\1\10\7\0\10\10"+
    "\2\0\13\10\1\170\7\10\16\0\1\10\7\0\10\10"+
    "\2\0\12\10\1\171\10\10\16\0\1\10\7\0\10\10"+
    "\2\0\3\10\1\172\17\10\16\0\1\10\7\0\10\10"+
    "\2\0\12\10\1\173\10\10\16\0\1\10\7\0\10\10"+
    "\2\0\4\10\1\174\16\10\16\0\1\10\7\0\10\10"+
    "\2\0\10\10\1\175\12\10\16\0\1\10\7\0\10\10"+
    "\2\0\4\10\1\176\16\10\16\0\1\10\7\0\10\10"+
    "\2\0\4\10\1\177\16\10\16\0\1\10\7\0\3\10"+
    "\1\200\4\10\2\0\23\10\16\0\1\10\7\0\10\10"+
    "\2\0\7\10\1\201\13\10\16\0\1\10\7\0\10\10"+
    "\2\0\20\10\1\202\2\10\16\0\1\10\7\0\10\10"+
    "\2\0\2\10\1\203\20\10\16\0\1\10\7\0\10\10"+
    "\2\0\2\10\1\204\20\10\16\0\1\10\7\0\10\10"+
    "\2\0\3\10\1\205\17\10\16\0\1\10\7\0\10\10"+
    "\2\0\5\10\1\206\15\10\16\0\1\10\7\0\10\10"+
    "\2\0\12\10\1\207\10\10\16\0\1\10\7\0\10\10"+
    "\2\0\20\10\1\210\2\10\16\0\1\10\7\0\10\10"+
    "\2\0\23\10\16\0\1\211\7\0\10\10\2\0\10\10"+
    "\1\212\12\10\16\0\1\10\7\0\10\10\2\0\11\10"+
    "\1\213\11\10\16\0\1\10\7\0\10\10\2\0\13\10"+
    "\1\214\7\10\16\0\1\10\7\0\10\10\2\0\15\10"+
    "\1\215\5\10\16\0\1\10\7\0\10\10\2\0\7\10"+
    "\1\216\13\10\16\0\1\10\7\0\10\10\2\0\12\10"+
    "\1\217\10\10\16\0\1\10\7\0\10\10\2\0\7\10"+
    "\1\220\13\10\16\0\1\10\7\0\10\10\2\0\3\10"+
    "\1\221\17\10\16\0\1\10\7\0\10\10\2\0\2\10"+
    "\1\222\20\10\16\0\1\10\7\0\10\10\2\0\7\10"+
    "\1\223\13\10\16\0\1\10\7\0\10\10\2\0\3\10"+
    "\1\224\17\10\16\0\1\10\7\0\10\10\2\0\4\10"+
    "\1\225\16\10\16\0\1\10\7\0\10\10\2\0\13\10"+
    "\1\226\7\10\16\0\1\10\7\0\10\10\2\0\3\10"+
    "\1\227\17\10\16\0\1\10\7\0\10\10\2\0\4\10"+
    "\1\230\16\10\16\0\1\10\7\0\3\10\1\231\4\10"+
    "\2\0\23\10\16\0\1\10\7\0\10\10\2\0\4\10"+
    "\1\232\16\10\16\0\1\10\7\0\10\10\2\0\3\10"+
    "\1\233\17\10\16\0\1\10\7\0\10\10\2\0\10\10"+
    "\1\234\12\10\16\0\1\10\7\0\10\10\2\0\13\10"+
    "\1\235\7\10\16\0\1\10\7\0\10\10\2\0\12\10"+
    "\1\236\10\10\16\0\1\10\7\0\10\10\2\0\15\10"+
    "\1\237\5\10\16\0\1\10\7\0\10\10\2\0\7\10"+
    "\1\240\13\10\16\0\1\10\7\0\10\10\2\0\13\10"+
    "\1\241\7\10\16\0\1\10\7\0\10\10\2\0\15\10"+
    "\1\242\5\10\16\0\1\10\7\0\10\10\2\0\7\10"+
    "\1\243\13\10\16\0\1\10\7\0\10\10\2\0\15\10"+
    "\1\244\5\10\16\0\1\10\7\0\10\10\2\0\5\10"+
    "\1\245\15\10\16\0\1\10\7\0\10\10\2\0\10\10"+
    "\1\246\12\10\16\0\1\10\7\0\10\10\2\0\15\10"+
    "\1\247\5\10\16\0\1\10\7\0\10\10\2\0\3\10"+
    "\1\250\17\10\16\0\1\10\7\0\10\10\2\0\1\10"+
    "\1\251\21\10\16\0\1\10\7\0\10\10\2\0\16\10"+
    "\1\252\4\10\16\0\1\10\7\0\10\10\2\0\2\10"+
    "\1\253\20\10\16\0\1\10\7\0\10\10\2\0\7\10"+
    "\1\254\13\10\16\0\1\10\7\0\10\10\2\0\3\10"+
    "\1\255\17\10\16\0\1\10\7\0\10\10\2\0\7\10"+
    "\1\256\13\10\16\0\1\10\7\0\10\10\2\0\5\10"+
    "\1\257\15\10\16\0\1\10\7\0\10\10\2\0\5\10"+
    "\1\260\15\10\16\0\1\10\7\0\10\10\2\0\21\10"+
    "\1\261\1\10\16\0\1\10\7\0\10\10\2\0\3\10"+
    "\1\262\17\10\16\0\1\10\7\0\10\10\2\0\3\10"+
    "\1\263\17\10\16\0\1\10\7\0\10\10\2\0\7\10"+
    "\1\264\13\10\16\0\1\10\7\0\10\10\2\0\13\10"+
    "\1\265\7\10\16\0\1\10\7\0\3\10\1\266\4\10"+
    "\2\0\23\10\16\0\1\10\7\0\10\10\2\0\22\10"+
    "\1\267\16\0\1\10\7\0\10\10\2\0\3\10\1\270"+
    "\17\10\16\0\1\10\7\0\3\10\1\271\4\10\2\0"+
    "\23\10\16\0\1\10\3\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[6783];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\4\0\1\11\1\1\1\11\22\1\15\11\1\1\2\11"+
    "\1\1\1\11\2\1\1\11\2\0\1\1\2\0\25\1"+
    "\7\11\33\1\1\11\116\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[185];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true iff the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true iff the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
  boolean stringResult = false;
  boolean characterResult = false;
  StringBuilder stringBuf = new StringBuilder();

  public Object value() {
    if (stringResult) {
        stringResult = false;
        String value = stringBuf.toString();
        stringBuf.setLength(0);
        return value;
    } else if (characterResult) {
        characterResult = false;
        String value = stringBuf.toString();
        if (stringBuf.length() != 1) throw new Error("Character not on char ("+ value +")");
        stringBuf.setLength(0);
        return value;
    }
    return yytext();
  }

  public static JavaSignatureLexer create(java.io.InputStream stream) {
    return new JavaSignatureLexer(new java.io.InputStreamReader(stream));
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public JavaSignatureLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2854) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters. See JFlex examples for workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn += zzCharCount;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return YYEOF;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { throw new Error("Invalid character ("+yytext()+")");
            } 
            // fall through
          case 61: break;
          case 2: 
            { 
            } 
            // fall through
          case 62: break;
          case 3: 
            { return JavaSignatureParser.IDENTIFIER;
            } 
            // fall through
          case 63: break;
          case 4: 
            { return JavaSignatureParser.NUM_LITERAL;
            } 
            // fall through
          case 64: break;
          case 5: 
            { return JavaSignatureParser.DOT;
            } 
            // fall through
          case 65: break;
          case 6: 
            { return JavaSignatureParser.AT;
            } 
            // fall through
          case 66: break;
          case 7: 
            { return JavaSignatureParser.AND;
            } 
            // fall through
          case 67: break;
          case 8: 
            { return JavaSignatureParser.COMMA;
            } 
            // fall through
          case 68: break;
          case 9: 
            { return JavaSignatureParser.ELLIPSIS;
            } 
            // fall through
          case 69: break;
          case 10: 
            { return JavaSignatureParser.EQUAL;
            } 
            // fall through
          case 70: break;
          case 11: 
            { return JavaSignatureParser.LCURLY;
            } 
            // fall through
          case 71: break;
          case 12: 
            { return JavaSignatureParser.RCURLY;
            } 
            // fall through
          case 72: break;
          case 13: 
            { return JavaSignatureParser.LPAREN;
            } 
            // fall through
          case 73: break;
          case 14: 
            { return JavaSignatureParser.RPAREN;
            } 
            // fall through
          case 74: break;
          case 15: 
            { return JavaSignatureParser.LBRACK;
            } 
            // fall through
          case 75: break;
          case 16: 
            { return JavaSignatureParser.RBRACK;
            } 
            // fall through
          case 76: break;
          case 17: 
            { return JavaSignatureParser.QUESTION;
            } 
            // fall through
          case 77: break;
          case 18: 
            { return JavaSignatureParser.LT;
            } 
            // fall through
          case 78: break;
          case 19: 
            { return JavaSignatureParser.GT;
            } 
            // fall through
          case 79: break;
          case 20: 
            { yybegin(STRING);
            } 
            // fall through
          case 80: break;
          case 21: 
            { yybegin(CHARACTER);
            } 
            // fall through
          case 81: break;
          case 22: 
            { stringBuf.append( yytext() );
            } 
            // fall through
          case 82: break;
          case 23: 
            { characterResult = true;
         yybegin(YYINITIAL);
         return JavaSignatureParser.CHARACTER_LITERAL;
            } 
            // fall through
          case 83: break;
          case 24: 
            { stringBuf.append('\\');
            } 
            // fall through
          case 84: break;
          case 25: 
            { stringResult = true;
                     yybegin(YYINITIAL); 
                     return JavaSignatureParser.STRING_LITERAL;
            } 
            // fall through
          case 85: break;
          case 26: 
            { return JavaSignatureParser.RSHIFT;
            } 
            // fall through
          case 86: break;
          case 27: 
            { stringBuf.append('\b');
            } 
            // fall through
          case 87: break;
          case 28: 
            { stringBuf.append('\n');
            } 
            // fall through
          case 88: break;
          case 29: 
            { stringBuf.append('\t');
            } 
            // fall through
          case 89: break;
          case 30: 
            { stringBuf.append('\r');
            } 
            // fall through
          case 90: break;
          case 31: 
            { stringBuf.append('\f');
            } 
            // fall through
          case 91: break;
          case 32: 
            { stringBuf.append('\"');
            } 
            // fall through
          case 92: break;
          case 33: 
            { stringBuf.append('\'');
            } 
            // fall through
          case 93: break;
          case 34: 
            { return JavaSignatureParser.HEXNUM_LITERAL;
            } 
            // fall through
          case 94: break;
          case 35: 
            { return JavaSignatureParser.INT;
            } 
            // fall through
          case 95: break;
          case 36: 
            { return JavaSignatureParser.URSHIFT;
            } 
            // fall through
          case 96: break;
          case 37: 
            { return JavaSignatureParser.BYTE;
            } 
            // fall through
          case 97: break;
          case 38: 
            { return JavaSignatureParser.LONG;
            } 
            // fall through
          case 98: break;
          case 39: 
            { return JavaSignatureParser.TRUE_LITERAL;
            } 
            // fall through
          case 99: break;
          case 40: 
            { return JavaSignatureParser.CHAR;
            } 
            // fall through
          case 100: break;
          case 41: 
            { return JavaSignatureParser.VOID;
            } 
            // fall through
          case 101: break;
          case 42: 
            { return JavaSignatureParser.SHORT;
            } 
            // fall through
          case 102: break;
          case 43: 
            { return JavaSignatureParser.SUPER;
            } 
            // fall through
          case 103: break;
          case 44: 
            { return JavaSignatureParser.FLOAT;
            } 
            // fall through
          case 104: break;
          case 45: 
            { return JavaSignatureParser.FALSE_LITERAL;
            } 
            // fall through
          case 105: break;
          case 46: 
            { return JavaSignatureParser.FINAL;
            } 
            // fall through
          case 106: break;
          case 47: 
            { return JavaSignatureParser.DOUBLE;
            } 
            // fall through
          case 107: break;
          case 48: 
            { return JavaSignatureParser.NATIVE;
            } 
            // fall through
          case 108: break;
          case 49: 
            { return JavaSignatureParser.THROWS;
            } 
            // fall through
          case 109: break;
          case 50: 
            { return JavaSignatureParser.STATIC;
            } 
            // fall through
          case 110: break;
          case 51: 
            { return JavaSignatureParser.PUBLIC;
            } 
            // fall through
          case 111: break;
          case 52: 
            { return JavaSignatureParser.BOOLEAN;
            } 
            // fall through
          case 112: break;
          case 53: 
            { return JavaSignatureParser.EXTENDS;
            } 
            // fall through
          case 113: break;
          case 54: 
            { return JavaSignatureParser.PRIVATE;
            } 
            // fall through
          case 114: break;
          case 55: 
            { return JavaSignatureParser.ABSTRACT;
            } 
            // fall through
          case 115: break;
          case 56: 
            { return JavaSignatureParser.STRICTFP;
            } 
            // fall through
          case 116: break;
          case 57: 
            { return JavaSignatureParser.VOLATILE;
            } 
            // fall through
          case 117: break;
          case 58: 
            { return JavaSignatureParser.TRANSIENT;
            } 
            // fall through
          case 118: break;
          case 59: 
            { return JavaSignatureParser.PROTECTED;
            } 
            // fall through
          case 119: break;
          case 60: 
            { return JavaSignatureParser.SYNCHRONIZED;
            } 
            // fall through
          case 120: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }

  /**
   * Runs the scanner on input files.
   *
   * This is a standalone scanner, it will print any unmatched
   * text to System.out unchanged.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String argv[]) {
    if (argv.length == 0) {
      System.out.println("Usage : java JavaSignatureLexer [ --encoding <name> ] <inputfile(s)>");
    }
    else {
      int firstFilePos = 0;
      String encodingName = "UTF-8";
      if (argv[0].equals("--encoding")) {
        firstFilePos = 2;
        encodingName = argv[1];
        try {
          java.nio.charset.Charset.forName(encodingName); // Side-effect: is encodingName valid? 
        } catch (Exception e) {
          System.out.println("Invalid encoding '" + encodingName + "'");
          return;
        }
      }
      for (int i = firstFilePos; i < argv.length; i++) {
        JavaSignatureLexer scanner = null;
        try {
          java.io.FileInputStream stream = new java.io.FileInputStream(argv[i]);
          java.io.Reader reader = new java.io.InputStreamReader(stream, encodingName);
          scanner = new JavaSignatureLexer(reader);
          while ( !scanner.zzAtEOF ) scanner.yylex();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
      }
    }
  }


}
