/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.jardiff;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.objectweb.asm.Type;
import org.osjava.jardiff.AbstractInfo;
import org.osjava.jardiff.ClassInfo;
import org.osjava.jardiff.DiffException;
import org.osjava.jardiff.DiffHandler;
import org.osjava.jardiff.FieldInfo;
import org.osjava.jardiff.MethodInfo;
import org.osjava.jardiff.Tools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMDiffHandler
implements DiffHandler {
    public static final String XML_URI = "http://www.osjava.org/jardiff/0.1";
    private final Transformer transformer;
    private final Result result;
    private final Document doc;
    private Node currentNode;

    public DOMDiffHandler() throws DiffException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            this.transformer = tf.newTransformer();
            this.result = new StreamResult(System.out);
            this.currentNode = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.doc = db.newDocument();
        }
        catch (TransformerConfigurationException tce) {
            throw new DiffException(tce);
        }
        catch (ParserConfigurationException pce) {
            throw new DiffException(pce);
        }
    }

    public DOMDiffHandler(Transformer transformer, Result result) throws DiffException {
        try {
            this.transformer = transformer;
            this.result = result;
            this.currentNode = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.doc = db.newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new DiffException(pce);
        }
    }

    public void startDiff(String oldJar, String newJar) throws DiffException {
        Element tmp = this.doc.createElementNS(XML_URI, "diff");
        tmp.setAttribute("old", oldJar);
        tmp.setAttribute("new", newJar);
        this.doc.appendChild(tmp);
        this.currentNode = tmp;
    }

    public void startRemoved() throws DiffException {
        Element tmp = this.doc.createElementNS(XML_URI, "removed");
        this.currentNode.appendChild(tmp);
        this.currentNode = tmp;
    }

    public void classRemoved(ClassInfo info) throws DiffException {
        this.writeClassInfo(info);
    }

    public void endRemoved() throws DiffException {
        this.currentNode = this.currentNode.getParentNode();
    }

    public void startAdded() throws DiffException {
        Element tmp = this.doc.createElementNS(XML_URI, "added");
        this.currentNode.appendChild(tmp);
        this.currentNode = tmp;
    }

    public void classAdded(ClassInfo info) throws DiffException {
        this.writeClassInfo(info);
    }

    public void endAdded() throws DiffException {
        this.currentNode = this.currentNode.getParentNode();
    }

    public void startChanged() throws DiffException {
        Element tmp = this.doc.createElementNS(XML_URI, "changed");
        this.currentNode.appendChild(tmp);
        this.currentNode = tmp;
    }

    public void startClassChanged(String internalName) throws DiffException {
        Element tmp = this.doc.createElementNS(XML_URI, "classchanged");
        tmp.setAttribute("name", Tools.getClassName(internalName));
        this.currentNode.appendChild(tmp);
        this.currentNode = tmp;
    }

    public void fieldRemoved(FieldInfo info) throws DiffException {
        this.writeFieldInfo(info);
    }

    public void methodRemoved(MethodInfo info) throws DiffException {
        this.writeMethodInfo(info);
    }

    public void fieldAdded(FieldInfo info) throws DiffException {
        this.writeFieldInfo(info);
    }

    public void methodAdded(MethodInfo info) throws DiffException {
        this.writeMethodInfo(info);
    }

    public void classChanged(ClassInfo oldInfo, ClassInfo newInfo) throws DiffException {
        Node currentNode = this.currentNode;
        Element tmp = this.doc.createElementNS(XML_URI, "classchange");
        Element from = this.doc.createElementNS(XML_URI, "from");
        Element to = this.doc.createElementNS(XML_URI, "to");
        tmp.appendChild(from);
        tmp.appendChild(to);
        currentNode.appendChild(tmp);
        this.currentNode = from;
        this.writeClassInfo(oldInfo);
        this.currentNode = to;
        this.writeClassInfo(newInfo);
        this.currentNode = currentNode;
    }

    public void fieldChanged(FieldInfo oldInfo, FieldInfo newInfo) throws DiffException {
        Node currentNode = this.currentNode;
        Element tmp = this.doc.createElementNS(XML_URI, "fieldchange");
        Element from = this.doc.createElementNS(XML_URI, "from");
        Element to = this.doc.createElementNS(XML_URI, "to");
        tmp.appendChild(from);
        tmp.appendChild(to);
        currentNode.appendChild(tmp);
        this.currentNode = from;
        this.writeFieldInfo(oldInfo);
        this.currentNode = to;
        this.writeFieldInfo(newInfo);
        this.currentNode = currentNode;
    }

    public void methodChanged(MethodInfo oldInfo, MethodInfo newInfo) throws DiffException {
        Node currentNode = this.currentNode;
        Element tmp = this.doc.createElementNS(XML_URI, "methodchange");
        Element from = this.doc.createElementNS(XML_URI, "from");
        Element to = this.doc.createElementNS(XML_URI, "to");
        tmp.appendChild(from);
        tmp.appendChild(to);
        currentNode.appendChild(tmp);
        this.currentNode = from;
        this.writeMethodInfo(oldInfo);
        this.currentNode = to;
        this.writeMethodInfo(newInfo);
        this.currentNode = currentNode;
    }

    public void endClassChanged() throws DiffException {
        this.currentNode = this.currentNode.getParentNode();
    }

    public void endChanged() throws DiffException {
        this.currentNode = this.currentNode.getParentNode();
    }

    public void endDiff() throws DiffException {
        DOMSource source = new DOMSource(this.doc);
        try {
            this.transformer.transform(source, this.result);
        }
        catch (TransformerException te) {
            throw new DiffException(te);
        }
    }

    protected void writeClassInfo(ClassInfo info) {
        Node currentNode = this.currentNode;
        Element tmp = this.doc.createElementNS(XML_URI, "class");
        currentNode.appendChild(tmp);
        this.currentNode = tmp;
        this.addAccessFlags(info);
        if (info.getName() != null) {
            tmp.setAttribute("name", Tools.getClassName(info.getName()));
        }
        if (info.getSignature() != null) {
            tmp.setAttribute("signature", info.getSignature());
        }
        if (info.getSupername() != null) {
            tmp.setAttribute("superclass", Tools.getClassName(info.getSupername()));
        }
        String[] interfaces = info.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Element iface = this.doc.createElementNS(XML_URI, "implements");
            tmp.appendChild(iface);
            iface.setAttribute("name", Tools.getClassName(interfaces[i]));
        }
        this.currentNode = currentNode;
    }

    protected void writeMethodInfo(MethodInfo info) {
        String[] exceptions;
        Node currentNode = this.currentNode;
        Element tmp = this.doc.createElementNS(XML_URI, "method");
        currentNode.appendChild(tmp);
        this.currentNode = tmp;
        this.addAccessFlags(info);
        if (info.getName() != null) {
            tmp.setAttribute("name", info.getName());
        }
        if (info.getSignature() != null) {
            tmp.setAttribute("signature", info.getSignature());
        }
        if (info.getDesc() != null) {
            this.addMethodNodes(info.getDesc());
        }
        if ((exceptions = info.getExceptions()) != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                Element excep = this.doc.createElementNS(XML_URI, "exception");
                excep.setAttribute("name", Tools.getClassName(exceptions[i]));
                tmp.appendChild(excep);
            }
        }
        this.currentNode = currentNode;
    }

    protected void writeFieldInfo(FieldInfo info) {
        Node currentNode = this.currentNode;
        Element tmp = this.doc.createElementNS(XML_URI, "field");
        currentNode.appendChild(tmp);
        this.currentNode = tmp;
        this.addAccessFlags(info);
        if (info.getName() != null) {
            tmp.setAttribute("name", info.getName());
        }
        if (info.getSignature() != null) {
            tmp.setAttribute("signature", info.getSignature());
        }
        if (info.getValue() != null) {
            tmp.setAttribute("value", info.getValue().toString());
        }
        if (info.getDesc() != null) {
            this.addTypeNode(info.getDesc());
        }
        this.currentNode = currentNode;
    }

    protected void addAccessFlags(AbstractInfo info) {
        Element currentNode = (Element)this.currentNode;
        currentNode.setAttribute("access", info.getAccessType());
        if (info.isAbstract()) {
            currentNode.setAttribute("abstract", "yes");
        }
        if (info.isAnnotation()) {
            currentNode.setAttribute("annotation", "yes");
        }
        if (info.isBridge()) {
            currentNode.setAttribute("bridge", "yes");
        }
        if (info.isDeprecated()) {
            currentNode.setAttribute("deprecated", "yes");
        }
        if (info.isEnum()) {
            currentNode.setAttribute("enum", "yes");
        }
        if (info.isFinal()) {
            currentNode.setAttribute("final", "yes");
        }
        if (info.isInterface()) {
            currentNode.setAttribute("interface", "yes");
        }
        if (info.isNative()) {
            currentNode.setAttribute("native", "yes");
        }
        if (info.isStatic()) {
            currentNode.setAttribute("static", "yes");
        }
        if (info.isStrict()) {
            currentNode.setAttribute("strict", "yes");
        }
        if (info.isSuper()) {
            currentNode.setAttribute("super", "yes");
        }
        if (info.isSynchronized()) {
            currentNode.setAttribute("synchronized", "yes");
        }
        if (info.isSynthetic()) {
            currentNode.setAttribute("synthetic", "yes");
        }
        if (info.isTransient()) {
            currentNode.setAttribute("transient", "yes");
        }
        if (info.isVarargs()) {
            currentNode.setAttribute("varargs", "yes");
        }
        if (info.isVolatile()) {
            currentNode.setAttribute("volatile", "yes");
        }
    }

    protected void addMethodNodes(String desc) {
        Type[] args = Type.getArgumentTypes((String)desc);
        Type ret = Type.getReturnType((String)desc);
        Node currentNode = this.currentNode;
        Element tmp = this.doc.createElementNS(XML_URI, "arguments");
        currentNode.appendChild(tmp);
        this.currentNode = tmp;
        for (int i = 0; i < args.length; ++i) {
            this.addTypeNode(args[i]);
        }
        tmp = this.doc.createElementNS(XML_URI, "return");
        currentNode.appendChild(tmp);
        this.currentNode = tmp;
        this.addTypeNode(ret);
        this.currentNode = currentNode;
    }

    protected void addTypeNode(String desc) {
        this.addTypeNode(Type.getType((String)desc));
    }

    protected void addTypeNode(Type type) {
        Element tmp = this.doc.createElementNS(XML_URI, "type");
        this.currentNode.appendChild(tmp);
        int i = type.getSort();
        if (i == 9) {
            tmp.setAttribute("array", "yes");
            tmp.setAttribute("dimensions", "" + type.getDimensions());
            type = type.getElementType();
            i = type.getSort();
        }
        switch (i) {
            case 1: {
                tmp.setAttribute("primitive", "yes");
                tmp.setAttribute("name", "boolean");
                break;
            }
            case 3: {
                tmp.setAttribute("primitive", "yes");
                tmp.setAttribute("name", "byte");
                break;
            }
            case 2: {
                tmp.setAttribute("primitive", "yes");
                tmp.setAttribute("name", "char");
                break;
            }
            case 8: {
                tmp.setAttribute("primitive", "yes");
                tmp.setAttribute("name", "double");
                break;
            }
            case 6: {
                tmp.setAttribute("primitive", "yes");
                tmp.setAttribute("name", "float");
                break;
            }
            case 5: {
                tmp.setAttribute("primitive", "yes");
                tmp.setAttribute("name", "int");
                break;
            }
            case 7: {
                tmp.setAttribute("primitive", "yes");
                tmp.setAttribute("name", "long");
                break;
            }
            case 10: {
                tmp.setAttribute("name", Tools.getClassName(type.getInternalName()));
                break;
            }
            case 4: {
                tmp.setAttribute("primitive", "yes");
                tmp.setAttribute("name", "short");
                break;
            }
            case 0: {
                tmp.setAttribute("primitive", "yes");
                tmp.setAttribute("name", "void");
            }
        }
    }
}

