/***************************************************************
 * Name:      BobDudeApp.h
 * Purpose:   Defines Application Class
 * Author:    Nils Springob (springob@nicai-systems.de)
 * Created:   2009-10-04
 * Copyright: Nils Springob (http://nibo.nicai-systems.de)
 * License:
 **************************************************************/

#ifndef BOBDUDEAPP_H
#define BOBDUDEAPP_H

#include <wx/app.h>
#include <wx/cmdline.h>
#include <wx/snglinst.h>
#include <wx/ipc.h>

#if !defined(PACKAGE_NAME)
#define PACKAGE_NAME "BobDude"
#endif

#if !defined(PACKAGE_VERSION)
#define PACKAGE_VERSION "1.5.0"
#endif

#if !defined(PACKAGE_STRING)
#define PACKAGE_STRING (PACKAGE_NAME " " PACKAGE_VERSION)
#endif

#define VERSION_STR PACKAGE_VERSION

#ifdef AVRDUDE_CONF
#include "avrdude.h"
#endif

class CConnection : public wxConnection {
    protected:
        virtual bool OnExec(const wxString& topic, const wxString& data);
        virtual bool OnDisconnect();
        virtual ~CConnection();
};


class CServer : public wxServer {
    public:
        wxConnectionBase *OnAcceptConnection(const wxString& topic);
        virtual ~CServer() {}
};


class BobDudeApp : public wxApp {
    private:
        wxSingleInstanceChecker m_one;
        CServer *m_server;
        
    public:
        virtual bool OnInit();
        virtual int OnExit();
        virtual void OnEventLoopEnter(wxEventLoopBase *loop);
        virtual void OnInitCmdLine(wxCmdLineParser& parser);
        virtual bool OnCmdLineParsed(wxCmdLineParser& parser);
        wxString conf;
        wxArrayString files;
#ifdef AVRDUDE_CONF
        Avrdude * avrdude;
#endif
        bool autoprog;
        bool autohide;
        
        virtual void MacOpenFile(const wxString &fileName);
};

static const wxCmdLineEntryDesc g_cmdLineDesc [] = {
     { wxCMD_LINE_SWITCH, "h", "help", "displays help on the command line parameters", wxCMD_LINE_VAL_NONE, wxCMD_LINE_OPTION_HELP },
     { wxCMD_LINE_OPTION, "c", "config", "configuration file", wxCMD_LINE_VAL_STRING },
     { wxCMD_LINE_SWITCH, NULL, "autoprog", "automatically start programming" },
     { wxCMD_LINE_SWITCH, NULL, "autohide", "hide window after successful programming" },
     { wxCMD_LINE_PARAM, NULL, NULL, "bob3-file", wxCMD_LINE_VAL_STRING, wxCMD_LINE_PARAM_OPTIONAL },
     { wxCMD_LINE_NONE }
};

DECLARE_APP(BobDudeApp);

#endif // BOBDUDEAPP_H
