#include "translation/common.h"
#include "translation/translation.h"

static translation_string all_strings[] = {
    {TR_NO_PATCH_TITLE, "Patch 1.0.1.0 not installed"},
    {TR_NO_PATCH_MESSAGE,
        "Your Caesar 3 installation does not have the 1.0.1.0 patch installed. "
        "You can download the patch from:\n"
        URL_PATCHES "\n"
        "Continue at your own risk."},
    {TR_MISSING_FONTS_TITLE, "Missing fonts"},
    {TR_MISSING_FONTS_MESSAGE,
        "Your Caesar 3 installation requires extra font files. "
        "You can download them for your language from:\n"
        URL_PATCHES},
    {TR_NO_EDITOR_TITLE, "Editor not installed"},
    {TR_NO_EDITOR_MESSAGE,
        "Your Caesar 3 installation does not contain the editor files. "
        "You can download them from:\n"
        URL_EDITOR},
    {TR_INVALID_LANGUAGE_TITLE, "Invalid language directory"},
    {TR_INVALID_LANGUAGE_MESSAGE,
        "The directory you selected does not contain a valid language pack. "
        "Please check the log for errors."},
    {TR_AUTO_CYCLE_TEMPLES, "Auto cycle"},
    {TR_BUTTON_OK, "OK"},
    {TR_BUTTON_CANCEL, "Cancel"},
    {TR_BUTTON_RESET_DEFAULTS, "Reset defaults"},
    {TR_BUTTON_CONFIGURE_HOTKEYS, "Hotkeys"},
    {TR_CONFIG_ARE_YOU_SURE, "Reset to defaults?"},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_CONFIGS, "You will lose all your custom configs."},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_HOTKEYS, "You will lose all your custom hotkeys."},
    {TR_CONFIG_TITLE, "Augustus configuration options"},
    {TR_CONFIG_HEADER_GENERAL, "General Settings"},
    {TR_CONFIG_HEADER_UI_CHANGES, "User Interface"},
    {TR_CONFIG_HEADER_GAMEPLAY_CHANGES, "Difficulty"},
    {TR_CONFIG_HEADER_CITY_MANAGEMENT_CHANGES, "City Management"},
    {TR_CONFIG_LANGUAGE_LABEL, "Language:"},
    {TR_CONFIG_LANGUAGE_DEFAULT, "(default)"},
    {TR_CONFIG_GAME_SPEED, "Game speed:"},
    {TR_CONFIG_VIDEO, "Video Options"},
    {TR_CONFIG_FULLSCREEN, "Fullscreen"},
    {TR_CONFIG_WINDOWED_RESOLUTION, "Windowed resolution:"},
    {TR_CONFIG_DISPLAY_SCALE, "Display scale:"},
    {TR_CONFIG_CURSOR_SCALE, "Cursor scale:"},
    {TR_CONFIG_USE_COLOR_CURSORS, "Use colored cursors"},
    {TR_CONFIG_AUDIO, "Audio Options"},
    {TR_CONFIG_VOLUME, "Volume"},
    {TR_CONFIG_ENABLE_AUDIO, "Enable audio"},
    {TR_CONFIG_MUSIC, "Enable music"},
    {TR_CONFIG_SPEECH, "Enable speech"},
    {TR_CONFIG_EFFECTS, "Enable sound effects"},
    {TR_CONFIG_CITY_SOUNDS, "Enable city sounds"},
    {TR_CONFIG_VIDEO_SOUND, "Enable video sound"},
    {TR_CONFIG_SCROLL_SPEED, "Scroll speed:"},
    {TR_CONFIG_SHOW_INTRO_VIDEO, "Play intro videos"},
    {TR_CONFIG_SIDEBAR_INFO, "Extra information in the control panel"},
    {TR_CONFIG_SMOOTH_SCROLLING, "Enable smooth scrolling"},
    {TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "Disable map scrolling on window edge"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Disable dragging with right mouse button"},
    {TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE, "Improve visual feedback when clearing land"},
    {TR_CONFIG_ALLOW_CYCLING_TEMPLES, "Allow building each temple in succession"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE, "Show range when building reservoirs, fountains and wells"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE_HOUSES, "Show range of fountains and wells when building houses"},
    {TR_CONFIG_SHOW_MARKET_RANGE, "Show range when building markets"},
    {TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "Show draggable construction size"},
    {TR_CONFIG_HIGHLIGHT_LEGIONS, "Highlight legion on cursor hover"},
    {TR_CONFIG_ROTATE_MANUALLY, "Rotate Gatehouse and Triumph Arch by hotkey"},
    {TR_CONFIG_SHOW_MILITARY_SIDEBAR, "Enable military sidebar"},
    {TR_CONFIG_UI_INVERSE_MAP_DRAG, "Inverse dragging map with right mouse button"},
    {TR_CONFIG_UI_MESSAGE_ALERTS, "Show new messages as alerts instead of popups"},
    {TR_CONFIG_UI_SHOW_GRID, "Show grid"},
    {TR_CONFIG_UI_SHOW_PARTIAL_GRID_AROUND_CONSTRUCTION, "Show partial grid around construction"},
    {TR_CONFIG_UI_ALWAYS_SHOW_ROTATION_BUTTONS, "Always show rotation buttons"},
    {TR_CONFIG_FIX_IMMIGRATION_BUG, "Fix immigration bug on very hard"},
    {TR_CONFIG_FIX_100_YEAR_GHOSTS, "Fix 100-year-old ghosts"},
    {TR_CONFIG_FIX_EDITOR_EVENTS, "Fix Emperor change and survival time in custom missions"},
    {TR_CONFIG_COMPLETE_RATING_COLUMNS, "Fix uncompleted rating columns on low targets"},
    {TR_CONFIG_GRANDFESTIVAL, "Grand festivals allow extra blessing from a god"},
    {TR_CONFIG_DIFFICULTY, "Difficulty:"},
    {TR_CONFIG_MAX_GRAND_TEMPLES, "Maximum number of grand temples per city:"},
    {TR_CONFIG_INFINITE, "Infinite"},
    {TR_CONFIG_GODS_EFFECTS, "Enable god curses/blessings"},
    {TR_CONFIG_JEALOUS_GODS, "Disable jealousness of gods"},
    {TR_CONFIG_GLOBAL_LABOUR, "Enable global labor pool"},
    {TR_CONFIG_SCHOOL_WALKERS, "Extend school walkers range"},
    {TR_CONFIG_RETIRE_AT_60, "Change citizens' retirement age from 50 to 60"},
    {TR_CONFIG_FIXED_WORKERS, "Fixed worker pool - 38% of plebeian population"},
    {TR_CONFIG_EXTRA_FORTS, "Allow building 4 extra forts"},
    {TR_CONFIG_WOLVES_BLOCK, "Block building around wolves"},
    {TR_CONFIG_DYNAMIC_GRANARIES, "Block unconnected granary roads"},
    {TR_CONFIG_MORE_STOCKPILE, "Houses stockpile more goods from market"},
    {TR_CONFIG_NO_SUPPLIER_DISTRIBUTION, "Buying market ladies don't distribute goods"},
    {TR_CONFIG_IMMEDIATELY_DELETE_BUILDINGS, "Immediately destroy buildings"},
    {TR_CONFIG_GETTING_GRANARIES_GO_OFFROAD, "Cart pushers from getting granaries can go offroad"},
    {TR_CONFIG_GRANARIES_GET_DOUBLE, "Double the capacity of cart pushers from getting granaries"},
    {TR_CONFIG_ALLOW_EXPORTING_FROM_GRANARIES, "Allow traders to export food from granaries"},
    {TR_CONFIG_TOWER_SENTRIES_GO_OFFROAD, "Tower sentries don't need road access from barracks"},
    {TR_CONFIG_FARMS_DELIVER_CLOSE, "Farms and wharves deliver only to nearby granaries"},
    {TR_CONFIG_DELIVER_ONLY_TO_ACCEPTING_GRANARIES, "Food isn't delivered to getting granaries"},
    {TR_CONFIG_ALL_HOUSES_MERGE, "All houses merge"},
    {TR_CONFIG_WINE_COUNTS_IF_OPEN_TRADE_ROUTE, "Open trade route counts as providing different wine type"},
    {TR_CONFIG_RANDOM_COLLAPSES_TAKE_MONEY, "Randomly collapsing pits and mines take some money instead"},
    {TR_CONFIG_MULTIPLE_BARRACKS, "Allow building multiple barracks" },
    {TR_CONFIG_NOT_ACCEPTING_WAREHOUSES, "Warehouses and granaries don't accept anything when built"},
    {TR_CONFIG_HOUSES_DONT_EXPAND_INTO_GARDENS, "Houses don't expand into gardens"},
    {TR_CONFIG_ROAMERS_DONT_SKIP_CORNERS, "Roaming walkers don't skip corners"},
    {TR_CONFIG_SHOW_MAX_POSSIBLE_PROSPERITY, "Display max attainable prosperity rating with current housing"},
    {TR_CONFIG_AUTO_KILL_ANIMALS, "Citizens will automatically kill harmless animals"},
    {TR_CONFIG_SHOW_ROAMING_PATH, "Preview paths travelled by roaming walkers"},
    {TR_CONFIG_DRAW_CLOUD_SHADOWS, "Draw cloud shadows"},
    {TR_CONFIG_ASK_CONFIRMATION_ON_FILE_OVERWRITE, "Ask for confirmation when overwriting a file"},
    {TR_CONFIG_GATES_DEFAULT_TO_PASS_ALL_WALKERS, "Non-military gates default to allowing all walkers"},
    {TR_HOTKEY_TITLE, "Augustus hotkey configuration"},
    {TR_HOTKEY_LABEL, "Hotkey"},
    {TR_HOTKEY_ALTERNATIVE_LABEL, "Alternative"},
    {TR_HOTKEY_HEADER_ARROWS, "Arrow keys"},
    {TR_HOTKEY_HEADER_GLOBAL, "Global hotkeys"},
    {TR_HOTKEY_HEADER_CITY, "City hotkeys"},
    {TR_HOTKEY_HEADER_ADVISORS, "Advisors"},
    {TR_HOTKEY_HEADER_OVERLAYS, "Overlays"},
    {TR_HOTKEY_HEADER_BOOKMARKS, "City map bookmarks"},
    {TR_HOTKEY_HEADER_EDITOR, "Editor"},
    {TR_HOTKEY_HEADER_BUILD, "Construction hotkeys"},
    {TR_HOTKEY_ARROW_UP, "Up"},
    {TR_HOTKEY_ARROW_DOWN, "Down"},
    {TR_HOTKEY_ARROW_LEFT, "Left"},
    {TR_HOTKEY_ARROW_RIGHT, "Right"},
    {TR_HOTKEY_TOGGLE_FULLSCREEN, "Toggle fullscreen"},
    {TR_HOTKEY_CENTER_WINDOW, "Center window"},
    {TR_HOTKEY_RESIZE_TO_640, "Resize window to 640x480"},
    {TR_HOTKEY_RESIZE_TO_800, "Resize window to 800x600"},
    {TR_HOTKEY_RESIZE_TO_1024, "Resize window to 1024x768"},
    {TR_HOTKEY_SAVE_SCREENSHOT, "Save screenshot"},
    {TR_HOTKEY_SAVE_CITY_SCREENSHOT, "Save full city screenshot"},
    {TR_HOTKEY_SAVE_MINIMAP_SCREENSHOT, "Save minimap screenshot"},
    {TR_HOTKEY_BUILD_CLONE, "Clone building under cursor"},
    {TR_HOTKEY_LOAD_FILE, "Load file"},
    {TR_HOTKEY_SAVE_FILE, "Save file"},
    {TR_HOTKEY_INCREASE_GAME_SPEED, "Increase game speed"},
    {TR_HOTKEY_DECREASE_GAME_SPEED, "Decrease game speed"},
    {TR_HOTKEY_TOGGLE_PAUSE, "Toggle pause"},
    {TR_HOTKEY_CYCLE_LEGION, "Cycle through legions"},
    {TR_HOTKEY_ROTATE_MAP_LEFT, "Rotate map left"},
    {TR_HOTKEY_ROTATE_MAP_RIGHT, "Rotate map right"},
    {TR_HOTKEY_ZOOM_IN, "Zoom in"},
    {TR_HOTKEY_ZOOM_OUT, "Zoom out"},
    {TR_HOTKEY_RESET_ZOOM, "Reset zoom"},
    {TR_HOTKEY_SHOW_ADVISOR_LABOR, "Labor advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_MILITARY, "Military advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_IMPERIAL, "Imperial advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_RATINGS, "Ratings advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_TRADE, "Trade advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_POPULATION, "Population advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_HEALTH, "Health advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_EDUCATION, "Education advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT, "Entertainment advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_RELIGION, "Religion advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_FINANCIAL, "Financial advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_CHIEF, "Chief advisor"},
    {TR_HOTKEY_SHOW_ADVISOR_HOUSING, "Housing advisor"},
    {TR_HOTKEY_TOGGLE_OVERLAY, "Toggle current overlay"},
    {TR_HOTKEY_SHOW_OVERLAY_RELATIVE, "Relative overlay"},
    {TR_HOTKEY_SHOW_OVERLAY_WATER, "Water overlay"},
    {TR_HOTKEY_SHOW_OVERLAY_FIRE, "Fire overlay"},
    {TR_HOTKEY_SHOW_OVERLAY_DAMAGE, "Damage overlay"},
    {TR_HOTKEY_SHOW_OVERLAY_CRIME, "Crime overlay"},
    {TR_HOTKEY_ROTATE_BUILDING, "Next building rotation"},
    {TR_HOTKEY_ROTATE_BUILDING_BACK, "Previous building rotation"},
    {TR_HOTKEY_SHOW_OVERLAY_PROBLEMS, "Problems overlay"},
    {TR_HOTKEY_GO_TO_BOOKMARK_1, "Go to bookmark 1"},
    {TR_HOTKEY_GO_TO_BOOKMARK_2, "Go to bookmark 2"},
    {TR_HOTKEY_GO_TO_BOOKMARK_3, "Go to bookmark 3"},
    {TR_HOTKEY_GO_TO_BOOKMARK_4, "Go to bookmark 4"},
    {TR_HOTKEY_SET_BOOKMARK_1, "Set bookmark 1"},
    {TR_HOTKEY_SET_BOOKMARK_2, "Set bookmark 2"},
    {TR_HOTKEY_SET_BOOKMARK_3, "Set bookmark 3"},
    {TR_HOTKEY_SET_BOOKMARK_4, "Set bookmark 4"},
    {TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO, "Toggle battle info"},
    {TR_HOTKEY_EDIT_TITLE, "Press new hotkey"},
    {TR_BUILDING_ROADBLOCK, "Roadblock"},
    {TR_BUILDING_ROADBLOCK_DESC, "Roadblock stops loitering citizens."},
    {TR_BUILDING_ARCHITECT_GUILD, "Architects' guild" },
    {TR_BUILDING_ARCHITECT_GUILD_DESC, "Architects here work tirelessly to construct monuments for the glory of Rome." },
    {TR_BUILDING_GRAND_TEMPLE_ADD_MODULE, "Bestow epithet on temple" },
    {TR_BUILDING_GRAND_TEMPLE_CERES, "Ceres grand temple" },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE, "Neptune grand temple" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY, "Mercury grand temple" },
    {TR_BUILDING_GRAND_TEMPLE_MARS, "Mars grand temple" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS, "Venus grand temple" },
    {TR_BUILDING_PANTHEON, "Pantheon" },
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC, "Grand temple of Ceres" },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC, "Grand temple of Neptune" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC, "Grand temple of Mercury" },
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC, "Grand temple of Mars" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC, "Grand temple of Venus" },
    {TR_BUILDING_PANTHEON_DESC, "Pantheon" },
    {TR_BUILDING_GRAND_TEMPLE_CERES_BONUS_DESC, "Ceres inspires cartpushers from your city's farms to move 50% faster." },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_BONUS_DESC, "Neptune grants an additional +1 range for fountains and wells and +2 for reservoirs. Water services labor is also reduced by 50% and trading ships travel 25% faster. Sickness increase in houses is greatly hindered." }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_BONUS_DESC, "Mercury blesses your traders by land and sea with an additional 50% capacity, and inspires land traders to move 25% faster." }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_GRAND_TEMPLE_MARS_BONUS_DESC, "Mars exhorts your citizens to enlist, dispatching recruits to your city's forts, and allowing four additional forts to be built." }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_GRAND_TEMPLE_VENUS_BONUS_DESC, "Venus graces your city's gardens, statues and temples to glow with beauty, improving their desirability. Houses also hold more goods, and devolve more slowly." }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_PANTHEON_BONUS_DESC, "The Pantheon provides access to your citizens to worship all the gods. Annual festivals are also held here, and religious and cultural building levies are reduced by 25%." }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_1_DESC, "Priests reduce food consumption by 20%." },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_1_DESC, "Temples produce charioteers for the hippodrome." },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_1_DESC, "Priests reduce pottery and furniture consumption by 20%." },
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_1_DESC, "Temples generate food, in an amount based on the number of houses they cover, and deliver it to the supply post. Fort levies reduced by 25%." }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_1_DESC, "The grand temple produces wine in a quantity scaled to city population with Venus temple access. Temples collect and distribute it to houses and taverns." },
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_2_DESC, "Priests collect and distribute both oil and one food type from city storage." },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_2_DESC, "Priests expand housing capacity by 5%. Grand temple provides water like a filled reservoir." },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_2_DESC, "Priests reduce oil and wine consumption by 20%." },
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_2_DESC, "Priests reduce consumption of all goods by 10%." },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_2_DESC, "Priests provide entertainment and beautify houses themselves, increasing the attractiveness of the neighborhood without additional decoration." },
    {TR_BUILDING_PANTHEON_MODULE_1_DESC, "All the temples in the city send priests to Pantheon, spreading the faith and blessings of their gods." },
    {TR_BUILDING_PANTHEON_MODULE_2_DESC, "Houses with access to the Pantheon can evolve one additional step." },
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_1, "Temple of Ceres Fecunda" }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_2, "Temple of Ceres Frugifera" }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_1, "Temple of Neptunus Equester" },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_2, "Temple of Neptunus Adiutor" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_1, "Temple of Mercurius Fortunus" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_2, "Temple of Mercurius Mercator" }, // Note to translators: This one changed from the previous versions, please update.
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_1, "Temple of Mars Ultor" },
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_2, "Temple of Mars Quirinus" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_1, "Temple of Venus Verticordia" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_2, "Temple of Venus Genetrix" },
    {TR_BUILDING_PANTHEON_DESC_MODULE_1, "Pantheum Ara Maxima" },
    {TR_BUILDING_PANTHEON_DESC_MODULE_2, "Pantheum Roma Aeterna" },
    {TR_BUILDING_GRAND_TEMPLE_MENU, "Grand temple" },
    {TR_BUILDING_WORK_CAMP, "Work camp" },
    {TR_BUILDING_WORK_CAMP_DESC, "Laborers gather here to transport materials to construction sites." },
    {TR_BUILDING_DEPOT, "Cart depot"},
    {TR_BUILDING_CAT_DEPOT, "Cat depot"},
    {TR_BUILDING_DEPOT_DESC, "Cart depot sends out carts to transfer goods between warehouses and granaries based on the order. The carts must return to the depot after each delivery."},
    {TR_HEADER_HOUSING, "Housing"},
    {TR_ADVISOR_HOUSING_ROOM, "City housing has room available for"},
    {TR_ADVISOR_HOUSING_NO_ROOM, "There is no room available in city housing."},
    {TR_ADVISOR_RESIDENCES_USING_POTTERY, "Residences using pottery"},
    {TR_ADVISOR_RESIDENCES_USING_FURNITURE, "Residences using furniture"},
    {TR_ADVISOR_RESIDENCES_USING_OIL, "Residences using oil"},
    {TR_ADVISOR_RESIDENCES_USING_WINE, "Residences using wine"},
    {TR_ADVISOR_TOTAL_NUM_HOUSES, "Total residences:"},
    {TR_ADVISOR_AVAILABLE_HOUSING_CAPACITY, "Available capacity:"},
    {TR_ADVISOR_TOTAL_HOUSING_CAPACITY, "Total capacity:"},
    {TR_ADVISOR_ADVISOR_HEADER_HOUSING, "Population - Housing"},
    {TR_ADVISOR_BUTTON_GRAPHS, "Graphs"},
    {TR_ADVISOR_HOUSING_PROSPERITY_RATING, "Housing prosperity rating is"},
    {TR_ADVISOR_PERCENTAGE_IN_VILLAS_PALACES, "Percentage of your population in villas and palaces is"},
    {TR_ADVISOR_PERCENTAGE_IN_TENTS_SHACKS, "Percentage of your population in tents and shacks is"},
    {TR_ADVISOR_AVERAGE_TAX, "Average tax income per residence is"},
    {TR_ADVISOR_AVERAGE_AGE, "Average age of your population is"},
    {TR_ADVISOR_PERCENT_IN_WORKFORCE, "Percentage of your population in the workforce is"},
    {TR_ADVISOR_BIRTHS_LAST_YEAR, "Births last year:"},
    {TR_ADVISOR_DEATHS_LAST_YEAR, "Deaths last year:"},
    {TR_ADVISOR_TOTAL_POPULATION, "residents total"},
    {TR_ADVISOR_IN_STORAGE, "in storage"},
    {TR_ADVISOR_FROM_GRANARIES, "from granaries"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TITLE, "Dispatching food from granaries"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TEXT, "Are you sure?"},
    {TR_ADVISOR_KEEP_STOCKPILING, "Keep stockpiling resource"},
    {TR_ADVISOR_MAX_ATTAINABLE_PROSPERITY_IS, "Max Prosperity for the current housing level is"},
    {TR_ADVISOR_POPULATION_AGE, "Age"},
    {TR_ADVISOR_POPULATION_RESIDENTS, "residents"},
    {TR_ADVISOR_POPULATION_DWELLERS, "dwellers"},
    {TR_REQUIRED_RESOURCES, "Resources delivered for current phase:"},
    {TR_BUILDING_GRAND_TEMPLE_CONSTRUCTION_DESC, "Constructing grand temples requires material stored in a warehouse, laborers from a work camp, and architects from an architects' guild."},
    {TR_CONSTRUCTION_PHASE, "Construction phase:"},
    {TR_ADD_MODULE, "Rededicate temple?"},
    {TR_BUILDING_TEMPLE_MODULE_CONSTRUCTED, "Epithet bestowed."},
    {TR_BUILDING_CERES_TEMPLE_QUOTE, "First Ceres taught the laboring hind to plow\nThe pregnant Earth, and quickening seed to sow.\nShe first for Man did wholesome food provide\nAnd with just laws the wicked world supplied.\n-Ovid, the Metamorphoses, Book V" },
    {TR_BUILDING_NEPTUNE_TEMPLE_QUOTE, "The billows fall, while Neptune lays his mace\nOn the rough sea,and smooths its furrowed face.\nAlready Triton, at his call, appears Above the waves;\na Tyrian robe he wears;\nAnd in his hand a crooked trumpet bears.\n-Ovid, the Metamorphoses, Book I"},
    {TR_BUILDING_MERCURY_TEMPLE_QUOTE, "Cattle and fat sheep can all be had for the raiding,\ntripods for the trading, and tawny headed stallions.\nBut a mans's lifebreath cannot come back again-\nno raiders in force, no trading brings it back, \nonce it slips through a man's clenched teeth.\n-Homer, The Iliad, Book IX"},
    {TR_BUILDING_MARS_TEMPLE_QUOTE, "For Mars, repair his broken axletrees and blunted war,\nAnd send him forth again with furbished arms,\nTo wake the lazy war with trumpets' loud alarms.\n-Virgil, the Aeneid, Book VIII" },
    {TR_BUILDING_VENUS_TEMPLE_QUOTE, "By winged Cupid, and Venus, his tender mother,\nhow great the joy I had!\nHow clearly passion touched me!\nHow my whole heart melted where I lay!\n-Ovid, the Metamorphoses, Book IX" },
    {TR_BUILDING_PANTHEON_QUOTE, "The gates of heaven unfold: Jupiter summons all\nThe gods to council in the common hall.\nSublimely seated, he surveys from far\nThe fields, the camp, the fortune of the war,\nAnd all the inferior world. From first to last,\nThe sovereign senate in degrees are placed.\n-Virgil, The Aeneid, Book X" },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1, "(Podium)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2, "(Portico)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3, "(Cella)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4, "(Praecinctum)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5, "(Dedicatio)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1_TEXT, "Laborers are constructing the podium that will elevate the temple and provide a solid foundation to weather the passage of time." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2_TEXT, "Artisans are crafting the portico, which bears the temple's sacrificial altar." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3_TEXT, "Engineers are crafting the cella, the temple interior that houses the sacred images." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4_TEXT, "Work on the temple praecinctum has begun, where worshippers will gather outdoors for public ceremonies." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5_TEXT, "With the temple nearly complete, priests gather to perform the rites of consecration." },
    {TR_BUILDING_MENU_TREES, "Trees" },
    {TR_BUILDING_MENU_PATHS, "Paths" },
    {TR_BUILDING_MENU_PARKS, "Parks"},
    {TR_BUILDING_SMALL_POND, "Small pond"},
    {TR_BUILDING_LARGE_POND, "Large pond"},
    {TR_BUILDING_PINE_TREE, "Pine tree"},
    {TR_BUILDING_FIR_TREE, "Fir tree" },
    {TR_BUILDING_OAK_TREE, "Oak tree" },
    {TR_BUILDING_ELM_TREE, "Elm tree" },
    {TR_BUILDING_FIG_TREE, "Fig tree" },
    {TR_BUILDING_PLUM_TREE, "Plum tree" },
    {TR_BUILDING_PALM_TREE, "Palm tree" },
    {TR_BUILDING_DATE_TREE, "Date tree" },
    {TR_BUILDING_PINE_PATH, "Pine path" },
    {TR_BUILDING_FIR_PATH, "Fir path" },
    {TR_BUILDING_OAK_PATH, "Oak path" },
    {TR_BUILDING_ELM_PATH, "Elm path" },
    {TR_BUILDING_FIG_PATH, "Fig path" },
    {TR_BUILDING_PLUM_PATH, "Plum path" },
    {TR_BUILDING_PALM_PATH, "Palm path" },
    {TR_BUILDING_DATE_PATH, "Date path" },
    {TR_BUILDING_BLUE_PAVILION, "Pavilion" },
    {TR_BUILDING_RED_PAVILION, "Red pavilion"},
    {TR_BUILDING_ORANGE_PAVILION, "Orange pavilion"},
    {TR_BUILDING_YELLOW_PAVILION, "Yellow pavilion"},
    {TR_BUILDING_GREEN_PAVILION, "Green pavilion" },
    {TR_BUILDING_SMALL_STATUE_ALT, "Goddess statue" },
    {TR_BUILDING_SMALL_STATUE_ALT_B, "Senator statue"},
    {TR_BUILDING_OBELISK, "Obelisk" },
    {TR_BUILDING_POND_DESC, "Ponds fill from city reservoirs and provide water for plants and animals and a cool, relaxing oasis for people. All citizens would love to live near a pond." },
    {TR_BUILDING_WINDOW_POND, "Pond"},
    {TR_BUILDING_OBELISK_DESC, "A prestigious monument, the work of an ancient king of the Nile. The Egyptians weren't using it."},
    {TR_ADVISOR_FINANCE_LEVIES, "Building levies"},
    {TR_CONFIRM_DELETE_MONUMENT, "Demolishing this monument"},
    {TR_SELECT_EPITHET_PROMPT_HEADER, "Select epithet to bestow"},
    {TR_SELECT_EPITHET_PROMPT_TEXT, "Bestowing an epithet will permanently dedicate your temple to one aspect of its deity, imbuing priests with divine power." },
    {TR_BUILDING_INFO_MONTHLY_LEVY, "/month"},
    {TR_BUILDING_MESS_HALL, "Supply post"},
    {TR_BUILDING_MESS_HALL_DESC, "The supply post collects food from city granaries to feed soldiers stationed at city forts. A poorly supplied supply post will slow recruitment and damage morale."},
    {TR_BUILDING_MESS_HALL_FULFILLMENT, "Last month's food supply:"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER, "Soldiers are: " },
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_1, "Well-fed" },
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_2, "Fed"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_3, "Hungry"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_4, "Very hungry"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_5, "Starving"},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_1, "The varied diet of your soldiers greatly increases morale."},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_2, "The diverse, nutritious diet enjoyed by your soldiers greatly increases morale."},
    {TR_BUILDING_MESS_HALL_NO_SOLDIERS, "You have no soldiers to feed." },
    {TR_BUILDING_MESS_HALL_MONTHS_FOOD_STORED, "Months of food stored:" },
    {TR_BUILDING_MESS_HALL_NO_FOOD, "This supply post has employees, but they are currently looking for an available source of food." },
    {TR_MESS_HALL_SPECIAL_ORDERS_HEADER, "Supply post instructions"},
    {TR_BUILDING_BARRACKS_FOOD_WARNING, "Food shortages at your supply post are slowing soldier recruitment."},
    {TR_BUILDING_BARRACKS_FOOD_WARNING_2, "Critical food shortages at your supply post are crippling soldier recruitment." },
    {TR_BUILDING_LEGION_FOOD_WARNING_1, "Recent food shortage decreased morale"},
    {TR_BUILDING_LEGION_FOOD_WARNING_2, "Recent food shortage greatly decreased morale"},
    {TR_BUILDING_LEGION_STARVING, "Food shortage" },
    {TR_ADVISOR_TRADE_MAX, "Max"},
    {TR_ADVISOR_TRADE_NO_LIMIT, "max"},
    {TR_ADVISOR_TRADE_IMPORTABLE, "Importable"},
    {TR_ADVISOR_TRADE_EXPORTABLE, "Exportable"},
    {TR_ADVISOR_TRADE_NO_BUYERS, "No buyers for this resource"},
    {TR_ADVISOR_TRADE_NO_SELLERS, "No sellers for this resource"},
    {TR_ADVISOR_TRADE_NOT_IMPORTING, "Not importing"},
    {TR_ADVISOR_TRADE_NOT_EXPORTING, "Not exporting"},
    {TR_ADVISOR_TRADE_RESOURCE_NOT_STORABLE, "Cannot be stored"},
    {TR_ADVISOR_TRADE_RESOURCE_NOT_STORABLE_OR_TRADABLE, "Resource cannot be stored or traded"},
    {TR_ADVISOR_OPEN_TO_IMPORT, "Open trade route to import"},
    {TR_ADVISOR_OPEN_TO_EXPORT, "Open trade route to export"},
    {TR_ADVISOR_LEGION_FOOD_SATISFIED, "Your soldiers have all the food they require."},
    {TR_ADVISOR_LEGION_FOOD_NEEDED, "Your soldiers need more food." },
    {TR_ADVISOR_LEGION_FOOD_CRITICAL, "Your soldiers are starving!"},
    {TR_ADVISOR_LEGION_MONTHS_FOOD_STORED, "Months of food stored at supply post:" },
    {TR_CITY_MESSAGE_TITLE_MESS_HALL_NEEDS_FOOD, "Hungry soldiers" },
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_NEEDS_FOOD, "Your supply post is critically low on food, and the morale of your troops wanes. Ensure your supply post can access a well-stocked granary."},
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_MISSING, "Your city has lost its supply post, and your troops starve. Construct a supply post immediately."},
    {TR_MARKET_SPECIAL_ORDERS_HEADER, "Market instructions"},
    {TR_DOCK_SPECIAL_ORDERS_HEADER, "Dock instructions"},
    {TR_TEMPLE_SPECIAL_ORDERS_HEADER, "Temple instructions"},
    {TR_TAVERN_SPECIAL_ORDERS_HEADER, "Tavern instructions"},
    {TR_WARNING_NO_MESS_HALL, "You must first build a supply post to feed your soldiers."},
    {TR_WARNING_MAX_GRAND_TEMPLES, "No more grand temples can be built."},
    {TR_CITY_MESSAGE_TITLE_GRAND_TEMPLE_COMPLETE, "Grand temple completed"},
    {TR_CITY_MESSAGE_TEXT_GRAND_TEMPLE_COMPLETE, "Priests and worshippers flock to the new grand temple for the rites of dedication. Your people stand in awe of the majesty of your works, and your chosen deity showers you with favor."},
    {TR_CITY_MESSAGE_TITLE_MERCURY_BLESSING, "A blessing from Mercury" },
    {TR_CITY_MESSAGE_TEXT_MERCURY_BLESSING, "Delighted by your devotion, Mercury has blessed your industry, uncovering raw materials for your craftsmen."},
    {TR_FIGURE_TYPE_WORK_CAMP_WORKER, "Foreman"},
    {TR_FIGURE_TYPE_WORK_CAMP_SLAVE, "Hauler"},
    {TR_FIGURE_TYPE_WORK_CAMP_ARCHITECT, "Architect"},
    {TR_FIGURE_TYPE_MESS_HALL_SUPPLIER, "Quartermaster"},
    {TR_FIGURE_TYPE_MESS_HALL_COLLECTOR, "Camp-servant"},
    {TR_BUILDING_CERES_TEMPLE_MODULE_DESC, "The grand temple organizes priests of Ceres to aid in distributing food and oil to your hungry citizens."},
    {TR_BUILDING_VENUS_TEMPLE_MODULE_DESC, "The grand temple allows priests of Venus to supply sacred wine to your citizens." },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC, "The grand temple organizes priests of Mars to supply food to your supply post."},
    {TR_BUILDING_SMALL_TEMPLE_CERES_NAME, "Temple of Ceres"},
    {TR_BUILDING_SMALL_TEMPLE_NEPTUNE_NAME, "Temple of Neptune"},
    {TR_BUILDING_SMALL_TEMPLE_MERCURY_NAME, "Temple of Mercury"},
    {TR_BUILDING_SMALL_TEMPLE_MARS_NAME, "Temple of Mars"},
    {TR_BUILDING_SMALL_TEMPLE_VENUS_NAME, "Temple of Venus"},
    {TR_FIGURE_TYPE_PRIEST_SUPPLIER, "Priest" },
    {TR_BUILDING_DOCK_CITIES_CONFIG_DESC, "Cities with opened sea trade:" },
    {TR_BUILDING_DOCK_CITIES_NO_ROUTES, "There are no open sea trade routes." },
    // Transcription of mission_exact4.wav
    {TR_PHRASE_FIGURE_MISSIONARY_EXACT_4, "\"I'll do what I can to calm these barbarians down. I'm sure they'll stop attacking the city when I've had a word with them.\"" },
    {TR_CITY_MESSAGE_TITLE_PANTHEON_FESTIVAL, "An annual festival"},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_CERES, "The faithful flock to temples for the celebration of Cerealia, in honor of Ceres. Farmers offer sacrifices for rich harvests in the coming years."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_NEPTUNE, "Today is the festival of Neptunalia, in honor of Neptune. The faithful build huts of branch and foliage and make merry under the blazing heat of the midsummer sun."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MERCURY, "Traders and merchants turn out in droves to celebrate Mercuralia. Sacred water is sprinkled on ships and warehouses in hopes of divine protection from the god Mercury."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MARS, "Citizens gather outside the city for the celebration of Equirria, to seek the favor of Mars. The air is filled with the thunder of hooves and the creaking of chariots as the faithful race in honor of their god."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_VENUS, "The faithful gather for the celebration of Veneralia, a day sacred to Venus. Your citizens beseech her for good fortune in matters of the heart."},
    {TR_TOOLTIP_BUTTON_DELETE_READ_MESSAGES, "Delete read messages"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_ON, "Disable this building"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_OFF, "Enable this building"},
    {TR_TOOLTIP_BUTTON_ACCEPT_MARKET_LADIES, "Allow market ladies to buy from here"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_CARAVAN, "Allow caravans to trade here"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_SHIPS, "Allow trade ships to trade here"},
    {TR_TOOLTIP_BUTTON_ACCEPT_WORKERS, "Halt resource to workshops or granaries"},
    {TR_TOOLTIP_BUTTON_STOCKPILING_ON, " Enable stockpiling to a warehouse"},
    {TR_TOOLTIP_BUTTON_STOCKPILING_OFF, "Disable stockpiling"},
    {TR_BUILDING_LIGHTHOUSE, "Lighthouse"},
    {TR_BUILDING_CARAVANSERAI, "Caravanserai"},
    {TR_BUILDING_CARAVANSERAI_DESC, "Merchant caravans shelter here to rest and feed their animals. Land trade disruptions last half as long."},
    {TR_CARAVANSERAI_SPECIAL_ORDERS_HEADER, "Caravanserai instructions"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1, "(Foundation)"},
    {TR_BUILDING_CARAVANSERAI_PHASE_2, "(Colonnade)"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1_TEXT, "Engineers are laying the foundation of a large courtyard for traders to gather on."},
    {TR_BUILDING_CARAVANSERAI_PHASE_2_TEXT, "Masons are constructing a rectangular colonnade. Inside will be shelters for traders and their animals."},
    {TR_FIGURE_TYPE_CARAVANSERAI_SUPPLIER, "Caravanserai supplier" },
    {TR_FIGURE_TYPE_CARAVANSERAI_COLLECTOR, "Caravanserai collector" },
    {TR_BUILDING_CARAVANSERAI_POLICY_TITLE, "Land trade policy" },
    {TR_BUILDING_CARAVANSERAI_NO_POLICY, "No land trade policy." },
    {TR_BUILDING_CARAVANSERAI_POLICY_TEXT, "Select a land trade policy for your city. You can change to another policy at any time." },
    {TR_BUILDING_CARAVANSERAI_POLICY_1_TITLE, "Consilium venditor terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_1, "Landed seller's policy: Land exports earn 20% more, but land imports are 10% more expensive." },
    {TR_BUILDING_CARAVANSERAI_POLICY_2_TITLE, "Consilium emptor terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_2, "Landed buyer's policy: Land imports are 20% cheaper, but land exports earn 10% less." },
    {TR_BUILDING_CARAVANSERAI_POLICY_3_TITLE, "Consilium quantitas terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_3, "Landed quantity policy: Trade caravans carry 4 additional goods, but the Caravanserai consumes 20% more food." },
    {TR_BUILDING_CARAVANSERAI_NO_FOOD, "This caravanserai has employees, but they are currently looking for an available source of food." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_1, "(Foundation)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_2, "(Pedestal)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_3, "(Tower)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_4, "(Crown)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_1_TEXT, "Engineers are laying a strong foundation to hold the weight of a great tower of stone." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_2_TEXT, "Masons are constructing the pedestal that will raise the lighthouse's flame far above the horizon." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_3_TEXT, "The lighthouse rises higher each day, as masons lay successive courses of the great tower." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_4_TEXT, "Engineers are putting the final touches on the construction of the lighthouse. Soon it will shine for miles, guiding ships home." },
    {TR_BUILDING_LIGHTHOUSE_CONSTRUCTION_DESC, "Constructing the lighthouse requires material stored in a warehouse, laborers from a work camp, and architects from an architects' guild." },
    {TR_BUILDING_LIGHTHOUSE_BONUS_DESC, "The light atop this great tower guides ships from the far reaches of the world safely to your city. Fishing ships now move 10% faster, and sea storms last half as long." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_TITLE, "Sea trade policy" },
    {TR_BUILDING_LIGHTHOUSE_NO_POLICY, "No sea trade policy." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_TEXT, "Select a sea trade policy for your city. You can change to another policy at any time." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1_TITLE, "Consilium venditor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1, "Maritime seller's policy: Sea exports earn 20% more, but sea imports are 10% more expensive." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2_TITLE, "Consilium emptor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2, "Maritime buyer's policy: Sea imports are 20% cheaper, but sea exports earn 10% less." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3_TITLE, "Consilium quantitas maritimae" }, // XXX "quantitatis"? Can anybody double check?
    {TR_BUILDING_LIGHTHOUSE_POLICY_3, "Maritime quantity policy: Trade ships carry 4 additional goods, but the Lighthouse consumes 20% more timber." },
    {TR_EDITOR_ALLOWED_BUILDINGS_MONUMENTS, "Monuments"},
    {TR_CITY_MESSAGE_TEXT_LIGHTHOUSE_COMPLETE, "The completed lighthouse; a mighty tower of stone, looms over the horizon. May its firey beacon guide ships safely home until the end of time." },
    {TR_CITY_MESSAGE_TEXT_PANTHEON_COMPLETE, "The Pantheon is completed. It stands unrivaled as a monument to the awesome power of the gods and people of Rome." },
    {TR_CITY_MESSAGE_TITLE_MONUMENT_COMPLETE, "Monument completed" },
    {TR_CITY_MESSAGE_TITLE_NEPTUNE_BLESSING, "A blessing from Neptune"},
    {TR_CITY_MESSAGE_TEXT_NEPTUNE_BLESSING, "Rewarding your city's devotion, Neptune grants smooth passage to traders for twelve months, during which your exports will earn an extra 50%."},
    {TR_CITY_MESSAGE_TITLE_VENUS_BLESSING, "A blessing from Venus" },
    {TR_CITY_MESSAGE_TEXT_VENUS_BLESSING, "Delighted by the joyful reverence shown to her, Venus grants youthfulness, health, and happiness to your people, increasing the size of your working population. The mood in your city lifts at Venus' smile." },
    {TR_BUILDING_MENU_STATUES, "Statues" },
    {TR_BUILDING_MENU_GOV_RES, "Governor's mansions" },
    {TR_OVERLAY_ROADS, "Roads" },
    {TR_NO_EXTRA_ASSETS_TITLE, "Extra assets couldn't be loaded" },
    {TR_NO_EXTRA_ASSETS_MESSAGE,
        "The extra Augustus assets could not be loaded.\n"
        "This can be due to a missing or old 'assets' directory.\n"
        "Please ensure you have the most up-to-date 'assets' directory, which can obtained from GitHub." },
    {TR_WARNING_WATER_NEEDED_FOR_BUILDING, "Building must be placed near water"},
    {TR_TOOLTIP_OVERLAY_PANTHEON_ACCESS, "This house has access to all five gods from the Pantheon"},
    {TR_BUILDING_LEGION_FOOD_BONUS, "Plentiful food is boosting morale" },
    {TR_BUILDING_LEGION_FOOD_STATUS, "Food status"},
    {TR_TOOLTIP_BUTTON_ACCEPT_QUARTERMASTER, "Allow quartermaster to get food here"},
    {TR_WARNING_RESOURCES_NOT_AVAILABLE, "You cannot obtain the needed materials"},
    {TR_CONFIG_GP_CH_MONUMENTS_BOOST_CULTURE_RATING, "Completed grand temples grant +6 culture rating"},
    {TR_CONFIG_GP_CH_DISABLE_INFINITE_WOLVES_SPAWNING, "Disable infinite wolves spawning"},
    {TR_BUTTON_BACK_TO_MAIN_MENU, "Exit to main menu" },
    {TR_LABEL_PAUSE_MENU, "Pause" },
    {TR_OVERLAY_LEVY, "Levies" },
    {TR_TOOLTIP_OVERLAY_LEVY, " denarii paid monthly in levies." },
    {TR_MAP_EDITOR_OPTIONS, "Scenario settings" },
    {TR_BUILDING_TAVERN, "Tavern" },
    {TR_BUILDING_GRAND_GARDEN, "Grand garden" },
    {TR_BUILDING_TAVERN_DESC_1, "This tavern has no workers, and cannot open for business." },
    {TR_BUILDING_TAVERN_DESC_2, "This tavern has no wine, and cannot open for business." },
    {TR_BUILDING_TAVERN_DESC_3, "This tavern provides entertainment as long as the wine keeps flowing. A supply of meat or fish would increase its appeal." },
    {TR_BUILDING_TAVERN_DESC_4, "Plentiful wine and the smell of roasted food draw a lively crowd to this tavern for gambling, music, and merriment." },
    {TR_FIGURE_TYPE_BARKEEP, "Barkeep" },
    {TR_FIGURE_TYPE_BARKEEP_SUPPLIER, "Tavern supplier" },
    {TR_OVERLAY_TAVERN, "Tavern" },
    {TR_TOOLTIP_OVERLAY_TAVERN_1, "This house has no access to a tavern, or its tavern has run dry of wine." },
    {TR_TOOLTIP_OVERLAY_TAVERN_2, "No barkeep has passed for a while. This house will soon lose access to its tavern." },
    {TR_TOOLTIP_OVERLAY_TAVERN_3, "This house was passed by a barkeep from a tavern with wine." },
    {TR_TOOLTIP_OVERLAY_TAVERN_4, "This house was passed by a barkeep from a tavern with wine and meat or fish." },
    {TR_TOOLTIP_OVERLAY_TAVERN_5, "This house was recently passed by a barkeep from a tavern with wine." },
    {TR_TOOLTIP_OVERLAY_TAVERN_6, "This house was recently passed by a barkeep from a tavern with wine and meat or fish. Let merriment commence!" },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_1, "Residents loathe your very name."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_2, "Residents are very angry with you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_3, "Residents are angry with you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_4, "Residents are very upset with you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_5, "Residents are upset with you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_6, "Residents are annoyed with you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_7, "Residents are indifferent to you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_8, "Residents are pleased with you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_9, "Residents are very pleased with you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_10, "Residents are extremely pleased with you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_11, "Residents love you." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_12, "Residents idolize you as a god." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_HIGH_TAXES, "Residents are upset about high taxation." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_LOW_WAGES, "Residents are upset about low wages." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_UNEMPLOYMENT, "Residents are upset about the lack of jobs." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_SQUALOR, "Residents are despondent about their poor housing." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_ENTERTAINMENT, "Residents would appreciate more entertainment." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_FOOD, "Residents would appreciate a more varied diet." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_DESIRABILITY, "Residents would appreciate more desirability." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_POSITIVE, "Residents have their spirits lifted by a recent event." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_NEGATIVE, "Residents lose heart due to a recent event." },
    {TR_BUILDING_WINDOW_INDUSTRY_EFFICIENCY, "Efficiency:" },
    {TR_BUILDING_WINDOW_INDUSTRY_EFFICIENCY_TOOLTIP, "Efficiency is the ratio between how much the building can produce in a year versus what it actually produced the past year." },
    {TR_BUILDING_WINDOW_INDUSTRY_LOW_EFFICIENCY_RAW_MATERIALS, "This building has low efficiency. This could be due to a lack of a close destination for the final goods." },
    {TR_BUILDING_WINDOW_INDUSTRY_LOW_EFFICIENCY_WORKSHOPS, "This building has low efficiency. This could be due to a lack of a constant supply of raw materials or of a close destination for the final goods." },
    {TR_BUILDING_WINDOW_INDUSTRY_WHARF_AVERAGE_CATCH, "Average monthly catch:" },
    {TR_BUILDING_WINDOW_INDUSTRY_NEEDED, " needed)" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE, "Tavern" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE_PLURAL, "Taverns" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_HEADER, "Games" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_DESC, "Sponsor Great Games at your Colosseum, costing personal funds and resources from your city." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Hold games" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_PREPARING, "Preparations for the Great Games are underway." },
    {TR_SELECT_GAMES_HEADER, "Games" },
    {TR_SELECT_GAMES_TEXT, "Games will be held at the Colosseum, costing personal funds and resources from your city." },
    {TR_BUILDING_ARENA, "Arena" },
    {TR_BUILDING_HORSE_STATUE, "Equestrian statue" },
    {TR_BUILDING_DOLPHIN_FOUNTAIN, "Dolphin fountain" },
    {TR_BUILDING_HEDGE_DARK, "Verdant hedge" },
    {TR_BUILDING_HEDGE_LIGHT, "Sunlit hedge" },
    {TR_BUILDING_GARDEN_WALL, "Looped garden wall" },
    {TR_BUILDING_LEGION_STATUE, "Legionary statue" },
    {TR_BUILDING_DECORATIVE_COLUMN, "Marble column" },
    {TR_BUILDING_COLOSSEUM_PHASE_1, "(Hypogeum)" },
    {TR_BUILDING_COLOSSEUM_PHASE_2, "(Foundation)" },
    {TR_BUILDING_COLOSSEUM_PHASE_3, "(Arcade)" },
    {TR_BUILDING_COLOSSEUM_PHASE_4, "(Gallery)" },
    {TR_BUILDING_COLOSSEUM_PHASE_1_TEXT, "Workers are digging the underground hypogeum - tunnels and machinery from which grand spectacles will spring." },
    {TR_BUILDING_COLOSSEUM_PHASE_2_TEXT, "The walls of the Colosseum take shape as tiers of seating for both commoners and emperors are lain." },
    {TR_BUILDING_COLOSSEUM_PHASE_3_TEXT, "Graceful arches rise to the heavens, to hold the mighty Colosseum aloft." },
    {TR_BUILDING_COLOSSEUM_PHASE_4_TEXT, "As the Colosseum reaches skyward, its walls are clad in gleaming marble and statuary." },
    {TR_BUILDING_HIPPODROME_PHASE_1, "(Track)" },
    {TR_BUILDING_HIPPODROME_PHASE_2, "(Foundation)" },
    {TR_BUILDING_HIPPODROME_PHASE_3, "(Stands)" },
    {TR_BUILDING_HIPPODROME_PHASE_4, "(Facade)" },
    {TR_BUILDING_HIPPODROME_PHASE_1_TEXT, "This massive site is being painstakingly surveyed and cleared for a project of unprecedented scale." },
    {TR_BUILDING_HIPPODROME_PHASE_2_TEXT, "Accessways and support structures are being constructed around the track." },
    {TR_BUILDING_HIPPODROME_PHASE_3_TEXT, "Masons are carving stone seating that will one day accommodate tens of thousands of racing fans." },
    {TR_BUILDING_HIPPODROME_PHASE_4_TEXT, "More than a mere racetrack, artisans are crafting a monument worthy of the gods and people of Rome." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_DESC, "Constructing the monument requires material stored in a warehouse, laborers from a work camp, and architects from an architects' guild." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_HALTED, "Construction halted." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE, "Arena" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE_PLURAL, "Arenas" },
    {TR_BUILDING_INFO_TOURISM, "(travellers)" },
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_COMPLETE, "The Colosseum is complete! Let the games commence!" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_COMPLETE, "The Hippodrome is completed. Your citizens eagerly await your command for the races to begin!" },
    {TR_CITY_MESSAGE_TITLE_COLOSSEUM_WORKING, "Inaugural games" },
    {TR_CITY_MESSAGE_TITLE_HIPPODROME_WORKING, "Races begin" },
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_WORKING, "The inaugural games for your Colosseum have begun. At your command, this monument will be consecrated with the blood of the valiant!" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_WORKING, "Your city empties as teeming throngs flock to the Hippodrome for the inaugural chariot races. A deafening cheer fills the air as the gates swing open!" },
    {TR_WINDOW_GAMES_OPTION_1, "Hold Naval Games" },
    {TR_WINDOW_GAMES_OPTION_2, "Hold Animal Games" },
    {TR_WINDOW_GAMES_OPTION_3, "Hold Kalends of Januarius" },
    {TR_WINDOW_GAMES_OPTION_4, "Hold Olympic Games" },
    {TR_WINDOW_GAMES_OPTION_5, "Hold Roman Games" },
    {TR_WINDOW_GAMES_OPTION_1_DESC, "The Colosseum will be flooded to re-enact a great naval battle. The movement speed of your troops and their strength in distant battles will be increased for the next year." },
    {TR_WINDOW_GAMES_OPTION_2_DESC, "The Colosseum will host gruesome animal hunts and executions by wild beasts, delighting the plebeian masses. Crime, riots, and revolts will be suppressed for the next year. Lion tamers will help defend the city from the next invasion." },
    {TR_WINDOW_GAMES_OPTION_3_DESC, "The Colosseum will host games in honor of the gods on the first day of next year, beseeching fortune and prosperity. Trade quotas will be doubled next year." },
    {TR_WINDOW_GAMES_OPTION_4_DESC, "The Hippodrome will host the Olympic Games. Your city will host throngs of visitors, and if your athletes honor your city well you will gain a permanent increase in tourism and favor." },
    {TR_WINDOW_GAMES_OPTION_5_DESC, "The Colosseum will host the Roman Games, with people travelling to your city from across the empire to compete. Such a grand spectacle will surely earn you the favor of both the Emperor and the common people for the next year." },
    {TR_WINDOW_GAMES_COST, "Cost:" },
    {TR_WINDOW_GAMES_PERSONAL_FUNDS, "(personal funds)" },
    {TR_WINDOW_GAMES_NOT_ENOUGH_FUNDS, "Not enough personal funds." },
    {TR_WINDOW_GAMES_NOT_ENOUGH_RESOURCES, "Not enough resources stored." },
    {TR_WINDOW_GAMES_NO_VENUE, "Venue is not built, or has no workers." },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1, "(Construction)" },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1_TEXT, "Masons and engineers are constructing this sacred structure from gleaming marble." },
    {TR_BUILDING_SMALL_TEMPLE_CONSTRUCTION_DESC, "Constructing this temple will require material stored in a warehouse, laborers from a work camp, and architects from an architects' guild." },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_PLANNING, "Water from your city's reservoirs is slowly filling the Colosseum. Carpenters begin to assemble lifelike miniature ships of war as gladiators train in waterborne combat. Soon the Naval Games will begin!" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_STARTING, "The Colosseum has become a man-made lake, as gladiators re-enact great Roman victories at sea. Blood and water mix as the crowd roars its approval. The Naumachia - the Naval Games - have begun!" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_ENDING, "A long cleanup process begins for the Colosseum as it is drained and made ready for normal use. Your people will be talking about this great watery spectacle for years to come." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_PLANNING, "Strange cargo begins to appear in your city as traders from the far reaches of the earth deliver terrifying beasts to the cages beneath the Colosseum. Soon a gruesome spectacle will delight your people." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_STARTING, "Condemned criminals and gladiators seeking ultimate glory face death in the form of tooth and claw. With a blast of trumpets, the Animal Games have begun!" },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_ENDING, "The last of the wild beasts lie slain in the sands of the Colosseum, their blood mingling with that of the condemned. The Animal Games have come to an end." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_PLANNING, "We will greet the new year with a glorious games in honor of the gods. In return, we ask for fortune, prosperity, and blessings in matters of commerce." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_STARTING, "The Games begin at sunrise on the Kalends of Ianuarius. Priests conduct animal sacrifices as gladiators gird their arms to die seeking the favor of the divine."},
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_ENDING, "Auguries suggest that the gods were well pleased by our great games, and the sacrifices and reverance shown to them. We can expect a very profitable year!"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_PLANNING, "All eyes will be on your city as the Olympic Games bring travellers, competitors, and Roman dignitaries from across the world. It will take no less than a full year to see every possible preparation made."},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_STARTING, "All long last, the day has come. The sacred flame is lit, and your city streets lie deserted as citizens pack into the great hippodrome. Let the games begin!"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_ENDING, "The sacred flame is doused, and travellers and citizens trickle home in weary exultation. Eternal glory is yours for successfully hosting this ancient and sacred celebration of mortal strength and honor." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_PLANNING, "With the announcement of Roman Games, people from the furthest reaches flock to your city, many hoping to win the upcoming competitions. It will take no less than a full year to see every possible preparation made." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_STARTING, "The solemn procession begins, and with it, the Roman Games. May Jupiter himself select the champions of the races, wrestling matches, and other contests of stamina and agility. The Colosseum is filled to the brim with citizens awaiting the games and the customary gifts of wheat and olive oil. Let the games begin!" },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_ENDING, "The final day of Roman Games comes to an end. Brimming with excitement, and with full bellies, every citizen has tasted the greatness of Roman life. Glory to the gods, glory to the victorious, and glory to the governor!" },
    {TR_CITY_MESSAGE_TITLE_GREAT_GAMES, "The Great Games"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN, "Months until new Games can be held: " },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_NG, "Months until the Naval Games:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_NG, "The Naval Games are underway. The splash of water, creaking of timbers, and battle cries of gladiators add to the roar of the crowd." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_AG, "Months until the Animal Games:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_AG, "The Animal Games are underway. Shoulder to shoulder, the mob screams itself hoarse as the wild beasts stalk their human prey." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_KG, "Months until the Kalends Games:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_KG, "The Kalends Games are underway. The smell of animal sacrifices and incense overpowers even the pungent blood and sweat of the arena." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_OG, "Months until the Olympic Games:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_OG, "The Olympic Games are underway. The sacred fire burns day and night as athletes compete for immortal glory." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_IG, "Months until the Roman Games:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_IG, "The Roman Games are underway. Each participant spills their blood, sweat and tears to prove themself the finest Roman." },
    {TR_WINDOW_BUILDING_GAMES_REMAINING_DURATION, "Great Games will continue for another" }, // ...XX Days,
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN_TEXT, "Great Games were held recently." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_UNDERWAY, "The Great Games are underway! Your city throngs with travellers and revelry." },
    {TR_WINDOW_BUILDING_ARENA_CLOSED, "The arena is closed. Birds make nests in the empty seats." },
    {TR_WINDOW_BUILDING_ARENA_NO_SHOWS, "This arena hosts neither lions nor gladiators, and provides little entertainment." },
    {TR_WINDOW_BUILDING_ARENA_BOTH_SHOWS, "This arena hosts gladiators and animal hunts, to the delight of the locals." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_LIONS, "Regular gladiator shows keep the mob entertained, but lions would elevate the spectacle." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_GLADIATORS, "Hungry beasts prowl the arena in search of prey, but a lack of trained gladiators makes for brief shows." },
    {TR_OVERLAY_ARENA_COL, "Arena" },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_1, "This house has no access to an arena or the Colosseum." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_2, "This house has access to an arena with one show." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_3, "This house has access to an arena with two shows." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_4, "This house has access to the Colosseum, with one show." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_5, "This house has access to the Colosseum, with two shows." },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_STRIKE, "Workers on strike" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_WATER_ACCESS, "No water access" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_CARTPUSHER, "Waiting for the cartpusher" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_RESOURCES, "No resources available" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_MOTHBALLED, "Building mothballed" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_PLAGUE, "Building has plague"},
    {TR_WINDOW_BUILDING_TOURISM_DISABLED, "Too many buildings of this type-- travellers avoid this place." },
    {TR_WINDOW_BUILDING_TOURISM_ANNUAL, "Income from travellers this year:" },
    {TR_WINDOW_BUILDING_WHARF_MOTHBALLED, "Your Trade Advisor ordered a halt to fish production."},
    {TR_WINDOW_ADVISOR_FINANCE_INTEREST_TRIBUTE, "Tribute/interest"},
    {TR_WINDOW_ADVISOR_TOURISM, "Miscellaneous"},
    {TR_WINDOW_FIGURE_TOURIST, "This traveller has spent: "},
    {TR_FIGURE_TYPE_TOURIST,  "Traveller"},
    {TR_SAVEGAME_LARGER_VERSION_TITLE, "Incompatible savegame version" },
    {TR_SAVEGAME_LARGER_VERSION_MESSAGE, "The savegame you're trying to load is for a more recent version of Augustus.\nPlease update Augustus to the most recent version." },
    {TR_SAVEGAME_NOT_ABLE_TO_SAVE_TITLE, "Unable to save the game" },
    {TR_SAVEGAME_NOT_ABLE_TO_SAVE_MESSAGE, "It was not possible to save the game.\nIt may be because the folder where Caesar 3 keeps the savegames requires administrator access.\nPlease either change the Caesar 3 folder to a place which doesn't require administrator access or run Augustus as administrator (not recommended)." },
    {TR_BUILDING_COLONNADE, "Colonnade" },
    {TR_BUILDING_LARARIUM, "Lararium" },
    {TR_WINDOW_BUILDING_LARARIUM_DESC, "This small shrine is dedicated to the Lares - the ancestral spirits of the Roman people. Small sacrifices and prayers may be made here."},
    {TR_BUILDING_WATCHTOWER, "Watchtower"},
    {TR_BUILDING_WATCHTOWER_DESC, "Archers on the battlements of this tower keep a vigilant watch for invaders, while watchmen patrol the streets below." },
    {TR_BUILDING_WATCHTOWER_DESC_NO_SOLDIERS, "This tower needs a sentry from the barracks before it can protect our city."},
    {TR_BUILDING_NYMPHAEUM, "Nymphaeum"},
    {TR_BUILDING_NYMPHAEUM_DESC, "This great temple is dedicated to the water nymphs - minor deities of springs, rivers and seas. It promises beauty and plenty to the surrounding land and divine favor to the city." },
    {TR_BUILDING_SMALL_MAUSOLEUM, "Small Mausoleum"},
    {TR_BUILDING_SMALL_MAUSOLEUM_DESC, "This building is the final resting place of past generations of your city's proud families, and the envy of many amongst the living." },
    {TR_BUILDING_LARGE_MAUSOLEUM, "Large Mausoleum"},
    {TR_BUILDING_LARGE_MAUSOLEUM_DESC, "The polished marble walls and statues of this magnificent structure reflect the great deeds of the patricians who earned the privilege of resting here." },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_1, "Vault" },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_2, "Facade" },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_1_TEXT, "Masons are laying courses of precisely carved stones to form the central vault of this mausoleum." },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_2_TEXT, "Skilled artisans are preparing the facade of this mausoleum, carving gleaming marble statues to memorialize those who will rest here." },
    {TR_BUILDING_LARGE_MAUSOLEUM_CONSTRUCTION_DESC, "Constructing this mausoleum will require material stored in a warehouse, laborers from a work camp, and architects from an architects' guild." },
    {TR_FIGURE_TYPE_WATCHMAN, "Watchman" },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS, "This temple will collect food for your supply post, once one is constructed." },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MAINTENANCE, "Toggle prefects and engineers access" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_PRIEST, "Toggle priests access" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MARKET, "Toggle market supplier access" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_ENTERTAINER, "Toggle entertainer access" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_EDUCATION, "Toggle education walker access" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MEDICINE, "Toggle health walker access" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_TAX_COLLECTOR, "Toggle tax collector access" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_LABOR_SEEKER, "Toggle labor seekers access" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MISSIONARY, "Toggle missionary access" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_WATCHMAN, "Toggle watchmen access" },
    {TR_HOTKEY_DUPLICATE_TITLE, "Hotkey already used"},
    {TR_HOTKEY_DUPLICATE_MESSAGE, "This key combination is already assigned to the following action:"},
    {TR_BUILDING_GARDEN_PATH, "Garden Path" },
    {TR_BUTTON_GO_TO_SITE, "Go to the site" },
    {TR_BUTTON_HALT_MONUMENT_CONSTRUCTION, "Halt construction" },
    {TR_BUTTON_RESUME_MONUMENT_CONSTRUCTION, "Resume construction" },
    {TR_RESOURCE_FISH, "Fish"},
    {TR_RESOURCE_GOLD, "Gold"},
    {TR_RESOURCE_STONE, "Stone"},
    {TR_RESOURCE_SAND, "Sand"},
    {TR_RESOURCE_BRICKS, "Bricks"},
    {TR_RESOURCE_CONCRETE, "Concrete"},
    {TR_WARNING_VARIANT_TOGGLE, "Press the rotation key to cycle variants of this building"},
    {TR_BUILDING_SCHOOL_UPGRADE_DESC, "This school is operational. Local development allowed your citizens to expand the building, providing space for more children."},
    {TR_BUILDING_THEATRE_UPGRADE_DESC, "This theater is operational. Local development allowed your citizens to expand the building, providing more seating." },
    {TR_BUILDING_LIBRARY_UPGRADE_DESC, "This library is operational. Local development allowed your citizens to expand the building, providing additional scrolls and reading nooks." },
    {TR_WINDOW_BUILDING_INFO_WARNING_NO_MONUMENT_ROAD_ACCESS, "This monument construction site has no road access and cannot recieve materials. Connect a road to one of the middle tiles."},
    {TR_WINDOW_BUILDING_WORKSHOP_STRIKING, "Due to low city sentiment, the plebians of this workshop have declared secession and refuse to work!" },
    {TR_CITY_WARNING_SECESSION, "Plebians are refusing to work!" },
    {TR_CITY_WARNING_WAREHOUSE_BREAKIN, "A warehouse was looted!" },
    {TR_CITY_WARNING_GRANARY_BREAKIN, "A granary was looted!" },
    {TR_CITY_WARNING_THEFT, "Funds were stolen from a forum or senate!" },
    {TR_CITY_MESSAGE_TITLE_LOOTING, "Looting in the city!"},
    {TR_CITY_MESSAGE_TEXT_LOOTING, "A warehouse or granary was looted by angry citizens and goods were stolen! Low sentiment makes these incidents more likely."},
    {TR_SIDEBAR_EXTRA_INVASIONS, "Invasions" },
    {TR_SIDEBAR_EXTRA_INVASION_UNDERWAY, "Invasion underway" },
    {TR_SIDEBAR_EXTRA_NO_INVASIONS, "No invasions" },
    {TR_SIDEBAR_EXTRA_INVASION_IMMINENT, "Invasion imminent" },
    {TR_SIDEBAR_EXTRA_ENEMIES_CLOSING, "Enemies closing" },
    {TR_SIDEBAR_EXTRA_ENEMIES_DISTANT, "Enemies distant" },
    {TR_SIDEBAR_EXTRA_GODS, "Gods" },
    {TR_SIDEBAR_EXTRA_REQUESTS_VIEW_ALL, "View all" },
    {TR_SIDEBAR_EXTRA_REQUESTS_SMALL_FORCE, "Small force"},
    {TR_SIDEBAR_EXTRA_REQUESTS_AVERAGE_FORCE, "Average force"},
    {TR_SIDEBAR_EXTRA_REQUESTS_LARGE_FORCE, "Large force"},
    {TR_SIDEBAR_EXTRA_REQUESTS_SEND, "Send request"},
    {TR_SIDEBAR_EXTRA_REQUESTS_STOCK, "Store"},
    {TR_SIDEBAR_EXTRA_REQUESTS_UNSTOCK, "Stop storing"},
    {TR_TOOLTIP_ADVISOR_HOUSING_GRAPH_BUTTON, "Go to population graphs" },
    {TR_TOOLTIP_ADVISOR_POPULATION_HOUSING_BUTTON, "Visit your Housing Advisor" },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_ARCHITECT_NEEDED, "This monument has all the materials needed for this phase. Workers await a skilled architect from an architects' guild to oversee further construction." },
    {TR_RETURN_ALL_TO_FORT, "Return all" },
    {TR_TOOLTIP_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Games information" },
    {TR_WINDOW_BUILDING_GOVERNMENT_LARGE_STATUE_WATER_WARNING, "This statue would look even more impressive with its fountain working. Provide it with water access." },
    {TR_OPTION_MENU_APPLY, "Apply" },
    {TR_OPTION_MENU_COST, "This will cost" },
    {TR_FIGURE_TYPE_LOOTER, "Looter" },
    {TR_FIGURE_TYPE_ROBBER, "Robber" },
    {TR_OVERLAY_SENTIMENT, "Sentiment" },
    {TR_OVERLAY_EFFICIENCY, "Efficiency" },
    {TR_OVERLAY_STORAGES, "Storages" },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_0, "Nobody can remember the last time this building produced anything." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_1, "This building produces hardly anything." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_2, "Much more could be produced here if its efficiency were higher." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_3, "Work is often stopped at this building, and its efficiency is low." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_4, "This building is productive and has little downtime." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_5, "This building is producing at maximum efficiency." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_NO_COVERAGE, "Nobody" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_FULL_COVERAGE, "Everyone" },
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY, "Select a land trade policy"},
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY_REQUIRED, "A Caravanserai is required to set a land trade policy"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY, "Select a sea trade policy"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY_REQUIRED, "A Lighthouse is required to set a sea trade policy"},
    {TR_TOOLTIP_HOLD_GAME, "Hold the Games"},
    {TR_TOOLTIP_NO_GAME, "Do not hold the Games"},
    {TR_WARNING_NEARBY_WOLF, "Cannot build when wolves are nearby" },
    {TR_MARKET_TRADING, "Trading"},
    {TR_MARKET_NOT_TRADING, "Not trading"},
    {TR_TAVERN_FETCHING, "Fetching"},
    {TR_TAVERN_NOT_FETCHING, "Not fetching"},
    {TR_TEMPLE_DISTRIBUTING, "Distributing"},
    {TR_TEMPLE_NOT_DISTRIBUTING, "Not distributing"},
    {TR_ADVISOR_CHIEF_NO_IMMIGRATION_SQUALOR, "Squalid housing and slums prevent immigration"},
    {TR_CITY_MESSAGE_SQUALOR, "Squalid housing and slums are a problem"},
    {TR_FIGURE_TYPE_LIGHTHOUSE_SUPPLIER, "Lighthouse keeper" },
    {TR_WINDOW_GAMES_NO_WATER_ACCESS, "Venue does not have access to a reservoir." },
    {TR_HOTKEY_COPY_SETTINGS, "Copy building settings" },
    {TR_HOTKEY_PASTE_SETTINGS, "Paste building settings" },
    {TR_HOTKEY_MOTHBALL_TOGGLE, "Mothball/Enable building" },
    {TR_HOTKEY_SPECIAL_ORDERS, "Show building special orders" },
    {TR_WINDOW_ADVISOR_RELIGION_LARARIUMS, "Lararia in the city" },
    {TR_WINDOW_RACE_YOUR_BET, "Your bet"},
    {TR_WINDOW_RACE_BET_BUTTON, "Bet on a horse"},
    {TR_WINDOW_IN_PROGRESS_BET_BUTTON, "Race in progress..."},
    {TR_WINDOW_RACE_BET_TITLE, "Place a bet on a horse"},
    {TR_WINDOW_RACE_BET_AMOUNT, "Amount"},
    {TR_WINDOW_RACE_BET_DESCRIPTION, "Bet an amount of your personal funds on the chariot team of your choice, and double your stake if your horse wins. Your earnings will even be quadrupled during the Colosseum Games!"},
    {TR_WARNING_BET_VICTORY, "Your horse won the race at your city's Hippodrome"},
    {TR_WARNING_BET_DEFEAT, "Your horse lost the race at your city's Hippodrome"},
    {TR_PERSONAL_SAVINGS, "Savings :"},
    {TR_WINDOW_RACE_BET_BLUE_HORSE, "Bet on the blue horse"},
    {TR_WINDOW_RACE_BET_RED_HORSE, "Bet on the red horse"},
    {TR_WINDOW_RACE_BET_WHITE_HORSE, "Bet on the white horse"},
    {TR_WINDOW_RACE_BET_GREEN_HORSE, "Bet on the green horse"},
    {TR_BUILDING_GRAND_TEMPLE_NEEDS_WORKERS, "Without a full staff of priests and attendants, this temple cannot perform all the sacred rites and celebrations. Until that changes, you should not expect divine favour. "},
    {TR_BUILDING_COLOSSEUM_NEEDS_WORKERS, "The Colosseum is understaffed. More workers are needed to ensure all of your citizens enjoy the games."},
    {TR_BUILDING_HIPPODROME_NEEDS_WORKERS, "The Hippodrome is understaffed. More workers are needed to provide spectacular entertainment for all of your citizens."},
    {TR_BUILDING_LIGHTHOUSE_NEEDS_WORKERS, "The Lighthouse is understaffed, and cannot keep the fire going. Ships struggle to find the way to your city's docks."},
    {TR_BUILDING_CARAVANSERAI_NEEDS_WORKERS, "The Caravanserai is understaffed, and cannot keep up support to all the incoming caravans."},
    {TR_BUILDING_ROOFED_GARDEN_WALL, "Roofed garden wall"},
    {TR_BUILDING_GARDEN_WALL_GATE, "Garden wall gate"},
    {TR_BUILDING_GARDEN_WALL_GATE_DESC, "This small gate controls the movement of people in and out of your city's most secluded spots."},
    {TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_GETTING, "The cart pusher is on his way to get goods from another warehouse."},
    {TR_BUILDING_PALISADE, "Palisade" },
    {TR_BUILDING_PALISADE_DESC, "This earthen bank, topped by a high wall of sharpened wooden stakes, will keep your city safe from invaders and hostile animals."},
    {TR_OVERLAY_MOTHBALL, "Mothballed"},
    {TR_OVERLAY_ENEMY, "Enemies"},
    {TR_BUILDING_TAVERN_DESC_5, "Citizens love visiting this establishment in their free time to socialize over fine food and wine." },
    {TR_OVERLAY_WAREHOUSES, "Warehouses" },
    {TR_WINDOW_RACE_BLUE_HORSE_DESCRIPTION, "The Blue team - favourites of Neptune. These are the most promising of Rome's young charioteers who wish to prove themselves." },
    {TR_WINDOW_RACE_RED_HORSE_DESCRIPTION, "The Red team - known as the team of the most successful charioteer in the history of Rome - a former oarsman and saviour of a Roman consul." },
    {TR_WINDOW_RACE_WHITE_HORSE_DESCRIPTION, "The White team - founded by former gladiators. They have combat in their blood, and even as free men they live for the challenge." },
    {TR_WINDOW_RACE_GREEN_HORSE_DESCRIPTION, "The Green team - descendants of the 'Celeres' horsemen from the time of the Kingdom of Rome. They still claim to be the best of the best." },
    {TR_TOOLTIP_BUTTON_REJECT_WORKERS, "Resume resource delivery"},
    {TR_CONFIG_DIGIT_SEPARATOR, "Separate digits"},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_LABOR, "No labor" },
    {TR_WINDOW_BUILDING_DISTRIBUTION_GRANARY_CART_PUSHER_GETTING, "The cart pusher is on his way to get food from another granary."},
    {TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_RETURNING_WITH, "The cart pusher is returning with a delivery." },
    {TR_BUTTON_YEARLY_AUTOSAVE_OFF, "Yearly autosave OFF"},
    {TR_BUTTON_YEARLY_AUTOSAVE_ON, "Yearly autosave ON" },
    {TR_BUILDING_DOCK_PLAGUE_DESC, "The plague was brought here by a trade ship. This dock is in quarantine while a doctor or surgeon decontaminates the area."},
    {TR_BUILDING_GRANARY_PLAGUE_DESC, "The plague was brought here by a contaminated worker. This granary is in quarantine while a doctor or surgeon decontaminates the area."},
    {TR_BUILDING_GRANARY_NO_FOOD, "No food stored at this granary."},
    {TR_BUILDING_WAREHOUSE_PLAGUE_DESC, "The plague was brought here by a contaminated worker. This warehouse is in quarantine while a doctor or surgeon decontaminates the area."},
    {TR_BUILDING_WAREHOUSE_NO_GOODS, "No goods stored at this warehouse."},
    {TR_BUILDING_HOUSE_DISEASE_DESC, "Pestilence has struck! Without adequate healthcare, residents dwelling here have died. This house is in quarantine while a doctor or surgeon decontaminates the area."},
    {TR_BUILDING_FUMIGATION_DESC, "The building is being cleansed of disease. The fumigation should last a few days."},
    {TR_OVERLAY_SICKNESS, "Sickness"},
    {TR_ADVISOR_SICKNESS_LEVEL_LOW, "Disease is a rare occurrence in the city. The high standard of healthcare provided to the vast majority of residents effectively prevents epidemics spreading here."},
    {TR_ADVISOR_SICKNESS_LEVEL_MEDIUM, "Some infectious diseases have appeared in areas of the city with a lacking hygiene, but the situation is under control. A sufficiently high level of healthcare will mitigate the impact of epidemics in the city."},
    {TR_ADVISOR_SICKNESS_LEVEL_HIGH, "Infectious diseases spread in areas of the city having a poor level of hygiene. If the situation is not remedied soon, some buildings may be quarantined. Greater access to healthcare would effectively prevent epidemics from breaking out."},
    {TR_ADVISOR_SICKNESS_LEVEL_PLAGUE, "The plague has come to some unhealthy areas in the city! Citizens fall ill and buildings have been quarantined or burned to prevent the further spread of disease. Available doctors and surgeons have been requisitioned to decontaminate the afflicted places. Action must be taken!"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_NONE, "No disease"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_LOW, "Very few diseases"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_MEDIUM, "A few infectious diseases"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_HIGH, "Many infectious diseases spreading"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_PLAGUE, "Plague stalks this land"},
    {TR_CITY_MESSAGE_TITLE_SICKNESS, "Plague in the city"},
    {TR_CITY_MESSAGE_TEXT_SICKNESS, "Plague has broken out in the city! A building is in quarantine, and doctors or surgeons have been requisitioned to decontaminate it."},
    {TR_FIGURES_CARTPUSHER_GOING_TO_ROME, "Delivering the request to Rome"},
    {TR_CITY_WARNING_DATA_COPY_SUCCESS, "Settings copied" },
    {TR_CITY_WARNING_DATA_COPY_NOT_SUPPORTED, "Can't copy from this building" },
    {TR_CITY_WARNING_DATA_PASTE_SUCCESS, "Settings pasted" },
    {TR_CITY_WARNING_DATA_PASTE_NOT_SUPPORTED, "Can't paste" },
    {TR_CITY_WARNING_DATA_MOTHBALL_ON, "Building is now mothballed" },
    {TR_CITY_WARNING_DATA_MOTHBALL_OFF, "Building is now active" },
    {TR_CITY_WARNING_GOLD_NEEDED, "This building needs gold"},
    {TR_CITY_WARNING_BUILD_GOLD_MINE, "Build a gold mine"},
    {TR_CITY_WARNING_SAND_NEEDED, "This building needs sand"},
    {TR_CITY_WARNING_BUILD_SAND_PIT, "Build a sand pit"},
    {TR_CITY_WARNING_STONE_NEEDED, "This building needs stone"},
    {TR_CITY_WARNING_BUILD_STONE_QUARRY, "Build a stone quarry"},
    {TR_CITY_WARNING_SENATE_NEEDED, "This building needs a working senate"},
    {TR_CITY_WARNING_BUILD_SENATE, "Build a senate"},
    {TR_HOTKEY_SHOW_OVERLAY_EFFICIENCY, "Efficiency overlay"},
    {TR_HOTKEY_SHOW_OVERLAY_FOOD_STOCKS, "Food Stocks overlay"},
    {TR_HOTKEY_SHOW_OVERLAY_ENTERTAINMENT, "Entertainment overlay" },
    {TR_HOTKEY_SHOW_OVERLAY_EDUCATION, "Education overlay" },
    {TR_HOTKEY_SHOW_OVERLAY_SCHOOL, "Schools overlay" },
    {TR_HOTKEY_SHOW_OVERLAY_LIBRARY, "Library overlay" },
    {TR_HOTKEY_SHOW_OVERLAY_ACADEMY, "Academy overlay" },
    {TR_HOTKEY_SHOW_OVERLAY_BARBER, "Barber overlay" },
    {TR_HOTKEY_SHOW_OVERLAY_BATHHOUSE, "Baths overlay" },
    {TR_HOTKEY_SHOW_OVERLAY_CLINIC, "Clinics overlay" },
    {TR_HOTKEY_SHOW_OVERLAY_HOSPITAL, "Hospital overlay" },
    {TR_HOTKEY_SHOW_OVERLAY_SICKNESS, "Sickness overlay" },
    {TR_HOTKEY_SHOW_OVERLAY_TAX_INCOME, "Tax Income overlay" },
    {TR_HOTKEY_SHOW_OVERLAY_DESIRABILITY, "Desirability overlay" },
    {TR_HOTKEY_SHOW_OVERLAY_SENTIMENT, "Sentiment overlay" },
    {TR_HOTKEY_SHOW_OVERLAY_MOTHBALL, "Mothballed overlay" },
    {TR_HOTKEY_SHOW_OVERLAY_RELIGION, "Religion overlay" },
    {TR_HOTKEY_SHOW_OVERLAY_ROADS, "Roads overlay" },
    {TR_HOTKEY_SHOW_OVERLAY_LEVY, "Levies overlay" },
    {TR_HOTKEY_ROTATE_MAP_NORTH, "Rotate map to North" },
    {TR_HOTKEY_BUILD_WHEAT_FARM, "Wheat farm" },
    {TR_HOTKEY_SHOW_MESSAGES, "Show messages"},
    {TR_HOTKEY_SHOW_EMPIRE_MAP, "Show empire map"},
    {TR_TOGGLE_GRID, "Toggle grid"},
    {TR_WARNING_SCREENSHOT_SAVED, "Screenshot saved: "},
    {TR_OUT_OF_MONEY, "Out of money"},
    {TR_CITY_MESSAGE_TITLE_EMPERORS_WRATH, "Emperor's anger" },
    {TR_CITY_MESSAGE_TEXT_EMPERORS_WRATH, "You have fallen from Caesar's grace and so he has ordered your arrest. Unless you restore your favor with the emperor, his elite legionaries will soon invade your city!" },
    {TR_BUILDING_ACADEMY_UPGRADE_DESC, "This academy is operational. Local development allowed your citizens to expand the building, providing more halls for orations and research to take place."},
    {TR_BUILDING_PALISADE_GATE, "Palisade gate"},
    {TR_BUILDING_PALISADE_GATE_DESC, "This narrow wooden gateway controls the movement of people in and out of your city's defences."},
    {TR_SAVE_DIALOG_INVALID_FILE, "Invalid file"},
    {TR_SAVE_DIALOG_INVALID_FILE_DESC, "The savegame you're trying to load is invalid.\n\nThe save may have been corrupted due to a bug.\n\nIf you're sure this should be a valid save, please report the bug to:\n\nhttps://github.com/Keriew/augustus/issues/new\n\nPlease attach the save as well."},
    {TR_SAVE_DIALOG_INCOMPATIBLE_VERSION, "Incompatible version"},
    {TR_SAVE_DIALOG_NEW_FILE, "New file"},
    {TR_SAVE_DIALOG_SELECT_FILE, "Select a file"},
    {TR_SAVE_DIALOG_FUNDS, "Funds:"},
    {TR_SAVE_DIALOG_POPULATION, "Population:"},
    {TR_SAVE_DIALOG_DATE, "Date:"},
    {TR_SAVE_DIALOG_CUSTOM_SCENARIO, "Custom scenario"},
    {TR_SAVE_DIALOG_FIRST_MISSION, "First mission"},
    {TR_SAVE_DIALOG_MISSION, "Mission"},
    {TR_SAVE_DIALOG_MILITARY, "Military"},
    {TR_SAVE_DIALOG_PEACEFUL, "Peaceful"},
    {TR_SAVE_DIALOG_FILTER, "Filter"},
    {TR_SAVE_DIALOG_SORTING_BY_NAME, "Sorting by name"},
    {TR_SAVE_DIALOG_SORTING_BY_DATE, "Sorting by date"},
    {TR_SAVE_DIALOG_OVERWRITE_FILE, "Overwrite file?"},
    {TR_SAVE_DIALOG_OVERWRITE_FILE_DESC, "The file already exists. Overwrite?"},
    {TR_SAVE_DIALOG_OVERWRITE_FILE_DO_NOT_ASK_AGAIN, "Do not ask again"},
    {TR_CITY_MESSAGE_TITLE_MARS_MINOR_CURSE_PREVENTED, "Wrath of Mars" },
    {TR_CITY_MESSAGE_TEXT_MARS_MINOR_CURSE_PREVENTED, "Mars is enraged! We have little to be afraid of in such a peaceful land, but be sure, that peace will not last forever!" },
    {TR_TOOLTIP_MONUMENT_PHASE, " phase. "},
    {TR_TOOLTIP_MONUMENT_PHASES, " phases. "},
    {TR_TOOLTIP_MONUMENT_RESOURCE_REQUIREMENTS, "Resource requirements:\n"},
    {TR_BUILDING_GLADIATOR_STATUE, "Gladiator statue"},
    {TR_BUILDING_HIGHWAY, "Highway"},
    {TR_BUILDING_HIGHWAY_DESC, "Highways allow citizens to reach their destination more quickly."},
    {TR_BUILDING_GOLD_MINE, "Gold mine"},
    {TR_BUILDING_GOLD_MINE_DESC, "Mine gold for trade, or to supply your city mint in order to generate denarii."},
    {TR_BUILDING_GOLD_MINE_PRODUCTION, "Production is"},
    {TR_BUILDING_GOLD_MINE_COMPLETE, "complete."},
    {TR_BUILDING_GOLD_MINE_HALTED, "Your Trade Advisor ordered a halt to gold mining."},
    {TR_BUILDING_GOLD_MINE_NO_EMPLOYEES, "This mine has no employees. Production has ceased."},
    {TR_BUILDING_GOLD_MINE_FULL_EMPLOYEES, "This mine has all the employees it needs, and is working flat out to produce gold."},
    {TR_BUILDING_GOLD_MINE_MANY_EMPLOYEES, "This mine is working below maximum capacity. Gold mining could be slightly more efficient with more miners."},
    {TR_BUILDING_GOLD_MINE_HALF_EMPLOYEES, "This mine is understaffed. It is taking longer to produce gold than it should."},
    {TR_BUILDING_GOLD_MINE_SOME_EMPLOYEES, "Very few people work in this mine. Gold production is slow as a result."},
    {TR_BUILDING_GOLD_MINE_FEW_EMPLOYEES, "With hardly any miners here, output has nearly stopped.It will produce little gold over the coming year."},
    {TR_BUILDING_STONE_QUARRY, "Stone quarry"},
    {TR_BUILDING_STONE_QUARRY_DESC, "Quarry stone for monument construction."},
    {TR_BUILDING_STONE_QUARRY_PRODUCTION, "Production is"},
    {TR_BUILDING_STONE_QUARRY_COMPLETE, "complete."},
    {TR_BUILDING_STONE_QUARRY_HALTED, "Your Trade Advisor ordered a halt to stone quarrying."},
    {TR_BUILDING_STONE_QUARRY_NO_EMPLOYEES, "This quarry has no employees. Production has ceased."},
    {TR_BUILDING_STONE_QUARRY_FULL_EMPLOYEES, "This quarry has all the employees it needs, and is working flat out to produce stone." },
    {TR_BUILDING_STONE_QUARRY_MANY_EMPLOYEES, "This quarry is working below maximum capacity. Stone quarrying could be slightly more efficient with more workers." },
    {TR_BUILDING_STONE_QUARRY_HALF_EMPLOYEES, "This quarry is understaffed. It is taking longer to produce stone than it should." },
    {TR_BUILDING_STONE_QUARRY_SOME_EMPLOYEES, "Very few people work in this quarry. Stone production is slow as a result." },
    {TR_BUILDING_STONE_QUARRY_FEW_EMPLOYEES, "With hardly any quarry workers here, output has nearly stopped. It will produce little stone over the coming year."},
    {TR_BUILDING_SAND_PIT, "Sand pit"},
    {TR_BUILDING_SAND_PIT_DESC, "Mine sand for monument construction."},
    {TR_BUILDING_SAND_PIT_PRODUCTION, "Production is"},
    {TR_BUILDING_SAND_PIT_COMPLETE, "complete."},
    {TR_BUILDING_SAND_PIT_HALTED, "Your Trade Advisor ordered a halt to sand mining."},
    {TR_BUILDING_SAND_PIT_NO_EMPLOYEES, "This pit has no employees. Production has ceased."},
    {TR_BUILDING_SAND_PIT_FULL_EMPLOYEES, "This pit has all the employees it needs, and is working flat out to mine sand."},
    {TR_BUILDING_SAND_PIT_MANY_EMPLOYEES, "This pit is working below maximum capacity. Sand mining could be slightly more efficient with more workers."},
    {TR_BUILDING_SAND_PIT_HALF_EMPLOYEES, "This pit is understaffed. It is taking longer to mine sand than it should."},
    {TR_BUILDING_SAND_PIT_SOME_EMPLOYEES, "Very few people work in this pit. Sand production is slow as a result."},
    {TR_BUILDING_SAND_PIT_FEW_EMPLOYEES, "With hardly any pit workers here, output has nearly stopped. It will produce little sand over the coming year."},
    {TR_BUILDING_BRICKWORKS, "Brickworks"},
    {TR_BUILDING_BRICKWORKS_DESC, "Here, sand and clay are processed into bricks for monument construction."},
    {TR_BUILDING_BRICKWORKS_PRODUCTION, "Production is"},
    {TR_BUILDING_BRICKWORKS_COMPLETE, "complete."},
    {TR_BUILDING_BRICKWORKS_HALTED, "Your Trade Advisor ordered a halt to brick production."},
    {TR_BUILDING_BRICKWORKS_NO_EMPLOYEES, "This workshop has no employees. Production has ceased."},
    {TR_BUILDING_BRICKWORKS_FULL_EMPLOYEES, "This workshop has all the employees it needs, and is working flat out to produce bricks."},
    {TR_BUILDING_BRICKWORKS_MANY_EMPLOYEES, "This workshop is working below maximum capacity. Brick production could be slightly more efficient with more workers."},
    {TR_BUILDING_BRICKWORKS_HALF_EMPLOYEES, "This workshop is understaffed. It is taking longer to produce bricks than it should."},
    {TR_BUILDING_BRICKWORKS_SOME_EMPLOYEES, "Very few people work in this workshop. Brick production is slow as a result."},
    {TR_BUILDING_BRICKWORKS_FEW_EMPLOYEES, "With hardly any workers here, output has nearly stopped. It will produce few bricks over the coming year."},
    {TR_BUILDING_BRICKWORKS_NO_RESOURCES, "This workshop needs clay and sand delivered to it, from a warehouse or a sand pit and clay pit, to produce bricks."},
    {TR_BUILDING_BRICKWORKS_STORED_SAND, "Stored sand,"},
    {TR_BUILDING_BRICKWORKS_STORED_CLAY, "Stored clay,"},
    {TR_BUILDING_CONCRETE_MAKER, "Concrete Maker"},
    {TR_BUILDING_CONCRETE_MAKER_DESC, "Here, sand is mixed into concrete for monument construction."},
    {TR_BUILDING_CONCRETE_MAKER_PRODUCTION, "Production is"},
    {TR_BUILDING_CONCRETE_MAKER_COMPLETE, "complete."},
    {TR_BUILDING_CONCRETE_MAKER_HALTED, "Your Trade Advisor ordered a halt to concrete production."},
    {TR_BUILDING_CONCRETE_MAKER_NO_EMPLOYEES, "This workshop has no employees. Production has ceased."},
    {TR_BUILDING_CONCRETE_MAKER_FULL_EMPLOYEES, "This workshop has all the employees it needs, and is working flat out to produce concrete."},
    {TR_BUILDING_CONCRETE_MAKER_MANY_EMPLOYEES, "This workshop is working below maximum capacity. Concrete production could be slightly more efficient with more workers."},
    {TR_BUILDING_CONCRETE_MAKER_HALF_EMPLOYEES, "This workshop is understaffed. It is taking longer to produce concrete than it should."},
    {TR_BUILDING_CONCRETE_MAKER_SOME_EMPLOYEES, "Very few people work in this workshop. Concrete production is slow as a result."},
    {TR_BUILDING_CONCRETE_MAKER_FEW_EMPLOYEES, "With hardly any workers here, output has nearly stopped. It will produce little concrete over the coming year."},
    {TR_BUILDING_CONCRETE_MAKER_NO_RESOURCES, "This workshop needs water access from a reservoir, fountain or well, as well as sand delivered to it, from a warehouse or a sand pit, to mix concrete."},
    {TR_BUILDING_CONCRETE_MAKER_STORED_SAND, "Stored sand,"},
    {TR_BUILDING_CONCRETE_MAKER_NO_TARGETS, "There are no buildings requiring concrete. Production has stopped."},
    {TR_BUILDING_CONCRETE_MAKER_IMPROVE_WATER_ACCESS, "This workshop only has well or fountain access. Output could be improved if direct reservoir access was available."},
    {TR_BUILDING_CITY_MINT, "City mint"},
    {TR_BUILDING_CITY_MINT_PHASE_1, "(Foundation)"},
    {TR_BUILDING_CITY_MINT_PHASE_1_TEXT, "Engineers lay the foundation of the building."},
    {TR_BUILDING_CITY_MINT_DESC, "Here, gold is minted into coin, which fills your city's treasury."},
    {TR_BUILDING_CITY_MINT_DESC_ALTERNATIVE, "Here, coin is melted into gold, which can be used for monument construction."},
    {TR_BUILDING_CITY_MINT_DESC_NO_PALACE, "Build your palace to also collect personal funds from the city mint."},
    {TR_BUILDING_CITY_MINT_DESC_PALACE, "Since you own a palace, extra coin is being added to your personal funds."},
    {TR_BUILDING_CITY_MINT_NO_EMPLOYEES, "The city mint has no employees. Production has ceased."},
    {TR_BUILDING_CITY_MINT_FULL_EMPLOYEES, "The city mint has all the employees it needs. It is working flat out to mint coin or melt it for gold."},
    {TR_BUILDING_CITY_MINT_MANY_EMPLOYEES, "The city mint is working below maximum capacity. Coin minting or gold production will be slightly slower as a result."},
    {TR_BUILDING_CITY_MINT_HALF_EMPLOYEES, "The city mint is understaffed, and it takes longer to mint coin or melt it for gold than it should."},
    {TR_BUILDING_CITY_MINT_SOME_EMPLOYEES, "Very few people work here. Coin minting or gold production is slow as a result."},
    {TR_BUILDING_CITY_MINT_FEW_EMPLOYEES, "With hardly any employees at this workshop, it is at a virtual standstill. It will almost produce nothing over the coming year."},
    {TR_BUILDING_CITY_MINT_NO_GOLD, "This workshop needs gold delivered to it, from a warehouse or a gold mine, to mint coin."},
    {TR_BUILDING_CITY_MINT_STORED_GOLD, "Stored gold,"},
    {TR_BUILDING_CITY_MINT_NO_SENATE, "This building requires an active senate to work. Without such a building, no coin can be minted."},
    {TR_BUILDING_CITY_MINT_CONVERT, "Convert:"},
    {TR_BUILDING_CITY_MINT_GOLD_TO_DN, "One cartload of gold to 500 denarii"},
    {TR_BUILDING_CITY_MINT_DN_TO_GOLD, "600 denarii to one cartload of gold"},
    {TR_BUILDING_CITY_MINT_CHANGE_PRODUCTION, "Change city mint production?"},
    {TR_BUILDING_CITY_MINT_PROGRESS_WILL_BE_LOST, "Current production progress will be lost."},
    {TR_ADVISOR_NO_ACTIVE_COLOSSEUM, "No active colosseum in the city"},
    {TR_ADVISOR_ACTIVE_COLOSSEUM, "The city is served by the colosseum"},
    {TR_ADVISOR_NO_ACTIVE_HIPPODROME, "No active hippodrome in the city"},
    {TR_ADVISOR_ACTIVE_HIPPODROME, "The city is served by the hippodrome"},
    {TR_WINDOW_ADVISOR_EDUCATION_MISSION_POSTS, "Mission posts"},
    {TR_CITY_MESSAGE_TITLE_ENEMIES_LEAVING, "Enemies retreating"},
    {TR_CITY_MESSAGE_TEXT_ENEMIES_LEAVING, "Humpf! Your puny city has nothing else worth destroying. We'll be leaving for now, but beware, we can always come back!"},
    {TR_ZOOM, "Zoom:"},
    {TR_WINDOW_ASSET_PREVIEWER_TITLE, "Asset Previewer"},
    {TR_WINDOW_ASSET_PREVIEWER_GROUP, "Group:"},
    {TR_WINDOW_ASSET_PREVIEWER_NO_GROUPS, "( no groups )"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN, "Terrain:"},
    {TR_WINDOW_ASSET_PREVIEWER_PLAY_ANIMATIONS, "Play animations"},
    {TR_WINDOW_ASSET_PREVIEWER_REFRESH, "Refresh"},
    {TR_WINDOW_ASSET_PREVIEWER_QUIT, "Quit"},
    {TR_WINDOW_ASSET_PREVIEWER_ASSET, "Asset:"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_NONE, "None" },
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_CENTRAL, "Central"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_NORTHERN, "Northern"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_DESERT, "Desert"},
    {TR_WINDOW_ASSET_PREVIEWER_NO_ASSETS, "No assets"},
    {TR_WINDOW_ASSET_PREVIEWER_UNNAMED_ASSET, "( unnamed asset )"},
    {TR_WINDOW_ASSET_PREVIEWER_ANIMATION_FRAME, "( animation frame )"},
    {TR_WINDOW_ASSET_PREVIEWER_SHOW_ANIMATION_FRAMES, "Show animation frames"},
    {TR_WINDOW_ASSET_PREVIEWER_ASSETS_REFRESHED, "Assets refreshed" },
    {TR_CHEAT_ADDED_MONEY, "Added money"},
    {TR_CHEAT_STARTED_INVASION, "Started invasion"},
    {TR_CHEAT_YEAR_ADVANCED, "Year advanced"},
    {TR_CHEAT_CASTED_BLESSING, "Casted blessing"},
    {TR_CHEAT_TOGGLE_TOOLTIPS, "Show tooltip toggled"},
    {TR_CHEAT_KILLED_ALL_WALKERS, "Killed all walkers"},
    {TR_CHEAT_FINISHED_MONUMENTS, "Monuments finished"},
    {TR_CHEAT_UPDATED_MONUMENTS, "Monuments updated"},
    {TR_CHEAT_UNLOCKED_ALL_BUILDINGS, "All buildings unlocked"},
    {TR_CHEAT_INCITED_RIOT, "Incited a riot"},
    {TR_CITY_MESSAGE_TITLE_ROAD_TO_ROME_WARNING, "City Inacessible" },
    {TR_CITY_MESSAGE_TEXT_ROAD_TO_ROME_WARNING, "The road to Rome is obstructed. Unless we immediately restore the access to the imperial highway, the engineers from Rome will be forced to take action." },
    {TR_CITY_MESSAGE_TITLE_TRADE_ROUTE_PRICE_CHANGE, "Trade route price" },
    {TR_CITY_MESSAGE_TEXT_TRADE_ROUTE_PRICE_CHANGE, "The price for opening a trade route has changed." },
    {TR_EDITOR_CHOOSE_CUSTOM_EMPIRE, "Choose custom empire"},
    {TR_EDITOR_CUSTOM_EMPIRE_TITLE, "Loading an empire"},
    {TR_EDITOR_UNABLE_TO_LOAD_EMPIRE_TITLE, "Unable to load custom empire"},
    {TR_EDITOR_UNABLE_TO_LOAD_EMPIRE_MESSAGE, "Please check augustus-log.txt in your Augustus directory for details."},
    {TR_EDITOR_SHORT_ROUTE_TEXT, "rt"},
    {TR_EDITOR_TOGGLE_INVASIONS, "Toggle invasions"},
    {TR_EDITOR_REFRESH_EMPIRE, "Refresh (F5)"},
    {TR_EDITOR_CITY_PREVIEW, "City image preview: "},
    {TR_EDITOR_CURRENT_COORDS, "Current coords: "},
    {TR_EDITOR_SELECTED_COORDS, "Selected coords: "},
    {TR_EDITOR_MAX_WAGES, "Up to"},
    {TR_EDITOR_MIN_WAGES, "Down to"},
    {TR_EDITOR_FAVOUR_DISFAVOR, "Favor lost if extension needed"},
    {TR_EDITOR_FAVOUR_IGNORED, "Favor lost if request ignored entirely"},
    {TR_EDITOR_FAVOUR_EXTENSION_MONTHS, "Extension months allowed"},
    {TR_EDITOR_SCENARIO_EVENTS_TITLE, "Scenario events" },
    {TR_EDITOR_SCENARIO_EVENTS_IMPORT, "Import" },
    {TR_EDITOR_SCENARIO_EVENTS_IMPORT_FULL, "Import scenario events" },
    {TR_EDITOR_SCENARIO_EVENTS_EXPORT, "Export" },
    {TR_EDITOR_SCENARIO_EVENTS_EXPORT_FULL, "Export scenario events" },
    {TR_EDITOR_SCENARIO_EVENTS_CLEAR, "Clear all events" },
    {TR_EDITOR_SCENARIO_EVENTS_COUNT, "scenario events" },
    {TR_EDITOR_SCENARIO_EVENTS_CONDITIONS, "conditions" },
    {TR_EDITOR_SCENARIO_EVENTS_ACTIONS, "actions" },
    {TR_EDITOR_UNABLE_TO_LOAD_EVENTS_TITLE, "Unable to load scenario events"},
    {TR_EDITOR_CHECK_LOG_MESSAGE, "Please check augustus-log.txt in your Augustus directory for details."},
    {TR_EDITOR_UNABLE_TO_SAVE_EVENTS_TITLE, "Unable to save scenario events"},
    {TR_EDITOR_IMPORT_LINE, "Line: "},
    {TR_EDITOR_SCENARIO_EVENT_ID, "ID: "},
    {TR_EDITOR_SCENARIO_EVENT_REPEAT_MIN_MONTHS, "Min months before repeat: "},
    {TR_EDITOR_SCENARIO_EVENT_REPEAT_MAX_MONTHS, "Max months before repeat: "},
    {TR_EDITOR_SCENARIO_EVENT_MAX_NUM_REPEATS, "Maximum number of repeats: "},
    {TR_EDITOR_SCENARIO_EVENT_REPEATS_FOREVER, "Infinite"},
    {TR_EDITOR_SCENARIO_EVENT_DOES_NOT_REPEAT, "Does not repeat."},
    {TR_EDITOR_SCENARIO_EVENT_STATE_UNDEFINED, "Undefined"},
    {TR_EDITOR_SCENARIO_EVENT_STATE_DISABLED, "Disabled"},
    {TR_EDITOR_SCENARIO_EVENT_STATE_ACTIVE, "Active"},
    {TR_EDITOR_SCENARIO_EVENT_STATE_PAUSED, "Paused"},
    {TR_EDITOR_SCENARIO_EVENT_EXECUTION_COUNT, "Execution count: "},
    {TR_EDITOR_SCENARIO_EVENT_MONTHS_UNTIL_ACTIVE, "Months until active: "},
    {TR_EDITOR_SCENARIO_CONDITION, "Condition"},
    {TR_EDITOR_SCENARIO_ACTION, "Action"},
    {TR_EDITOR_SCENARIO_EVENTS_ADD, "Add new event"},
    {TR_EDITOR_SCENARIO_CONDITION_ADD, "Add new condition"},
    {TR_EDITOR_SCENARIO_ACTION_ADD, "Add new action"},
    {TR_EDITOR_DELETE, "Delete"},
    {TR_EDITOR_DELETED, "Deleted"},
    {TR_EDITOR_SCENARIO_EVENT_DELETED, "Deleted event"},
    {TR_EDITOR_CUSTOM_MESSAGES_TITLE, "Custom messages" },
    {TR_EDITOR_CUSTOM_MESSAGES_COUNT, "Total messages" },
    {TR_EDITOR_CUSTOM_MESSAGES_CLEAR, "Clear messages" },
    {TR_EDITOR_CUSTOM_MESSAGES_IMPORT_FULL, "Import custom messages" },
    {TR_EDITOR_CUSTOM_MESSAGES_EXPORT_FULL, "Export custom messages" },
    {TR_EDITOR_UNABLE_TO_LOAD_CUSTOM_MESSAGES_TITLE, "Unable to load custom messages"},
    {TR_EDITOR_SCENARIO_SELECT_INTRO, "Select scenario intro"},
    {TR_EDITOR_SCENARIO_DESELECT_INTRO, "Deselect scenario intro"},
    {TR_EDITOR_CUSTOM_VARIABLES_TITLE, "Custom variables" },
    {TR_EDITOR_CUSTOM_VARIABLES_COUNT, "Maximum possible variables" },
    {TR_EDITOR_GRID_OFFSET, " offset" },
    {TR_PARAMETER_TYPE_CHECK, "Comparison check"},
    {TR_PARAMETER_TYPE_MIN_MAX_NUMBER_MIN, "Minimum"},
    {TR_PARAMETER_TYPE_MIN_MAX_NUMBER_MAX, "Maximum"},
    {TR_PARAMETER_TYPE_DIFFICULTY, "Difficulty"},
    {TR_PARAMETER_TYPE_BOOLEAN, "True or False"},
    {TR_PARAMETER_TYPE_NUMBER, "Number"},
    {TR_PARAMETER_TYPE_RESOURCE, "Resource"},
    {TR_PARAMETER_TYPE_POP_CLASS, "Population class"},
    {TR_PARAMETER_TYPE_BUILDING_COUNTING, "Building type for counting"},
    {TR_PARAMETER_TYPE_ALLOWED_BUILDING, "Allowable building type"},
    {TR_PARAMETER_TYPE_ROUTE, "Target trade route"},
    {TR_PARAMETER_TYPE_STANDARD_MESSAGE, "Standard message"},
    {TR_PARAMETER_TYPE_FUTURE_CITY, "Target future trade city"},
    {TR_PARAMETER_USE_PERCENTAGE, "Use percentage?"},
    {TR_PARAMETER_IN_CITY_ONLY, "Only count soldiers in the city?"},
    {TR_PARAMETER_CHECK_FOR_ONGOING, "Check that it is ongoing?"},
    {TR_PARAMETER_SHOW_MESSAGE, "Show message?"},
    {TR_PARAMETER_SET_TO_VALUE, "Set to value?"},
    {TR_PARAMETER_ADD_AS_BUYING, "Add as buying?"},
    {TR_PARAMETER_PRODUCED, "Produced?"},
    {TR_PARAMETER_ALLOWED, "Allowed?"},
    {TR_PARAMETER_SET_BUY_PRICE, "Set buy price?"},
    {TR_PARAMETER_CHECK_FOR_OPEN, "Check for route being open?"},
    {TR_PARAMETER_RESPECT_SETTINGS, "Respect storage settings?"},
    {TR_PARAMETER_TYPE_CUSTOM_MESSAGE, "Custom message"},
    {TR_PARAMETER_TYPE_CUSTOM_VARIABLE, "Custom variable"},
    {TR_PARAMETER_TYPE_RATING_TYPE, "Rating type"},
    {TR_PARAMETER_TYPE_STORAGE_TYPE, "Storage type"},
    {TR_PARAMETER_APPLY_COST, "Apply the open cost?"},
    {TR_PARAMETER_DESTROY_ALL, "Destroy all types?"},
    {TR_PARAMETER_GRID_OFFSET, "Grid offset"},
    {TR_PARAMETER_RADIUS, "Radius"},
    {TR_PARAMETER_TYPE_INVASION_SIZE, "Size"},
    {TR_PARAMETER_TYPE_INVASION_TYPE, "Attack type"},
    {TR_PARAMETER_TYPE_INVASION_POINT, "Invasion point"},
    {TR_PARAMETER_TYPE_TARGET_TYPE, "Target type"},
    {TR_PARAMETER_TYPE_ENEMY_TYPE, "Enemy type"},
    {TR_CONDITION_TYPE_TIME_PASSED, "Time passed"},
    {TR_CONDITION_TYPE_DIFFICULTY, "Difficulty"},
    {TR_CONDITION_TYPE_MONEY, "City money"},
    {TR_CONDITION_TYPE_SAVINGS, "Personal savings"},
    {TR_CONDITION_TYPE_STATS_FAVOR, "Favor"},
    {TR_CONDITION_TYPE_STATS_PROSPERITY, "Prosperity"},
    {TR_CONDITION_TYPE_STATS_CULTURE, "Culture"},
    {TR_CONDITION_TYPE_STATS_PEACE, "Peace"},
    {TR_CONDITION_TYPE_TRADE_SELL_PRICE, "Trade sell price"},
    {TR_CONDITION_TYPE_POPS_UNEMPLOYMENT, "Unemployment"},
    {TR_CONDITION_TYPE_ROME_WAGES, "Wages paid by Rome"},
    {TR_CONDITION_TYPE_CITY_POPULATION, "City population"},
    {TR_CONDITION_TYPE_BUILDING_COUNT_ACTIVE, "Active count of building type"},
    {TR_CONDITION_TYPE_STATS_CITY_HEALTH, "City health"},
    {TR_CONDITION_TYPE_COUNT_OWN_TROOPS, "Count of own troops"},
    {TR_CONDITION_TYPE_REQUEST_IS_ONGOING, "Request is ongoing"},
    {TR_CONDITION_TYPE_TAX_RATE, "Tax rate"},
    {TR_CONDITION_TYPE_BUILDING_COUNT_ANY, "Count of building type"},
    {TR_CONDITION_TYPE_CUSTOM_VARIABLE_CHECK, "Custom variable value"},
    {TR_CONDITION_TYPE_TRADE_ROUTE_OPEN, "Trade route is open"},
    {TR_CONDITION_TYPE_TRADE_ROUTE_PRICE, "Trade route open price"},
    {TR_CONDITION_TYPE_RESOURCE_STORED_COUNT, "Resource stored count"},
    {TR_CONDITION_TYPE_RESOURCE_STORAGE_AVAILABLE, "Resource storage available"},
    {TR_CONDITION_TYPE_BUILDING_COUNT_AREA, "Buildings in area"},
    {TR_ACTION_TYPE_ADJUST_FAVOR, "Adjust favor"},
    {TR_ACTION_TYPE_ADJUST_MONEY, "Adjust money"},
    {TR_ACTION_TYPE_ADJUST_SAVINGS, "Adjust savings"},
    {TR_ACTION_TYPE_TRADE_ADJUST_PRICE, "Adjust trade price"},
    {TR_ACTION_TYPE_TRADE_PROBLEM_LAND, "Start land trade problem"},
    {TR_ACTION_TYPE_TRADE_PROBLEM_SEA, "Start sea trade problem"},
    {TR_ACTION_TYPE_TRADE_ADJUST_ROUTE_AMOUNT, "Adjust trade route traded amount"},
    {TR_ACTION_TYPE_ADJUST_ROME_WAGES, "Adjust Rome wages"},
    {TR_ACTION_TYPE_GLADIATOR_REVOLT, "Start gladiator revolt"},
    {TR_ACTION_TYPE_CHANGE_RESOURCE_PRODUCED, "Change local resources available"},
    {TR_ACTION_TYPE_CHANGE_ALLOWED_BUILDINGS, "Allow or disallow buildings"},
    {TR_ACTION_TYPE_SEND_STANDARD_MESSAGE, "Send standard message"},
    {TR_ACTION_TYPE_ADJUST_CITY_HEALTH, "Adjust city health"},
    {TR_ACTION_TYPE_TRADE_SET_PRICE, "Set trade price"},
    {TR_ACTION_TYPE_EMPIRE_MAP_CONVERT_FUTURE_TRADE_CITY, "Convert empire future trade city"},
    {TR_ACTION_TYPE_REQUEST_IMMEDIATELY_START, "Immediately start request"},
    {TR_ACTION_TYPE_SHOW_CUSTOM_MESSAGE, "Show custom message"},
    {TR_ACTION_TYPE_TAX_RATE_SET, "Set tax rate"},
    {TR_ACTION_TYPE_CHANGE_CUSTOM_VARIABLE, "Change custom variable value"},
    {TR_ACTION_TYPE_TRADE_ADJUST_ROUTE_OPEN_PRICE, "Change trade route open cost"},
    {TR_ACTION_TYPE_A_MESSAGE, "A message"},
    {TR_ACTION_TYPE_CHANGE_CITY_RATING, "Change city rating"},
    {TR_ACTION_TYPE_CHANGE_RESOURCE_STOCKPILES, "Change resource stockpiles"},
    {TR_ACTION_TYPE_TRADE_ROUTE_SET_OPEN, "Open route"},
    {TR_ACTION_TYPE_TRADE_ROUTE_ADD_NEW_RESOURCE, "Trade route add new resource"},
    {TR_ACTION_TYPE_TRADE_SET_BUY_PRICE_ONLY, "Trade set buy price only"},
    {TR_ACTION_TYPE_TRADE_SET_SELL_PRICE_ONLY, "Trade set sell price only"},
    {TR_ACTION_TYPE_BUILDING_FORCE_COLLAPSE, "Building force collapse"},
    {TR_ACTION_TYPE_INVASION_IMMEDIATE, "Invasion start immediately"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_EQUAL, "Equal"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_EQUAL_OR_LESS, "Less than or equal"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_EQUAL_OR_MORE, "Greater than or equal"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_NOT_EQUAL, "Not equal"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_LESS_THAN, "Less than"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_GREATER_THAN, "Greater than"},
    {TR_PARAMETER_VALUE_DIFFICULTY_VERY_EASY, "Very easy"},
    {TR_PARAMETER_VALUE_DIFFICULTY_EASY, "Easy"},
    {TR_PARAMETER_VALUE_DIFFICULTY_NORMAL, "Normal"},
    {TR_PARAMETER_VALUE_DIFFICULTY_HARD, "Hard"},
    {TR_PARAMETER_VALUE_DIFFICULTY_VERY_HARD, "Very hard"},
    {TR_PARAMETER_VALUE_BOOLEAN_FALSE, "False"},
    {TR_PARAMETER_VALUE_BOOLEAN_TRUE, "True"},
    {TR_PARAMETER_VALUE_POP_CLASS_ALL, "All"},
    {TR_PARAMETER_VALUE_POP_CLASS_PATRICIAN, "Patricians"},
    {TR_PARAMETER_VALUE_POP_CLASS_PLEBEIAN, "Plebeians"},
    {TR_PARAMETER_VALUE_POP_CLASS_SLUMS, "Slumdwellers"},
    {TR_PARAMETER_VALUE_BUILDING_NONE, "None"},
    {TR_PARAMETER_VALUE_BUILDING_ANY, "Any"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_FARMS, "All farms"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_RAW_MATERIALS, "All raw materials"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_WORKSHOPS, "All workshops"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_STATUES, "All statues"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_GOV_RES, "All governor residence"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_GRAND_TEMPLES, "All grand temples"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_TREES, "All decorative trees"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_PATHS, "All decorative paths"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_PARKS, "All decorative parks"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_SMALL_TEMPLES, "All small temples"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_LARGE_TEMPLES, "All large temples"},
    {TR_PARAMETER_VALUE_BUILDING_NATIVE_CROPS, "Native crops"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_CERES, "Small Ceres temple"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_NEPTUNE, "Small Neptune temple"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_MERCURY, "Small Mercury temple"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_MARS, "Small Mars temple"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_VENUS, "Small Venus temple"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_CERES, "Large Ceres temple"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_NEPTUNE, "Large Neptune temple"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_MERCURY, "Large Mercury temple"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_MARS, "Large Mars temple"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_VENUS, "Large Venus temple"},
    {TR_PARAMETER_VALUE_DYNAMIC_RESOLVE, "..."},
    {TR_PARAMETER_VALUE_NONE, "None"},
    {TR_PARAMETER_VALUE_MESSAGE_CITY_IN_DEBT, "City in debt"},
    {TR_PARAMETER_VALUE_MESSAGE_CITY_IN_DEBT_AGAIN, "City in debt again"},
    {TR_PARAMETER_VALUE_MESSAGE_CITY_STILL_IN_DEBT, "City still in debt"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_WRATH, "Caesar wrath"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_ARMY_CONTINUE, "Caesar army continue"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_ARMY_RETREAT, "Caesar army retreat"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE, "Distant battle"},
    {TR_PARAMETER_VALUE_MESSAGE_ENEMIES_CLOSING, "Enemies closing"},
    {TR_PARAMETER_VALUE_MESSAGE_ENEMIES_AT_THE_DOOR, "Enemies at the door"},
    {TR_PARAMETER_VALUE_MESSAGE_SMALL_FESTIVAL, "Small festival"},
    {TR_PARAMETER_VALUE_MESSAGE_LARGE_FESTIVAL, "Large festival"},
    {TR_PARAMETER_VALUE_MESSAGE_GRAND_FESTIVAL, "Grand festival"},
    {TR_PARAMETER_VALUE_MESSAGE_GODS_UNHAPPY, "Gods unhappy"},
    {TR_PARAMETER_VALUE_MESSAGE_GLADIATOR_REVOLT, "Gladiator revolt"},
    {TR_PARAMETER_VALUE_MESSAGE_GLADIATOR_REVOLT_FINISHED, "Gladiator revolt over"},
    {TR_PARAMETER_VALUE_MESSAGE_EMPEROR_CHANGE, "Emperor changed"},
    {TR_PARAMETER_VALUE_MESSAGE_LAND_TRADE_DISRUPTED_SANDSTORMS, "Land trade sandstorms"},
    {TR_PARAMETER_VALUE_MESSAGE_LAND_TRADE_DISRUPTED_LANDSLIDES, "Land trade landslides"},
    {TR_PARAMETER_VALUE_MESSAGE_SEA_TRADE_DISRUPTED, "Sea trade disrupted"},
    {TR_PARAMETER_VALUE_MESSAGE_ROME_RAISES_WAGES, "Rome raises wages"},
    {TR_PARAMETER_VALUE_MESSAGE_ROME_LOWERS_WAGES, "Rome lowers wages"},
    {TR_PARAMETER_VALUE_MESSAGE_CONTAMINATED_WATER, "Contaminated water"},
    {TR_PARAMETER_VALUE_MESSAGE_EMPIRE_HAS_EXPANDED, "Empire has expanded"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_CERES, "Wrath of Ceres"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_NEPTUNE_NO_SEA_TRADE, "Wrath of Neptune (no sea trade)"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MERCURY, "Wrath of Mercury"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MARS_NO_MILITARY, "Wrath of Mars (no military)"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_VENUS, "Wrath of Venus"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_NEPTUNE, "Wrath of Neptune"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MARS, "Wrath of Mars"},
    {TR_PARAMETER_VALUE_MESSAGE_CERES_IS_UPSET, "Ceres is upset"},
    {TR_PARAMETER_VALUE_MESSAGE_NEPTUNE_IS_UPSET, "Neptune is upset"},
    {TR_PARAMETER_VALUE_MESSAGE_MERCURY_IS_UPSET, "Mercury is upset"},
    {TR_PARAMETER_VALUE_MESSAGE_MARS_IS_UPSET, "Mars is upset"},
    {TR_PARAMETER_VALUE_MESSAGE_VENUS_IS_UPSET, "Venus is upset"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_CERES, "Blessing from Ceres"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_NEPTUNE, "Blessing from Neptune"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_MERCURY, "Blessing from Mercury"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_MARS, "Blessing from Mars"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_VENUS, "Blessing from Venus"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_MERCURY_ALTERNATE, "Blessing from Mercury alternate"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_NEPTUNE_ALTERNATE, "Blessing from Neptune alternate"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_VENUS_ALTERNATE, "Blessing from Venus alternate"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MARS_NO_NATIVES, "Wrath of Mars (no natives)"},
    {TR_PARAMETER_VALUE_MESSAGE_GODS_WRATHFUL, "Gods wrathful"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_LOST_NO_TROOPS, "Distant battle lost (no troops)"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_LOST_TOO_LATE, "Distant battle lost (too late)"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_LOST_TOO_WEAK, "Distant battle lost (too weak)"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_WON, "Distant battle won"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_CITY_RETAKEN, "Distant battle city retaken"},
    {TR_PARAMETER_VALUE_MESSAGE_HEALTH_ILLNESS, "Health illness"},
    {TR_PARAMETER_VALUE_MESSAGE_HEALTH_DISEASE, "Health disease"},
    {TR_PARAMETER_VALUE_MESSAGE_HEALTH_PESTILENCE, "Health pestilence"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_RESPECT_1, "Caesar respect 1"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_RESPECT_2, "Caesar respect 2"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_RESPECT_3, "Caesar respect 3"},
    {TR_PARAMETER_VALUE_MESSAGE_EMIGRATION, "Emigration"},
    {TR_PARAMETER_VALUE_MESSAGE_FIRED, "Fired"},
    {TR_PARAMETER_VALUE_MESSAGE_SOLDIERS_STARVING, "Soldiers starving"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_ANGER, "Caesar anger"},
    {TR_PARAMETER_VALUE_MESSAGE_ENEMIES_LEAVING, "Enemies leaving"},
    {TR_PARAMETER_VALUE_MEDIA_TYPE_SOUND, "Sound"},
    {TR_PARAMETER_VALUE_MEDIA_TYPE_VIDEO, "Video"},
    {TR_PARAMETER_VALUE_RATING_TYPE_PEACE, "Peace"},
    {TR_PARAMETER_VALUE_RATING_TYPE_PROSPERITY, "Prosperity"},
    {TR_PARAMETER_VALUE_STORAGE_TYPE_ALL, "All"},
    {TR_PARAMETER_VALUE_STORAGE_TYPE_GRANARIES, "Granaries"},
    {TR_PARAMETER_VALUE_STORAGE_TYPE_WAREHOUSES, "Warehouses"},
    {TR_PARAMETER_VALUE_INVASION_TYPE_ENEMY_ARMY, "Enemy army"},
    {TR_PARAMETER_VALUE_INVASION_TYPE_CAESAR, "Caesar"},
    {TR_PARAMETER_VALUE_INVASION_TYPE_NATIVES, "Natives"},
    {TR_PARAMETER_VALUE_INVASION_TYPE_MARS_NATIVES, "Mars natives"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_FOOD_CHAIN, "Food chain"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_GOLD_STORES, "Gold stores"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_BEST_BUILDINGS, "Best buildings"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_TROOPS, "Troops"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_RANDOM, "Randomly"},
    {TR_PARAMETER_VALUE_ENEMY_UNDEFINED, "Map defined"},
    {TR_PARAMETER_VALUE_ENEMY_0_BARBARIAN, "Barbaren!"},
    {TR_PARAMETER_VALUE_ENEMY_1_NUMIDIAN, "Numidian"},
    {TR_PARAMETER_VALUE_ENEMY_2_GAUL, "Gaul"},
    {TR_PARAMETER_VALUE_ENEMY_3_CELT, "Celt"},
    {TR_PARAMETER_VALUE_ENEMY_4_GOTH, "Goth"},
    {TR_PARAMETER_VALUE_ENEMY_5_PERGAMUM, "Pergamum"},
    {TR_PARAMETER_VALUE_ENEMY_6_SELEUCID, "Seleucid"},
    {TR_PARAMETER_VALUE_ENEMY_7_ETRUSCAN, "Etruscan"},
    {TR_PARAMETER_VALUE_ENEMY_8_GREEK, "Greek"},
    {TR_PARAMETER_VALUE_ENEMY_9_EGYPTIAN, "Egyptian"},
    {TR_PARAMETER_VALUE_ENEMY_10_CARTHAGINIAN, "Carthaginian"},
    {TR_PARAMETER_VALUE_ENEMY_11_CAESAR, "Caesar"},
    {TR_PARAMETER_DISPLAY_SET_TO, "set to"},
    {TR_PARAMETER_DISPLAY_ADD_TO, "add"},
    {TR_PARAMETER_DISPLAY_BETWEEN, "between"},
    {TR_PARAMETER_DISPLAY_IN_CITY, "in city"},
    {TR_PARAMETER_DISPLAY_ANYWHERE, "anywhere"},
    {TR_PARAMETER_DISPLAY_PERCENTAGE, "percentage"},
    {TR_PARAMETER_DISPLAY_FLAT_NUMBER, "flat number"},
    {TR_PARAMETER_DISPLAY_ONGOING, "is ongoing"},
    {TR_PARAMETER_DISPLAY_NOT_ONGOING, "is not ongoing"},
    {TR_PARAMETER_DISPLAY_ROUTE_OPEN, "route is open"},
    {TR_PARAMETER_DISPLAY_ROUTE_CLOSED, "route is closed"},
    {TR_PARAMETER_DISPLAY_ALLOWED, "allowed"},
    {TR_PARAMETER_DISPLAY_DISALLOWED, "disallowed"},
    {TR_PARAMETER_DISPLAY_SHOW_MESSAGE, "show message"},
    {TR_PARAMETER_DISPLAY_DO_NOT_SHOW_MESSAGE, "do not show message"},
    {TR_PARAMETER_DISPLAY_BUY_PRICE, "buy price"},
    {TR_PARAMETER_DISPLAY_SELL_PRICE, "sell price"},
    {TR_PARAMETER_DISPLAY_MONTHS, "months"},
    {TR_PARAMETER_DISPLAY_DAYS, "days"},
    {TR_PARAMETER_DISPLAY_RESPECT_SETTINGS, "respecting settings"},
    {TR_PARAMETER_DISPLAY_IGNORE_SETTINGS, "ignoring settings"},
    {TR_PARAMETER_DISPLAY_APPLY_COST, "apply cost"},
    {TR_PARAMETER_DISPLAY_NO_COST, "no cost"},
    {TR_PARAMETER_DISPLAY_ADD_AS_BUYING, "add as buying"},
    {TR_PARAMETER_DISPLAY_ADD_AS_SELLING, "add as selling"},
    {TR_PARAMETER_DISPLAY_DESTROY_ALL_TYPES, "destroy all types"},
    {TR_ORDER_CONDITION_NEVER, "Never" },
    {TR_ORDER_CONDITION_ALWAYS, "Always" },
    {TR_ORDER_CONDITION_SOURCE_HAS_MORE_THAN, "Source has more than" },
    {TR_ORDER_CONDITION_DESTINATION_HAS_LESS_THAN, "Destination has less than" },
    {TR_BUILDING_INFO_DEPOT_SELECT_SOURCE, "Select a source"},
    {TR_BUILDING_INFO_DEPOT_SELECT_DESTINATION, "Select a destination"},
    {TR_BUILDING_INFO_DEPOT_ONE_BUILDING_FOR_RESOURCE, "Only one building available"},
    {TR_BUILDING_INFO_DEPOT_NO_SOURCE_AVAILABLE, "No source available"},
    {TR_BUILDING_INFO_DEPOT_NO_DESTINATION_AVAILABLE, "No destination available"},
    {TR_BUILDING_INFO_DEPOT_DELIVER, "Deliver" },
    {TR_BUILDING_INFO_DEPOT_CONDITION, "When" },
    {TR_BUILDING_INFO_DEPOT_SOURCE, "Source" },
    {TR_BUILDING_INFO_DEPOT_DESTINATION, "Destination" },
    {TR_BUILDING_INFO_DEPOT_SELECT_SOURCE_TITLE, "Select source storage" },
    {TR_BUILDING_INFO_DEPOT_SELECT_DESTINATION_TITLE, "Select destination storage" },
    {TR_BUILDING_INFO_DEPOT_SELECT_RESOURCE_TITLE, "Select resource" },
    {TR_TOOLTIP_BUTTON_CENTER_CAMERA, "Center camera on building"},
    {TR_FIGURE_INFO_DEPOT_RECALL, "Recall" },
    {TR_FIGURE_INFO_DEPOT_RETURNING, "Returning" },
    {TR_FIGURE_INFO_DEPOT_DELIVER, "Delivering" },
    {TR_FIGURE_INFO_DEPOT_FROM, "From " },
    {TR_FIGURE_INFO_DEPOT_TO, " to " },
    {TR_BUILDING_DEPOT_NO_EMPLOYEES, "This depot has no employees. Cats are sleeping in the empty carts." },
    {TR_BUILDING_DEPOT_FEW_EMPLOYEES, "With hardly any workers here, nobody can remember when this depot sent out its last cart pusher." },
    {TR_BUILDING_DEPOT_SOME_EMPLOYEES, "Very few people work in this depot. It takes a while before goods are transferred." },
    {TR_BUILDING_DEPOT_HALF_EMPLOYEES, "This depot is understaffed. Goods are transferred slowly as a result." },
    {TR_BUILDING_DEPOT_MANY_EMPLOYEES, "This depot is working below maximum capacity. Goods could be transferred slightly faster with more workers." },
    {TR_BUILDING_INFO_MOTHBALL_WARNING, "This building is mothballed." },
    {TR_BUILDING_INFO_CARTLOAD, "cartload." },
    {TR_BUILDING_INFO_CARTLOADS, "cartloads." },
    {TR_HOTKEY_SHOW_OVERLAY_RISKS_NATIVE, "Native overlay"},
    {TR_BUILDING_PANELLED_GARDEN_WALL, "Paneled garden wall"},
    {TR_BUILDING_LOOPED_GARDEN_WALL_GATE, "Looped garden wall gate"},
    {TR_BUILDING_LOOPED_GARDEN_WALL_GATE_DESC, "This small gate controls the movement of people in and out of your city's most secluded spots." },
    {TR_BUILDING_PANELLED_GARDEN_WALL_GATE, "Paneled garden wall gate" },
    {TR_BUILDING_PANELLED_GARDEN_WALL_GATE_DESC, "This small gate controls the movement of people in and out of your city's most secluded spots." },
    {TR_HOTKEY_BUILD_HIGHWAY, "Highway" },
    {TR_BUILDING_SHRINE_DESC, "Altars are appreciated not only by their neighbouring citizens but also by their respective gods."},
    {TR_BUILDING_SHRINE_CERES, "Ceres altar"},
    {TR_BUILDING_SHRINE_MARS, "Mars altar"},
    {TR_BUILDING_SHRINE_MERCURY, "Mercury altar"},
    {TR_BUILDING_SHRINE_NEPTUNE, "Neptune altar"},
    {TR_BUILDING_SHRINE_VENUS, "Venus altar"},
    {TR_BUILDING_MENU_SHRINES, "Altar" },
    {TR_BUILDING_INFO_TOTAL_FOOD, "Total food:" },
    {TR_BUILDING_FORMAL_GARDENS, "Formal Gardens" },
    {TR_BUILDING_OVERGROWN_GARDENS, "Overgrown Gardens" },
    {TR_WINDOW_ADVISOR_RELIGION_ALTARS_HEADER, "Altars"}
};

void translation_english(const translation_string **strings, int *num_strings)
{
    *strings = all_strings;
    *num_strings = sizeof(all_strings) / sizeof(translation_string);
}
