#include "translation/common.h"
#include "translation/translation.h"

static translation_string all_strings[] = {
    {TR_NO_PATCH_TITLE, "Patch 1.0.1.0 není nainstalován"},
    {TR_NO_PATCH_MESSAGE,
        "Vaše instalace Caesar 3 nemá nainstalovaný patch 1.0.1.0. "
        "Můžete stáhnout patch z:\n"
        URL_PATCHES "\n"
        "Pokračujte na vlastní nebezpečí."},
    {TR_MISSING_FONTS_TITLE, "Chybějící písma"},
    {TR_MISSING_FONTS_MESSAGE,
        "Vaše instalace Caesar 3 vyžaduje dodatečné soubory s písmy. "
        "Můžete je stáhnout pro váš jazyk z:\n"
        URL_PATCHES},
    {TR_NO_EDITOR_TITLE, "Editor není nainstalován"},
    {TR_NO_EDITOR_MESSAGE,
        "Vaše instalace Caesar 3 neobsahuje soubory editoru. "
        "Můžete je stáhnout z:\n"
        URL_EDITOR},
    {TR_INVALID_LANGUAGE_TITLE, "Neplatný adresář s jazyky"},
    {TR_INVALID_LANGUAGE_MESSAGE,
        "Adresář, který jste zvolili neobsahuje platný jazykový balíček. "
        "Prosím zkontrolujte záznam pro výskyt chyb."},
    {TR_AUTO_CYCLE_TEMPLES, "Vše"},
    {TR_BUTTON_OK, "OK"},
    {TR_BUTTON_CANCEL, "Zrušit"},
    {TR_BUTTON_RESET_DEFAULTS, "Výchozí nastavení"},
    {TR_BUTTON_CONFIGURE_HOTKEYS, "Horké klávesy"},
    {TR_CONFIG_TITLE, "Konfigurační volby Juliuse"},
    {TR_CONFIG_LANGUAGE_LABEL, "Jazyk:"},
    {TR_CONFIG_LANGUAGE_DEFAULT, "(výchozí)"},
    {TR_CONFIG_DISPLAY_SCALE, "Měřítko displeje:"},
    {TR_CONFIG_CURSOR_SCALE, "Měřítko kurzoru:"},
    {TR_CONFIG_HEADER_UI_CHANGES, "Změny uživatelského rozhraní"},
    {TR_CONFIG_HEADER_GAMEPLAY_CHANGES, "Změny hratelnosti"},
    {TR_CONFIG_SHOW_INTRO_VIDEO, "Přehrát úvodní videa"},
    {TR_CONFIG_SIDEBAR_INFO, "Dodatečné informace v kontrolním panelu"},
    {TR_CONFIG_SMOOTH_SCROLLING, "Povolit plynulé posouvání"},
    {TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "Vypnout posouvání mapy okrajem obrazovky"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Zakázat posouvání mapy pravým tlačítkem myši"},
    {TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE, "Vylepšit vizuální odezvu při čištění země"},
    {TR_CONFIG_ALLOW_CYCLING_TEMPLES, "Povolit stavbu každého chrámu po sobě"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE, "Zobrazit dosah při stavbě nádrží, fontán a studní"},
    {TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "Zobrazit velikost konstrukce při přetahování"},
    {TR_CONFIG_HIGHLIGHT_LEGIONS, "Zvýraznit legii při najetí kurzorem"},
    {TR_CONFIG_SHOW_MILITARY_SIDEBAR, "Povolit vojenský postranní panel"},
    {TR_CONFIG_FIX_IMMIGRATION_BUG, "Opravit chybu imigrace na velmi těžkou obtížnost"},
    {TR_CONFIG_FIX_100_YEAR_GHOSTS, "Opravit chybu stoletých duchů"},
    {TR_HOTKEY_TITLE, "Nastavení klávesových zkratek Juliuse"},
    {TR_HOTKEY_LABEL, "Klávesa"},
    {TR_HOTKEY_ALTERNATIVE_LABEL, "Alternativní"},
    {TR_HOTKEY_HEADER_ARROWS, "Šipky"},
    {TR_HOTKEY_HEADER_GLOBAL, "Globální klávesové zkratky"},
    {TR_HOTKEY_HEADER_CITY, "Městské zkratky"},
    {TR_HOTKEY_HEADER_ADVISORS, "Poradci"},
    {TR_HOTKEY_HEADER_OVERLAYS, "Překryvy"},
    {TR_HOTKEY_HEADER_BOOKMARKS, "Záložky na mapě města"},
    {TR_HOTKEY_HEADER_EDITOR, "Editor"},
    {TR_HOTKEY_HEADER_BUILD, "Konstrukční klávesové zkratky"},
    {TR_HOTKEY_ARROW_UP, "Nahoru"},
    {TR_HOTKEY_ARROW_DOWN, "Dolů"},
    {TR_HOTKEY_ARROW_LEFT, "Doleva"},
    {TR_HOTKEY_ARROW_RIGHT, "Doprava"},
    {TR_HOTKEY_TOGGLE_FULLSCREEN, "Přepnout na celou obrazovku"},
    {TR_HOTKEY_CENTER_WINDOW, "Vycentrovat okno"},
    {TR_HOTKEY_RESIZE_TO_640, "Změnit velikost okna na 640x480"},
    {TR_HOTKEY_RESIZE_TO_800, "Změnit velikost okna na 800x600"},
    {TR_HOTKEY_RESIZE_TO_1024, "Změnit velikost okna na 1024x768"},
    {TR_HOTKEY_SAVE_SCREENSHOT, "Uložit snímek obrazovky"},
    {TR_HOTKEY_SAVE_CITY_SCREENSHOT, "Uložit snímek obrazovky celého města"},
    {TR_HOTKEY_BUILD_CLONE, "Klonovat budovu pod kurzorem"},
    {TR_HOTKEY_LOAD_FILE, "Našíst soubor"},
    {TR_HOTKEY_SAVE_FILE, "Uložit soubor"},
    {TR_HOTKEY_INCREASE_GAME_SPEED, "Zvýšit rychlost hry"},
    {TR_HOTKEY_DECREASE_GAME_SPEED, "Snížit rychlost hry"},
    {TR_HOTKEY_TOGGLE_PAUSE, "Přepnout pauzu"},
    {TR_HOTKEY_CYCLE_LEGION, "Procházet legiemi"},
    {TR_HOTKEY_ROTATE_MAP_LEFT, "Otočit mapu vlevo"},
    {TR_HOTKEY_ROTATE_MAP_RIGHT, "Otočit mapu vpravo"},
    {TR_HOTKEY_SHOW_ADVISOR_LABOR, "Pracovní poradce"},
    {TR_HOTKEY_SHOW_ADVISOR_MILITARY, "Vojenský poradce"},
    {TR_HOTKEY_SHOW_ADVISOR_IMPERIAL, "Císařský poradce"},
    {TR_HOTKEY_SHOW_ADVISOR_RATINGS, "Poradce pro hodnocení"},
    {TR_HOTKEY_SHOW_ADVISOR_TRADE, "Obchodní poradce"},
    {TR_HOTKEY_SHOW_ADVISOR_POPULATION, "Populační poradce"},
    {TR_HOTKEY_SHOW_ADVISOR_HEALTH, "Zdravotní poradce"},
    {TR_HOTKEY_SHOW_ADVISOR_EDUCATION, "Poradce pro vzdělávání"},
    {TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT, "Zábavní poradce"},
    {TR_HOTKEY_SHOW_ADVISOR_RELIGION, "Náboženský poradce"},
    {TR_HOTKEY_SHOW_ADVISOR_FINANCIAL, "Finanční poradce"},
    {TR_HOTKEY_SHOW_ADVISOR_CHIEF, "Hlavní poradce"},
    {TR_HOTKEY_TOGGLE_OVERLAY, "Přepnout aktuální překryv"},
    {TR_HOTKEY_SHOW_OVERLAY_WATER, "Překryv vody"},
    {TR_HOTKEY_SHOW_OVERLAY_FIRE, "Překryv požárů"},
    {TR_HOTKEY_SHOW_OVERLAY_DAMAGE, "Překryv poškození"},
    {TR_HOTKEY_SHOW_OVERLAY_CRIME, "Překryv kriminality"},
    {TR_HOTKEY_SHOW_OVERLAY_PROBLEMS, "Překryv problémů"},
    {TR_HOTKEY_GO_TO_BOOKMARK_1, "Přejít na záložku 1"},
    {TR_HOTKEY_GO_TO_BOOKMARK_2, "Přejít na záložku 2"},
    {TR_HOTKEY_GO_TO_BOOKMARK_3, "Přejít na záložku 3"},
    {TR_HOTKEY_GO_TO_BOOKMARK_4, "Přejít na záložku 4"},
    {TR_HOTKEY_SET_BOOKMARK_1, "Nastavit záložku 1"},
    {TR_HOTKEY_SET_BOOKMARK_2, "Nastavit záložku 2"},
    {TR_HOTKEY_SET_BOOKMARK_3, "Nastavit záložku 3"},
    {TR_HOTKEY_SET_BOOKMARK_4, "Nastavit záložku 4"},
    {TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO, "Přepnout informace o bitvě"},
    {TR_HOTKEY_EDIT_TITLE, "Stiskněte novou klávesovou zkratku"},
    {TR_HOTKEY_DUPLICATE_TITLE, "Klávesová zkratka již použita"},
    {TR_HOTKEY_DUPLICATE_MESSAGE, "Tato kombinace kláves je již přiřazena k následující akci:"},
    {TR_WARNING_SCREENSHOT_SAVED, "Snímek obrazovky byl uložen: "},
};

void translation_czech(const translation_string **strings, int *num_strings)
{
    *strings = all_strings;
    *num_strings = sizeof(all_strings) / sizeof(translation_string);
}
