RabbitMQ `3.9.16` is a maintenance release in the `3.9.x` release series.

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if upgrading from a version prior to 3.9.0.

This release requires at least Erlang 23.2, and supports Erlang 24. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.


## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).
Contributors are encouraged to update them together with their changes. This helps with release automation and a more consistent release schedule.

### Core Server

#### Enhancements

 * Quorum queues: better forward compatibility with (currently in preview) RabbitMQ 3.10.

   GitHub issue: [#4560](https://github.com/rabbitmq/rabbitmq-server/pull/4560)

 * Significantly faster queue re-import from [definitions](https://rabbitmq.com/definitions.html)
   on subsequent node restarts. Initial definition import still takes
   the same amount of time as before.

   GitHub issue: [#4538](https://github.com/rabbitmq/rabbitmq-server/pull/4538)

 * Significantly faster exchange re-import from [definitions](https://rabbitmq.com/definitions.html)
   on subsequent node restarts. Initial definition import still takes
   the same amount of time as before.

   GitHub issue: [#4585](https://github.com/rabbitmq/rabbitmq-server/pull/4585)

 * RabbitMQ nodes will now filter out certain log messages related to
   connections, channels, and queue leader replicas receiving internal protocol messages
   sent to this node before a restart. These messages usually raise more questions
   and cause confusion than help.

   It is still possible to detect relevant underlying events (node or connection failures)
   from other log messages.

   GitHub issue: [#4557](https://github.com/rabbitmq/rabbitmq-server/issues/4557)

#### Bug Fixes

 * `rabbitmq-upgrade await_online_synchronized_mirror` is now a no-op in single node
   clusters

   GitHub issue: [#4570](https://github.com/rabbitmq/rabbitmq-server/pull/4570)


### Prometheus Plugin

#### Bug Fixes

 * One metric that was exposed via CLI tools and management plugin's HTTP API
   was not exposed via Prometheus scraping API.

   Contributed by @gomoripeti.

   GitHub issue: [#4645](https://github.com/rabbitmq/rabbitmq-server/pull/4645)


## Dependency Upgrades

 * `osiris` upgraded from [`1.2.4` to `1.2.6`](https://github.com/rabbitmq/osiris/compare/v1.2.4...v1.2.6)
 * `observer-cli` was upgraded [from v1.7.2 to v1.7.3](https://github.com/zhongwencool/observer_cli/compare/1.7.2...1.7.3)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.16.tar.xz`
instead of the source tarball produced by GitHub.
